# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = [
    'FunctionArg',
    'SchemaPolicy',
    'GetSequencesSequenceResult',
    'GetTablesTableResult',
]

@pulumi.output_type
class FunctionArg(dict):
    def __init__(__self__, *,
                 type: builtins.str,
                 default: Optional[builtins.str] = None,
                 mode: Optional[builtins.str] = None,
                 name: Optional[builtins.str] = None):
        """
        :param builtins.str type: The type of the argument.
        :param builtins.str default: An expression to be used as default value if the parameter is not specified.
        :param builtins.str mode: Can be one of IN, INOUT, OUT, or VARIADIC. Default is IN.
        :param builtins.str name: The name of the argument.
        """
        pulumi.set(__self__, "type", type)
        if default is not None:
            pulumi.set(__self__, "default", default)
        if mode is not None:
            pulumi.set(__self__, "mode", mode)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def type(self) -> builtins.str:
        """
        The type of the argument.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def default(self) -> Optional[builtins.str]:
        """
        An expression to be used as default value if the parameter is not specified.
        """
        return pulumi.get(self, "default")

    @property
    @pulumi.getter
    def mode(self) -> Optional[builtins.str]:
        """
        Can be one of IN, INOUT, OUT, or VARIADIC. Default is IN.
        """
        return pulumi.get(self, "mode")

    @property
    @pulumi.getter
    def name(self) -> Optional[builtins.str]:
        """
        The name of the argument.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class SchemaPolicy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "createWithGrant":
            suggest = "create_with_grant"
        elif key == "usageWithGrant":
            suggest = "usage_with_grant"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SchemaPolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SchemaPolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SchemaPolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 create: Optional[builtins.bool] = None,
                 create_with_grant: Optional[builtins.bool] = None,
                 role: Optional[builtins.str] = None,
                 usage: Optional[builtins.bool] = None,
                 usage_with_grant: Optional[builtins.bool] = None):
        """
        :param builtins.bool create: Should the specified ROLE have CREATE privileges to the specified SCHEMA.
        :param builtins.bool create_with_grant: Should the specified ROLE have CREATE privileges to the specified SCHEMA and the ability to GRANT the CREATE privilege to other ROLEs.
        :param builtins.str role: The ROLE who is receiving the policy.  If this value is empty or not specified it implies the policy is referring to the [`PUBLIC` role](https://www.postgresql.org/docs/current/static/sql-grant.html).
        :param builtins.bool usage: Should the specified ROLE have USAGE privileges to the specified SCHEMA.
        :param builtins.bool usage_with_grant: Should the specified ROLE have USAGE privileges to the specified SCHEMA and the ability to GRANT the USAGE privilege to other ROLEs.
               
               > **NOTE on `policy`:** The permissions of a role specified in multiple policy blocks is cumulative.  For example, if the same role is specified in two different `policy` each with different permissions (e.g. `create` and `usage_with_grant`, respectively), then the specified role with have both `create` and `usage_with_grant` privileges.
        """
        if create is not None:
            pulumi.set(__self__, "create", create)
        if create_with_grant is not None:
            pulumi.set(__self__, "create_with_grant", create_with_grant)
        if role is not None:
            pulumi.set(__self__, "role", role)
        if usage is not None:
            pulumi.set(__self__, "usage", usage)
        if usage_with_grant is not None:
            pulumi.set(__self__, "usage_with_grant", usage_with_grant)

    @property
    @pulumi.getter
    def create(self) -> Optional[builtins.bool]:
        """
        Should the specified ROLE have CREATE privileges to the specified SCHEMA.
        """
        return pulumi.get(self, "create")

    @property
    @pulumi.getter(name="createWithGrant")
    def create_with_grant(self) -> Optional[builtins.bool]:
        """
        Should the specified ROLE have CREATE privileges to the specified SCHEMA and the ability to GRANT the CREATE privilege to other ROLEs.
        """
        return pulumi.get(self, "create_with_grant")

    @property
    @pulumi.getter
    def role(self) -> Optional[builtins.str]:
        """
        The ROLE who is receiving the policy.  If this value is empty or not specified it implies the policy is referring to the [`PUBLIC` role](https://www.postgresql.org/docs/current/static/sql-grant.html).
        """
        return pulumi.get(self, "role")

    @property
    @pulumi.getter
    def usage(self) -> Optional[builtins.bool]:
        """
        Should the specified ROLE have USAGE privileges to the specified SCHEMA.
        """
        return pulumi.get(self, "usage")

    @property
    @pulumi.getter(name="usageWithGrant")
    def usage_with_grant(self) -> Optional[builtins.bool]:
        """
        Should the specified ROLE have USAGE privileges to the specified SCHEMA and the ability to GRANT the USAGE privilege to other ROLEs.

        > **NOTE on `policy`:** The permissions of a role specified in multiple policy blocks is cumulative.  For example, if the same role is specified in two different `policy` each with different permissions (e.g. `create` and `usage_with_grant`, respectively), then the specified role with have both `create` and `usage_with_grant` privileges.
        """
        return pulumi.get(self, "usage_with_grant")


@pulumi.output_type
class GetSequencesSequenceResult(dict):
    def __init__(__self__, *,
                 data_type: builtins.str,
                 object_name: builtins.str,
                 schema_name: builtins.str):
        """
        :param builtins.str data_type: The sequence's data type as defined in ``information_schema.sequences``.
        :param builtins.str object_name: The sequence name.
        :param builtins.str schema_name: The parent schema.
        """
        pulumi.set(__self__, "data_type", data_type)
        pulumi.set(__self__, "object_name", object_name)
        pulumi.set(__self__, "schema_name", schema_name)

    @property
    @pulumi.getter(name="dataType")
    def data_type(self) -> builtins.str:
        """
        The sequence's data type as defined in ``information_schema.sequences``.
        """
        return pulumi.get(self, "data_type")

    @property
    @pulumi.getter(name="objectName")
    def object_name(self) -> builtins.str:
        """
        The sequence name.
        """
        return pulumi.get(self, "object_name")

    @property
    @pulumi.getter(name="schemaName")
    def schema_name(self) -> builtins.str:
        """
        The parent schema.
        """
        return pulumi.get(self, "schema_name")


@pulumi.output_type
class GetTablesTableResult(dict):
    def __init__(__self__, *,
                 object_name: builtins.str,
                 schema_name: builtins.str,
                 table_type: builtins.str):
        """
        :param builtins.str object_name: The table name.
        :param builtins.str schema_name: The parent schema.
        :param builtins.str table_type: The table type as defined in ``information_schema.tables``.
        """
        pulumi.set(__self__, "object_name", object_name)
        pulumi.set(__self__, "schema_name", schema_name)
        pulumi.set(__self__, "table_type", table_type)

    @property
    @pulumi.getter(name="objectName")
    def object_name(self) -> builtins.str:
        """
        The table name.
        """
        return pulumi.get(self, "object_name")

    @property
    @pulumi.getter(name="schemaName")
    def schema_name(self) -> builtins.str:
        """
        The parent schema.
        """
        return pulumi.get(self, "schema_name")

    @property
    @pulumi.getter(name="tableType")
    def table_type(self) -> builtins.str:
        """
        The table type as defined in ``information_schema.tables``.
        """
        return pulumi.get(self, "table_type")


