# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['SecurityLabelArgs', 'SecurityLabel']

@pulumi.input_type
class SecurityLabelArgs:
    def __init__(__self__, *,
                 label: pulumi.Input[builtins.str],
                 label_provider: pulumi.Input[builtins.str],
                 object_name: pulumi.Input[builtins.str],
                 object_type: pulumi.Input[builtins.str]):
        """
        The set of arguments for constructing a SecurityLabel resource.
        :param pulumi.Input[builtins.str] label: The value of the security label.
        :param pulumi.Input[builtins.str] label_provider: The name of the provider with which this label is to be associated.
        :param pulumi.Input[builtins.str] object_name: The name of the object to be labeled. Names of objects that reside in schemas (tables, functions, etc.) can be schema-qualified.
        :param pulumi.Input[builtins.str] object_type: The PostgreSQL object type to apply this security label to.
        """
        pulumi.set(__self__, "label", label)
        pulumi.set(__self__, "label_provider", label_provider)
        pulumi.set(__self__, "object_name", object_name)
        pulumi.set(__self__, "object_type", object_type)

    @property
    @pulumi.getter
    def label(self) -> pulumi.Input[builtins.str]:
        """
        The value of the security label.
        """
        return pulumi.get(self, "label")

    @label.setter
    def label(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "label", value)

    @property
    @pulumi.getter(name="labelProvider")
    def label_provider(self) -> pulumi.Input[builtins.str]:
        """
        The name of the provider with which this label is to be associated.
        """
        return pulumi.get(self, "label_provider")

    @label_provider.setter
    def label_provider(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "label_provider", value)

    @property
    @pulumi.getter(name="objectName")
    def object_name(self) -> pulumi.Input[builtins.str]:
        """
        The name of the object to be labeled. Names of objects that reside in schemas (tables, functions, etc.) can be schema-qualified.
        """
        return pulumi.get(self, "object_name")

    @object_name.setter
    def object_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "object_name", value)

    @property
    @pulumi.getter(name="objectType")
    def object_type(self) -> pulumi.Input[builtins.str]:
        """
        The PostgreSQL object type to apply this security label to.
        """
        return pulumi.get(self, "object_type")

    @object_type.setter
    def object_type(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "object_type", value)


@pulumi.input_type
class _SecurityLabelState:
    def __init__(__self__, *,
                 label: Optional[pulumi.Input[builtins.str]] = None,
                 label_provider: Optional[pulumi.Input[builtins.str]] = None,
                 object_name: Optional[pulumi.Input[builtins.str]] = None,
                 object_type: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering SecurityLabel resources.
        :param pulumi.Input[builtins.str] label: The value of the security label.
        :param pulumi.Input[builtins.str] label_provider: The name of the provider with which this label is to be associated.
        :param pulumi.Input[builtins.str] object_name: The name of the object to be labeled. Names of objects that reside in schemas (tables, functions, etc.) can be schema-qualified.
        :param pulumi.Input[builtins.str] object_type: The PostgreSQL object type to apply this security label to.
        """
        if label is not None:
            pulumi.set(__self__, "label", label)
        if label_provider is not None:
            pulumi.set(__self__, "label_provider", label_provider)
        if object_name is not None:
            pulumi.set(__self__, "object_name", object_name)
        if object_type is not None:
            pulumi.set(__self__, "object_type", object_type)

    @property
    @pulumi.getter
    def label(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The value of the security label.
        """
        return pulumi.get(self, "label")

    @label.setter
    def label(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "label", value)

    @property
    @pulumi.getter(name="labelProvider")
    def label_provider(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the provider with which this label is to be associated.
        """
        return pulumi.get(self, "label_provider")

    @label_provider.setter
    def label_provider(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "label_provider", value)

    @property
    @pulumi.getter(name="objectName")
    def object_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the object to be labeled. Names of objects that reside in schemas (tables, functions, etc.) can be schema-qualified.
        """
        return pulumi.get(self, "object_name")

    @object_name.setter
    def object_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "object_name", value)

    @property
    @pulumi.getter(name="objectType")
    def object_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The PostgreSQL object type to apply this security label to.
        """
        return pulumi.get(self, "object_type")

    @object_type.setter
    def object_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "object_type", value)


@pulumi.type_token("postgresql:index/securityLabel:SecurityLabel")
class SecurityLabel(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 label: Optional[pulumi.Input[builtins.str]] = None,
                 label_provider: Optional[pulumi.Input[builtins.str]] = None,
                 object_name: Optional[pulumi.Input[builtins.str]] = None,
                 object_type: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        The ``SecurityLabel`` resource creates and manages security labels.

        See [PostgreSQL documentation](https://www.postgresql.org/docs/current/sql-security-label.html)

        > **Note:** This resource needs Postgresql version 11 or above.

        ## Usage

        ```python
        import pulumi
        import pulumi_postgresql as postgresql

        my_role = postgresql.Role("my_role",
            name="my_role",
            login=True)
        workload = postgresql.SecurityLabel("workload",
            object_type="role",
            object_name=my_role.name,
            label_provider="pgaadauth",
            label="aadauth,oid=00000000-0000-0000-0000-000000000000,type=service")
        ```

        ## Import

        Security label is an attribute that can be added multiple times, so no import is needed, simply apply again.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] label: The value of the security label.
        :param pulumi.Input[builtins.str] label_provider: The name of the provider with which this label is to be associated.
        :param pulumi.Input[builtins.str] object_name: The name of the object to be labeled. Names of objects that reside in schemas (tables, functions, etc.) can be schema-qualified.
        :param pulumi.Input[builtins.str] object_type: The PostgreSQL object type to apply this security label to.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SecurityLabelArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        The ``SecurityLabel`` resource creates and manages security labels.

        See [PostgreSQL documentation](https://www.postgresql.org/docs/current/sql-security-label.html)

        > **Note:** This resource needs Postgresql version 11 or above.

        ## Usage

        ```python
        import pulumi
        import pulumi_postgresql as postgresql

        my_role = postgresql.Role("my_role",
            name="my_role",
            login=True)
        workload = postgresql.SecurityLabel("workload",
            object_type="role",
            object_name=my_role.name,
            label_provider="pgaadauth",
            label="aadauth,oid=00000000-0000-0000-0000-000000000000,type=service")
        ```

        ## Import

        Security label is an attribute that can be added multiple times, so no import is needed, simply apply again.

        :param str resource_name: The name of the resource.
        :param SecurityLabelArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SecurityLabelArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 label: Optional[pulumi.Input[builtins.str]] = None,
                 label_provider: Optional[pulumi.Input[builtins.str]] = None,
                 object_name: Optional[pulumi.Input[builtins.str]] = None,
                 object_type: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SecurityLabelArgs.__new__(SecurityLabelArgs)

            if label is None and not opts.urn:
                raise TypeError("Missing required property 'label'")
            __props__.__dict__["label"] = label
            if label_provider is None and not opts.urn:
                raise TypeError("Missing required property 'label_provider'")
            __props__.__dict__["label_provider"] = label_provider
            if object_name is None and not opts.urn:
                raise TypeError("Missing required property 'object_name'")
            __props__.__dict__["object_name"] = object_name
            if object_type is None and not opts.urn:
                raise TypeError("Missing required property 'object_type'")
            __props__.__dict__["object_type"] = object_type
        super(SecurityLabel, __self__).__init__(
            'postgresql:index/securityLabel:SecurityLabel',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            label: Optional[pulumi.Input[builtins.str]] = None,
            label_provider: Optional[pulumi.Input[builtins.str]] = None,
            object_name: Optional[pulumi.Input[builtins.str]] = None,
            object_type: Optional[pulumi.Input[builtins.str]] = None) -> 'SecurityLabel':
        """
        Get an existing SecurityLabel resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] label: The value of the security label.
        :param pulumi.Input[builtins.str] label_provider: The name of the provider with which this label is to be associated.
        :param pulumi.Input[builtins.str] object_name: The name of the object to be labeled. Names of objects that reside in schemas (tables, functions, etc.) can be schema-qualified.
        :param pulumi.Input[builtins.str] object_type: The PostgreSQL object type to apply this security label to.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SecurityLabelState.__new__(_SecurityLabelState)

        __props__.__dict__["label"] = label
        __props__.__dict__["label_provider"] = label_provider
        __props__.__dict__["object_name"] = object_name
        __props__.__dict__["object_type"] = object_type
        return SecurityLabel(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def label(self) -> pulumi.Output[builtins.str]:
        """
        The value of the security label.
        """
        return pulumi.get(self, "label")

    @property
    @pulumi.getter(name="labelProvider")
    def label_provider(self) -> pulumi.Output[builtins.str]:
        """
        The name of the provider with which this label is to be associated.
        """
        return pulumi.get(self, "label_provider")

    @property
    @pulumi.getter(name="objectName")
    def object_name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the object to be labeled. Names of objects that reside in schemas (tables, functions, etc.) can be schema-qualified.
        """
        return pulumi.get(self, "object_name")

    @property
    @pulumi.getter(name="objectType")
    def object_type(self) -> pulumi.Output[builtins.str]:
        """
        The PostgreSQL object type to apply this security label to.
        """
        return pulumi.get(self, "object_type")

