from sklearn.datasets import load_iris
from sklearn.model_selection import train_test_split
from sklearn.linear_model import LogisticRegression
import exlog
X, y = load_iris(return_X_y=True)
X_train, X_test, y_train, y_test = train_test_split(X, y, test_size=0.2, random_state=42)
model = LogisticRegression(max_iter=500)
model.fit(X_train, y_train)
#cls = model.__class__.__module__
#print(cls)
logs = exlog.log(model, X_test, y_test, path="lr_exlog.json")
print(logs[0])
