import * as constructs from 'constructs';
/**
 * Supported instance types for Managed Blockchain nodes
 */
export declare enum InstanceType {
    BURSTABLE3_XLARGE = "bc.t3.xlarge",
    STANDARD5_XLARGE = "bc.m5.xlarge",
    STANDARD5_XLARGE2 = "bc.m5.2xlarge",
    STANDARD5_XLARGE4 = "bc.m5.4xlarge",
    COMPUTE5_XLARGE2 = "bc.c5.2xlarge",
    COMPUTE5_XLARGE4 = "bc.c5.4xlarge"
}
/**
 * Supported Ethereum networks for Managed Blockchain nodes
 */
export declare enum Network {
    MAINNET = "n-ethereum-mainnet",
    GOERLI = "n-ethereum-goerli",
    RINKEBY = "n-ethereum-rinkeby",
    ROPSTEN = "n-ethereum-ropsten"
}
/**
 * Construct properties for `EthereumNode`
 */
export interface EthereumNodeProps {
    /**
       * The Ethereum Network in which the node will be created
       * @default - The default network selected is Mainnet network
       */
    readonly network?: Network;
    /**
       * The Amazon Managed Blockchain instance type for the Ethereum node
       * @default - BURSTABLE3_LARGE
       */
    readonly instanceType?: InstanceType;
    /**
       * The Availability Zone in which the node will be created
       * @default - us-east-1a
       */
    readonly availabilityZone?: string;
}
export declare class EthereumNode extends constructs.Construct {
    /**
       * Managed Blockchain Ethereum network identifier
       */
    readonly network: Network;
    /**
       * The Amazon Managed Blockchain instance type for the node
       */
    readonly instanceType: InstanceType;
    /**
     * The Region in which the node exists
     */
    readonly region: string;
    /**
       * The Availability Zone in which the node exists
       */
    readonly availabilityZone: string;
    /**
     * Creates an Ethereum public network node on an Amazon Managed Blockchain network
    */
    constructor(scope: constructs.Construct, id: string, props?: EthereumNodeProps);
}
