"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.EthereumNode = exports.Network = exports.InstanceType = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
// Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
// SPDX-License-Identifier: MIT-0
const cdk = require("aws-cdk-lib");
const managedblockchain = require("aws-cdk-lib/aws-managedblockchain");
const constructs = require("constructs");
const utilities = require("./utilities");
/**
 * Supported instance types for Managed Blockchain nodes
 */
var InstanceType;
(function (InstanceType) {
    InstanceType["BURSTABLE3_XLARGE"] = "bc.t3.xlarge";
    InstanceType["STANDARD5_XLARGE"] = "bc.m5.xlarge";
    InstanceType["STANDARD5_XLARGE2"] = "bc.m5.2xlarge";
    InstanceType["STANDARD5_XLARGE4"] = "bc.m5.4xlarge";
    InstanceType["COMPUTE5_XLARGE2"] = "bc.c5.2xlarge";
    InstanceType["COMPUTE5_XLARGE4"] = "bc.c5.4xlarge";
})(InstanceType = exports.InstanceType || (exports.InstanceType = {}));
/**
 * Supported Ethereum networks for Managed Blockchain nodes
 */
var Network;
(function (Network) {
    Network["MAINNET"] = "n-ethereum-mainnet";
    Network["GOERLI"] = "n-ethereum-goerli";
    Network["RINKEBY"] = "n-ethereum-rinkeby";
    Network["ROPSTEN"] = "n-ethereum-ropsten";
})(Network = exports.Network || (exports.Network = {}));
class EthereumNode extends constructs.Construct {
    /**
     * Creates an Ethereum public network node on an Amazon Managed Blockchain network
    */
    constructor(scope, id, props) {
        super(scope, id);
        const region = cdk.Stack.of(this).region;
        const availabilityZones = cdk.Stack.of(this).availabilityZones;
        var regionInEnvironment = !cdk.Token.isUnresolved(region);
        /**
         * Builds out Ethereum node given a list of input property objects,
         * using defaults if values not provided; additionally checks to ensure node deployment
         * is supported given region and availability zone
         */
        if (typeof props === 'undefined')
            props = {};
        // If no node configurations are provided, create one; the empty object
        // will be populated with defaults when passed to the node constructor
        this.network = props.network ?? Network.MAINNET;
        this.instanceType = props.instanceType ?? InstanceType.BURSTABLE3_XLARGE;
        this.region = region;
        // If no availability zone is provided, use the first in the region.
        if (regionInEnvironment) {
            utilities.validateRegion(region);
            this.availabilityZone = props.availabilityZone ?? `${region}a`;
            utilities.validateAvailabilityZone(region, this.availabilityZone);
        }
        else {
            this.availabilityZone = props.availabilityZone ?? availabilityZones[0];
        }
        /**
         * Build out CloudFormation resources populating with input values or defaults if none provided
         */
        new managedblockchain.CfnNode(this, id, {
            networkId: this.network,
            nodeConfiguration: {
                availabilityZone: this.availabilityZone,
                instanceType: this.instanceType,
            },
        });
    }
}
exports.EthereumNode = EthereumNode;
_a = JSII_RTTI_SYMBOL_1;
EthereumNode[_a] = { fqn: "@cdklabs/cdk-ethereum-node.EthereumNode", version: "0.0.380" };
//# sourceMappingURL=data:application/json;base64,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