# mammos-entity

`mammos-entity` provides entities. An **entity** is a quantity, which in addition links the entity to its definition in the [ontology](https://mammos-project.github.io/MagneticMaterialsOntology/doc/magnetic_material_mammos.html). A **quantity** is an object that carries a value and units.

| Description   | Badge                                                                                                                                                                                    |
|---------------|------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| Tests         | [![Test package](https://github.com/MaMMoS-project/mammos-entity/actions/workflows/test.yml/badge.svg)](https://github.com/MaMMoS-project/mammos-entity/actions/workflows/test.yml)        |
| Linting       | [![pre-commit.ci status](https://results.pre-commit.ci/badge/github/MaMMoS-project/mammos-entity/main.svg)](https://results.pre-commit.ci/latest/github/MaMMoS-project/mammos-entity/main) |
| Releases      | [![PyPI version](https://badge.fury.io/py/mammos-entity.svg)](https://badge.fury.io/py/mammos-entity)                                                                                      |
| Documentation | [![Documentation](https://img.shields.io/badge/Docs-mammos--project.github.io%2Fmammos-blue)](https://mammos-project.github.io/mammos/index.html)                                        |
| Binder        | [![Binder](https://mybinder.org/badge_logo.svg)](https://mybinder.org/v2/gh/mammos-project/mammos-entity/latest?urlpath=lab%2Ftree%2Fexamples)                                       |
| License       | [![License](https://img.shields.io/badge/License-MIT-blue.svg)](https://opensource.org/licenses/MIT)                                                                                     |
| DOI           | [![DOI](https://zenodo.org/badge/DOI/10.5281/zenodo.15754818.svg)](https://doi.org/10.5281/zenodo.15754818)                                                                               |


## Try it in the cloud
Try `mammos-entity` without installing it locally by directly accessing it directly in the cloud
via Binder.

Simply click the badge in the table above to get started.

Sessions are temporary and may time out after a period of inactivity, and any files
created or modified during your session will not be saved.
To avoid losing your work, please remember to download any files you create or edit
before your session ends.

## Documentation

APIs and tutorials are available in the documentation. To access the documentation, use the badge in the table above.

## Installation

To install `mammos-entity`, you can use `pip install mammos-entity` inside a Python environment.
For more details refer to the documentation.

## License

The code is licensed under MIT.

The ontology files in src/mammos_entity/ontology are licensed under CC-BY-4.0
(LICENSE_ONTOLOGY). `emmo.ttl` is taken from
[EMMO](https://github.com/emmo-repo/EMMO), `magnetic_material_mammos.ttl` is
taken from [MaMMoS
MagneticMaterialsOntology](https://github.com/MaMMoS-project/MagneticMaterialsOntology/tree/main).
No modifications have been made to the ontology files.

## How to cite

TODO

## Acknowledgements

This software has been supported by the European Union’s Horizon Europe research and innovation programme under grant agreement No 101135546 [MaMMoS](https://mammos-project.github.io/).
