"use strict";
var __create = Object.create;
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __getProtoOf = Object.getPrototypeOf;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toESM = (mod, isNodeMode, target) => (target = mod != null ? __create(__getProtoOf(mod)) : {}, __copyProps(
  // If the importer is in node compatibility mode or this is not an ESM
  // file that has been converted to a CommonJS file using a Babel-
  // compatible transform (i.e. "__esModule" has not been set), then set
  // "default" to the CommonJS "module.exports" for node compatibility.
  isNodeMode || !mod || !mod.__esModule ? __defProp(target, "default", { value: mod, enumerable: true }) : target,
  mod
));
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);

// src/provider/credentials-handler.lambda.ts
var credentials_handler_lambda_exports = {};
__export(credentials_handler_lambda_exports, {
  handler: () => handler
});
module.exports = __toCommonJS(credentials_handler_lambda_exports);
var AWS = __toESM(require("aws-sdk"));

// src/provider/calculate-ses-smtp-password.ts
var import_buffer = require("buffer");
var import_crypto = require("crypto");
var sign = (key, message) => {
  const hmac = (0, import_crypto.createHmac)("sha256", import_buffer.Buffer.from(key.map((a) => a.charCodeAt(0)))).update(message);
  return hmac.digest("binary").toString().split("");
};
var calculateSesSmtpPassword = (secretAccessKey, region) => {
  const date = "11111111";
  const service = "ses";
  const terminal = "aws4_request";
  const message = "SendRawEmail";
  const version = [4];
  let signature = sign(`AWS4${secretAccessKey}`.split(""), date);
  signature = sign(signature, region);
  signature = sign(signature, service);
  signature = sign(signature, terminal);
  signature = sign(signature, message);
  const signatureAndVersion = version.slice();
  signature.forEach((a) => signatureAndVersion.push(a.charCodeAt(0)));
  return import_buffer.Buffer.from(signatureAndVersion).toString("base64");
};

// src/provider/credentials-handler.lambda.ts
async function handler(event) {
  const requestType = event.RequestType;
  console.log(`Request of type ${requestType} received`);
  if (requestType == "Create") {
    const username = event.ResourceProperties.UserName;
    const secretId = event.ResourceProperties.SecretId;
    const region = process.env.AWS_DEFAULT_REGION;
    const iam = new AWS.IAM();
    const secretsManager = new AWS.SecretsManager();
    const accessKey = await iam.createAccessKey({
      UserName: username
    }).promise();
    const accessKeyId = accessKey.AccessKey.AccessKeyId;
    const secretAccessKey = accessKey.AccessKey.SecretAccessKey;
    const smtpPassword = calculateSesSmtpPassword(secretAccessKey, region);
    await secretsManager.putSecretValue({
      SecretId: secretId,
      SecretString: JSON.stringify({
        ["username" /* USERNAME */]: accessKeyId,
        ["password" /* PASSWORD */]: smtpPassword
      })
    }).promise();
    return {
      ...event,
      PhysicalResourceId: accessKeyId,
      Data: {
        ...event.ResourceProperties,
        AccessKeyId: accessKeyId
      }
    };
  }
  if (requestType == "Update") {
    console.log("Access key has already been provisioned, no operation to be performed");
  }
  if (requestType == "Delete") {
    console.log(
      "No operation required, deletion of this resource is assumed to occur in conjunction with deletion of an IAM User and a SecretsManager Secret"
    );
  }
  return {
    ...event,
    Data: {
      ...event.ResourceProperties
    }
  };
}
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  handler
});
