"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.calculateSesSmtpPassword = exports.sign = void 0;
const buffer_1 = require("buffer");
const crypto_1 = require("crypto");
exports.sign = (key, message) => {
    const hmac = crypto_1.createHmac("sha256", buffer_1.Buffer.from(key.map((a) => a.charCodeAt(0)))).update(message);
    return hmac.digest("binary").toString().split("");
};
/**
 * https://docs.aws.amazon.com/ses/latest/dg/smtp-credentials.html#smtp-credentials-convert
 */
exports.calculateSesSmtpPassword = (secretAccessKey, region) => {
    const date = "11111111";
    const service = "ses";
    const terminal = "aws4_request";
    const message = "SendRawEmail";
    const version = [0x04];
    let signature = exports.sign(`AWS4${secretAccessKey}`.split(""), date);
    signature = exports.sign(signature, region);
    signature = exports.sign(signature, service);
    signature = exports.sign(signature, terminal);
    signature = exports.sign(signature, message);
    const signatureAndVersion = version.slice(); // copy of array
    signature.forEach((a) => signatureAndVersion.push(a.charCodeAt(0)));
    return buffer_1.Buffer.from(signatureAndVersion).toString("base64");
};
//# sourceMappingURL=data:application/json;base64,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