"""
csmPPI.py

Created by George Scott on 2012-08-01.
Modified by Katherine Dykes 2012.
Copyright (c) NREL. All rights reserved.
"""
import os
import re

PPI_Tables = [
    "Based on Combined Land Based-Offshore Turbine Cost Model. V2.01.05																			",
    "								From gdpchg.xls downloaded from BEA website 8/2010											",
    "								2000	2001	2002	2003	2004	2005	2006	2007	2008	2009	2010	",
    "PPI and GDP Tables								4.1	1.1	1.8	2.5	3.6	3.1	2.7	1.9	-0.3	-3.5	3.0	",
    "								1	1.011	1.029	1.054	1.09	1.121	1.148	1.167	1.164	1.129	1.159	",
    "Gross Domestic Product																			",
    "Year	2000	2001	2002	2003	2004	2005	2006	2007	2008	2009	2010								",
    "Change/2000$ From Previous Period	4.1	1.1	1.8	2.5	3.6	3.1	2.7	1.9	-0.3	-3.5	3.0								",
    "Absolute Value from Previous	1	1.011	1.029	1.054	1.09	1.121	1.148	1.167	1.164	1.129	1.159								",
    "		Yellow Numbers are preliminary																	",
    "	Â PCU3272123272128		198306																",
    "NAICS Code	3272123	'Glass fiber, textile-type, made by establishment producing glass'												Row Numbers					",
    "	Jan	Feb	Mar	Apr	May	June	Jul	Aug	Sep	Oct	Nov	Dec	Annual						",
    "Month #	1	2	3	4	5	6	7	8	9	10	11	12	13	1					",
    "2000	94.2	97.9	100.6	100.7	101.1	101.4	100.1	99.5	101.7	102.1	100.6	101.7	100.1	2					",
    "2001	102.7	103.6	103.8	103.1	106.6	104.6	105.1	103.5	105.3	102.1	102.1	102.2	103.7	3					",
    "2002	102.3	100.7	101.3	98.8	97.0	97.0	97.8	100.2	101.7	96.6	100.6	100.4	99.5	4					",
    "2003	100.9	96.9	96.1	96.1	97.6	98.1	94.8	95.5	95.2	91.9	91.1	89.2	95.3	5					",
    "2004	87.1	87.4	86.8	86.1	86.8	84.2	88.4	87.1	88.7	87.2	87.2	89.1	87.2	6					",
    "2005	89.0	88.8	90.3	90.7	90.6	90.4	90.8	91.1	90.2	90.8	91.0	91.5	90.4	7					",
    "2006	90.7	89.8	89.4	89.4	90.4	90.4	89.7	89.8	90.9	89.6	89.6	88.5	89.8	8					",
    "2007	89.1	88.1	86.7	87.0	86.7	87.1	88.1	87.6	87.5	87.4	87.6	87.1	87.5	9					",
    "2008	87.7	82.1	82.3	82.7	85.1	84.8	84.8	85.3	87.2	87.2	86.8	86.8	85.2	10					",
    "2009	88.1	87.9	87.9	86.6	86.6	85.5	85.5	85.5	85.5	85.5	85.5	85.4	86.3	11					",
    "2010	83.5	82.8	82.8	83.3	83.9	83.9	83.9	83.1	83.1	83.1	83.0	83.0	83.3	12					",
    "2011	82.5	83.5	83.5	83.4	85.2	84.4	84.4							13					",
    "														14					",
    "	PCU3255203255204																		",
    "NAICS Code	3255204	'Synthetic resin & rubber adhesives, incl all types of bonding & laminating adhesives'												Row Numbers					",
    "	Jan	Feb	Mar	Apr	May	June	Jul	Aug	Sep	Oct	Nov	Dec	Annual						",
    "Year/Month #	1	2	3	4	5	6	7	8	9	10	11	12	13	1					",
    "2000	153.1	153.6	154.0	154.2	154.2	155.3	156.2	156.2	156.4	156.7	158.0	158.3	155.5	2					",
    "2001	158.8	160.9	161.0	161.0	161.1	161.2	161.8	163.6	163.5	163.5	163.4	162.3	161.8	3					",
    "2002	162.8	162.7	162.7	162.4	162.3	162.2	162.2	162.1	162.1	161.9	161.9	161.8	162.3	4					",
    "2003	162.4	162.3	163.4	163.7	163.7	163.8	163.9	164.0	165.9	165.9	165.9	166.0	164.2	5					",
    "2004	165.9	167.6	166.2	166.5	166.5	166.6	167.3	168.8	168.8	168.8	169.7	170.0	167.7	6					",
    "2005	171.3	172.2	173.0	172.4	173.8	174.6	174.6	175.2	180.5	182.6	184.8	186.5	176.8	7					",
    "2006	188.9	189.9	191.9	192.3	192.8	192.8	192.1	192.8	193.7	194.6	195.1	195.2	192.7	8					",
    "2007	197.3	200.1	199.8	200.5	200.6	200.6	200.9	201.5	202.0	202.6	202.6	202.8	200.9	9					",
    "2008	204.6	206.0	207.6	208.9	208.4	211.3	220.7	222.1	228.6	229.4	230.1	231.2	217.4	10					",
    "2009	232.2	232.4	232.5	231.8	230.6	230.8	230.9	230.9	230.9	225.9	225.0	224.6	229.9	11					",
    "2010	224.9	226.9	225.9	226.1	226.6	240.3	241.6	241.6	241.6	242.7	243.4	243.4	235.4	12					",
    "2011	245.6	246.5	249.4	250.1	260.8	260.8	260.9							13					",
    "														14					",
    "	PCU3315113315113		198606																",
    "NAICS Code	3315113	Other ductile iron castings												Row Numbers					",
    "	Jan	Feb	Mar	Apr	May	June	Jul	Aug	Sep	Oct	Nov	Dec	Annual						",
    "Year/Month #	1	2	3	4	5	6	7	8	9	10	11	12	13	1					",
    "2000	113.4	113.4	113.5	113.3	113.3	113.3	113.2	113.1	113.1	112.9	113.0	113.0	113.2	2					",
    "2001	112.7	113.2	113.3	113.3	113.3	113.2	112.6	112.7	112.7	112.7	112.7	112.7	112.9	3					",
    "2002	113.0	113.0	113.0	113.0	112.9	113.2	112.7	112.8	113.1	113.2	113.2	113.3	113.0	4					",
    "2003	113.3	113.3	113.3	114.0	114.2	114.2	114.2	114.2	114.2	114.5	114.8	115.2	114.1	5					",
    "2004	115.7	115.8	114.7	117.5	117.0	118.3	118.9	119.3	121.7	123.1	122.7	124.5	119.1	6					",
    "2005	127.3	126.9	126.6	127.3	126.4	125.9	126.6	126.5	123.5	122.3	126.2	128.0	126.1	7					",
    "2006	129.8	129.9	130.2	130.6	129.8	130.4	133.5	134.4	135.0	133.6	132.9	132.6	131.9	8					",
    "2007	130.3	130.9	131.8	134.4	136.2	135.4	137.1	137.4	137.6	137.8	137.9	137.3	135.3	9					",
    "2008	139.2	141.0	141.7	149.2	159.8	168.0	174.2	179.9	179.2	165.2	155.0	147.1	158.3	10					",
    "2009	148.2	150.8	146.7	145.0	143.7	144.1	143.5	145.7	146.0	147.0	146.9	147.6	146.3	11					",
    "2010	149.9	152.5	153.6	158.6	161.8	161.6	160.8	158.2	157.9	159.2	157.7	158.3	157.5	12					",
    "2011	161.2	164.8	164.2	164.9	165.0	165.8	166.3							13					",
    "														13					",
    "	PCU332991332991P		198306																",
    "NAICS Code	332991P	Ball and roller bearings												Row Numbers					",
    "	Jan	Feb	Mar	Apr	May	June	Jul	Aug	Sep	Oct	Nov	Dec	Annual						",
    "Year/Month #	1	2	3	4	5	6	7	8	9	10	11	12	13	1					",
    "2000	165.4	165.7	165.8	165.8	165.8	165.8	167.0	167.9	168.0	168.1	168.1	168.1	166.8	2					",
    "2001	168.5	168.6	167.5	167.5	167.5	167.3	167.4	167.4	168.0	168.0	168.0	168.2	167.8	3					",
    "2002	168.6	168.6	168.6	167.8	167.8	168.4	169.1	169.1	169.2	169.1	169.2	169.5	168.7	4					",
    "2003	170.3	170.3	170.3	170.7	170.7	170.9	170.5	170.5	170.5	170.2	170.2	170.1	170.4	5					",
    "2004	171.0	173.4	173.4	173.5	174.6	175.5	175.5	175.5	175.7	175.8	176.2	176.4	174.7	6					",
    "2005	177.0	179.7	182.5	183.8	184.2	184.3	184.8	185.1	188.1	188.5	187.8	187.9	184.5	7					",
    "2006	188.7	189.9	190.1	190.1	189.8	189.8	193.7	194.3	194.7	194.8	194.8	195.1	192.2	8					",
    "2007	197.5	197.6	197.7	197.5	197.4	197.3	197.4	202.6	202.6	203.0	203.6	203.5	199.8	9					",
    "2008	204.3	204.7	205.2	205.8	207.1	207.9	216.9	217.0	217.3	218.5	218.6	219.9	211.9	10					",
    "2009	220.4	220.9	220.0	219.8	224.1	224.1	224.6	223.6	224.4	224.1	224.1	223.9	222.8	11					",
    "2010	224.9	224.9	225.0	224.9	225.1	225.1	225.5	229.9	229.8	229.9	230.1	230.4	227.1	12					",
    "2011	230.5	230.4	230.8	231.5	231.9	238.1	237.6							13					",
    "														14					",
    "	PCU3353123353123		198306																",
    "NAICS Code	3353123	Integral horsepower motors and generators other than for trans equipment												Row Numbers					",
    "	Jan	Feb	Mar	Apr	May	June	Jul	Aug	Sep	Oct	Nov	Dec	Annual						",
    "Year/Month #	1	2	3	4	5	6	7	8	9	10	11	12	13	1					",
    "2000	147.1	146.8	147.3	147.6	147.6	147.6	147.6	147.7	147.8	147.4	147.4	147.4	147.5	2					",
    "2001	147.7	148.0	149.1	149.1	149.3	149.0	149.0	149.0	148.9	149.0	149.5	149.7	148.9	3					",
    "2002	150.0	149.9	149.9	150.0	150.3	150.3	150.3	150.3	149.6	149.7	149.6	149.5	149.9	4					",
    "2003	149.5	149.3	149.4	149.3	149.2	149.2	149.2	149.2	149.2	149.1	149.1	149.4	149.3	5					",
    "2004	149.4	149.4	150.2	150.5	150.7	153.5	153.9	153.9	153.9	154.0	154.0	157.3	152.6	6					",
    "2005	160.5	160.5	160.9	160.9	161.1	161.9	162.5	162.8	162.5	163.6	167.4	169.1	162.8	7					",
    "2006	168.5	168.5	168.6	171.0	171.0	171.0	171.8	179.0	180.3	181.7	181.7	181.8	174.6	8					",
    "2007	183.8	183.8	183.8	185.7	186.0	188.8	188.9	189.0	189.1	190.6	191.9	192.6	187.8	9					",
    "2008	193.4	193.8	194.8	197.8	200.3	202.4	209.6	210.4	211.8	213.1	214.0	214.0	204.6	10					",
    "2009	213.7	214.4	214.1	210.9	210.3	209.3	208.8	208.9	208.4	207.5	207.5	207.7	210.1	11					",
    "2010	207.4	206.4	206.9	207.3	207.5	221.5	221.8	222.5	222.9	223.3	223.3	223.4	216.2	12					",
    "2011	231.9	233.0	234.1	233.2	234.8	245.1	245.3							13					",
    "														14					",
    "	PCU333612333612P		198312																",
    "NAICS Code	333612P	'Speed changer, industrial high-speed, & gear mfg.'												Row Numbers					",
    "	Jan	Feb	Mar	Apr	May	June	Jul	Aug	Sep	Oct	Nov	Dec	Annual						",
    "Year/Month #	1	2	3	4	5	6	7	8	9	10	11	12	13	1					",
    "2000	159.3	159.4	159.7	159.7	160.3	160.3	160.3	160.4	160.4	160.8	161.1	162.0	160.3	2					",
    "2001	162.9	163.5	163.6	163.6	163.5	163.5	163.6	163.6	163.6	163.5	164.3	164.5	163.7	3					",
    "2002	165.4	165.4	165.5	165.1	165.1	165.2	165.2	165.2	165.2	165.6	166.0	166.1	165.4	4					",
    "2003	168.8	168.6	168.2	168.2	168.2	168.1	167.0	167.0	167.0	167.1	168.3	169.5	168.0	5					",
    "2004	170.5	171.3	171.2	173.4	173.5	175.8	176.4	176.5	176.5	176.4	176.6	177.0	174.6	6					",
    "2005	180.6	180.4	184.6	184.6	184.6	184.6	184.7	185.5	185.8	187.9	188.7	188.1	185.0	7					",
    "2006	189.4	190.4	190.5	190.6	190.9	190.8	191.7	191.9	192.2	193.4	197.2	197.3	192.2	8					",
    "2007	198.5	199.0	200.0	200.0	199.9	200.5	200.9	201.8	202.8	206.2	207.2	207.2	202.0	9					",
    "2008	209.5	209.7	209.3	210.0	211.5	212.1	219.6	221.6	221.7	222.0	223.1	226.4	216.4	10					",
    "2009	225.3	225.4	225.3	224.2	223.6	222.8	223.6	222.0	222.1	222.3	220.5	220.3	223.1	11					",
    "2010	220.8	220.7	220.8	221.2	221.5	220.1	222.4	223.2	223.2	223.3	223.5	226.9	222.3	12					",
    "2011	229.0	229.3	229.6	232.7	232.8	233.7	234.7							13					",
    "														14					",
    "	PCU334513334513		198306																",
    "NAICS Code	334513	Industrial process control manufacturing												Row Numbers					",
    "	Jan	Feb	Mar	Apr	May	June	Jul	Aug	Sep	Oct	Nov	Dec	Annual						",
    "Year/Month #	1	2	3	4	5	6	7	8	9	10	11	12	13	1					",
    "2000	152.2	152.3	152.2	152.1	152.4	152.4	152.3	152.3	152.3	152.5	152.5	152.5	152.3	2					",
    "2001	153.7	153.9	154.0	154.2	154.2	154.3	154.2	154.4	154.3	154.5	155.1	155.1	154.3	3					",
    "2002	155.2	156.6	156.7	156.7	156.4	156.5	156.5	157.0	157.1	157.2	157.3	158.2	156.8	4					",
    "2003	159.1	159.1	159.2	160.1	160.0	160.0	160.0	160.9	160.9	161.0	161.0	161.0	160.2	5					",
    "2004	161.1	161.1	161.1	162.9	164.0	164.2	164.4	164.4	164.4	164.4	164.3	166.9	163.6	6					",
    "2005	166.8	167.3	167.0	167.3	168.8	169.2	169.3	168.7	168.6	169.4	169.5	169.7	168.5	7					",
    "2006	171.1	171.9	172.0	173.6	173.5	173.7	174.2	173.9	174.0	174.3	174.4	175.6	173.5	8					",
    "2007	177.9	178.1	177.9	178.8	180.6	181.3	182.3	181.9	181.7	182.2	182.0	182.5	180.6	9					",
    "2008	183.9	183.9	183.8	184.8	185.1	185.1	185.8	187.0	187.8	188.4	189.0	189.1	186.1	10					",
    "2009	191.1	191.6	191.7	192.0	192.0	191.9	192.3	192.4	192.6	192.4	192.7	193.5	192.2	11					",
    "2010	193.9	193.9	194.1	193.6	193.4	193.5	193.3	193.9	194.0	193.8	194.5	195.8	194.0	12					",
    "2011	197.0	199.0	199.0	200.6	200.8	200.9	202.7							13					",
    "														14					",
    "	PCU3315133315131		198106																",
    "NAICS Code	3315131	Cast carbon steel castings												Row Numbers					",
    "	Jan	Feb	Mar	Apr	May	June	Jul	Aug	Sep	Oct	Nov	Dec	Annual						",
    "Year/Month #	1	2	3	4	5	6	7	8	9	10	11	12	13	1					",
    "2000	146.4	146.5	146.1	145.6	145.5	144.6	144.1	144.2	143.9	143.9	143.0	142.9	144.7	2					",
    "2001	142.4	142.7	142.2	142.2	142.7	142.5	142.9	142.8	143.2	142.8	143.5	143.5	142.8	3					",
    "2002	143.5	143.6	142.5	142.2	142.7	142.7	142.8	142.8	142.9	144.7	145.0	144.6	143.3	4					",
    "2003	144.4	145.5	145.9	146.1	147.4	147.9	148.6	149.5	150.5	152.2	152.6	151.2	148.5	5					",
    "2004	152.9	155.3	157.0	159.6	160.6	160.6	160.6	161.4	171.6	175.1	176.8	179.6	164.2	6					",
    "2005	180.3	182.5	182.2	184.1	184.4	185.3	187.3	191.1	191.5	193.0	193.0	195.4	187.5	7					",
    "2006	197.4	198.1	198.2	198.9	198.6	199.0	198.8	198.4	198.3	198.3	198.3	198.3	198.4	8					",
    "2007	200.4	200.3	200.2	200.5	202.2	201.4	201.7	202.2	202.1	202.0	202.7	203.3	201.6	9					",
    "2008	203.7	211.8	213.6	218.5	218.7	218.7	221.0	221.4	221.4	221.4	220.9	220.0	217.6	10					",
    "2009	220.2	221.6	221.6	222.1	221.1	220.5	220.8	220.8	220.8	221.0	220.9	220.9	221.0	11					",
    "2010	221.1	221.1	221.1	223.4	223.4	223.3	223.6	223.6	223.6	224.4	224.8	225.3	223.2	12					",
    "2011	225.4	226.6	226.0	224.9	230.3	228.8	228.8							13					",
    "														14					",
    "	PCU335312335312P		198306																",
    "NAICS Code	335312P	'Motor & generator mfg, Primary Products'												Row Numbers					",
    "	Jan	Feb	Mar	Apr	May	June	Jul	Aug	Sep	Oct	Nov	Dec	Annual						",
    "Year/Month #	1	2	3	4	5	6	7	8	9	10	11	12	13	1					",
    "2000	139.2	139.3	139.4	139.0	139.1	139.0	139.3	139.5	139.5	139.4	139.4	139.5	139.3	2					",
    "2001	139.6	139.7	140.1	140.0	140.0	140.0	140.3	140.3	140.2	139.4	139.4	139.5	139.9	3					",
    "2002	139.7	139.7	139.6	139.9	140.0	139.9	139.9	140.0	139.9	139.5	140.4	140.5	139.9	4					",
    "2003	140.6	140.6	140.6	140.5	140.7	140.5	140.5	140.5	140.6	140.5	140.5	140.6	140.6	5					",
    "2004	140.6	140.8	141.3	141.7	141.7	143.3	143.7	144.2	144.1	144.2	144.5	147.2	143.1	6					",
    "2005	150.2	150.3	150.4	150.6	150.7	150.8	151.3	151.3	151.1	152.3	153.6	153.9	151.4	7					",
    "2006	154.5	154.6	154.7	156.0	156.0	157.5	158.9	161.8	162.0	162.3	162.6	162.6	158.6	8					",
    "2007	163.8	164.9	164.9	165.9	165.6	166.4	167.2	167.3	167.3	167.6	167.9	168.1	166.4	9					",
    "2008	170.0	170.5	171.1	172.1	173.4	174.0	176.6	178.2	178.2	178.5	178.6	178.6	175.0	10					",
    "2009	179.4	179.9	180.1	179.5	179.8	179.6	179.4	180.1	180.0	180.0	180.0	180.0	179.8	11					",
    "2010	180.1	179.9	180.7	181.0	181.5	185.2	185.3	185.4	185.3	185.6	185.7	186.9	183.6	12					",
    "2011	190.9	191.1	192.6	192.4	193.1	196.3	196.3							13					",
    "														14					",
    "	PCU335314335314P		198506																",
    "NAICS Code	335314P	Relay & industrial control mfg												Row Numbers					",
    "	Jan	Feb	Mar	Apr	May	June	Jul	Aug	Sep	Oct	Nov	Dec	Annual						",
    "Year/Month #	1	2	3	4	5	6	7	8	9	10	11	12	13	1					",
    "2000	142.9	143.4	143.5	143.7	143.0	143.0	143.1	144.2	144.3	144.4	144.7	144.8	143.7	2					",
    "2001	145.4	146.4	146.9	147.1	147.1	147.2	146.9	147.0	146.9	146.9	147.3	149.0	147.0	3					",
    "2002	149.3	148.9	148.9	148.8	149.2	149.2	147.4	147.4	147.4	147.9	149.3	149.4	148.6	4					",
    "2003	149.6	149.9	149.9	150.0	150.0	150.5	150.7	150.7	151.9	151.8	151.9	152.0	150.7	5					",
    "2004	152.0	152.1	153.4	153.3	153.6	154.1	154.1	154.1	155.5	155.8	155.9	156.1	154.2	6					",
    "2005	156.6	157.4	157.8	157.8	157.9	158.2	158.4	158.4	164.7	163.0	162.8	162.9	159.6	7					",
    "2006	164.2	164.4	165.3	165.4	165.5	165.7	166.7	166.7	171.2	172.6	172.5	172.3	167.7	8					",
    "2007	172.3	172.3	173.7	173.8	172.2	172.2	172.2	172.6	176.2	176.3	176.3	176.4	173.9	9					",
    "2008	177.3	178.6	178.8	178.8	178.9	179.2	179.8	179.9	186.7	186.8	186.8	186.9	181.5	10					",
    "2009	187.4	187.4	187.4	187.4	187.5	187.6	187.9	188.0	188.1	188.1	188.4	188.5	187.8	11					",
    "2010	188.7	192.6	193.7	193.9	194.3	194.2	194.9	194.9	194.9	195.0	197.1	197.0	194.3	12					",
    "2011	197.2	197.8	198.6	198.1	198.2	200.4	200.7							13					",
    "														14					",
    "	PCU3363403363401		198812																",
    "NAICS Code	3363401	'Motor vehicle brake parts and assemblies, new'												Row Numbers					",
    "	Jan	Feb	Mar	Apr	May	June	Jul	Aug	Sep	Oct	Nov	Dec	Annual						",
    "Year/Month #	1	2	3	4	5	6	7	8	9	10	11	12	13	1					",
    "2000	108.8	108.7	108.8	108.8	108.3	108.6	108.7	108.6	108.6	108.5	108.3	108.3	108.6	2					",
    "2001	108.1	108.1	108.1	107.9	106.8	106.8	106.9	106.9	107.0	107.0	107.0	107.0	107.3	3					",
    "2002	106.9	106.9	106.9	106.8	106.7	106.7	106.6	106.7	106.7	106.6	106.6	106.4	106.7	4					",
    "2003	106.4	106.2	106.2	106.2	106.2	106.0	107.0	107.0	107.1	106.6	106.4	106.0	106.5	5					",
    "2004	105.5	105.5	105.7	105.7	105.7	105.5	105.5	105.2	105.2	105.2	105.2	105.5	105.4	6					",
    "2005	106.2	106.2	106.2	106.2	106.2	106.2	106.5	106.6	106.3	106.3	106.8	106.8	106.4	7					",
    "2006	107.0	107.2	107.2	107.3	107.2	107.2	107.0	106.9	106.9	106.9	106.9	106.9	107.0	8					",
    "2007	107.0	107.4	107.4	107.5	107.5	107.5	107.1	107.1	107.1	107.0	107.0	107.0	107.2	9					",
    "2008	107.1	107.0	106.4	106.7	106.7	107.5	107.2	109.5	110.7	111.6	111.9	111.2	108.6	10					",
    "2009	110.6	110.6	110.5	110.5	110.4	109.9	109.8	108.6	108.9	108.8	108.8	108.8	109.7	11					",
    "2010	108.7	108.6	108.8	109.4	109.7	109.8	109.8	109.8	109.8	109.6	109.6	110.1	109.5	12					",
    "2011	110.2	110.7	111.5	111.1	111.3	111.9	112.0							13					",
    "														14					",
    "	PCU335313335313P		198506																",
    "NAICS Code	335313P	'Switchgear & switchboard apparatus mfg, Primary products'												Row Numbers					",
    "	Jan	Feb	Mar	Apr	May	June	Jul	Aug	Sep	Oct	Nov	Dec	Annual						",
    "Year/Month #	1	2	3	4	5	6	7	8	9	10	11	12	13	1					",
    "2000	143.4	143.9	143.8	144.5	145.1	144.3	144.5	144.0	144.0	143.8	143.7	144.8	144.1	2					",
    "2001	144.2	146.6	146.7	147.9	149.6	150.1	150.9	149.5	150.4	150.6	149.8	148.1	148.7	3					",
    "2002	149.6	150.4	150.3	151.7	150.1	151.2	149.7	150.8	150.4	151.5	151.7	154.0	151.0	4					",
    "2003	154.0	153.3	153.3	153.7	151.6	153.7	150.6	151.9	150.9	151.1	151.6	150.5	152.2	5					",
    "2004	152.1	150.4	152.0	153.9	154.5	154.5	157.8	157.2	157.1	157.3	154.7	155.8	154.8	6					",
    "2005	160.0	159.8	161.9	163.5	162.3	164.0	160.4	161.0	161.3	163.9	163.4	162.0	162.0	7					",
    "2006	164.4	166.6	167.2	167.6	167.3	168.5	168.0	170.9	172.1	172.0	171.5	175.4	169.3	8					",
    "2007	177.7	179.9	181.3	182.2	182.2	182.3	182.7	180.6	185.1	183.4	184.3	184.8	182.2	9					",
    "2008	182.9	185.7	185.8	187.7	187.1	187.7	189.8	192.7	192.3	193.5	192.6	194.2	189.3	10					",
    "2009	196.0	192.0	195.2	196.9	192.2	193.4	193.4	195.8	195.6	196.3	196.8	196.7	195.0	11					",
    "2010	196.4	195.4	196.7	196.9	196.4	198.2	197.1	198.1	197.5	198.5	197.9	198.9	197.3	12					",
    "2011	196.6	197.0	200.3	201.4	199.5	200.1	201.6							13					",
    "														14					",
    "	PCU3359293359291		198212																",
    "NAICS Code	3359291	'Power wire and cable, made in plants that draw wire'												Row Numbers					",
    "	Jan	Feb	Mar	Apr	May	June	Jul	Aug	Sep	Oct	Nov	Dec	Annual						",
    "Year/Month #	1	2	3	4	5	6	7	8	9	10	11	12	13	1					",
    "2000	113.6	115.9	120.7	122.3	124.0	120.9	118.3	118.4	118.9	118.1	118.8	117.3	118.9	2					",
    "2001	117.7	117.8	116.5	114.5	113.2	113.8	109.6	112.3	111.5	110.2	109.9	108.8	113.0	3					",
    "2002	110.4	110.2	111.2	110.4	112.4	111.9	110.0	109.4	108.6	107.6	106.4	108.1	109.7	4					",
    "2003	110.6	108.2	110.8	110.2	116.9	118.3	114.2	119.5	119.2	116.4	116.8	115.5	114.7	5					",
    "2004	118.6	120.1	119.6	128.3	123.7	122.8	122.5	122.0	125.0	134.1	137.3	132.8	125.6	6					",
    "2005	132.9	137.7	139.5	139.3	137.1	142.2	151.9	146.4	148.3	150.2	162.5	180.0	147.3	7					",
    "2006	176.1	171.3	174.9	191.4	215.6	211.7	221.2	231.1	225.0	224.6	215.4	209.0	205.6	8					",
    "2007	207.2	198.7	194.2	213.4	223.3	213.5	212.9	234.0	230.8	227.4	229.0	241.1	218.8	9					",
    "2008	245.5	232.9	246.2	225.5	234.3	226.2	229.1	220.6	227.7	211.2	198.3	188.6	223.8	10					",
    "2009	186.1	184.0	166.0	173.4	177.6	185.6	183.5	191.9	187.8	201.4	200.7	217.1	187.9	11					",
    "2010	219.4	218.6	222.5	226.5	225.2	223.2	222.7	226.2	232.3	234.8	238.2	235.3	227.1	12					",
    "2011	245.4	252.4	260.1	257.7	257.4	252.7	254.5							13					",
    "														14					",
    "	PCU3353113353111		199912																",
    "NAICS Code	3353119	Power and distribution transformers												Row Numbers					",
    "	Jan	Feb	Mar	Apr	May	June	Jul	Aug	Sep	Oct	Nov	Dec	Annual						",
    "Year/Month #	1	2	3	4	5	6	7	8	9	10	11	12	13	1					",
    "2000	100.3	100.8	101.5	101.7	101.7	101.6	100.8	100.5	99.9	100.2	99.2	99.2	100.6	2					",
    "2001	99.8	99.6	99.5	99.8	99.2	99.1	99.1	98.9	98.9	98.8	98.5	98.4	99.1	3					",
    "2002	97.9	97.9	97.5	97.8	98.1	98.2	98.2	98.2	98.2	98.2	98.3	98.3	98.1	4					",
    "2003	98.1	96.9	96.7	96.8	96.7	96.6	97.8	97.9	97.9	97.6	97.5	97.6	97.3	5					",
    "2004	97.8	98.1	98.8	100.0	99.9	100.0	101.0	101.7	103.1	104.2	105.2	108.3	101.5	6					",
    "2005	110.8	110.6	113.5	114.4	114.4	114.4	114.9	115.1	118.5	118.4	125.2	128.5	116.6	7					",
    "2006	127.6	128.3	128.4	130.4	131.2	133.9	137.8	141.5	145.0	145.3	145.1	146.1	136.7	8					",
    "2007	149.6	157.1	158.9	159.4	162.5	161.5	163.0	165.0	162.9	164.0	165.3	164.2	161.1	9					",
    "2008	170.2	170.9	178.4	179.9	183.7	189.9	195.4	194.3	194.6	194.0	178.3	174.4	183.7	10					",
    "2009	165.7	169.5	171.9	171.1	171.0	173.4	172.9	177.1	180.2	181.4	185.6	187.7	175.6	11					",
    "2010	190.5	190.7	190.5	191.1	194.0	192.4	191.6	191.8	191.8	192.6	193.7	193.7	192.0	12					",
    "2011	195.5	198.4	199.9	200.6	203.8	201.4	201.2							13					",
    "														14					",
    "	PCU3339953339952		199006																",
    "NAICS Code	3339954	'Non-aerospace type hydraulic fluid power cylinders & actuators, linera and rotary'												Row Numbers					",
    "	Jan	Feb	Mar	Apr	May	June	Jul	Aug	Sep	Oct	Nov	Dec	Annual						",
    "Year/Month #	1	2	3	4	5	6	7	8	9	10	11	12	13	1					",
    "2000	119.6	120.2	120.2	120.3	120.3	120.3	120.3	120.6	120.5	120.5	120.5	120.5	120.3	2					",
    "2001	121.6	120.6	120.6	120.7	122.7	122.7	122.7	122.7	122.4	122.4	122.4	122.4	122.0	3					",
    "2002	122.4	122.6	122.6	122.6	122.6	122.4	122.4	122.4	122.4	122.4	122.4	122.5	122.5	4					",
    "2003	123.4	122.7	122.7	122.7	122.7	122.7	124.1	123.9	123.9	123.5	123.5	123.5	123.3	5					",
    "2004	125.9	125.9	126.7	128.4	129.6	130.1	130.1	131.7	132.0	134.2	134.2	135.3	130.3	6					",
    "2005	135.3	136.7	138.1	138.3	138.3	139.3	141.0	141.0	141.0	141.0	141.0	141.0	139.3	7					",
    "2006	142.9	142.9	143.2	143.4	143.4	143.9	145.1	145.1	145.1	145.1	145.4	145.2	144.2	8					",
    "2007	146.4	146.4	146.9	148.1	148.1	148.1	148.1	148.1	148.5	148.5	151.3	153.8	148.5	9					",
    "2008	154.3	154.4	154.9	155.9	156.5	159.2	161.0	162.7	163.4	163.0	163.3	163.3	159.3	10					",
    "2009	163.7	162.4	162.3	162.0	161.5	164.8	164.8	164.8	164.8	164.9	164.9	164.9	163.8	11					",
    "2010	165.0	165.1	165.3	165.3	165.7	165.7	166.2	166.8	166.8	166.9	168.0	168.0	166.2	12					",
    "2011	168.0	168.1	168.1	169.5	169.3	169.6	169.9							13					",
    "														14					",
    "	PCU331221331221		198206																",
    "NAICS Code	331221	Rolled steel shape manufacturing												Row Numbers					",
    "	Jan	Feb	Mar	Apr	May	June	Jul	Aug	Sep	Oct	Nov	Dec	Annual						",
    "Year/Month #	1	2	3	4	5	6	7	8	9	10	11	12	13	1					",
    "2000	111.8	112.7	113.0	114.3	115.7	115.1	115.2	115.5	114.5	114.6	111.8	109.1	113.6	2					",
    "2001	108.6	109.7	108.8	108.3	107.9	107.3	107.0	106.6	106.9	106.5	106.4	105.8	107.5	3					",
    "2002	105.3	106.8	108.2	111.4	115.2	117.0	118.5	119.2	117.6	118.3	118.3	118.3	114.5	4					",
    "2003	118.5	118.8	118.5	117.3	117.0	117.3	117.5	117.1	117.5	117.6	119.0	119.9	118.0	5					",
    "2004	123.2	130.6	137.6	144.0	146.4	147.1	148.7	155.6	160.7	163.2	162.6	165.7	148.8	6					",
    "2005	176.4	177.4	174.9	174.0	174.2	167.9	164.6	159.9	162.1	164.5	165.3	167.8	169.1	7					",
    "2006	164.0	163.7	164.5	165.6	167.9	171.1	172.4	172.5	171.9	171.1	170.9	171.0	168.9	8					",
    "2007	169.0	170.3	172.4	175.4	174.8	173.0	171.9	171.5	170.7	169.6	169.7	172.0	171.7	9					",
    "2008	177.4	183.9	191.4	208.0	225.5	240.9	250.8	255.4	251.3	240.6	224.9	213.5	222.0	10					",
    "2009	203.5	196.3	189.5	184.2	177.3	174.4	179.0	182.5	181.5	180.4	177.3	178.1	183.7	11					",
    "2010	182.2	187.4	188.2	190.0	192.6	192.2	190.1	186.6	186.0	185.2	183.4	186.1	187.5	12					",
    "2011	189.7	196.9	205.1	206.8	211.8	209.8	208.7							13					",
    "														14					",
    "																			",
    "NAICS Code	BHWY	Other non-residential construction				Previously through June 2010	PCUBHWY--BHWY--		198606					Row Numbers		BONS-->BHWY					",
    "	Jan	Feb	Mar	Apr	May	June	Jul	Aug	Sep	Oct	Nov	Dec	Annual						",
    "Year/Month #	1	2	3	4	5	6	7	8	9	10	11	12	13	1",
    "2000	61.7227	62.6439	62.4597	62.5518	63.3809	63.1506	62.9203	63.9797	63.7955	63.7494	63.2427	62.8743	63.0393	2",
    "2001	63.4731	63.6573	63.2888	63.7955	64.4404	63.9337	62.9203	63.1046	63.7494	62.3676	61.7688	60.9857	63.1046	3",
    "2002	61.2160	60.9857	61.1239	61.4003	61.6306	61.6766	61.7688	61.8148	61.9070	61.9070	61.6766	61.5845	61.5845	4",
    "2003	62.0451	62.5058	63.0124	63.1506	63.1046	63.0585	62.9664	63.0585	63.0124	62.9664	63.1506	63.1967	62.9203	5",
    "2004	64.7167	65.0392	65.6380	66.8816	68.1253	67.7107	68.7241	69.3229	69.9217	71.6260	71.5799	70.0138	68.2635	6",
    "2005	71.0732	72.0866	73.8830	75.0345	74.8042	75.4030	77.1994	78.3049	81.1147	83.2796	79.9632	79.9171	76.8310	7",
    "2006	81.7596	81.0226	82.6347	85.3984	86.5500	87.7015	88.3464	88.8531	85.6287	84.3851	84.2469	84.7996	85.1221	8",
    "2007	84.3390	85.3063	87.5173	89.6361	91.0180	90.6495	92.1234	90.2349	90.9719	90.9719	94.3805	93.3671	90.0507	9",
    "2008	94.2883	94.8411	98.4800	100.6449	104.6983	107.9687	112.1603	110.2257	111.0548	104.5140	97.6509	92.8144	102.4413	10",
    "2009	93.4592	91.8010	91.2943	92.4919	94.0120	96.1308	94.9332	96.2690	95.8544	95.5781	96.4993	96.4072	94.5647	11",
    "2010	97.9272	97.4666	99.0327	100.1842	100.8291	100.0000	99.9000	100.3000	100.0000	100.8000	101.4000	102.2000	100.0033	12",
    "2011	103.6000	104.8000	107.5000	109.3000	110.8000	110.4000	110.8000							13	",
    "														14					",
    "Note: Data are adjusted from new 2010 baseline in accord with historical  BHWY PPI Values														15					",
    "																			",
    "NAICS Code	BHVY	Other non-residential construction			Previously through June 2010	PCUBHVY--BHVY--		198606						Row Numbers		BONS-->BHVY			",
    "	Jan	Feb	Mar	Apr	May	June	Jul	Aug	Sep	Oct	Nov	Dec	Annual						",
    "Year/Month #	1	2	3	4	5	6	7	8	9	10	11	12	13	1					",
    "2000	66.9257	67.5085	67.9942	67.7513	67.6542	68.2370	68.1399	67.8970	68.3827	68.2856	68.1884	67.8485	67.8970	2",
    "2001	68.0427	68.1399	67.9456	68.2370	68.9169	68.8198	67.8485	67.8485	68.1884	66.9743	66.5857	66.1000	67.7999	3",
    "2002	66.1972	66.1486	66.3915	66.7314	66.6829	66.7800	66.8286	66.9257	67.0714	67.0714	66.8286	66.7314	66.6829	4",
    "2003	67.0228	67.4114	67.6056	67.4114	67.3142	67.4599	67.6056	67.7513	68.1399	68.1399	68.2856	68.4798	67.7028	5",
    "2004	69.5969	70.5682	72.0738	73.4823	74.6965	74.7450	75.5221	76.6877	77.2220	78.4361	78.2904	77.6591	74.8907	6",
    "2005	78.8247	79.6017	80.8159	81.3016	81.0102	81.4959	82.4672	83.1472	84.3613	85.9641	84.1185	84.5070	82.3215	7",
    "2006	85.6241	85.3813	86.3526	88.1496	89.3638	90.5294	91.1608	91.5979	89.5580	88.8295	88.7324	89.1209	88.6838	8",
    "2007	88.6838	89.3152	90.8694	92.4235	93.5406	93.5406	94.5119	93.3949	93.7834	93.8805	95.8718	95.2404	92.9092	9",
    "2008	96.1146	96.9888	99.7086	102.0398	105.3424	108.0622	110.3934	109.1306	109.4220	104.9053	100.0486	96.5032	103.2054	10",
    "2009	96.4546	94.9004	94.0748	93.9291	94.7062	95.8232	94.9490	96.3089	95.8718	95.5804	96.5032	96.4546	95.4832	11",
    "2010	97.9116	97.4745	99.0287	100.1943	100.8256	100.0000	99.9000	100.3000	100.0000	100.8000	101.4000	102.2000	100.0029	12",
    "2011	103.6000	104.8000	107.5000	109.3000	110.8000	110.4000	110.8000							13	",
    "														14					",
    "Note: Data are adjusted from new 2010 baseline in accord with historical  BHVY PPI Values														15					",
    "	PCU4841214841212		199206																",
    "NAICS Code	4841212	'General freight trucking, long-distance, truckload'												Row Numbers					",
    "	Jan	Feb	Mar	Apr	May	June	Jul	Aug	Sep	Oct	Nov	Dec	Annual						",
    "Year/Month #	1	2	3	4	5	6	7	8	9	10	11	12	13	1					",
    "2000	106.1	106.4	107.0	107.5	107.9	108.0	108.1	108.4	109.2	109.5	109.8	109.8	108.1	2					",
    "2001	110.0	109.6	109.4	109.7	109.9	109.9	110.3	110.2	110.4	110.0	109.7	109.3	109.9	3					",
    "2002	108.9	108.8	108.7	109.3	109.3	109.5	109.5	109.8	109.9	110.2	110.4	110.3	109.5	4					",
    "2003	110.4	110.8	111.4	111.6	111.8	111.4	112.4	112.8	113.0	113.3	113.4	113.9	112.2	5					",
    "2004	114.2	115.1	115.2	115.6	116.0	116.7	116.7	117.3	118.3	119.2	120.0	119.4	117.0	6					",
    "2005	120.1	120.9	121.7	122.5	123.3	123.3	123.3	123.6	125.3	127.3	128.0	126.9	123.8	7					",
    "2006	125.6	125.6	125.7	126.1	127.6	128.0	128.1	128.8	129.1	128.6	128.0	127.8	127.4	8					",
    "2007	128.5	128.0	127.7	128.3	128.5	128.2	128.3	128.7	129.0	129.3	130.4	131.3	128.9	9					",
    "2008	131.4	131.3	132.0	133.3	136.4	139.0	139.9	140.2	137.6	137.4	133.8	130.4	135.2	10					",
    "2009	128.3	127.1	125.1	124.2	124.2	124.6	126.1	125.6	126.4	125.4	126.1	125.5	125.7	11					",
    "2010	125.3	125.6	126.7	127.0	128.1	128.6	128.3	128.7	128.8	129.4	131.0	131.5	128.2	12					",
    "2011	132.0	133.0	135.1	136.8	137.8	137.9	137.7							13					",
    "														14					",
    "	PCU3327223327223199		199912																",
    "NAICS Code	332722489	'Other externally threaded metal fasteners, including studs'												Row Numbers					",
    "	Jan	Feb	Mar	Apr	May	June	Jul	Aug	Sep	Oct	Nov	Dec	Annual						",
    "Year/Month #	1	2	3	4	5	6	7	8	9	10	11	12	13	1					",
    "2000	100.0	100.0	100.0	100.1	100.0	100.5	100.8	100.8	100.8	101.0	101.0	101.0	100.5	2					",
    "2001	98.7	98.7	98.6	100.1	100.2	100.2	100.2	100.2	99.4	99.5	99.5	99.5	99.6	3					",
    "2002	99.7	99.3	99.5	99.6	98.9	98.9	98.6	98.6	98.6	98.6	98.4	98.4	98.9	4					",
    "2003	98.4	98.4	98.4	98.4	98.5	98.6	98.6	98.6	98.6	98.6	98.6	98.6	98.5	5					",
    "2004	98.8	98.8	101.6	101.6	101.7	102.8	102.8	103.5	104.4	104.6	104.7	104.7	102.5	6					",
    "2005	104.7	104.8	104.8	105.1	105.1	105.1	105.6	105.6	105.8	105.7	105.7	105.8	105.3	7					",
    "2006	105.7	105.7	105.7	105.7	106.3	106.3	106.5	106.5	106.8	107.4	107.4	107.4	106.5	8					",
    "2007	107.6	107.6	107.6	108.7	109.0	109.0	109.5	109.5	109.5	109.5	109.5	109.5	108.9	9					",
    "2008	112.9	112.9	112.9	112.9	112.9	112.9	115.3	118.4	118.5	118.4	118.4	112.1	114.9	10					",
    "2009	113.8	110.1	110.1	109.8	107.9	108.1	105.8	104.9	102.0	101.8	101.9	101.9	106.5	11					",
    "2010	102.1	102.6	102.6	103.7	103.7	103.7	103.7	103.7	103.7	103.9	103.9	103.9	103.4	12					",
    "2011	104.3	106.2	106.9	106.8	107.2	108.8	108.6							13					",
    "														14					",
    "	PCU326150326150P		200312																",
    "NAICS Code	326150P	Urethane and other foam products												Row Numbers					",
    "	Jan	Feb	Mar	Apr	May	June	Jul	Aug	Sep	Oct	Nov	Dec	Annual						",
    "Year/Month #	1	2	3	4	5	6	7	8	9	10	11	12	13	1					",
    "2000	93.5	93.5	93.5	93.5	93.5	93.5	93.5	93.5	93.5	93.5	93.5	93.5	93.5	2					",
    "2001	96.2	96.2	96.2	96.2	96.2	96.2	96.2	96.2	96.2	96.2	96.2	96.2	96.2	3					",
    "2002	98.0	98.0	98.0	98.0	98.0	98.0	98.0	98.0	98.0	98.0	98.0	98.0	98.0	4					",
    "2003	100.0	100.0	100.0	100.0	100.0	100.0	100.0	100.0	100.0	100.0	100.0	100.0	100.0	5					",
    "2004	99.3	99.2	98.8	99.1	99.2	98.5	98.7	99.2	99.9	100.1	99.7	99.7	99.3	6					",
    "2005	100.7	100.9	102.5	102.8	104.0	104.0	104.5	104.2	105.2	108.3	140.8	132.7	109.4	7					",
    "2006	132.5	132.2	132.1	132.6	133.9	136.4	137.4	139.6	139.9	141.3	140.7	139.1	136.5	8					",
    "2007	136.9	135.9	134.5	131.7	130.3	130.2	129.9	130.0	129.9	130.1	130.0	130.5	131.7	9					",
    "2008	131.0	132.3	132.3	131.6	131.5	133.9	139.4	144.6	146.9	149.9	149.6	144.8	139.0	10					",
    "2009	141.9	141.3	141.3	137.3	138.6	140.4	142.5	142.5	142.9	142.4	141.7	140.7	141.1	11					",
    "2010	140.3	137.5	137.5	137.5	136.3	138.5	138.9	140.6	139.9	138.7	136.9	136.0	138.2	12					",
    "2011	135.7	135.9	135.8	135.5	136.7	141.1	143.1							13					",
    "														14					",
    "Note:  Actual data not available for cells above in yellow.  2003 is base year.  Projected back from base year Using CPI for Calendar Year.																			",
    "																			",
    "NAICS Code														Row Numbers					",
    "	Jan	Feb	Mar	Apr	May	June	Jul	Aug	Sep	Oct	Nov	Dec	Annual						",
    "Year/Month #	1	2	3	4	5	6	7	8	9	10	11	12		1					",
    "2000														2					",
    "2001														3					",
    "2002														4					",
    "2003														5					",
    "2004														6					",
    "2005														7					",
    "2006														8					",
    "2007														9					",
    "2008														10					",
    "2009														11					",
    "2010														12					",
    "2011														13					",
    "																			",
    "NAICS Code														Row Numbers					",
    "	Jan	Feb	Mar	Apr	May	June	Jul	Aug	Sep	Oct	Nov	Dec	Annual						",
    "Year/Month #	1	2	3	4	5	6	7	8	9	10	11	12		1					",
    "2000														2					",
    "2001														3					",
    "2002														4					",
    "2003														5					",
    "2004														6					",
    "2005														7					",
    "2006														8					",
    "2007														9					",
    "2008														10					",
    "2009														11					",
    "2010														12					",
    "2011														13					",
]


class Escalator:
    """
    cost escalator class - computes weighted sum of different PPI_tables
    """

    def __init__(self, x):
        """x is a list"""
        self.name = x[0]  # name
        self.tbls = x[1]  # list of table names
        self.wts = x[2]  # list of weights in pct (0-100.0)

        sum = 0.0
        for i in range(len(self.wts)):
            self.wts[i] *= 0.01
            sum += self.wts[i]
        if abs(sum - 1.0) > 0.0001:
            print(("Weights add up to {0:.5f}".format(sum)))

    def compute(self, ppitbls, sy, sm, ey, em):
        """
        returns cost escalator between start_yr/start_mon and end_yr/end_mon
        ppitbls is a dictionary of PPITbl objects, indexed by NAICS code
        """
        sum = 0.0
        for i in range(len(self.tbls)):
            key = self.tbls[i].strip()
            """if (key == 'GDP'):
                print('Skipping GDP')
                continue"""
            if key not in ppitbls:
                print(("No PPI table %s".format(key)))
                continue
            if (key == "326150P") and (self.name == "Advanced Blade material costs       "):
                ce = ppitbls[key].getEsc(2002, sm, ey, em)
            else:
                ce = ppitbls[key].getEsc(sy, sm, ey, em)
            sum += ce * self.wts[i]
        return sum


# ------------------------------------------------


class PPITbl:
    """a PPITbl object represents a cost table"""

    def __init__(self, code="", name="PPITbl"):
        self.cost = []  # empty list
        self.years = []
        self.name = name
        self.code = code
        pass

    def add_row(self, year, cost_array):
        self.cost.append(cost_array)
        self.years.append(year)
        return 1

    def getEsc(self, start_yr, start_mon, end_yr, end_mon, printFlag=0):
        """return cost escalator between two dates (mon==13 is annual value)"""
        start_row = start_yr - self.years[0]
        end_row = end_yr - self.years[0]

        if start_row < 0:
            print(("\n*** Year start_yr ${0:.2f} before table start {1}\n".format(start_yr, self.years[0])))
            return None
        if end_row >= len(self.cost):
            print(("\n*** Year end_yr ${0:.2f} after table end {1}\n".format(end_yr, self.years[-1])))
            return None
        if len(self.cost[start_row]) < start_mon:
            raise IndexError("Start_mon out of range")
        if len(self.cost[int(end_row)]) < int(end_mon):
            print(("\n*** EM {0:2d} > LER {0:2d} in table {}".format(end_mon, len(self.cost[end_row]), self.code)))
            raise IndexError("End_mon out of range")

        try:
            """print('SR {0:2d} ER {0:2d}'.format(start_row,end_row))
            print('LSR {0:2d} LER {0:2d}'.format(len(self.cost[start_row]),len(self.cost[end_row])))"""
            cost_start = self.cost[start_row][start_mon - 1]
            cost_end = self.cost[int(end_row)][int(end_mon) - 1]
        except:
            print(("Index out of range for table {} {}".format(self.code, self.name)))
            return None
        esc = cost_end / cost_start
        return esc


# --------------------------------------------------------------------------------------


class PPI:
    def __init__(self, ref_yr, ref_mon, curr_yr, curr_mon, debug=0):
        """
        Initialize the PPI class for calculation of PPI indices given a referene year/month and current year/month.

        Parameters
        ----------
        ref_yr : int
          reference PPI year
        ref_mon : int
          reference PPI month
        curr_yr : int
          current PPI year
        curr_mon : int
          current PPI month
        """

        # self.escData = [None] * 37
        self.escData = {}  # try a dictionary
        self.ppitbls = {}  # dictionary of PPITbl objects
        self.yrs_gdp = []
        self.ppi_gdp = []

        self.ref_yr = ref_yr
        self.ref_mon = ref_mon
        self.curr_yr = curr_yr
        self.curr_mon = curr_mon
        self.debug = debug

        itable = -1
        found_tables = False
        found_GDP = False
        iCode = {}
        code = ""

        for line in PPI_Tables:
            words = line.strip().split("\t")
            if not words:
                continue

            if words[0].startswith("Gross Domestic Product"):
                found_GDP = True
                continue
            if found_GDP and words[0].startswith("Year"):
                y = []
                for i in range(1, len(words)):
                    if words[i].startswith("20"):
                        y.append(int(words[i]))
                self.yrs_gdp = y
                continue
            if found_GDP and words[0].startswith("Absolute Value"):
                g = []
                num_re = re.compile(r"[\d\.]+")
                for i in range(1, len(words)):
                    if num_re.search(words[i]):
                        g.append(float(words[i]))
                self.ppi_gdp = g

                code = "GDP"
                self.ppitbls[code] = PPITbl(
                    code=code, name="Gross Domestic Product"
                )  # add a new element to self.ppitbls
                for i in range(len(y)):
                    rvals = []
                    for mon in range(13):
                        rvals.append(g[i])  # fill all monthly values with annual value
                    self.ppitbls[code].add_row(y[i], rvals)
                ippi = len(self.ppitbls) - 1
                iCode[code] = ippi  # index of tables by code
                if self.debug > 0:
                    print(("Created {0:2d} {} {}".format(ippi, code, self.ppitbls[code].name)))
                continue

            if words[0].startswith("NAICS"):
                found_tables = True
                itable += 1
                iyr = 0

                words[2] = words[2].replace(r'"', "")  # strip quotes from name
                code = words[1]
                self.ppitbls[code] = PPITbl(code=code, name=words[2])  # add a new element to self.ppitbls
                ippi = len(self.ppitbls) - 1
                if self.debug > 0:
                    print(("Created {0:2d} {} {}".format(ippi, code, self.ppitbls[code].name)))
                iCode[code] = ippi  # index of tables by code

            if found_tables and words[0].startswith("20"):  # a year number
                rvals = []
                i = 1
                while re.match(r"\d+\.", words[i]):
                    rvals.append(float(words[i]))
                    i += 1
                self.ppitbls[code].add_row(int(words[0]), rvals)
                iyr += 1

        self.escData["IPPI_BLD"] = Escalator(
            [
                "Baseline Blade material costs       ",
                ["3272123", "3255204", "332722489", "326150P"],
                [60.00, 23.00, 8.00, 9.00],
            ]
        )
        self.escData["IPPI_BLA"] = Escalator(
            [
                "Advanced Blade material costs       ",
                ["3272123", "3255204", "332722489", "326150P"],
                [61.00, 27.00, 3.00, 9.00],
            ]
        )
        self.escData["IPPI_BLL"] = Escalator(["Blade Labor costs                   ", ["GDP    "], [100.00]])
        self.escData["IPPI_HUB"] = Escalator(
            [
                "Hub                                 ",
                [
                    "3315113",
                ],
                [100.00],
            ]
        )
        self.escData["IPPI_PMB"] = Escalator(
            [
                "Pitch Mechanisms/Bearings           ",
                ["332991P", "3353123", "333612P  ", "334513"],
                [50.00, 20.00, 20.00, 10.00],
            ]
        )
        self.escData["IPPI_LSS"] = Escalator(["Low speed shaft                     ", ["3315131"], [100.00]])
        self.escData["IPPI_BRN"] = Escalator(["Bearings                            ", ["332991P"], [100.00]])
        self.escData["IPPI_GRB"] = Escalator(["Gearbox                             ", ["333612P"], [100.00]])
        self.escData["IPPI_BRK"] = Escalator(["Mech brake, HS cpling etc           ", ["3363401"], [100.00]])
        self.escData["IPPI_GEN"] = Escalator(["Generator                           ", ["335312P"], [100.00]])
        self.escData["IPPI_VSE"] = Escalator(["Variable spd electronics            ", ["335314P"], [100.00]])
        self.escData["IPPI_YAW"] = Escalator(
            [
                "Yaw drive & bearing                 ",
                [
                    "3353123",
                    "332991P",
                ],
                [50.00, 50.00],
            ]
        )
        self.escData["IPPI_MFM"] = Escalator(["Main frame                          ", ["3315113"], [100.00]])
        self.escData["IPPI_ELC"] = Escalator(
            [
                "Electrical connections              ",
                [
                    "335313P",
                    "3359291",
                    "GDP      ",
                ],
                [25.00, 60.00, 15.00],
            ]
        )
        self.escData["IPPI_HYD"] = Escalator(["Hydraulic system                    ", ["3339954"], [100.00]])
        self.escData["IPPI_NAC"] = Escalator(
            [
                "Nacelle                             ",
                [
                    "3272123",
                    "3255204",
                    "GDP      ",
                ],
                [55.00, 30.00, 15.00],
            ]
        )
        self.escData["IPPI_CTL"] = Escalator(["Control, safety system              ", ["334513 "], [100.00]])
        self.escData["IPPI_MAR"] = Escalator(["Marinization                        ", ["GDP    "], [100.00]])
        self.escData["IPPI_WAR"] = Escalator(["Offshore Warranty Premium           ", ["GDP    "], [100.00]])
        self.escData["IPPI_TWR"] = Escalator(["Tower                               ", ["331221 "], [100.00]])
        self.escData["IPPI_MPF"] = Escalator(["Monopole Foundations                ", ["BHVY   "], [100.00]])
        self.escData["IPPI_TPT"] = Escalator(["Transportation On/Offshore          ", ["4841212"], [100.00]])
        self.escData["IPPI_STP"] = Escalator(["Off Shore Site Prep                 ", ["BHVY   "], [100.00]])
        self.escData["IPPI_LAI"] = Escalator(["Land Based Assembly & installation  ", ["BHVY   "], [100.00]])
        self.escData["IPPI_OAI"] = Escalator(["Offshore Assembly & installation    ", ["BHVY   "], [100.00]])
        self.escData["IPPI_LEL"] = Escalator(
            [
                "Land Based Elect                    ",
                ["3353119", "335313P", "3359291  ", "GDP"],
                [40.00, 15.00, 35.00, 10.00],
            ]
        )
        self.escData["IPPI_OEL"] = Escalator(
            [
                "Offshore Elect                      ",
                ["3353119", "335313P", "3359291  ", "GDP"],
                [5.00, 5.00, 70.00, 20.00],
            ]
        )
        self.escData["IPPI_LPM"] = Escalator(["Permits, engineering (Land Based)   ", ["GDP    "], [100.00]])
        self.escData["IPPI_OPM"] = Escalator(["Permits, engineering (Offshore)     ", ["GDP    "], [100.00]])
        self.escData["IPPI_LLR"] = Escalator(["Land Based Levelized Replacement    ", ["GDP    "], [100.00]])
        self.escData["IPPI_OLR"] = Escalator(["Offshore Levelized Replacement      ", ["GDP    "], [100.00]])
        self.escData["IPPI_LOM"] = Escalator(["O&M Land Based                      ", ["GDP    "], [100.00]])
        self.escData["IPPI_OOM"] = Escalator(["O&M Offshore                        ", ["GDP    "], [100.00]])
        self.escData["IPPI_LSE"] = Escalator(["Land Based & Offshore Lease Cost    ", ["GDP    "], [100.00]])
        self.escData["IPPI_FND"] = Escalator(["Foundations                         ", ["BHVY   "], [100.00]])
        self.escData["IPPI_RDC"] = Escalator(["Road & Civil Work                   ", ["BHWY   "], [100.00]])
        self.escData["IPPI_PAE"] = Escalator(["Personnel Access Equipment          ", ["GDP    "], [100.00]])

    def compute(self, escCode, debug=0):
        """
        Returns the cost escalator for escData object 'escCode', using reference and current yr/mon values.

        Parameters
        ----------
        escCode : object
          codes for different PPI data

        Returns
        -------
        esc : float
          cost escalator for a particular PPI from reference year/month to current year month
        """
        # returns the cost escalator for escData object 'escCode', using reference and current yr/mon values

        if escCode not in self.escData:
            print(("Warning - no such code in PPI {0:.2f}".format(escCode)))
            # return 0
        esc = self.escData[escCode].compute(self.ppitbls, self.ref_yr, self.ref_mon, self.curr_yr, self.curr_mon)
        if debug > 0:
            print(
                (
                    "Escalator {} from {}{:02} to {}{:02} = {:.4}".format(
                        escCode, self.ref_yr, self.ref_mon, self.curr_yr, self.curr_mon, esc
                    )
                )
            )
        return esc


# --------------------------------------------------------------------------------------


def example():
    # test cases

    sy = 2002
    sm = 9
    ey = 2010
    em = 13
    ppi = PPI(sy, sm, ey, em)

    for i in list(ppi.escData.keys()):
        print((ppi.escData[i].name))
        # Use ppi.compute(code) to compute ppi for default interval
        print(("{0:2d} {:.4} ".format(i, ppi.compute(i))))
        print(" " "")


if __name__ == "__main__":
    example()
