# LCAx

The goal for LCAx is to make an open, machine and human-readable data format for exchanging LCA results,
EPD's and assemblies.

We propose a simple three level data format with information on project, assembly and EPD level,
written in an open data format and paired with a validator for a more robust and standardized format.
We intend to create connections to existing tools and API’s.

Our goal is making LCA calculations more accessible, transparent, and open.

![LCAx](./assets/benchmark.png)

# Motivation

We are doing this because we see that many new LCA tools are seeing the light of day recently, but there is no open data
exchange format between different software. This makes it hard to collaborate in interdisciplinary teams, as they all
need to use the same platform for calculations if multiple people are working on the same calculation.

Furthermore, it makes it hard to quality assure an LCA calculation coming from another software than the one you or your
company is using. Having an open data format will make it easier to check if an LCA calculation is compliant with the
requirements for an individual project.

# Get Involved!

In the spirit of transparency and openness, we would like anyone with interest in the project to participate on which
ever level you feel comfortable with. If that is as an LCA specialist that has input to what needs to be included in the
format, or as a developer helping with writing code for the project, or simply spreading the word in your professional
network, we will be thankful for your contribution. 

The more people are involved and aware of the project, the more likely it is to succeed. 
Feel free to reach out to us on [GitHub](https://github.com/ocni-dtu/lcax/issues) or contact us through 
[email](mailto:christian@kongsgaard.eu), and we will get back to you as soon as possible.