# generated by datamodel-codegen:
#   filename:  lcax.schema.json
#   timestamp: 2023-07-05T11:17:07+00:00

from __future__ import annotations

from datetime import datetime
from enum import Enum
from typing import Any, Dict, List, Optional, Union

from pydantic import BaseModel, Extra, conint


class Classification(BaseModel):
    code: str
    name: str
    system: str


class ExternalEPD(BaseModel):
    format: str
    url: str
    version: Optional[str] = None


class ImpactCategory(BaseModel):
    a1a3: Optional[float] = None
    a4: Optional[float] = None
    a5: Optional[float] = None
    b1: Optional[float] = None
    b2: Optional[float] = None
    b3: Optional[float] = None
    b4: Optional[float] = None
    b5: Optional[float] = None
    b6: Optional[float] = None
    b7: Optional[float] = None
    c1: Optional[float] = None
    c2: Optional[float] = None
    c3: Optional[float] = None
    c4: Optional[float] = None
    d: Optional[float] = None


class InternalEPD(BaseModel):
    path: str


class LifeCycleStage(Enum):
    A1A3 = 'A1A3'
    A4 = 'A4'
    A5 = 'A5'
    B1 = 'B1'
    B2 = 'B2'
    B3 = 'B3'
    B4 = 'B4'
    B5 = 'B5'
    B6 = 'B6'
    B7 = 'B7'
    C1 = 'C1'
    C2 = 'C2'
    C3 = 'C3'
    C4 = 'C4'
    D = 'D'


class ResultsEN15804(BaseModel):
    adpe: Optional[ImpactCategory] = None
    adpf: Optional[ImpactCategory] = None
    ap: Optional[ImpactCategory] = None
    cru: Optional[ImpactCategory] = None
    eee: Optional[ImpactCategory] = None
    eet: Optional[ImpactCategory] = None
    ep: Optional[ImpactCategory] = None
    fw: Optional[ImpactCategory] = None
    gwp: Optional[ImpactCategory] = None
    hwd: Optional[ImpactCategory] = None
    mer: Optional[ImpactCategory] = None
    mrf: Optional[ImpactCategory] = None
    nhwd: Optional[ImpactCategory] = None
    nrsf: Optional[ImpactCategory] = None
    odp: Optional[ImpactCategory] = None
    penre: Optional[ImpactCategory] = None
    penrm: Optional[ImpactCategory] = None
    penrt: Optional[ImpactCategory] = None
    pere: Optional[ImpactCategory] = None
    perm: Optional[ImpactCategory] = None
    pert: Optional[ImpactCategory] = None
    pocp: Optional[ImpactCategory] = None
    rsf: Optional[ImpactCategory] = None
    rwd: Optional[ImpactCategory] = None
    sm: Optional[ImpactCategory] = None


class Standard(Enum):
    EN15804A1 = 'EN15804A1'
    EN15804A2 = 'EN15804A2'
    UNKNOWN = 'UNKNOWN'


class SubType(Enum):
    Generic = 'Generic'
    Specific = 'Specific'
    Industry = 'Industry'
    Representative = 'Representative'


class Transport(BaseModel):
    id: str
    name: str


class Unit(Enum):
    M = 'M'
    M2 = 'M2'
    M3 = 'M3'
    KG = 'KG'
    TONES = 'TONES'
    PCS = 'PCS'
    L = 'L'
    M2R1 = 'M2R1'
    UNKNOWN = 'UNKNOWN'


class Conversion(BaseModel):
    to: Unit
    value: float


class EPD(BaseModel):
    adpe: Optional[ImpactCategory] = None
    adpf: Optional[ImpactCategory] = None
    ap: Optional[ImpactCategory] = None
    comment: Optional[str] = None
    conversions: Optional[List[Conversion]] = None
    cru: Optional[ImpactCategory] = None
    declared_unit: Unit
    eee: Optional[ImpactCategory] = None
    eet: Optional[ImpactCategory] = None
    ep: Optional[ImpactCategory] = None
    format_version: str
    fw: Optional[ImpactCategory] = None
    gwp: Optional[ImpactCategory] = None
    hwd: Optional[ImpactCategory] = None
    id: str
    location: str
    mer: Optional[ImpactCategory] = None
    mrf: Optional[ImpactCategory] = None
    name: str
    nhwd: Optional[ImpactCategory] = None
    nrsf: Optional[ImpactCategory] = None
    odp: Optional[ImpactCategory] = None
    penre: Optional[ImpactCategory] = None
    penrm: Optional[ImpactCategory] = None
    penrt: Optional[ImpactCategory] = None
    pere: Optional[ImpactCategory] = None
    perm: Optional[ImpactCategory] = None
    pert: Optional[ImpactCategory] = None
    pocp: Optional[ImpactCategory] = None
    published_date: datetime
    reference_service_life: Optional[conint(ge=0)] = None
    rsf: Optional[ImpactCategory] = None
    rwd: Optional[ImpactCategory] = None
    sm: Optional[ImpactCategory] = None
    source: Optional[str] = None
    standard: Standard
    subtype: SubType
    valid_until: datetime
    version: str


class EPDSourceItem(BaseModel):
    class Config:
        extra = Extra.forbid

    EPD: EPD


class EPDSourceItem1(BaseModel):
    class Config:
        extra = Extra.forbid

    ExternalEPD: ExternalEPD


class EPDSourceItem2(BaseModel):
    class Config:
        extra = Extra.forbid

    InternalEPD: InternalEPD


class EPDSource(BaseModel):
    __root__: Union[EPDSourceItem, EPDSourceItem1, EPDSourceItem2]


class Result(BaseModel):
    class Config:
        extra = Extra.forbid

    EN15804: ResultsEN15804


class Results(BaseModel):
    __root__: Result


class EPDPart(BaseModel):
    epd_source: EPDSource
    id: str
    meta_data: Optional[Dict[str, Any]] = None
    name: str
    part_quantity: float
    part_unit: Unit
    reference_service_life: float
    transport: Optional[Transport] = None


class Assembly(BaseModel):
    category: Optional[str] = None
    classification: Optional[List[Classification]] = None
    comment: Optional[str] = None
    description: str
    id: str
    meta_data: Optional[Dict[str, Any]] = None
    name: str
    parts: Dict[str, EPDPart]
    quantity: float
    results: Optional[Results] = None
    unit: Unit


class LCAxProject(BaseModel):
    classification_system: Optional[str] = None
    comment: Optional[str] = None
    description: str
    emission_parts: Dict[str, Assembly]
    format_version: str
    id: str
    impact_categories: List[ImpactCategory]
    lcia_method: Optional[str] = None
    life_cycle_stages: List[LifeCycleStage]
    location: str
    meta_data: Optional[Dict[str, Any]] = None
    name: str
    results: Optional[Results] = None
