<img src='docs/VPE.png' height="50" width="50"></img>
# Contributing Guidelines

Thank you for your interest in contributing to our project. Whether it's a bug report, new feature, correction, or additional
documentation, we greatly value feedback and contributions from our community.

Please read through this document before submitting any issues or pull requests to ensure we have all the necessary
information to effectively respond to your bug report or contribution.

In addition, please review our [CodeOps](./docs/ops/CodeOps.md) to understand our approach to coding.

## Code contributions
### Reporting Bugs/Feature Requests

Please use the [GitHub issue tracker](https://github.com/VirtualPatientEngine/AIAgents4Pharma/issues) to report bugs or suggest features.

When filing an issue, please check existing open, or recently closed, issues to make sure somebody else hasn't already
reported the issue. Please try to include as much information as you can following the bug and feature templates that we provide.

### Contributing via Pull Requests
Contributions via pull requests are much appreciated. Before sending us a pull request, please review our [DevOps](./docs/ops/DevOps.md) guide, and please ensure that:

1. You are working against the latest source on the *main* branch.
2. You check existing open, and recently merged, pull requests to make sure someone else hasn't addressed the problem already.
3. You open an issue to discuss any significant work - we would hate for your time to be wasted.

### Finding contributions to work on
Looking at the existing issues is a great way to find something to contribute on. As our projects, by default, use the default GitHub issue labels (enhancement/bug/duplicate/help wanted/invalid/question/wontfix), looking at any 'help wanted' issues is a great place to start.

## Code of Conduct
This project follows the [Apache Code of Conduct](https://www.apache.org/foundation/policies/conduct).

## Security issue notifications
If you discover a potential security issue in this project we ask that you notify Team VPE directly. Please do **not** create a public github issue.

## Attributions
Portions adopted from https://github.com/pytorch, https://github.com/rapidsai, and https://github.com/aws-samples/
