# SonarCloud Integration Setup Guide

## Overview

SonarCloud provides advanced code quality analysis, security scanning, and technical debt tracking for the AIAgents4Pharma project. This document outlines the setup and configuration process.

## Setup Steps

### 1. SonarCloud Account Setup

1. **Create SonarCloud Account**: Go to [sonarcloud.io](https://sonarcloud.io) and sign in with GitHub
2. **Import Repository**: Import the `VirtualPatientEngine/AIAgents4Pharma` repository
3. **Generate Token**: Go to Account → Security → Generate new token

### 2. GitHub Repository Configuration

Add the following secrets to your GitHub repository settings:

```bash
# Repository Settings → Secrets and variables → Actions
SONAR_TOKEN=your_sonarcloud_token_here
```

### 3. SonarCloud Project Configuration

The project is configured with:

- **Project Key**: `VirtualPatientEngine_AIAgents4Pharma`
- **Organization**: `virtualpatientengine`
- **Quality Gate**: Uses SonarCloud's default quality gate

### 4. Analysis Configuration

The analysis includes:

#### Code Quality Metrics
- **Code Coverage**: Minimum 80% coverage required
- **Duplicated Code**: Less than 3% duplication
- **Maintainability Rating**: A rating required
- **Reliability Rating**: A rating required
- **Security Rating**: A rating required

#### Security Analysis
- **Security Hotspots**: Automatic detection of security issues
- **Vulnerabilities**: OWASP Top 10 compliance checking
- **Code Smells**: Anti-pattern detection

#### Technical Debt
- **Maintainability**: Technical debt ratio tracking
- **Code Complexity**: Cyclomatic complexity analysis
- **Test Coverage**: Line and branch coverage analysis

## Workflow Integration

### Automatic Analysis
The SonarCloud workflow runs on:
- **After test completion**: Triggered when any of the 5 test workflows complete successfully
- **Manual trigger**: On-demand analysis via workflow_dispatch
- **Artifact-based**: Uses pre-generated test reports for efficient analysis

### Modern CI/CD Approach
- **Sequential execution**: SonarCloud waits for test workflows to complete
- **Artifact reuse**: Downloads coverage and quality reports from test workflows
- **No duplicate testing**: Eliminates redundant test execution for efficiency
- **Component-specific**: Analyzes reports from all 5 submodule test workflows

### Workflow Architecture
```
PR/Push → Test Workflows (5 submodules) → Generate Artifacts → SonarCloud Analysis
         ├─ Talk2Scholars
         ├─ Talk2AIAgents4Pharma
         ├─ Talk2BioModels
         ├─ Talk2KnowledgeGraphs
         └─ Talk2Cells
                     ↓
            Artifacts Generated:
            - quality-reports-{module}
            - test-reports-{module}
                     ↓
              SonarCloud Downloads & Analyzes
```

### Workflow Triggers
- **workflow_run**: Triggered when any of the 5 test workflows complete successfully
- **workflow_dispatch**: Manual trigger for on-demand analysis
- **Conditional execution**: Only runs if test workflow conclusion is 'success'

### Quality Gates
- **Test-dependent**: Only runs on successful test completion
- **Artifact-driven**: Uses pylint, bandit, and coverage reports from test workflows
- **Coverage**: Requires minimum coverage on new code

## Reports Generated

### From Test Workflows (Artifacts)
1. **Code Coverage Report**: `coverage.xml` - Generated by each test workflow (Ubuntu only)
2. **PyLint Analysis**: `pylint-report.json` - Static analysis reports with configuration from `pyproject.toml`
3. **Security Scan**: `bandit-report.json` - Security vulnerability reports

### Test Workflow Artifacts
- **Quality Reports**: `quality-reports-{module}` - Pylint and Bandit JSON outputs
- **Test Reports**: `test-reports-{module}` - Coverage XML files
- **Retention**: 1-day retention for efficient CI/CD pipeline

### SonarCloud Outputs
4. **SonarCloud Dashboard**: Available on sonarcloud.io with comprehensive analysis
5. **SARIF Reports**: Uploaded to GitHub Security tab
6. **PR Comments**: Automated code quality feedback on pull requests

## Quality Standards

### Coverage Requirements
- **Overall Coverage**: ≥ 80%
- **New Code Coverage**: ≥ 90%
- **Duplicated Lines**: < 3%

### Security Standards
- **Security Rating**: A (no vulnerabilities)
- **Security Hotspots**: All reviewed
- **Bandit Issues**: Critical issues must be resolved
- **Dependency Security**: pip-audit and safety scans clean
- **File Upload Security**: Streamlit uploads validated and secure

### Maintainability
- **Maintainability Rating**: A
- **Code Smells**: < 10 per 1000 lines
- **Technical Debt**: < 5% of total development time

## Local Analysis

Run SonarCloud analysis locally:

```bash
# Install SonarScanner
npm install -g sonarqube-scanner

# Run analysis
sonar-scanner \
  -Dsonar.projectKey=VirtualPatientEngine_AIAgents4Pharma \
  -Dsonar.organization=virtualpatientengine \
  -Dsonar.sources=aiagents4pharma \
  -Dsonar.host.url=https://sonarcloud.io \
  -Dsonar.login=your_token_here
```

## Troubleshooting

### Common Issues

1. **Coverage Not Detected**
   - Ensure `coverage.xml` is generated
   - Check file paths in `sonar-project.properties`

2. **Quality Gate Failure**
   - Review SonarCloud dashboard for specific issues
   - Address code smells and security hotspots

3. **Token Issues**
   - Regenerate SONAR_TOKEN in SonarCloud
   - Update GitHub repository secrets

### Configuration Files

- `pyproject.toml`:
  - SonarCloud project settings (`[tool.sonarcloud]`)
  - Pylint configuration (`[tool.pylint.messages_control]`)
  - Coverage settings (`[tool.coverage.*]`)
  - Bandit security configuration (`[tool.bandit]`)
- `.github/workflows/sonarcloud.yml`: Modern artifact-based CI/CD workflow
- Test workflows: Generate and upload reports as artifacts for SonarCloud consumption

## Benefits

### For Developers
- **Real-time Feedback**: Immediate code quality feedback
- **Security Awareness**: Automated security vulnerability detection
- **Best Practices**: Enforcement of coding standards

### For Project
- **Quality Assurance**: Consistent code quality across contributors
- **Technical Debt Management**: Tracking and reduction of technical debt
- **Security Compliance**: Continuous security monitoring

### For Users
- **Reliability**: Higher code quality leads to fewer bugs
- **Security**: Enhanced security through automated scanning
- **Maintainability**: Easier to contribute to well-maintained codebase
