"""Use Text type [7280c14811d6].

Revision ID: 7280c14811d6
Revises: 5994f9ad0489
Create Date: 2022-11-09 16:29:37.025589

"""

import sqlalchemy as sa
from alembic import op

# revision identifiers, used by Alembic.
revision = "7280c14811d6"
down_revision = "5994f9ad0489"
branch_labels = None
depends_on = None


def upgrade() -> None:
    """Upgrade database schema and/or data, creating a new revision."""
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table("pipelinerunschema", schema=None) as batch_op:
        batch_op.alter_column(
            "pipeline_configuration",
            existing_type=sa.VARCHAR(length=4096),
            type_=sa.TEXT(),
            existing_nullable=False,
        )

    with op.batch_alter_table("pipelineschema", schema=None) as batch_op:
        batch_op.alter_column(
            "docstring",
            existing_type=sa.VARCHAR(length=4096),
            type_=sa.TEXT(),
            existing_nullable=True,
        )
        batch_op.alter_column(
            "spec",
            existing_type=sa.VARCHAR(length=4096),
            type_=sa.TEXT(),
            existing_nullable=False,
        )

    with op.batch_alter_table("steprunschema", schema=None) as batch_op:
        batch_op.alter_column(
            "parameters",
            existing_type=sa.VARCHAR(length=4096),
            type_=sa.TEXT(),
            existing_nullable=False,
        )
        batch_op.alter_column(
            "step_configuration",
            existing_type=sa.VARCHAR(length=4096),
            type_=sa.TEXT(),
            existing_nullable=False,
        )
        batch_op.alter_column(
            "docstring",
            existing_type=sa.VARCHAR(length=4096),
            type_=sa.TEXT(),
            existing_nullable=True,
        )

    # ### end Alembic commands ###


def downgrade() -> None:
    """Downgrade database schema and/or data back to the previous revision."""
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table("steprunschema", schema=None) as batch_op:
        batch_op.alter_column(
            "docstring",
            existing_type=sa.TEXT(),
            type_=sa.VARCHAR(length=4096),
            existing_nullable=True,
        )
        batch_op.alter_column(
            "step_configuration",
            existing_type=sa.TEXT(),
            type_=sa.VARCHAR(length=4096),
            existing_nullable=False,
        )
        batch_op.alter_column(
            "parameters",
            existing_type=sa.TEXT(),
            type_=sa.VARCHAR(length=4096),
            existing_nullable=False,
        )

    with op.batch_alter_table("pipelineschema", schema=None) as batch_op:
        batch_op.alter_column(
            "spec",
            existing_type=sa.TEXT(),
            type_=sa.VARCHAR(length=4096),
            existing_nullable=False,
        )
        batch_op.alter_column(
            "docstring",
            existing_type=sa.TEXT(),
            type_=sa.VARCHAR(length=4096),
            existing_nullable=True,
        )

    with op.batch_alter_table("pipelinerunschema", schema=None) as batch_op:
        batch_op.alter_column(
            "pipeline_configuration",
            existing_type=sa.TEXT(),
            type_=sa.VARCHAR(length=4096),
            existing_nullable=False,
        )

    # ### end Alembic commands ###
