"""Add code repo description and logo URL [979eff8fc4b1].

Revision ID: 979eff8fc4b1
Revises: 0.38.0
Create Date: 2023-04-20 12:11:34.058047

"""

import sqlalchemy as sa
import sqlmodel
from alembic import op

# revision identifiers, used by Alembic.
revision = "979eff8fc4b1"
down_revision = "0.38.0"
branch_labels = None
depends_on = None


def upgrade() -> None:
    """Upgrade database schema and/or data, creating a new revision."""
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table("code_repository", schema=None) as batch_op:
        batch_op.add_column(sa.Column("description", sa.TEXT(), nullable=True))
        batch_op.add_column(
            sa.Column(
                "logo_url", sqlmodel.sql.sqltypes.AutoString(), nullable=True
            )
        )

    # ### end Alembic commands ###


def downgrade() -> None:
    """Downgrade database schema and/or data back to the previous revision."""
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table("code_repository", schema=None) as batch_op:
        batch_op.drop_column("logo_url")
        batch_op.drop_column("description")

    # ### end Alembic commands ###
