"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __exportStar = (this && this.__exportStar) || function(m, exports) {
    for (var p in m) if (p !== "default" && !Object.prototype.hasOwnProperty.call(exports, p)) __createBinding(exports, m, p);
};
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.JsiiProject = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const projen_1 = require("projen");
const codeowners_1 = require("../../components/github/codeowners");
const pull_request_template_1 = require("../../components/github/pull-request-template");
const readme_1 = require("../../components/readme");
const merge_options_1 = require("../../utils/merge-options");
function getOptions(options) {
    const { name } = options;
    const defaults = {
        name,
        autoMerge: true,
        defaultReleaseBranch: 'main',
        gitignore: ['.npmrc', '.vscode'],
        pullRequestTemplateContents: pull_request_template_1.DEFAULT_PULL_REQUEST_TEMPLATE,
        projenrcTs: true,
    };
    return (0, merge_options_1.mergeOptions)(defaults, options);
}
/**
 * A JSII project in TypeScript
 *
 *
 * @pjid jsii-project
 */
class JsiiProject extends projen_1.cdk.JsiiProject {
    constructor(options) {
        const mergedOptions = getOptions(options);
        super({
            ...mergedOptions,
        });
        new codeowners_1.CodeOwners(this, mergedOptions.codeOwners);
        this.readme = new readme_1.Readme(this, {
            description: mergedOptions.readme?.description,
        });
        this.readme.addSection('Getting Started', `\`\`\`sh\nyarn install\nnpx projen build\n\`\`\`\n
This will:
* Install the dependencies
* Apply any projen changes
* Run tests
* Package project locally

Any files changed by projen should be committed to git.

Running the tests like this will update any snapshot files, this should be reviewed and committed to git.`);
        this.readme.addSection('Testing', `Types of testing:
* Snapshot - projen project outputs are stored as a snapshot in the corresponding \`__snapshots__\` directory. When the project changes then it is expected that these snapshots change too and should be reviewed committed alongside the project.
* Unit tests - these assert on specific functionality of the project and should be written for any new functionality added.
`);
        if (this.autoMerge) {
            this.github?.mergify?.addRule({
                name: 'Automatic approval for projen upgrade pull requests',
                conditions: [
                    'author=endor-projen[bot]',
                    ...(this.buildWorkflow?.buildJobIds?.map((id) => `status-success=${id}`) ?? []),
                ],
                actions: {
                    review: {
                        type: 'APPROVE',
                        message: 'Automatically approving projen upgrade',
                    },
                },
            });
            this.github?.mergify?.addRule({
                name: 'Assign PR when check fails',
                conditions: ['#check-failure > 0'],
                actions: {
                    assign: {
                        add_users: ['daveshepherd'],
                    },
                },
            });
        }
    }
}
exports.JsiiProject = JsiiProject;
_a = JSII_RTTI_SYMBOL_1;
JsiiProject[_a] = { fqn: "projen-modules.JsiiProject", version: "1.0.159" };
__exportStar(require("./jsii-project-options"), exports);
//# sourceMappingURL=data:application/json;base64,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