# mypy-boto3-eks<a id="mypy-boto3-eks"></a>

[![PyPI - mypy-boto3-eks](https://img.shields.io/pypi/v/mypy-boto3-eks.svg?color=blue)](https://pypi.org/project/mypy-boto3-eks)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/mypy-boto3-eks.svg?color=blue)](https://pypi.org/project/mypy-boto3-eks)
[![Docs](https://img.shields.io/readthedocs/mypy-boto3-builder.svg?color=blue)](https://mypy-boto3-builder.readthedocs.io/)
[![PyPI - Downloads](https://img.shields.io/pypi/dw/mypy-boto3-eks?color=blue)](https://pypistats.org/packages/mypy-boto3-eks)

![boto3.typed](https://github.com/vemel/mypy_boto3_builder/raw/master/logo.png)

Type annotations for
[boto3.EKS 1.17.78](https://boto3.amazonaws.com/v1/documentation/api/1.17.78/reference/services/eks.html#EKS)
service compatible with [VSCode](https://code.visualstudio.com/),
[PyCharm](https://www.jetbrains.com/pycharm/),
[Emacs](https://www.gnu.org/software/emacs/),
[Sublime Text](https://www.sublimetext.com/),
[mypy](https://github.com/python/mypy),
[pyright](https://github.com/microsoft/pyright) and other tools.

Generated by
[mypy-boto3-buider 4.13.1](https://github.com/vemel/mypy_boto3_builder).

More information can be found on
[boto3-stubs](https://pypi.org/project/boto3-stubs/) page and in
[mypy-boto3-eks docs](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_eks/)

See how it helps to find and fix potential bugs:

![boto3-stubs demo](https://github.com/vemel/mypy_boto3_builder/raw/master/demo.gif)

- [mypy-boto3-eks](#mypy-boto3-eks)
  - [How to install](#how-to-install)
  - [Usage](#usage)
    - [VSCode](#vscode)
    - [PyCharm](#pycharm)
    - [Other IDEs](#other-ides)
    - [mypy](#mypy)
    - [pyright](#pyright)
  - [Explicit type annotations](#explicit-type-annotations)
    - [Client annotations](#client-annotations)
    - [Paginators annotations](#paginators-annotations)
    - [Waiters annotations](#waiters-annotations)
    - [Literals](#literals)
    - [Typed dictionaries](#typed-dictionaries)
  - [Versioning](#versioning)
  - [Documentation](#documentation)
  - [Support and contributing](#support-and-contributing)

## How to install<a id="how-to-install"></a>

Install `boto3-stubs` for `EKS` service.

```bash
python -m pip install boto3-stubs[eks]
```

## Usage<a id="usage"></a>

### VSCode<a id="vscode"></a>

- Install
  [Python extension](https://marketplace.visualstudio.com/items?itemName=ms-python.python)
- Install
  [Pylance extension](https://marketplace.visualstudio.com/items?itemName=ms-python.vscode-pylance)
- Set `Pylance` as your Python Language Server
- Install `boto-stubs[eks]` in your environment:
  `python -m pip install 'boto3-stubs[eks]'`

Both type checking and auto-complete should work for `EKS` service. No explicit
type annotations required, write your `boto3` code as usual.

### PyCharm<a id="pycharm"></a>

- Install `boto-stubs[eks]` in your environment:
  `python -m pip install 'boto3-stubs[eks]'`

Both type checking and auto-complete should work for `EKS` service. No explicit
type annotations required, write your `boto3` code as usual. Auto-complete can
be slow on big projects or if you have a lot of installed `boto3-stubs`
submodules.

### Other IDEs<a id="other-ides"></a>

Not tested, but as long as your IDE support `mypy` or `pyright`, everything
should work.

### mypy<a id="mypy"></a>

- Install `mypy`: `python -m pip install mypy`
- Install `boto-stubs[eks]` in your environment:
  `python -m pip install 'boto3-stubs[eks]'`
- Run `mypy` as usual

Type checking should work for `EKS` service. No explicit type annotations
required, write your `boto3` code as usual.

### pyright<a id="pyright"></a>

- Install `pyright`: `yarn global add pyright`
- Install `boto-stubs[eks]` in your environment:
  `python -m pip install 'boto3-stubs[eks]'`
- Optionally, you can install `boto3-stubs` to `typings` folder.

Type checking should work for `EKS` service. No explicit type annotations
required, write your `boto3` code as usual.

## Explicit type annotations<a id="explicit-type-annotations"></a>

### Client annotations<a id="client-annotations"></a>

`EKSClient` provides annotations for `boto3.client("eks")`.

```python
import boto3

from mypy_boto3_eks import EKSClient

client: EKSClient = boto3.client("eks")

# now client usage is checked by mypy and IDE should provide code auto-complete

# works for session as well
session = boto3.session.Session(region="us-west-1")
session_client: EKSClient = session.client("eks")
```

### Paginators annotations<a id="paginators-annotations"></a>

`mypy_boto3_eks.paginator` module contains type annotations for all paginators.

```python
from mypy_boto3_eks import EKSClient
from mypy_boto3_eks.paginator import (
    DescribeAddonVersionsPaginator,
    ListAddonsPaginator,
    ListClustersPaginator,
    ListFargateProfilesPaginator,
    ListIdentityProviderConfigsPaginator,
    ListNodegroupsPaginator,
    ListUpdatesPaginator,
)

client: EKSClient = boto3.client("eks")

# Explicit type annotations are optional here
# Type should be correctly discovered by mypy and IDEs
# VSCode requires explicit type annotations
describe_addon_versions_paginator: DescribeAddonVersionsPaginator = client.get_paginator("describe_addon_versions")
list_addons_paginator: ListAddonsPaginator = client.get_paginator("list_addons")
list_clusters_paginator: ListClustersPaginator = client.get_paginator("list_clusters")
list_fargate_profiles_paginator: ListFargateProfilesPaginator = client.get_paginator("list_fargate_profiles")
list_identity_provider_configs_paginator: ListIdentityProviderConfigsPaginator = client.get_paginator("list_identity_provider_configs")
list_nodegroups_paginator: ListNodegroupsPaginator = client.get_paginator("list_nodegroups")
list_updates_paginator: ListUpdatesPaginator = client.get_paginator("list_updates")
```

### Waiters annotations<a id="waiters-annotations"></a>

`mypy_boto3_eks.waiter` module contains type annotations for all waiters.

```python
from mypy_boto3_eks import EKSClient
from mypy_boto3_eks.waiter import (
    AddonActiveWaiter,
    AddonDeletedWaiter,
    ClusterActiveWaiter,
    ClusterDeletedWaiter,
    NodegroupActiveWaiter,
    NodegroupDeletedWaiter,
)

client: EKSClient = boto3.client("eks")

# Explicit type annotations are optional here
# Type should be correctly discovered by mypy and IDEs
# VSCode requires explicit type annotations
addon_active_waiter: AddonActiveWaiter = client.get_waiter("addon_active")
addon_deleted_waiter: AddonDeletedWaiter = client.get_waiter("addon_deleted")
cluster_active_waiter: ClusterActiveWaiter = client.get_waiter("cluster_active")
cluster_deleted_waiter: ClusterDeletedWaiter = client.get_waiter("cluster_deleted")
nodegroup_active_waiter: NodegroupActiveWaiter = client.get_waiter("nodegroup_active")
nodegroup_deleted_waiter: NodegroupDeletedWaiter = client.get_waiter("nodegroup_deleted")
```

### Literals<a id="literals"></a>

`mypy_boto3_eks.literals` module contains literals extracted from shapes that
can be used in user code for type checking.

```python
from mypy_boto3_eks.literals import (
    AMITypesType,
    AddonActiveWaiterName,
    AddonDeletedWaiterName,
    AddonIssueCodeType,
    AddonStatusType,
    CapacityTypesType,
    ClusterActiveWaiterName,
    ClusterDeletedWaiterName,
    ClusterStatusType,
    DescribeAddonVersionsPaginatorName,
    ErrorCodeType,
    FargateProfileStatusType,
    ListAddonsPaginatorName,
    ListClustersPaginatorName,
    ListFargateProfilesPaginatorName,
    ListIdentityProviderConfigsPaginatorName,
    ListNodegroupsPaginatorName,
    ListUpdatesPaginatorName,
    LogTypeType,
    NodegroupActiveWaiterName,
    NodegroupDeletedWaiterName,
    NodegroupIssueCodeType,
    NodegroupStatusType,
    ResolveConflictsType,
    TaintEffectType,
    UpdateParamTypeType,
    UpdateStatusType,
    UpdateTypeType,
    configStatusType,
)

def check_value(value: AMITypesType) -> bool:
    ...
```

### Typed dictionaries<a id="typed-dictionaries"></a>

`mypy_boto3_eks.type_defs` module contains structures and shapes assembled to
typed dictionaries for additional type checking.

```python
from mypy_boto3_eks.type_defs import (
    AddonHealthTypeDef,
    AddonInfoTypeDef,
    AddonIssueTypeDef,
    AddonTypeDef,
    AddonVersionInfoTypeDef,
    AssociateEncryptionConfigResponseTypeDef,
    AssociateIdentityProviderConfigResponseTypeDef,
    AutoScalingGroupTypeDef,
    CertificateTypeDef,
    ClusterTypeDef,
    CompatibilityTypeDef,
    CreateAddonResponseTypeDef,
    CreateClusterResponseTypeDef,
    CreateFargateProfileResponseTypeDef,
    CreateNodegroupResponseTypeDef,
    DeleteAddonResponseTypeDef,
    DeleteClusterResponseTypeDef,
    DeleteFargateProfileResponseTypeDef,
    DeleteNodegroupResponseTypeDef,
    DescribeAddonResponseTypeDef,
    DescribeAddonVersionsResponseTypeDef,
    DescribeClusterResponseTypeDef,
    DescribeFargateProfileResponseTypeDef,
    DescribeIdentityProviderConfigResponseTypeDef,
    DescribeNodegroupResponseTypeDef,
    DescribeUpdateResponseTypeDef,
    DisassociateIdentityProviderConfigResponseTypeDef,
    EncryptionConfigTypeDef,
    ErrorDetailTypeDef,
    FargateProfileSelectorTypeDef,
    FargateProfileTypeDef,
    IdentityProviderConfigResponseTypeDef,
    IdentityProviderConfigTypeDef,
    IdentityTypeDef,
    IssueTypeDef,
    KubernetesNetworkConfigRequestTypeDef,
    KubernetesNetworkConfigResponseTypeDef,
    LaunchTemplateSpecificationTypeDef,
    ListAddonsResponseTypeDef,
    ListClustersResponseTypeDef,
    ListFargateProfilesResponseTypeDef,
    ListIdentityProviderConfigsResponseTypeDef,
    ListNodegroupsResponseTypeDef,
    ListTagsForResourceResponseTypeDef,
    ListUpdatesResponseTypeDef,
    LogSetupTypeDef,
    LoggingTypeDef,
    NodegroupHealthTypeDef,
    NodegroupResourcesTypeDef,
    NodegroupScalingConfigTypeDef,
    NodegroupTypeDef,
    OIDCTypeDef,
    OidcIdentityProviderConfigRequestTypeDef,
    OidcIdentityProviderConfigTypeDef,
    PaginatorConfigTypeDef,
    ProviderTypeDef,
    RemoteAccessConfigTypeDef,
    TaintTypeDef,
    UpdateAddonResponseTypeDef,
    UpdateClusterConfigResponseTypeDef,
    UpdateClusterVersionResponseTypeDef,
    UpdateLabelsPayloadTypeDef,
    UpdateNodegroupConfigResponseTypeDef,
    UpdateNodegroupVersionResponseTypeDef,
    UpdateParamTypeDef,
    UpdateTaintsPayloadTypeDef,
    UpdateTypeDef,
    VpcConfigRequestTypeDef,
    VpcConfigResponseTypeDef,
    WaiterConfigTypeDef,
)

def get_structure() -> AddonHealthTypeDef:
    return {
      ...
    }
```

## Versioning<a id="versioning"></a>

`mypy-boto3-eks` version is the same as related `boto3` version and follows
[PEP 440](https://www.python.org/dev/peps/pep-0440/) format.

## Documentation<a id="documentation"></a>

All type annotations can be found in
[mypy-boto3-eks docs](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_eks/)

## Support and contributing<a id="support-and-contributing"></a>

This package is auto-generated. Please reports any bugs or request new features
in [mypy-boto3-builder](https://github.com/vemel/mypy_boto3_builder/issues/)
repository.
