/* automatically generated by rust-bindgen 0.71.1 */

#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct Geometry1D {
    _unused: [u8; 0],
}
unsafe extern "C" {
    pub fn sk_geometry1d_create(
        cos_sza: f64,
        saa: f64,
        earth_radius: f64,
        grid_values: *mut f64,
        ngrid_values: ::std::os::raw::c_int,
        interp_method: ::std::os::raw::c_int,
        geotype: ::std::os::raw::c_int,
    ) -> *mut Geometry1D;
}
unsafe extern "C" {
    pub fn sk_geometry1d_destroy(geometry: *mut Geometry1D);
}
unsafe extern "C" {
    pub fn sk_geometry1d_get_num_altitudes(geometry: *const Geometry1D) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn sk_geometry1d_get_altitudes(
        geometry: *const Geometry1D,
        altitudes: *mut f64,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn sk_geometry1d_get_refractive_index_ptr(
        geometry: *const Geometry1D,
        refractive_index: *mut *mut f64,
    ) -> ::std::os::raw::c_int;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct BRDF {
    _unused: [u8; 0],
}
unsafe extern "C" {
    pub fn sk_brdf_create_lambertian(nstokes: ::std::os::raw::c_int) -> *mut BRDF;
}
unsafe extern "C" {
    pub fn sk_brdf_create_kokhanovsky(nstokes: ::std::os::raw::c_int) -> *mut BRDF;
}
unsafe extern "C" {
    pub fn sk_brdf_create_modis(nstokes: ::std::os::raw::c_int) -> *mut BRDF;
}
unsafe extern "C" {
    pub fn sk_brdf_get_num_deriv(
        config: *mut BRDF,
        num_deriv: *mut ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn sk_brdf_get_num_args(
        config: *mut BRDF,
        num_args: *mut ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn sk_brdf_destroy(config: *mut BRDF);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct DerivativeMapping {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SurfaceDerivativeMapping {
    _unused: [u8; 0],
}
unsafe extern "C" {
    pub fn sk_deriv_mapping_destroy(mapping: *mut DerivativeMapping) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn sk_deriv_mapping_set_zero(mapping: *mut DerivativeMapping) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn sk_deriv_mapping_get_d_ssa(
        mapping: *mut DerivativeMapping,
        ssa: *mut *mut f64,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn sk_deriv_mapping_get_d_extinction(
        mapping: *mut DerivativeMapping,
        extinction: *mut *mut f64,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn sk_deriv_mapping_get_scat_factor(
        mapping: *mut DerivativeMapping,
        scat_factor: *mut *mut f64,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn sk_deriv_mapping_get_d_legendre(
        mapping: *mut DerivativeMapping,
        d_legendre: *mut *mut f64,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn sk_deriv_mapping_get_d_emission(
        mapping: *mut DerivativeMapping,
        d_emission: *mut *mut f64,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn sk_deriv_mapping_get_scat_deriv_index(
        mapping: *mut DerivativeMapping,
        scat_deriv_index: *mut ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn sk_deriv_mapping_set_scat_deriv_index(
        mapping: *mut DerivativeMapping,
        scat_deriv_index: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn sk_deriv_mapping_get_num_location(
        mapping: *mut DerivativeMapping,
        num_location: *mut ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn sk_deriv_mapping_get_num_wavel(
        mapping: *mut DerivativeMapping,
        num_wavel: *mut ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn sk_deriv_mapping_get_num_legendre(
        mapping: *mut DerivativeMapping,
        num_legendre: *mut ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn sk_deriv_mapping_set_interp_dim(
        mapping: *mut DerivativeMapping,
        name: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn sk_deriv_mapping_set_assign_name(
        mapping: *mut DerivativeMapping,
        name: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn sk_deriv_mapping_set_log_radiance_space(
        mapping: *mut DerivativeMapping,
        log_radiance_space: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn sk_deriv_mapping_is_scattering_derivative(
        mapping: *mut DerivativeMapping,
        is_scattering_derivative: *mut ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn sk_deriv_mapping_get_num_output(
        mapping: *mut DerivativeMapping,
        num_output: *mut ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn sk_deriv_mapping_get_assign_name(
        mapping: *mut DerivativeMapping,
        name: *mut *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn sk_deriv_mapping_get_interp_dim(
        mapping: *mut DerivativeMapping,
        name: *mut *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn sk_deriv_mapping_set_interpolator(
        mapping: *mut DerivativeMapping,
        interpolator: *mut f64,
        dim1: ::std::os::raw::c_int,
        dim2: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn sk_deriv_mapping_get_interpolator(
        mapping: *mut DerivativeMapping,
        interpolator: *mut *mut f64,
        dim1: *mut ::std::os::raw::c_int,
        dim2: *mut ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn sk_surface_deriv_mapping_get_d_emission(
        mapping: *mut SurfaceDerivativeMapping,
        emission: *mut *mut f64,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn sk_surface_deriv_mapping_get_num_wavel(
        mapping: *mut SurfaceDerivativeMapping,
        num_wavel: *mut ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn sk_surface_deriv_mapping_get_num_brdf_args(
        mapping: *mut SurfaceDerivativeMapping,
        num_brdf_args: *mut ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn sk_surface_deriv_mapping_get_d_brdf(
        mapping: *mut SurfaceDerivativeMapping,
        brdf: *mut *mut f64,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn sk_surface_deriv_mapping_get_interpolator(
        mapping: *mut SurfaceDerivativeMapping,
        interpolator: *mut *mut f64,
        dim1: *mut ::std::os::raw::c_int,
        dim2: *mut ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn sk_surface_deriv_mapping_set_interpolator(
        mapping: *mut SurfaceDerivativeMapping,
        interpolator: *mut f64,
        dim1: ::std::os::raw::c_int,
        dim2: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn sk_surface_deriv_mapping_get_interp_dim(
        mapping: *mut SurfaceDerivativeMapping,
        name: *mut *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn sk_surface_deriv_mapping_set_interp_dim(
        mapping: *mut SurfaceDerivativeMapping,
        name: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn sk_surface_deriv_mapping_set_zero(
        mapping: *mut SurfaceDerivativeMapping,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn sk_surface_deriv_mapping_destroy(
        mapping: *mut SurfaceDerivativeMapping,
    ) -> ::std::os::raw::c_int;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AtmosphereStorage {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct Atmosphere {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct Surface {
    _unused: [u8; 0],
}
unsafe extern "C" {
    #[doc = " @brief Creates a new AtmosphereStorage object.\n\n @param nlocation Number of spatial locations.\n @param nwavel Number of wavelengths.\n @param nphase_moments Number of phase function moments.\n @param nstokes Number of Stokes parameters (usually 1 or 3).\n @param ssa Pointer to single scattering albedo data. [nlocation, nwavel]\n @param total_extinction Pointer to total extinction coefficient data.\n [nlocation, nwavel]\n @param emission_source Pointer to emission source data. [nlocation, nwavel]\n @param leg_coeff Pointer to Legendre coefficients. [nphase_moments,\n nlocation, nwavel]\n @param solar_irradiance Pointer to top-of-atmosphere solar irradiance.\n @return Pointer to a new AtmosphereStorage object."]
    pub fn sk_atmosphere_storage_create(
        nlocation: ::std::os::raw::c_int,
        nwavel: ::std::os::raw::c_int,
        nphase_moments: ::std::os::raw::c_int,
        nstokes: ::std::os::raw::c_int,
        ssa: *mut f64,
        total_extinction: *mut f64,
        emission_source: *mut f64,
        leg_coeff: *mut f64,
        solar_irradiance: *mut f64,
    ) -> *mut AtmosphereStorage;
}
unsafe extern "C" {
    #[doc = " @brief Destroys a previously created AtmosphereStorage object.\n\n @param storage The storage object to destroy."]
    pub fn sk_atmosphere_storage_destroy(storage: *mut AtmosphereStorage);
}
unsafe extern "C" {
    #[doc = " @brief Gets a pointer to a derivative mapping for a named quantity.\n\n @param storage The atmosphere storage to query.\n @param name The name of the quantity.\n @param mapping Output pointer to the derivative mapping object.\n @return 0 on success, non-zero on error."]
    pub fn sk_atmosphere_storage_get_derivative_mapping(
        storage: *mut AtmosphereStorage,
        name: *const ::std::os::raw::c_char,
        mapping: *mut *mut DerivativeMapping,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn sk_atmosphere_storage_get_derivative_mapping_by_index(
        storage: *mut AtmosphereStorage,
        index: ::std::os::raw::c_int,
        mapping: *mut *mut DerivativeMapping,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn sk_atmosphere_storage_get_num_derivative_mappings(
        storage: *mut AtmosphereStorage,
        num_mappings: *mut ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn sk_atmosphere_storage_get_derivative_mapping_name(
        storage: *mut AtmosphereStorage,
        index: ::std::os::raw::c_int,
        name: *mut *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn sk_atmosphere_storage_finalize_scattering_derivatives(
        storage: *mut AtmosphereStorage,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn sk_atmosphere_storage_set_zero(storage: *mut AtmosphereStorage)
        -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    #[doc = " @brief Creates a new Atmosphere object.\n\n @param storage Pointer to atmosphere storage.\n @param surface Pointer to surface model.\n @param calculate_derivatives Whether to compute derivatives (non-zero = yes).\n @param calculate_emission_derivatives Whether to compute emission\n derivatives, (non-zero = yes)\n @return Pointer to a new Atmosphere object."]
    pub fn sk_atmosphere_create(
        storage: *mut AtmosphereStorage,
        surface: *mut Surface,
        calculate_derivatives: ::std::os::raw::c_int,
        calculate_emission_derivatives: ::std::os::raw::c_int,
    ) -> *mut Atmosphere;
}
unsafe extern "C" {
    #[doc = " @brief Destroys a previously created Atmosphere object.\n\n @param atmosphere The atmosphere object to destroy."]
    pub fn sk_atmosphere_destroy(atmosphere: *mut Atmosphere);
}
unsafe extern "C" {
    pub fn sk_atmosphere_apply_delta_m_scaling(
        atmosphere: *mut Atmosphere,
        order: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    #[doc = " @brief Creates a new Surface object.\n\n @param nwavel Number of wavelengths.\n @param nstokes Number of Stokes parameters.\n @param emission Pointer to emission data. [nwavel]\n @return Pointer to a new Surface object."]
    pub fn sk_surface_create(
        nwavel: ::std::os::raw::c_int,
        nstokes: ::std::os::raw::c_int,
        emission: *mut f64,
    ) -> *mut Surface;
}
unsafe extern "C" {
    #[doc = " @brief Destroys a previously created Surface object.\n\n @param surface The surface object to destroy."]
    pub fn sk_surface_destroy(surface: *mut Surface);
}
unsafe extern "C" {
    pub fn sk_surface_set_brdf(
        surface: *mut Surface,
        brdf: *mut BRDF,
        brdf_args: *mut f64,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn sk_surface_get_derivative_mapping(
        storage: *mut Surface,
        name: *const ::std::os::raw::c_char,
        mapping: *mut *mut SurfaceDerivativeMapping,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn sk_surface_get_num_derivative_mappings(
        storage: *mut Surface,
        num_mappings: *mut ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn sk_surface_get_derivative_mapping_name(
        storage: *mut Surface,
        index: ::std::os::raw::c_int,
        name: *mut *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn sk_surface_set_zero(storage: *mut Surface) -> ::std::os::raw::c_int;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ViewingGeometry {
    _unused: [u8; 0],
}
unsafe extern "C" {
    pub fn sk_viewing_geometry_create() -> *mut ViewingGeometry;
}
unsafe extern "C" {
    pub fn sk_viewing_geometry_destroy(geometry: *mut ViewingGeometry);
}
unsafe extern "C" {
    pub fn sk_viewing_geometry_add_ground_viewing_solar(
        geometry: *mut ViewingGeometry,
        cos_sza: f64,
        relative_azimuth_angle: f64,
        observeraltitude: f64,
        cos_viewing_zenith: f64,
    );
}
unsafe extern "C" {
    pub fn sk_viewing_geometry_add_tangent_altitude_solar(
        geometry: *mut ViewingGeometry,
        tangent_altitude_m: f64,
        relative_azimuth_angle: f64,
        observeraltitude: f64,
        cos_sza: f64,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn sk_viewing_geometry_add_solar_angles_observer_location(
        geometry: *mut ViewingGeometry,
        cos_sza: f64,
        relative_azimuth_angle: f64,
        cos_viewing_zenith: f64,
        observeraltitude: f64,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn sk_viewing_geometry_num_rays(
        geometry: *mut ViewingGeometry,
        num_rays: *mut ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct Config {
    _unused: [u8; 0],
}
unsafe extern "C" {
    pub fn sk_config_create() -> *mut Config;
}
unsafe extern "C" {
    pub fn sk_config_destroy(config: *mut Config);
}
unsafe extern "C" {
    pub fn sk_config_get_num_stokes(
        config: *mut Config,
        num_stokes: *mut ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn sk_config_set_num_stokes(
        config: *mut Config,
        num_stokes: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn sk_config_get_multiple_scatter_source(
        config: *mut Config,
        multiple_scatter_source: *mut ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn sk_config_set_multiple_scatter_source(
        config: *mut Config,
        multiple_scatter_source: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn sk_config_get_single_scatter_source(
        config: *mut Config,
        single_scatter_source: *mut ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn sk_config_set_single_scatter_source(
        config: *mut Config,
        single_scatter_source: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn sk_config_get_num_streams(
        config: *mut Config,
        num_streams: *mut ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn sk_config_set_num_streams(
        config: *mut Config,
        num_streams: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn sk_config_get_num_threads(
        config: *mut Config,
        num_threads: *mut ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn sk_config_set_num_threads(
        config: *mut Config,
        num_threads: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn sk_config_get_threading_model(
        config: *mut Config,
        threading_model: *mut ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn sk_config_set_threading_model(
        config: *mut Config,
        threading_model: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn sk_config_get_num_singlescatter_moments(
        config: *mut Config,
        num_moments: *mut ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn sk_config_set_num_singlescatter_moments(
        config: *mut Config,
        num_moments: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn sk_config_get_singlescatter_phasemode(
        config: *mut Config,
        phasemode: *mut ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn sk_config_set_singlescatter_phasemode(
        config: *mut Config,
        phasemode: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn sk_config_get_apply_delta_scaling(
        config: *mut Config,
        apply_delta_scaling: *mut ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn sk_config_set_apply_delta_scaling(
        config: *mut Config,
        apply_delta_scaling: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn sk_config_get_num_do_sza(
        config: *mut Config,
        num_sza: *mut ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn sk_config_set_num_do_sza(
        config: *mut Config,
        num_sza: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn sk_config_get_num_do_forced_azimuth(
        config: *mut Config,
        num_forced_azimuth: *mut ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn sk_config_set_num_do_forced_azimuth(
        config: *mut Config,
        num_forced_azimuth: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn sk_config_get_do_backprop(
        config: *mut Config,
        do_backprop: *mut ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn sk_config_set_do_backprop(
        config: *mut Config,
        do_backprop: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn sk_config_get_num_do_spherical_iterations(
        config: *mut Config,
        num_iterations: *mut ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn sk_config_set_num_do_spherical_iterations(
        config: *mut Config,
        num_iterations: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn sk_config_get_num_hr_spherical_iterations(
        config: *mut Config,
        num_iterations: *mut ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn sk_config_set_num_hr_spherical_iterations(
        config: *mut Config,
        num_iterations: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn sk_config_get_num_hr_incoming(
        config: *mut Config,
        num_incoming: *mut ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn sk_config_set_num_hr_incoming(
        config: *mut Config,
        num_incoming: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn sk_config_get_num_hr_outgoing(
        config: *mut Config,
        num_outgoing: *mut ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn sk_config_set_num_hr_outgoing(
        config: *mut Config,
        num_outgoing: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn sk_config_get_num_hr_full_incoming_points(
        config: *mut Config,
        num_points: *mut ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn sk_config_set_num_hr_full_incoming_points(
        config: *mut Config,
        num_points: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn sk_config_get_initialize_hr_with_do(
        config: *mut Config,
        initialize: *mut ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn sk_config_set_initialize_hr_with_do(
        config: *mut Config,
        initialize: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn sk_config_get_occultation_source(
        config: *mut Config,
        occultation_source: *mut ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn sk_config_set_occultation_source(
        config: *mut Config,
        occultation_source: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn sk_config_get_emission_source(
        config: *mut Config,
        emission_source: *mut ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn sk_config_set_emission_source(
        config: *mut Config,
        emission_source: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn sk_config_get_los_refraction(
        config: *mut Config,
        refraction: *mut ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn sk_config_set_los_refraction(
        config: *mut Config,
        refraction: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn sk_config_get_solar_refraction(
        config: *mut Config,
        refraction: *mut ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn sk_config_set_solar_refraction(
        config: *mut Config,
        refraction: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn sk_config_get_multiple_scatter_refraction(
        config: *mut Config,
        refraction: *mut ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn sk_config_set_multiple_scatter_refraction(
        config: *mut Config,
        refraction: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn sk_config_get_wf_enabled(
        config: *mut Config,
        enabled: *mut ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn sk_config_set_wf_enabled(
        config: *mut Config,
        enabled: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn sk_config_get_wf_precision(
        config: *mut Config,
        precision: *mut ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn sk_config_set_wf_precision(
        config: *mut Config,
        precision: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn sk_config_get_stokes_basis(
        config: *mut Config,
        basis: *mut ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn sk_config_set_stokes_basis(
        config: *mut Config,
        basis: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn sk_config_get_input_validation_mode(
        config: *mut Config,
        mode: *mut ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn sk_config_set_input_validation_mode(
        config: *mut Config,
        mode: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn sk_config_get_output_los_optical_depth(
        config: *mut Config,
        output: *mut ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn sk_config_set_output_los_optical_depth(
        config: *mut Config,
        output: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn sk_config_get_log_level(
        config: *mut Config,
        log_level: *mut ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn sk_config_set_log_level(
        config: *mut Config,
        log_level: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct OutputC {
    _unused: [u8; 0],
}
unsafe extern "C" {
    pub fn sk_output_create(
        radiance: *mut f64,
        nrad: ::std::os::raw::c_int,
        nstokes: ::std::os::raw::c_int,
    ) -> *mut OutputC;
}
unsafe extern "C" {
    pub fn sk_output_destroy(config: *mut OutputC);
}
unsafe extern "C" {
    pub fn sk_output_assign_derivative_memory(
        output: *mut OutputC,
        name: *const ::std::os::raw::c_char,
        derivative_mapping: *mut f64,
        nrad: ::std::os::raw::c_int,
        nstokes: ::std::os::raw::c_int,
        nderiv: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn sk_output_assign_surface_derivative_memory(
        output: *mut OutputC,
        name: *const ::std::os::raw::c_char,
        derivative_mapping: *mut f64,
        nrad: ::std::os::raw::c_int,
        nstokes: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn sk_output_get_los_optical_depth(
        output: *mut OutputC,
        od: *mut *mut f64,
    ) -> ::std::os::raw::c_int;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct Engine {
    _unused: [u8; 0],
}
unsafe extern "C" {
    pub fn sk_engine_create(
        engine: *mut Config,
        geometry: *mut Geometry1D,
        viewing_geometry: *mut ViewingGeometry,
    ) -> *mut Engine;
}
unsafe extern "C" {
    pub fn sk_engine_calculate_radiance(
        engine: *mut Engine,
        atmosphere: *mut Atmosphere,
        output: *mut OutputC,
        only_initialize: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn sk_engine_calculate_radiance_thread(
        engine: *mut Engine,
        atmosphere: *mut Atmosphere,
        output: *mut OutputC,
        wavelength_idx: ::std::os::raw::c_int,
        thread_idx: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn sk_engine_destroy(engine: *mut Engine);
}
unsafe extern "C" {
    pub fn sk_openmp_support_enabled() -> ::std::os::raw::c_int;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct Geodetic {
    _unused: [u8; 0],
}
unsafe extern "C" {
    pub fn sk_geodetic_create(equatorial_radius: f64, flattening_factor: f64) -> *mut Geodetic;
}
unsafe extern "C" {
    pub fn sk_geodetic_destroy(geodetic: *mut Geodetic);
}
unsafe extern "C" {
    pub fn sk_geodetic_get_altitude(
        geodetic: *const Geodetic,
        altitude: *mut f64,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn sk_geodetic_get_latitude(
        geodetic: *const Geodetic,
        latitude: *mut f64,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn sk_geodetic_get_longitude(
        geodetic: *const Geodetic,
        longitude: *mut f64,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn sk_geodetic_get_location(
        geodetic: *const Geodetic,
        x: *mut f64,
        y: *mut f64,
        z: *mut f64,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn sk_geodetic_get_local_south(
        geodetic: *const Geodetic,
        x: *mut f64,
        y: *mut f64,
        z: *mut f64,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn sk_geodetic_get_local_up(
        geodetic: *const Geodetic,
        x: *mut f64,
        y: *mut f64,
        z: *mut f64,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn sk_geodetic_get_local_west(
        geodetic: *const Geodetic,
        x: *mut f64,
        y: *mut f64,
        z: *mut f64,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn sk_geodetic_get_altitude_intercepts(
        geodetic: *const Geodetic,
        altitude: f64,
        observer_x: f64,
        observer_y: f64,
        observer_z: f64,
        look_vector_x: f64,
        look_vector_y: f64,
        look_vector_z: f64,
        x1: *mut f64,
        y1: *mut f64,
        z1: *mut f64,
        x2: *mut f64,
        y2: *mut f64,
        z2: *mut f64,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn sk_geodetic_from_lat_lon_altitude(
        geodetic: *const Geodetic,
        latitude: f64,
        longitude: f64,
        altitude: f64,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn sk_geodetic_from_tangent_altitude(
        geodetic: *const Geodetic,
        altitude: f64,
        observer_x: f64,
        observer_y: f64,
        observer_z: f64,
        boresight_x: f64,
        boresight_y: f64,
        boresight_z: f64,
        look_vector_x: *mut f64,
        look_vector_y: *mut f64,
        look_vector_z: *mut f64,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn sk_geodetic_from_tangent_point(
        geodetic: *const Geodetic,
        observer_x: f64,
        observer_y: f64,
        observer_z: f64,
        look_vector_x: f64,
        look_vector_y: f64,
        look_vector_z: f64,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn sk_geodetic_from_xyz(
        geodetic: *const Geodetic,
        x: f64,
        y: f64,
        z: f64,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn sk_geodetic_is_valid(
        geodetic: *const Geodetic,
        is_valid: *mut ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
unsafe extern "C" {
    pub fn sk_geodetic_get_osculating_spheroid(
        geodetic: *const Geodetic,
        radius: *mut f64,
        offset_x: *mut f64,
        offset_y: *mut f64,
        offset_z: *mut f64,
    ) -> ::std::os::raw::c_int;
}
