
class XmlConstants:
    """
    A `no method` class that just hosts the strings that represent the Pyut XML strings
    """

    TOP_LEVEL_ELEMENT:    str = 'PyutProject'
    ELEMENT_OGL_CLASS:    str = 'OglClass'
    ELEMENT_OGL_LINK:     str = 'OglLink'
    ELEMENT_OGL_NOTE:     str = 'OglNote'
    ELEMENT_OGL_TEXT:     str = 'OglText'
    ELEMENT_OGL_USE_CASE: str = 'OglUseCase'
    ELEMENT_OGL_ACTOR:    str = 'OglActor'

    ELEMENT_OGL_SD_INSTANCE: str = 'OglSDInstance'
    ELEMENT_OGL_SD_MESSAGE:  str = 'OglSDMessage'

    ELEMENT_OGL_INTERFACE2:    str = 'OglInterface2'

    ELEMENT_DOCUMENT:             str = 'PyutDocument'
    ELEMENT_PYUT_CLASS:           str = 'PyutClass'
    ELEMENT_PYUT_METHOD:          str = 'PyutMethod'
    ELEMENT_MODEL_PYUT_PARAMETER: str = 'PyutParameter'
    ELEMENT_MODEL_PYUT_FIELD:     str = 'PyutField'
    ELEMENT_PYUT_LINK:            str = 'PyutLink'
    ELEMENT_PYUT_NOTE:            str = 'PyutNote'

    ELEMENT_PYUT_USE_CASE:        str = 'PyutUseCase'
    ELEMENT_PYUT_TEXT:            str = 'PyutText'
    ELEMENT_PYUT_ACTOR:           str = 'PyutActor'

    ELEMENT_PYUT_SD_INSTANCE:   str = 'PyutSDInstance'
    ELEMENT_PYUT_SD_MESSAGE:    str = 'PyutSDMessage'

    ELEMENT_MODEL_INTERFACE:      str = 'PyutInterface'
    ELEMENT_IMPLEMENTOR:          str = 'Implementor'

    ELEMENT_MODEL_MODIFIER:    str = 'Modifier'
    ELEMENT_MODEL_SOURCE_CODE: str = 'SourceCode'
    ELEMENT_MODEL_CODE:        str = 'Code'

    ELEMENT_MODEL_CONTROL_POINT: str = 'ControlPoint'

    ELEMENT_ASSOCIATION_CENTER_LABEL:      str = 'LabelCenter'
    ELEMENT_ASSOCIATION_SOURCE_LABEL:      str = 'LabelSource'
    ELEMENT_ASSOCIATION_DESTINATION_LABEL: str = 'LabelDestination'

    ATTR_VERSION: str = 'version'

    ATTR_ID: str = 'id'

    ATTR_WIDTH:  str = 'width'
    ATTR_HEIGHT: str = 'height'

    ATTR_X: str = 'x'
    ATTR_Y: str = 'y'

    ATTR_STEREOTYPE:  str = 'stereotype'
    ATTR_DESCRIPTION: str = 'description'
    ATTR_VISIBILITY:  str = 'visibility'

    ATTR_FILENAME: str = 'fileName'
    ATTR_NAME:     str = 'name'
    ATTR_CONTENT:  str = 'content'
    ATTR_TYPE:     str = 'type'
    ATTR_TITLE:    str = 'title'

    ATTR_DEFAULT_VALUE:      str = 'defaultValue'
    ATTR_DISPLAY_STEREOTYPE: str = 'displayStereotype'
    ATTR_DISPLAY_METHODS:    str = 'displayMethods'
    ATTR_DISPLAY_FIELDS:     str = 'displayFields'
    ATTR_DISPLAY_PARAMETERS: str = 'displayParameters'
    ATTR_FILE_NAME:          str = 'fileName'

    ATTR_METHOD_RETURN_TYPE: str = 'returnType'

    ATTR_SPLINE:               str = 'spline'
    ATTR_LINK_SOURCE_ANCHOR_X: str = 'sourceAnchorX'
    ATTR_LINK_SOURCE_ANCHOR_Y: str = 'sourceAnchorY'

    ATTR_LINK_DESTINATION_ANCHOR_X: str = 'destinationAnchorX'
    ATTR_LINK_DESTINATION_ANCHOR_Y: str = 'destinationAnchorY'

    ATTR_BIDIRECTIONAL: str = 'bidirectional'

    ATTR_SOURCE_ID:      str = 'sourceId'
    ATTR_DESTINATION_ID: str = 'destinationId'

    ATTR_CARDINALITY_SOURCE:      str = 'cardinalitySource'
    ATTR_CARDINALITY_DESTINATION: str = 'cardinalityDestination'

    ATTR_INSTANCE_NAME:    str = 'instanceName'
    ATTR_LIFE_LINE_LENGTH: str = 'lifeLineLength'

    ATTR_MESSAGE:          str = 'message'
    ATTR_SOURCE_TIME:      str = 'sourceTime'
    ATTR_DESTINATION_TIME: str = 'destinationTime'

    ATTR_SD_MESSAGE_SOURCE_ID:      str = 'sourceId'
    ATTR_SD_MESSAGE_DESTINATION_ID: str = 'destinationId'

    ATTR_CODE_PATH: str = 'CodePath'

    ATTR_SCROLL_POSITION_X: str = 'scrollPositionX'
    ATTR_SCROLL_POSITION_Y: str = 'scrollPositionY'
    ATTR_PIXELS_PER_UNIT_X: str = 'pixelsPerUnitX'
    ATTR_PIXELS_PER_UNIT_Y: str = 'pixelsPerUnitY'

    ATTR_LOLLIPOP_ATTACHMENT_POINT: str = 'attachmentPoint'
    ATTR_IMPLEMENTING_CLASS_NAME:   str = 'implementingClassName'

    ATTR_TEXT_SIZE:     str = 'textSize'
    ATTR_IS_BOLD:       str = 'isBold'
    ATTR_IS_ITALICIZED: str = 'isItalicized'
    ATTR_FONT_FAMILY:   str = 'fontFamily'
