"""Add event matcher model.

Revision ID: 3fafd217efa7
Revises: 053ee2c10d85
Create Date: 2022-09-01 11:48:03.057401

"""
from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision = '3fafd217efa7'
down_revision = '053ee2c10d85'
branch_labels = None
depends_on = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table('event_matcher',
    sa.Column('id', sa.Integer(), autoincrement=True, nullable=False),
    sa.Column('created_at', sa.DateTime(timezone=True), server_default=sa.text('(CURRENT_TIMESTAMP)'), nullable=True),
    sa.Column('updated_at', sa.DateTime(timezone=True), server_default=sa.text('(CURRENT_TIMESTAMP)'), nullable=True),
    sa.Column('event_type', sa.Enum('AWS_EVENT', name='eventtype'), nullable=True),
    sa.Column('name', sa.String(length=255), nullable=True),
    sa.Column('pattern', sa.JSON(), nullable=True),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_table('pipeline_schedule_event_matcher_association',
    sa.Column('pipeline_schedule_id', sa.Integer(), nullable=True),
    sa.Column('event_matcher_id', sa.Integer(), nullable=True),
    sa.ForeignKeyConstraint(['event_matcher_id'], ['event_matcher.id'], ),
    sa.ForeignKeyConstraint(['pipeline_schedule_id'], ['pipeline_schedule.id'], )
    )
    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_table('pipeline_schedule_event_matcher_association')
    op.drop_table('event_matcher')
    # ### end Alembic commands ###
