from setuptools import setup, find_packages
import os

setup(
    name="wass2s",
    version="0.2.7",
    author="HOUNGNIBO C. M. Mandela",
    author_email="hmandelahmadiba@gmail.com",
    description="A Python package for seasonal climate forecast.",
    long_description=open("README.md", encoding="utf-8").read() if os.path.exists("README.md") else "",
    long_description_content_type="text/markdown",
    url="https://github.com/hmandela/WASS2S",
    packages=find_packages(),
    install_requires=[
        "numpy",
        "pandas>=1.6.0",
        "xarray",
        "dask",
        "scikit-learn",
        "xgboost",
        "scipy",
        "statsmodels",
        "pykrige",
        "cartopy",
        "xeofs",
        "xskillscore",
        "properscoring",
        "minisom",
        "rioxarray",
        "fitter",
        "seaborn",
        "cdsapi==0.7.4",
        "h5netcdf>=1.2.0",
        "lightgbm",
        "pymc",
        "arviz",
        "jupyterlab",
        "hpelm"
    ],
    python_requires=">=3.11",
    license="GPL-3.0",
    license_files=('LICENSE',),
    classifiers=[
        "Programming Language :: Python :: 3",
        "License :: OSI Approved :: GNU General Public License v3 (GPLv3)",
        "Operating System :: OS Independent",
    ],
)
