# coding: utf-8

"""
    Toast API

    ## Authentication API  The authentication API returns an authentication token that you can present when your integration client software uses other Toast APIs. For more information about authentication, see [the Toast Developer Guide](https://doc.toasttab.com/doc/devguide/authentication.html).  ## Menus API  Returns information about a restaurant's menus.  _Important:_ Ordering integrations should use menus API V3. Other integration types should continue to use menus API V2 until further notice. See <a href=\"https://doc.toasttab.com/doc/devguide/apiComparingMenusAPIV2AndV3.html\">Comparing menus API V2 and V3</a> for more information.  ## Orders API  The orders API includes operations that create, update, and retrieve information about restaurant guest orders.  Information on orders includes the checks, items ordered, prices, payments, discounts, and customer data.  You can create a new order. The orders API includes an operation to retrieve the order prices before you `POST` the order.  You can add items to an existing check.  The orders API also allows you to retrieve payment information for the order and add a credit card payment to the order. You cannot update an existing payment, but you can update the tip amount.  For delivery orders, you can update the delivery information.  You can retrieve the applicable discounts for an order, and then add a discount to a menu item selection or a check.  The orders API supports email addresses that:    - Are up to 53 characters long.    - Start with the email prefix, ends with the email domain name, where the prefix and domain are separated by an @.    - Use the following supported characters:     - a-z     - A-Z     - 0-9     - _ (underscore)     - International characters are not supported  ## Labor API  Toast labor API is a set of REST web services that you can use to  manage the employees, jobs, and shifts for your restaurant. The  labor API is intended for software engineers, managers, and  technical staff who are responsible for integrating third-party  systems with the Toast platform. ## Restaurants API  Returns information about the configuration of restaurant.

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictFloat, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing_extensions import Annotated
from toastapi.models.content_advisories import ContentAdvisories
from toastapi.models.dimension_unit_of_measure import DimensionUnitOfMeasure
from toastapi.models.image import Image
from toastapi.models.item_tag import ItemTag
from toastapi.models.modifier_option_tax_info import ModifierOptionTaxInfo
from toastapi.models.portion import Portion
from toastapi.models.sales_category import SalesCategory
from toastapi.models.weight_unit_of_measure import WeightUnitOfMeasure
from typing import Optional, Set
from typing_extensions import Self

class ModifierOption(BaseModel):
    """
    Information about a modifier option configured for this restaurant. 
    """ # noqa: E501
    reference_id: Optional[StrictInt] = Field(default=None, description="An integer identifier that is used to refer to this modifier option by modifier option groups that contain it. ", alias="referenceId")
    name: Optional[StrictStr] = Field(default=None, description="A descriptive name for this modifier option, for example, \"Cheese\" or \"Pepperoni\". ")
    kitchen_name: Optional[StrictStr] = Field(default=None, description="The name of the modifier option as it appears on kitchen tickets. The `kitchenName` can include both numbers and letters. This value contains an empty string if a kitchen name has not been configured for the modifier option. ", alias="kitchenName")
    guid: Optional[StrictStr] = Field(default=None, description="A unique identifier for this modifier option's item reference, assigned by the Toast POS system. ")
    multi_location_id: Optional[StrictStr] = Field(default=None, description="An identifier that is used to identify and consolidate menu entities that are versions of each other.  `multiLocationId` replaces `masterId`. `multiLocationId` and `masterId` always have the same value.  Menu entities can be versioned. Those versions can be assigned to specific restaurant locations, or groups of locations, in a management group. For example, you could have two versions of a burger, one for a Boston location and another for a New York City location. Versioned menu entities share the majority of, but not all of, their data. For example, the Boston version is called the Minuteman Burger and has pickles, while the New York City version is called the Empire Burger and does not.  You use the `multiLocationId` to identify menu entities that are versions of each other. To continue the example above, the Minuteman Burger in the JSON returned for the Boston location has the same `multilocationId` as the Empire Burger in the JSON returned for the New York City location. These matching `multlocationId` values indicate that the two items are related versions of the same item. In Toast reports, this allows a restaurant to track sales of the burger across both locations. ", alias="multiLocationId")
    master_id: Optional[StrictInt] = Field(default=None, description="This value is deprecated. Instead of `masterId`, use `multiLocationId`.  An identifier that is used to identify and consolidate menu entities that are versions of each other. ", alias="masterId")
    description: Optional[StrictStr] = Field(default=None, description="An optional short description of this modifier option. ")
    pos_name: Optional[StrictStr] = Field(default=None, description="The button label name that appears for this menu entity in the Toast POS app. `posName` contains an empty string if a `posName` has not been defined for the menu entity and the `name` value is used for the button label instead. ", alias="posName")
    pos_button_color_light: Optional[StrictStr] = Field(default=None, description="The color of the menu entity's button on the Toast POS app, when the app is running in light mode.       When an employee configures a POS button's color, they select a color pairing that consists of two colors, one for light mode and one for dark mode. `posButtonColorLight` contains the HEX code for the light mode color. ", alias="posButtonColorLight")
    pos_button_color_dark: Optional[StrictStr] = Field(default=None, description="The color of the menu entity's button on the Toast POS app, when the app is running in dark mode.       When an employee configures a POS button's color, they select a color pairing that consists of two colors, one for light mode and one for dark mode. `posButtonColorDark` contains the HEX code for the dark mode color. ", alias="posButtonColorDark")
    prep_stations: Optional[List[StrictStr]] = Field(default=None, description="An array of GUIDs for the prep stations that have been assigned to this modifier option. ", alias="prepStations")
    image: Optional[Image] = None
    visibility: Optional[List[StrictStr]] = Field(default=None, description="An array of strings that indicate where this menu entity is visible:  * POS: The menu entity is visible in the Toast POS app.   * KIOSK: The menu entity is visible on a Toast kiosk.   * TOAST_ONLINE_ORDERING: The menu entity is visible in the Toast online   ordering site for this restaurant.   * ORDERING_PARTNERS: The restaurants wants this menu entity to be visible   on online ordering sites that integrate with the Toast POS system using the orders API.   * GRUBHUB: Deprecated. The menu entity is included during a menu sync to   Grubhub and will be visible on the Grubhub online ordering service after a   menu sync has completed. _Note:_ Conceptually, the _Grubhub_ configuration   option that was associated with the `GRUBHUB` string in this array has   been replaced by the more general _Online orders: Ordering partners_   configuration option and restaurants that used the _Grubhub_ option have   been automatically migrated to the new _Online orders: Ordering partners_   option. This means that any menu entity that had the _Grubhub_ option set   to _Yes_ will now have the _Online orders: Ordering partners_ option   enabled and the `ORDERING_PARTNERS` enum will be present in the   `visibility` array for it. To support backwards compatibility, the   `visibility` array for these entities will also continue to contain the   `GRUBHUB` enum for a short period of time. See <a   href=\"https://doc.toasttab.com/doc/devguide/apiDeprecatedApiFunctions.html#apiMenuEntityVisibilityEnhancements\">Menu   Visibility Enhancements (Rolled Out)</a> for more information.  The `visibility` array is empty if the menu entity is not configured to be visible for any of the use cases listed above. ")
    price: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="The price of this modifier option.  In Toast Web, a modifier option may:   * Inherit its price from a parent modifier group.   * Use the price specified for its modifier option item reference.   * Specify a price that overrides the price defined for its item reference.  The `price` value is populated differently depending on which of these pricing scenarios is used for the modifier option. ")
    pricing_strategy: Optional[StrictStr] = Field(default=None, description="A string that indicates how this modifier option has been priced. If `pricingStrategy` is:   * GROUP_PRICE, then the modifier option inherits its price from a parent modifier group.   * Any value other than GROUP_PRICE, then the modifier option is using either the price specified for its item reference or an override price. ", alias="pricingStrategy")
    pricing_rules: Optional[Dict[str, Any]] = Field(default=None, alias="pricingRules")
    sales_category: Optional[SalesCategory] = Field(default=None, alias="salesCategory")
    tax_info: Optional[List[StrictStr]] = Field(default=None, description="The `taxInfo` value on the `ModifierOption` object has been deprecated. Your integration should switch to using the `modifierOptionTaxInfo` value instead. ", alias="taxInfo")
    modifier_option_tax_info: Optional[ModifierOptionTaxInfo] = Field(default=None, alias="modifierOptionTaxInfo")
    item_tags: Optional[List[ItemTag]] = Field(default=None, description="An array of `ItemTag` objects that are assigned to this modifier option. Item tags are used to assign identifying characteristics to a modifier option, for example, vegetarian, gluten-free, alcohol. ", alias="itemTags")
    plu: Optional[StrictStr] = Field(default=None, description="The price lookup (PLU) code for this modifier option. The PLU code can contain both numbers and letters. This value contains an empty string if a PLU code has not been defined. ")
    sku: Optional[StrictStr] = Field(default=None, description="The stock keeping unit (SKU) identifier for this modifier option. The SKU identifier can contain both numbers and letters. This value contains an empty string if a SKU has not been defined. ")
    calories: Optional[StrictInt] = Field(default=None, description="The number of calories in this modifier option. The calories value can be any positive or negative integer, or zero. This value is null if a calories amount has not been configured for the modifier option. ")
    content_advisories: Optional[ContentAdvisories] = Field(default=None, alias="contentAdvisories")
    unit_of_measure: Optional[StrictStr] = Field(default=None, description="The unit of measure used to determine the price of the modifier option. For example, $10.00 per gram. ", alias="unitOfMeasure")
    is_default: Optional[StrictBool] = Field(default=None, description="Indicates whether this modifier option is included on the menu item by default. ", alias="isDefault")
    allows_duplicates: Optional[StrictBool] = Field(default=None, description="Indicates whether the modifier option may be added to a menu item multiple times. ", alias="allowsDuplicates")
    portions: Optional[Annotated[List[Portion], Field(min_length=0)]] = Field(default=None, description="An array of `Portion` objects that define the portions that this modifier option can be added to. ")
    prep_time: Optional[StrictInt] = Field(default=None, description="The amount of time, in seconds, that it takes to prepare this modifier option. This value is null if a prep time has not been specified for the modifier option. ", alias="prepTime")
    modifier_group_references: Optional[Annotated[List[StrictInt], Field(min_length=0)]] = Field(default=None, description="An array of `referenceId`s for `ModifierGroup` objects. These objects define nested modifier groups contained in this modifier option. ", alias="modifierGroupReferences")
    length: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="The length of the item or modifier. Use the `dimensionUnitOfMeasure` value to determine the unit of measurement.  The `length` value is `null` if no length is specified for the item or modifier.  You can use the `length`, `height`, and `width` values to determine the overall size of the item or modifier. This information is useful, for example, when determining shipping costs or choosing the size of delivery vehicle to use. ")
    height: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="The height of the item or modifier. Use the `dimensionUnitOfMeasure` value to determine the unit of measurement.  The `height` value is `null` if no height is specified for the item or modifier.  You can use the `length`, `height`, and `width` values to determine the overall size of the item or modifier. This information is useful, for example, when determining shipping costs or choosing the size of delivery vehicle to use. ")
    width: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="The width of the item or modifier. Use the `dimensionUnitOfMeasure` value to determine the unit of measurement.  The `width` value is `null` if no width is specified for the item or modifier.  You can use the `length`, `height`, and `width` values to determine the overall size of the item or modifier. This information is useful, for example, when determining shipping costs or choosing the size of delivery vehicle to use. ")
    dimension_unit_of_measure: Optional[DimensionUnitOfMeasure] = Field(default=None, alias="dimensionUnitOfMeasure")
    weight: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="The weight of the item or modifier. Use the `weightUnitOfMeasure` value to determine the unit of measurement.  The `weight` value is `null` if no weight is specified for the item or modifier.      You can use the `weight` value when determining shipping costs or choosing a delivery vehicle to use. ")
    weight_unit_of_measure: Optional[WeightUnitOfMeasure] = Field(default=None, alias="weightUnitOfMeasure")
    images: Optional[List[StrictStr]] = Field(default=None, description="An array of strings that contain URLs for images that have been uploaded for this item or modifier. The array is empty if no images have been uploaded.      _Note:_ The `images` array contains multiple URLs for multiple images for the same item or modifier. The older `image` value contains a single URL for a single image. ")
    guest_count: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="The number of guests the item or modifier is expected to serve. This value is `null` if no guest count is specified. ", alias="guestCount")
    __properties: ClassVar[List[str]] = ["referenceId", "name", "kitchenName", "guid", "multiLocationId", "masterId", "description", "posName", "posButtonColorLight", "posButtonColorDark", "prepStations", "image", "visibility", "price", "pricingStrategy", "pricingRules", "salesCategory", "taxInfo", "modifierOptionTaxInfo", "itemTags", "plu", "sku", "calories", "contentAdvisories", "unitOfMeasure", "isDefault", "allowsDuplicates", "portions", "prepTime", "modifierGroupReferences", "length", "height", "width", "dimensionUnitOfMeasure", "weight", "weightUnitOfMeasure", "images", "guestCount"]

    @field_validator('visibility')
    def visibility_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        for i in value:
            if i not in set(['POS', 'KIOSK', 'GRUBHUB', 'TOAST_ONLINE_ORDERING', 'ORDERING_PARTNERS']):
                raise ValueError("each list item must be one of ('POS', 'KIOSK', 'GRUBHUB', 'TOAST_ONLINE_ORDERING', 'ORDERING_PARTNERS')")
        return value

    @field_validator('unit_of_measure')
    def unit_of_measure_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['NONE', 'LB', 'OZ', 'KG', 'G']):
            raise ValueError("must be one of enum values ('NONE', 'LB', 'OZ', 'KG', 'G')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ModifierOption from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of image
        if self.image:
            _dict['image'] = self.image.to_dict()
        # override the default output from pydantic by calling `to_dict()` of pricing_rules
        if self.pricing_rules:
            _dict['pricingRules'] = self.pricing_rules.to_dict()
        # override the default output from pydantic by calling `to_dict()` of sales_category
        if self.sales_category:
            _dict['salesCategory'] = self.sales_category.to_dict()
        # override the default output from pydantic by calling `to_dict()` of modifier_option_tax_info
        if self.modifier_option_tax_info:
            _dict['modifierOptionTaxInfo'] = self.modifier_option_tax_info.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in item_tags (list)
        _items = []
        if self.item_tags:
            for _item_item_tags in self.item_tags:
                if _item_item_tags:
                    _items.append(_item_item_tags.to_dict())
            _dict['itemTags'] = _items
        # override the default output from pydantic by calling `to_dict()` of content_advisories
        if self.content_advisories:
            _dict['contentAdvisories'] = self.content_advisories.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in portions (list)
        _items = []
        if self.portions:
            for _item_portions in self.portions:
                if _item_portions:
                    _items.append(_item_portions.to_dict())
            _dict['portions'] = _items
        # set to None if price (nullable) is None
        # and model_fields_set contains the field
        if self.price is None and "price" in self.model_fields_set:
            _dict['price'] = None

        # set to None if calories (nullable) is None
        # and model_fields_set contains the field
        if self.calories is None and "calories" in self.model_fields_set:
            _dict['calories'] = None

        # set to None if prep_time (nullable) is None
        # and model_fields_set contains the field
        if self.prep_time is None and "prep_time" in self.model_fields_set:
            _dict['prepTime'] = None

        # set to None if length (nullable) is None
        # and model_fields_set contains the field
        if self.length is None and "length" in self.model_fields_set:
            _dict['length'] = None

        # set to None if height (nullable) is None
        # and model_fields_set contains the field
        if self.height is None and "height" in self.model_fields_set:
            _dict['height'] = None

        # set to None if width (nullable) is None
        # and model_fields_set contains the field
        if self.width is None and "width" in self.model_fields_set:
            _dict['width'] = None

        # set to None if weight (nullable) is None
        # and model_fields_set contains the field
        if self.weight is None and "weight" in self.model_fields_set:
            _dict['weight'] = None

        # set to None if guest_count (nullable) is None
        # and model_fields_set contains the field
        if self.guest_count is None and "guest_count" in self.model_fields_set:
            _dict['guestCount'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ModifierOption from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "referenceId": obj.get("referenceId"),
            "name": obj.get("name"),
            "kitchenName": obj.get("kitchenName"),
            "guid": obj.get("guid"),
            "multiLocationId": obj.get("multiLocationId"),
            "masterId": obj.get("masterId"),
            "description": obj.get("description"),
            "posName": obj.get("posName"),
            "posButtonColorLight": obj.get("posButtonColorLight"),
            "posButtonColorDark": obj.get("posButtonColorDark"),
            "prepStations": obj.get("prepStations"),
            "image": Image.from_dict(obj["image"]) if obj.get("image") is not None else None,
            "visibility": obj.get("visibility"),
            "price": obj.get("price"),
            "pricingStrategy": obj.get("pricingStrategy"),
            "pricingRules": PricingRules.from_dict(obj["pricingRules"]) if obj.get("pricingRules") is not None else None,
            "salesCategory": SalesCategory.from_dict(obj["salesCategory"]) if obj.get("salesCategory") is not None else None,
            "taxInfo": obj.get("taxInfo"),
            "modifierOptionTaxInfo": ModifierOptionTaxInfo.from_dict(obj["modifierOptionTaxInfo"]) if obj.get("modifierOptionTaxInfo") is not None else None,
            "itemTags": [ItemTag.from_dict(_item) for _item in obj["itemTags"]] if obj.get("itemTags") is not None else None,
            "plu": obj.get("plu"),
            "sku": obj.get("sku"),
            "calories": obj.get("calories"),
            "contentAdvisories": ContentAdvisories.from_dict(obj["contentAdvisories"]) if obj.get("contentAdvisories") is not None else None,
            "unitOfMeasure": obj.get("unitOfMeasure"),
            "isDefault": obj.get("isDefault"),
            "allowsDuplicates": obj.get("allowsDuplicates"),
            "portions": [Portion.from_dict(_item) for _item in obj["portions"]] if obj.get("portions") is not None else None,
            "prepTime": obj.get("prepTime"),
            "modifierGroupReferences": obj.get("modifierGroupReferences"),
            "length": obj.get("length"),
            "height": obj.get("height"),
            "width": obj.get("width"),
            "dimensionUnitOfMeasure": obj.get("dimensionUnitOfMeasure"),
            "weight": obj.get("weight"),
            "weightUnitOfMeasure": obj.get("weightUnitOfMeasure"),
            "images": obj.get("images"),
            "guestCount": obj.get("guestCount")
        })
        return _obj


