# coding: utf-8

"""
    Toast API

    ## Authentication API  The authentication API returns an authentication token that you can present when your integration client software uses other Toast APIs. For more information about authentication, see [the Toast Developer Guide](https://doc.toasttab.com/doc/devguide/authentication.html).  ## Menus API  Returns information about a restaurant's menus.  _Important:_ Ordering integrations should use menus API V3. Other integration types should continue to use menus API V2 until further notice. See <a href=\"https://doc.toasttab.com/doc/devguide/apiComparingMenusAPIV2AndV3.html\">Comparing menus API V2 and V3</a> for more information.  ## Orders API  The orders API includes operations that create, update, and retrieve information about restaurant guest orders.  Information on orders includes the checks, items ordered, prices, payments, discounts, and customer data.  You can create a new order. The orders API includes an operation to retrieve the order prices before you `POST` the order.  You can add items to an existing check.  The orders API also allows you to retrieve payment information for the order and add a credit card payment to the order. You cannot update an existing payment, but you can update the tip amount.  For delivery orders, you can update the delivery information.  You can retrieve the applicable discounts for an order, and then add a discount to a menu item selection or a check.  The orders API supports email addresses that:    - Are up to 53 characters long.    - Start with the email prefix, ends with the email domain name, where the prefix and domain are separated by an @.    - Use the following supported characters:     - a-z     - A-Z     - 0-9     - _ (underscore)     - International characters are not supported  ## Labor API  Toast labor API is a set of REST web services that you can use to  manage the employees, jobs, and shifts for your restaurant. The  labor API is intended for software engineers, managers, and  technical staff who are responsible for integrating third-party  systems with the Toast platform. ## Restaurants API  Returns information about the configuration of restaurant.

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from toastapi.models.applied_packaging_info import AppliedPackagingInfo
from toastapi.models.check import Check
from toastapi.models.curbside_pickup_info import CurbsidePickupInfo
from toastapi.models.delivery_info import DeliveryInfo
from toastapi.models.delivery_service_info import DeliveryServiceInfo
from toastapi.models.device import Device
from toastapi.models.external_reference import ExternalReference
from toastapi.models.marketplace_facilitator_tax_info import MarketplaceFacilitatorTaxInfo
from typing import Optional, Set
from typing_extensions import Self

class Order(BaseModel):
    """
    A Toast platform order is composed of one or more checks. Each check has  one or more menu item selections. 
    """ # noqa: E501
    guid: StrictStr = Field(description="The GUID maintained by the Toast platform.")
    entity_type: StrictStr = Field(description="The type of object this is. Response only.", alias="entityType")
    external_id: Optional[StrictStr] = Field(default=None, description="External identifier string that is prefixed by the naming authority.", alias="externalId")
    opened_date: Optional[datetime] = Field(default=None, description="The business date of the order.  For dine-in and as soon as possible (ASAP) orders, `openedDate` should match `createdDate`.  For scheduled orders, `openedDate` should match `promisedDate`.  If you do not provide a value for  `openedDate` value when you `POST` a new order, the business date of the order is set to the restaurant business day that corresponds to the current date and time.  The business date of an order is affected by the business date cutoff time for a restaurant, which is available from the restaurants API in the `closeoutHour` property. ", alias="openedDate")
    modified_date: Optional[datetime] = Field(default=None, description="The most recent date that the order, or a check or menu item selection in the order, was modified.", alias="modifiedDate")
    promised_date: Optional[datetime] = Field(default=None, description="For scheduled orders, the date and time that the order is scheduled to be fulfilled.  For dine-in and as soon as possible (ASAP) orders, `promisedDate` is `null`. ", alias="promisedDate")
    channel_guid: Optional[StrictStr] = Field(default=None, description="Reserved for future use. ", alias="channelGuid")
    dining_option: ExternalReference = Field(alias="diningOption")
    checks: Annotated[List[Check], Field(min_length=1)] = Field(description="The checks for this order. Most orders have one check.  If the check is split, then there are multiple checks. ")
    table: Optional[ExternalReference] = None
    service_area: Optional[ExternalReference] = Field(default=None, alias="serviceArea")
    restaurant_service: Optional[ExternalReference] = Field(default=None, alias="restaurantService")
    revenue_center: Optional[ExternalReference] = Field(default=None, alias="revenueCenter")
    source: Optional[StrictStr] = Field(default=None, description="Indicates the way that the order was placed.  Valid values:  * `In Store` * `Online` * `Order-and-Pay-at-Table` * `API` * `Kiosk` * `Caller Id` * `Google` * `Invoice` * `Toast Pickup App` * `Toast Local` * `Branded Online Ordering` * `Catering` * `Catering Online Ordering` * `Toast Tables` * `eCommerce Online ordering` * `Branded Mobile App * `Grubhub` (deprecated)  Response only. ")
    duration: Optional[StrictInt] = Field(default=None, description="The number of seconds between creation and payment. Response only.")
    delivery_info: Optional[DeliveryInfo] = Field(default=None, alias="deliveryInfo")
    required_prep_time: Optional[StrictStr] = Field(default=None, description="The amount of time that it will take to prepare the order. This value overrides the  default `deliveryPrepTime` or `takeoutPrepTime` that normally controls auto-firing for scheduled orders.  You can use `requiredPrepTime` to handle atypical orders that will take more time than usual for a restaurant to prepare.  Express the required preparation time in ISO-8601 duration format. Must be greater than zero and be an  increment of five minutes. For example, the value \"PT15M\" sets the required preparation time for the order to 15 minutes. ", alias="requiredPrepTime")
    estimated_fulfillment_date: Optional[datetime] = Field(default=None, description="The date and time that the order is expected to be ready for pickup or to be delivered.  This value is only set when the order dining option uses the `DELIVERY` or `TAKE_OUT` dining behavior. For other dining options, the value is `null`.  Response only. ", alias="estimatedFulfillmentDate")
    number_of_guests: Optional[StrictInt] = Field(default=None, description="The number of restaurant guests that are associated with the order. For example, for a dine-in order, this might be the number of guests at a table. ", alias="numberOfGuests")
    voided: Optional[StrictBool] = Field(default=None, description="Set to `true` if this order was voided. Response only.")
    void_date: Optional[datetime] = Field(default=None, description="The date on which this order was voided. Response only.", alias="voidDate")
    void_business_date: Optional[StrictInt] = Field(default=None, description="The business date (yyyyMMdd) on which this order was voided. Response only.", alias="voidBusinessDate")
    paid_date: Optional[datetime] = Field(default=None, description="The most recent date on which this order received payment. If not specified when `POST`ing, it is set to the current system time.", alias="paidDate")
    closed_date: Optional[datetime] = Field(default=None, description="The most recent date on which the order payment status changed to `CLOSED`.  This status is not returned for the order. The order is simply `CLOSED` when all of the checks on the order are `CLOSED`. ", alias="closedDate")
    deleted_date: Optional[datetime] = Field(default=None, description="The date and time when the order was deleted.  The `deletedDate` value only applies when the `deleted` value is `true`.  If `deleted` is `false`, the value of `deletedDate` is the UNIX epoch, `1970-01-01T00:00:00.000+0000`. ", alias="deletedDate")
    deleted: Optional[StrictBool] = Field(default=None, description="Set to `true` if this order is deleted. Response only.  For example, if you combine a check into another order, the original order for the check is deleted. ")
    business_date: Optional[StrictInt] = Field(default=None, description="The business date (yyyyMMdd) on which the order was fulfilled. Response only.", alias="businessDate")
    applied_packaging_info: Optional[AppliedPackagingInfo] = Field(default=None, alias="appliedPackagingInfo")
    approval_status: Optional[StrictStr] = Field(default=None, description="The current state of the order in the restaurant order fulfillment process. For example, the `approvalStatus` can indicate that an order is waiting for a restaurant employee to approve it or that the order is in a restaurant kitchen being fulfilled. Response only.  Valid values:  * `NEEDS_APPROVAL` - The order is created but will not be fulfilled by the restaurant until an employee approves it.  * `APPROVED` - The order is being fulfilled by the restaurant or it was fulfilled in the past. Orders remain in this state indefinitely after they are fulfilled.  * `FUTURE` - The order is expected to be fulfilled by the restaurant at a future date and time. Restaurant employees will receive information about the order at the date and time that it is ready to be fulfilled.  * `NOT_APPROVED` - Restaurant employees received information about the order but did not approve it for fulfillment. An order enters this state after a period of time passes without a restaurant employee approving it. ", alias="approvalStatus")
    created_device: Optional[Device] = Field(default=None, alias="createdDevice")
    created_in_test_mode: Optional[StrictBool] = Field(default=None, description="Indicates whether the order was created while the restaurant was in test mode.  For more information, see [this _Toast Central_ article](https://central.toasttab.com/s/article/Test-Mode-Enable-and-Disable-1492802389999) ", alias="createdInTestMode")
    curbside_pickup_info: Optional[CurbsidePickupInfo] = Field(default=None, alias="curbsidePickupInfo")
    delivery_service_info: Optional[DeliveryServiceInfo] = Field(default=None, alias="deliveryServiceInfo")
    display_number: Optional[StrictStr] = Field(default=None, description="Response only. Generally starts at one each day and counts up. Not guaranteed to be unique, can be empty if unset.", alias="displayNumber")
    excess_food: Optional[StrictBool] = Field(default=None, description="Indicates whether the order was created to track excess food (for example, food waste) rather than a  standard guest order. Response only.  For more information on the differences between guest orders and excess food orders, see  <a href=\"https://doc.toasttab.com/doc/devguide/apiDailyOrderForTrackingExcessFood.html\">Daily order for tracking excess food</a>. ", alias="excessFood")
    guest_order_status: Optional[StrictStr] = Field(default=None, description="Reserved for future use. ", alias="guestOrderStatus")
    initial_date: Optional[StrictInt] = Field(default=None, description="Reserved for future use. Do not use the `initialDate` value for integration development.", alias="initialDate")
    last_modified_device: Optional[Device] = Field(default=None, alias="lastModifiedDevice")
    marketplace_facilitator_tax_info: Optional[MarketplaceFacilitatorTaxInfo] = Field(default=None, alias="marketplaceFacilitatorTaxInfo")
    pricing_features: Optional[List[StrictStr]] = Field(default=None, description="Pricing features that this order is using.", alias="pricingFeatures")
    server: Optional[ExternalReference] = None
    created_date: Optional[datetime] = Field(default=None, description="The date and time that the Toast platform received the order.", alias="createdDate")
    __properties: ClassVar[List[str]] = ["guid", "entityType", "externalId", "openedDate", "modifiedDate", "promisedDate", "channelGuid", "diningOption", "checks", "table", "serviceArea", "restaurantService", "revenueCenter", "source", "duration", "deliveryInfo", "requiredPrepTime", "estimatedFulfillmentDate", "numberOfGuests", "voided", "voidDate", "voidBusinessDate", "paidDate", "closedDate", "deletedDate", "deleted", "businessDate", "appliedPackagingInfo", "approvalStatus", "createdDevice", "createdInTestMode", "curbsidePickupInfo", "deliveryServiceInfo", "displayNumber", "excessFood", "guestOrderStatus", "initialDate", "lastModifiedDevice", "marketplaceFacilitatorTaxInfo", "pricingFeatures", "server", "createdDate"]

    @field_validator('approval_status')
    def approval_status_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['NEEDS_APPROVAL', 'APPROVED', 'FUTURE', 'NOT_APPROVED']):
            raise ValueError("must be one of enum values ('NEEDS_APPROVAL', 'APPROVED', 'FUTURE', 'NOT_APPROVED')")
        return value

    @field_validator('pricing_features')
    def pricing_features_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        for i in value:
            if i not in set(['TAXESV2', 'TAXESV3']):
                raise ValueError("each list item must be one of ('TAXESV2', 'TAXESV3')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Order from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of dining_option
        if self.dining_option:
            _dict['diningOption'] = self.dining_option.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in checks (list)
        _items = []
        if self.checks:
            for _item_checks in self.checks:
                if _item_checks:
                    _items.append(_item_checks.to_dict())
            _dict['checks'] = _items
        # override the default output from pydantic by calling `to_dict()` of table
        if self.table:
            _dict['table'] = self.table.to_dict()
        # override the default output from pydantic by calling `to_dict()` of service_area
        if self.service_area:
            _dict['serviceArea'] = self.service_area.to_dict()
        # override the default output from pydantic by calling `to_dict()` of restaurant_service
        if self.restaurant_service:
            _dict['restaurantService'] = self.restaurant_service.to_dict()
        # override the default output from pydantic by calling `to_dict()` of revenue_center
        if self.revenue_center:
            _dict['revenueCenter'] = self.revenue_center.to_dict()
        # override the default output from pydantic by calling `to_dict()` of delivery_info
        if self.delivery_info:
            _dict['deliveryInfo'] = self.delivery_info.to_dict()
        # override the default output from pydantic by calling `to_dict()` of applied_packaging_info
        if self.applied_packaging_info:
            _dict['appliedPackagingInfo'] = self.applied_packaging_info.to_dict()
        # override the default output from pydantic by calling `to_dict()` of created_device
        if self.created_device:
            _dict['createdDevice'] = self.created_device.to_dict()
        # override the default output from pydantic by calling `to_dict()` of curbside_pickup_info
        if self.curbside_pickup_info:
            _dict['curbsidePickupInfo'] = self.curbside_pickup_info.to_dict()
        # override the default output from pydantic by calling `to_dict()` of delivery_service_info
        if self.delivery_service_info:
            _dict['deliveryServiceInfo'] = self.delivery_service_info.to_dict()
        # override the default output from pydantic by calling `to_dict()` of last_modified_device
        if self.last_modified_device:
            _dict['lastModifiedDevice'] = self.last_modified_device.to_dict()
        # override the default output from pydantic by calling `to_dict()` of marketplace_facilitator_tax_info
        if self.marketplace_facilitator_tax_info:
            _dict['marketplaceFacilitatorTaxInfo'] = self.marketplace_facilitator_tax_info.to_dict()
        # override the default output from pydantic by calling `to_dict()` of server
        if self.server:
            _dict['server'] = self.server.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Order from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "guid": obj.get("guid"),
            "entityType": obj.get("entityType"),
            "externalId": obj.get("externalId"),
            "openedDate": obj.get("openedDate"),
            "modifiedDate": obj.get("modifiedDate"),
            "promisedDate": obj.get("promisedDate"),
            "channelGuid": obj.get("channelGuid"),
            "diningOption": ExternalReference.from_dict(obj["diningOption"]) if obj.get("diningOption") is not None else None,
            "checks": [Check.from_dict(_item) for _item in obj["checks"]] if obj.get("checks") is not None else None,
            "table": ExternalReference.from_dict(obj["table"]) if obj.get("table") is not None else None,
            "serviceArea": ExternalReference.from_dict(obj["serviceArea"]) if obj.get("serviceArea") is not None else None,
            "restaurantService": ExternalReference.from_dict(obj["restaurantService"]) if obj.get("restaurantService") is not None else None,
            "revenueCenter": ExternalReference.from_dict(obj["revenueCenter"]) if obj.get("revenueCenter") is not None else None,
            "source": obj.get("source"),
            "duration": obj.get("duration"),
            "deliveryInfo": DeliveryInfo.from_dict(obj["deliveryInfo"]) if obj.get("deliveryInfo") is not None else None,
            "requiredPrepTime": obj.get("requiredPrepTime"),
            "estimatedFulfillmentDate": obj.get("estimatedFulfillmentDate"),
            "numberOfGuests": obj.get("numberOfGuests"),
            "voided": obj.get("voided"),
            "voidDate": obj.get("voidDate"),
            "voidBusinessDate": obj.get("voidBusinessDate"),
            "paidDate": obj.get("paidDate"),
            "closedDate": obj.get("closedDate"),
            "deletedDate": obj.get("deletedDate"),
            "deleted": obj.get("deleted"),
            "businessDate": obj.get("businessDate"),
            "appliedPackagingInfo": AppliedPackagingInfo.from_dict(obj["appliedPackagingInfo"]) if obj.get("appliedPackagingInfo") is not None else None,
            "approvalStatus": obj.get("approvalStatus"),
            "createdDevice": Device.from_dict(obj["createdDevice"]) if obj.get("createdDevice") is not None else None,
            "createdInTestMode": obj.get("createdInTestMode"),
            "curbsidePickupInfo": CurbsidePickupInfo.from_dict(obj["curbsidePickupInfo"]) if obj.get("curbsidePickupInfo") is not None else None,
            "deliveryServiceInfo": DeliveryServiceInfo.from_dict(obj["deliveryServiceInfo"]) if obj.get("deliveryServiceInfo") is not None else None,
            "displayNumber": obj.get("displayNumber"),
            "excessFood": obj.get("excessFood"),
            "guestOrderStatus": obj.get("guestOrderStatus"),
            "initialDate": obj.get("initialDate"),
            "lastModifiedDevice": Device.from_dict(obj["lastModifiedDevice"]) if obj.get("lastModifiedDevice") is not None else None,
            "marketplaceFacilitatorTaxInfo": MarketplaceFacilitatorTaxInfo.from_dict(obj["marketplaceFacilitatorTaxInfo"]) if obj.get("marketplaceFacilitatorTaxInfo") is not None else None,
            "pricingFeatures": obj.get("pricingFeatures"),
            "server": ExternalReference.from_dict(obj["server"]) if obj.get("server") is not None else None,
            "createdDate": obj.get("createdDate")
        })
        return _obj


