<a id="mypy-boto3-iotwireless"></a>

# mypy-boto3-iotwireless

[![PyPI - mypy-boto3-iotwireless](https://img.shields.io/pypi/v/mypy-boto3-iotwireless.svg?color=blue)](https://pypi.org/project/mypy-boto3-iotwireless)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/mypy-boto3-iotwireless.svg?color=blue)](https://pypi.org/project/mypy-boto3-iotwireless)
[![Docs](https://img.shields.io/readthedocs/mypy-boto3-builder.svg?color=blue)](https://mypy-boto3-builder.readthedocs.io/)
[![PyPI - Downloads](https://img.shields.io/pypi/dw/mypy-boto3-iotwireless?color=blue)](https://pypistats.org/packages/mypy-boto3-iotwireless)

![boto3.typed](https://github.com/vemel/mypy_boto3_builder/raw/master/logo.png)

Type annotations for
[boto3.IoTWireless 1.18.3](https://boto3.amazonaws.com/v1/documentation/api/1.18.3/reference/services/iotwireless.html#IoTWireless)
service compatible with [VSCode](https://code.visualstudio.com/),
[PyCharm](https://www.jetbrains.com/pycharm/),
[Emacs](https://www.gnu.org/software/emacs/),
[Sublime Text](https://www.sublimetext.com/),
[mypy](https://github.com/python/mypy),
[pyright](https://github.com/microsoft/pyright) and other tools.

Generated by
[mypy-boto3-buider 5.0.0](https://github.com/vemel/mypy_boto3_builder).

More information can be found on
[boto3-stubs](https://pypi.org/project/boto3-stubs/) page and in
[mypy-boto3-iotwireless docs](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_iotwireless/)

See how it helps to find and fix potential bugs:

![boto3-stubs demo](https://github.com/vemel/mypy_boto3_builder/raw/master/demo.gif)

- [mypy-boto3-iotwireless](#mypy-boto3-iotwireless)
  - [How to install](#how-to-install)
  - [Usage](#usage)
    - [VSCode](#vscode)
    - [PyCharm](#pycharm)
    - [Other IDEs](#other-ides)
    - [mypy](#mypy)
    - [pyright](#pyright)
  - [Explicit type annotations](#explicit-type-annotations)
    - [Client annotations](#client-annotations)
    - [Literals](#literals)
    - [Typed dictionaries](#typed-dictionaries)
  - [Versioning](#versioning)
  - [Documentation](#documentation)
  - [Support and contributing](#support-and-contributing)

<a id="how-to-install"></a>

## How to install

Install `boto3-stubs` for `IoTWireless` service.

```bash
python -m pip install boto3-stubs[iotwireless]
```

<a id="usage"></a>

## Usage

<a id="vscode"></a>

### VSCode

- Install
  [Python extension](https://marketplace.visualstudio.com/items?itemName=ms-python.python)
- Install
  [Pylance extension](https://marketplace.visualstudio.com/items?itemName=ms-python.vscode-pylance)
- Set `Pylance` as your Python Language Server
- Install `boto-stubs[iotwireless]` in your environment:
  `python -m pip install 'boto3-stubs[iotwireless]'`

Both type checking and auto-complete should work for `IoTWireless` service. No
explicit type annotations required, write your `boto3` code as usual.

<a id="pycharm"></a>

### PyCharm

- Install `boto-stubs[iotwireless]` in your environment:
  `python -m pip install 'boto3-stubs[iotwireless]'`

Both type checking and auto-complete should work for `IoTWireless` service. No
explicit type annotations required, write your `boto3` code as usual.
Auto-complete can be slow on big projects or if you have a lot of installed
`boto3-stubs` submodules.

<a id="other-ides"></a>

### Other IDEs

Not tested, but as long as your IDE support `mypy` or `pyright`, everything
should work.

<a id="mypy"></a>

### mypy

- Install `mypy`: `python -m pip install mypy`
- Install `boto-stubs[iotwireless]` in your environment:
  `python -m pip install 'boto3-stubs[iotwireless]'`
- Run `mypy` as usual

Type checking should work for `IoTWireless` service. No explicit type
annotations required, write your `boto3` code as usual.

<a id="pyright"></a>

### pyright

- Install `pyright`: `yarn global add pyright`
- Install `boto-stubs[iotwireless]` in your environment:
  `python -m pip install 'boto3-stubs[iotwireless]'`
- Optionally, you can install `boto3-stubs` to `typings` folder.

Type checking should work for `IoTWireless` service. No explicit type
annotations required, write your `boto3` code as usual.

<a id="explicit-type-annotations"></a>

## Explicit type annotations

<a id="client-annotations"></a>

### Client annotations

`IoTWirelessClient` provides annotations for `boto3.client("iotwireless")`.

```python
import boto3

from mypy_boto3_iotwireless import IoTWirelessClient

client: IoTWirelessClient = boto3.client("iotwireless")

# now client usage is checked by mypy and IDE should provide code auto-complete

# works for session as well
session = boto3.session.Session(region="us-west-1")
session_client: IoTWirelessClient = session.client("iotwireless")
```

<a id="literals"></a>

### Literals

`mypy_boto3_iotwireless.literals` module contains literals extracted from
shapes that can be used in user code for type checking.

```python
from mypy_boto3_iotwireless.literals import (
    BatteryLevelType,
    ConnectionStatusType,
    DeviceStateType,
    EventType,
    ExpressionTypeType,
    LogLevelType,
    MessageTypeType,
    PartnerTypeType,
    SigningAlgType,
    WirelessDeviceEventType,
    WirelessDeviceIdTypeType,
    WirelessDeviceTypeType,
    WirelessGatewayEventType,
    WirelessGatewayIdTypeType,
    WirelessGatewayServiceTypeType,
    WirelessGatewayTaskDefinitionTypeType,
    WirelessGatewayTaskStatusType,
    WirelessGatewayTypeType,
)

def check_value(value: BatteryLevelType) -> bool:
    ...
```

<a id="typed-dictionaries"></a>

### Typed dictionaries

`mypy_boto3_iotwireless.type_defs` module contains structures and shapes
assembled to typed dictionaries for additional type checking.

```python
from mypy_boto3_iotwireless.type_defs import (
    AbpV1_0_xTypeDef,
    AbpV1_1TypeDef,
    AssociateAwsAccountWithPartnerAccountRequestRequestTypeDef,
    AssociateAwsAccountWithPartnerAccountResponseTypeDef,
    AssociateWirelessDeviceWithThingRequestRequestTypeDef,
    AssociateWirelessGatewayWithCertificateRequestRequestTypeDef,
    AssociateWirelessGatewayWithCertificateResponseTypeDef,
    AssociateWirelessGatewayWithThingRequestRequestTypeDef,
    CertificateListTypeDef,
    CreateDestinationRequestRequestTypeDef,
    CreateDestinationResponseTypeDef,
    CreateDeviceProfileRequestRequestTypeDef,
    CreateDeviceProfileResponseTypeDef,
    CreateServiceProfileRequestRequestTypeDef,
    CreateServiceProfileResponseTypeDef,
    CreateWirelessDeviceRequestRequestTypeDef,
    CreateWirelessDeviceResponseTypeDef,
    CreateWirelessGatewayRequestRequestTypeDef,
    CreateWirelessGatewayResponseTypeDef,
    CreateWirelessGatewayTaskDefinitionRequestRequestTypeDef,
    CreateWirelessGatewayTaskDefinitionResponseTypeDef,
    CreateWirelessGatewayTaskRequestRequestTypeDef,
    CreateWirelessGatewayTaskResponseTypeDef,
    DeleteDestinationRequestRequestTypeDef,
    DeleteDeviceProfileRequestRequestTypeDef,
    DeleteServiceProfileRequestRequestTypeDef,
    DeleteWirelessDeviceRequestRequestTypeDef,
    DeleteWirelessGatewayRequestRequestTypeDef,
    DeleteWirelessGatewayTaskDefinitionRequestRequestTypeDef,
    DeleteWirelessGatewayTaskRequestRequestTypeDef,
    DestinationsTypeDef,
    DeviceProfileTypeDef,
    DisassociateAwsAccountFromPartnerAccountRequestRequestTypeDef,
    DisassociateWirelessDeviceFromThingRequestRequestTypeDef,
    DisassociateWirelessGatewayFromCertificateRequestRequestTypeDef,
    DisassociateWirelessGatewayFromThingRequestRequestTypeDef,
    GetDestinationRequestRequestTypeDef,
    GetDestinationResponseTypeDef,
    GetDeviceProfileRequestRequestTypeDef,
    GetDeviceProfileResponseTypeDef,
    GetLogLevelsByResourceTypesResponseTypeDef,
    GetPartnerAccountRequestRequestTypeDef,
    GetPartnerAccountResponseTypeDef,
    GetResourceLogLevelRequestRequestTypeDef,
    GetResourceLogLevelResponseTypeDef,
    GetServiceEndpointRequestRequestTypeDef,
    GetServiceEndpointResponseTypeDef,
    GetServiceProfileRequestRequestTypeDef,
    GetServiceProfileResponseTypeDef,
    GetWirelessDeviceRequestRequestTypeDef,
    GetWirelessDeviceResponseTypeDef,
    GetWirelessDeviceStatisticsRequestRequestTypeDef,
    GetWirelessDeviceStatisticsResponseTypeDef,
    GetWirelessGatewayCertificateRequestRequestTypeDef,
    GetWirelessGatewayCertificateResponseTypeDef,
    GetWirelessGatewayFirmwareInformationRequestRequestTypeDef,
    GetWirelessGatewayFirmwareInformationResponseTypeDef,
    GetWirelessGatewayRequestRequestTypeDef,
    GetWirelessGatewayResponseTypeDef,
    GetWirelessGatewayStatisticsRequestRequestTypeDef,
    GetWirelessGatewayStatisticsResponseTypeDef,
    GetWirelessGatewayTaskDefinitionRequestRequestTypeDef,
    GetWirelessGatewayTaskDefinitionResponseTypeDef,
    GetWirelessGatewayTaskRequestRequestTypeDef,
    GetWirelessGatewayTaskResponseTypeDef,
    ListDestinationsRequestRequestTypeDef,
    ListDestinationsResponseTypeDef,
    ListDeviceProfilesRequestRequestTypeDef,
    ListDeviceProfilesResponseTypeDef,
    ListPartnerAccountsRequestRequestTypeDef,
    ListPartnerAccountsResponseTypeDef,
    ListServiceProfilesRequestRequestTypeDef,
    ListServiceProfilesResponseTypeDef,
    ListTagsForResourceRequestRequestTypeDef,
    ListTagsForResourceResponseTypeDef,
    ListWirelessDevicesRequestRequestTypeDef,
    ListWirelessDevicesResponseTypeDef,
    ListWirelessGatewayTaskDefinitionsRequestRequestTypeDef,
    ListWirelessGatewayTaskDefinitionsResponseTypeDef,
    ListWirelessGatewaysRequestRequestTypeDef,
    ListWirelessGatewaysResponseTypeDef,
    LoRaWANDeviceMetadataTypeDef,
    LoRaWANDeviceProfileTypeDef,
    LoRaWANDeviceTypeDef,
    LoRaWANGatewayCurrentVersionTypeDef,
    LoRaWANGatewayMetadataTypeDef,
    LoRaWANGatewayTypeDef,
    LoRaWANGatewayVersionTypeDef,
    LoRaWANGetServiceProfileInfoTypeDef,
    LoRaWANListDeviceTypeDef,
    LoRaWANSendDataToDeviceTypeDef,
    LoRaWANServiceProfileTypeDef,
    LoRaWANUpdateDeviceTypeDef,
    LoRaWANUpdateGatewayTaskCreateTypeDef,
    LoRaWANUpdateGatewayTaskEntryTypeDef,
    OtaaV1_0_xTypeDef,
    OtaaV1_1TypeDef,
    PutResourceLogLevelRequestRequestTypeDef,
    ResetResourceLogLevelRequestRequestTypeDef,
    ResponseMetadataTypeDef,
    SendDataToWirelessDeviceRequestRequestTypeDef,
    SendDataToWirelessDeviceResponseTypeDef,
    ServiceProfileTypeDef,
    SessionKeysAbpV1_0_xTypeDef,
    SessionKeysAbpV1_1TypeDef,
    SidewalkAccountInfoTypeDef,
    SidewalkAccountInfoWithFingerprintTypeDef,
    SidewalkDeviceMetadataTypeDef,
    SidewalkDeviceTypeDef,
    SidewalkListDeviceTypeDef,
    SidewalkSendDataToDeviceTypeDef,
    SidewalkUpdateAccountTypeDef,
    TagResourceRequestRequestTypeDef,
    TagTypeDef,
    TestWirelessDeviceRequestRequestTypeDef,
    TestWirelessDeviceResponseTypeDef,
    UntagResourceRequestRequestTypeDef,
    UpdateDestinationRequestRequestTypeDef,
    UpdateLogLevelsByResourceTypesRequestRequestTypeDef,
    UpdatePartnerAccountRequestRequestTypeDef,
    UpdateWirelessDeviceRequestRequestTypeDef,
    UpdateWirelessGatewayRequestRequestTypeDef,
    UpdateWirelessGatewayTaskCreateTypeDef,
    UpdateWirelessGatewayTaskEntryTypeDef,
    WirelessDeviceEventLogOptionTypeDef,
    WirelessDeviceLogOptionTypeDef,
    WirelessDeviceStatisticsTypeDef,
    WirelessGatewayEventLogOptionTypeDef,
    WirelessGatewayLogOptionTypeDef,
    WirelessGatewayStatisticsTypeDef,
    WirelessMetadataTypeDef,
)

def get_structure() -> AbpV1_0_xTypeDef:
    return {
      ...
    }
```

<a id="versioning"></a>

## Versioning

`mypy-boto3-iotwireless` version is the same as related `boto3` version and
follows [PEP 440](https://www.python.org/dev/peps/pep-0440/) format.

<a id="documentation"></a>

## Documentation

All type annotations can be found in
[mypy-boto3-iotwireless docs](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_iotwireless/)

<a id="support-and-contributing"></a>

## Support and contributing

This package is auto-generated. Please reports any bugs or request new features
in [mypy-boto3-builder](https://github.com/vemel/mypy_boto3_builder/issues/)
repository.
