# coding: utf-8

"""
    FINBOURNE Luminesce Web API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import List, Dict, Optional, Any, Union, TYPE_CHECKING
from typing_extensions import Annotated
from pydantic.v1 import BaseModel, StrictStr, StrictInt, StrictBool, StrictFloat, StrictBytes, Field, validator, ValidationError, conlist, constr
from datetime import datetime
from luminesce.models.action_id import ActionId
from luminesce.models.id_selector_definition import IdSelectorDefinition

class AccessControlledAction(BaseModel):
    """
    AccessControlledAction
    """
    description:  Optional[StrictStr] = Field(None,alias="description") 
    action: Optional[ActionId] = None
    limited_set: Optional[List[IdSelectorDefinition]] = Field(default=None, alias="limitedSet")
    __properties = ["description", "action", "limitedSet"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def __str__(self):
        """For `print` and `pprint`"""
        return pprint.pformat(self.dict(by_alias=False))

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> AccessControlledAction:
        """Create an instance of AccessControlledAction from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of action
        if self.action:
            _dict['action'] = self.action.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in limited_set (list)
        _items = []
        if self.limited_set:
            for _item in self.limited_set:
                if _item:
                    _items.append(_item.to_dict())
            _dict['limitedSet'] = _items
        # set to None if description (nullable) is None
        # and __fields_set__ contains the field
        if self.description is None and "description" in self.__fields_set__:
            _dict['description'] = None

        # set to None if limited_set (nullable) is None
        # and __fields_set__ contains the field
        if self.limited_set is None and "limited_set" in self.__fields_set__:
            _dict['limitedSet'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> AccessControlledAction:
        """Create an instance of AccessControlledAction from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return AccessControlledAction.parse_obj(obj)

        _obj = AccessControlledAction.parse_obj({
            "description": obj.get("description"),
            "action": ActionId.from_dict(obj.get("action")) if obj.get("action") is not None else None,
            "limited_set": [IdSelectorDefinition.from_dict(_item) for _item in obj.get("limitedSet")] if obj.get("limitedSet") is not None else None
        })
        return _obj

AccessControlledAction.update_forward_refs()
