# coding: utf-8

"""
    FINBOURNE Luminesce Web API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import List, Dict, Optional, Any, Union, TYPE_CHECKING
from typing_extensions import Annotated
from pydantic.v1 import BaseModel, StrictStr, StrictInt, StrictBool, StrictFloat, StrictBytes, Field, validator, ValidationError, conlist, constr
from datetime import datetime

class DateParameters(BaseModel):
    """
    Collection of date parameters used in dashboards  # noqa: E501
    """
    date_from: Optional[datetime] = Field(default=None, description="Parameter to determine the lower bound in a date range", alias="dateFrom")
    date_to: Optional[datetime] = Field(default=None, description="Parameter to determine the upper bound in a date range", alias="dateTo")
    effective_at: Optional[datetime] = Field(default=None, description="EffectiveAt of the dashboard", alias="effectiveAt")
    as_at: datetime = Field(description="AsAt of the dashboard", alias="asAt")
    __properties = ["dateFrom", "dateTo", "effectiveAt", "asAt"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def __str__(self):
        """For `print` and `pprint`"""
        return pprint.pformat(self.dict(by_alias=False))

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> DateParameters:
        """Create an instance of DateParameters from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # set to None if date_from (nullable) is None
        # and __fields_set__ contains the field
        if self.date_from is None and "date_from" in self.__fields_set__:
            _dict['dateFrom'] = None

        # set to None if date_to (nullable) is None
        # and __fields_set__ contains the field
        if self.date_to is None and "date_to" in self.__fields_set__:
            _dict['dateTo'] = None

        # set to None if effective_at (nullable) is None
        # and __fields_set__ contains the field
        if self.effective_at is None and "effective_at" in self.__fields_set__:
            _dict['effectiveAt'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> DateParameters:
        """Create an instance of DateParameters from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return DateParameters.parse_obj(obj)

        _obj = DateParameters.parse_obj({
            "date_from": obj.get("dateFrom"),
            "date_to": obj.get("dateTo"),
            "effective_at": obj.get("effectiveAt"),
            "as_at": obj.get("asAt")
        })
        return _obj

DateParameters.update_forward_refs()
