# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
# THE SOFTWARE.

URL_SCHEME = 'https://'

ALLOWED_METHODS = frozenset(['GET', 'POST', 'PUT', 'DELETE', 'PATCH'])
BODY_METHODS = frozenset(['POST', 'PUT', 'PATCH'])
QUERY_METHODS = frozenset(['GET', 'DELETE'])

DEFAULT_CONTENT_HEADERS = {'content-type': 'application/json'}

STATUS_OK = 200
STATUS_INVALID_REQUEST = 400
STATUS_UNAUTHORIZED = 401
STATUS_CONFLICT = 409
STATUS_UNPROCESSABLE_ENTITY = 422
STATUS_INTERNAL_SERVER_ERROR = 500
STATUS_SERVICE_UNAVAILABLE = 503

VALID_TOKEN_TYPES = frozenset(['Bearer'])