import tkinter as tk
from PIL import Image, ImageTk
import threading
import time
from playsound import playsound
from pathlib import Path

def flashbang():
    root = tk.Tk()
    root.attributes('-fullscreen', True)
    root.configure(bg="white")

    # Play sound safely (Windows-friendly path)
    audio_path = Path(__file__).parent / "audio.mp3"
    threading.Thread(
        target=lambda: playsound(str(audio_path.resolve())),
        daemon=True
    ).start()

    def show_image():
        time.sleep(0.7)
        img_path = Path(__file__).parent / "image.jpg"
        img = Image.open(img_path)
        photo = ImageTk.PhotoImage(img)
        label = tk.Label(root, image=photo)
        label.image = photo
        label.pack(expand=True)
        root.configure(bg="white")
        root.after(2000, root.destroy)

    threading.Thread(target=show_image, daemon=True).start()
    root.mainloop()

if __name__ == "__main__":
    flashbang()
