# mypy-boto3-location

[![PyPI - mypy-boto3-location](https://img.shields.io/pypi/v/mypy-boto3-location.svg?color=blue)](https://pypi.org/project/mypy-boto3-location)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/mypy-boto3-location.svg?color=blue)](https://pypi.org/project/mypy-boto3-location)
[![Docs](https://img.shields.io/readthedocs/mypy-boto3-builder.svg?color=blue)](https://mypy-boto3-builder.readthedocs.io/)
[![PyPI - Downloads](https://img.shields.io/pypi/dw/mypy-boto3-location?color=blue)](https://pypistats.org/packages/mypy-boto3-location)

![boto3.typed](https://github.com/vemel/mypy_boto3_builder/raw/master/logo.png)

Type annotations for
[boto3.LocationService 1.17.60](https://boto3.amazonaws.com/v1/documentation/api/1.17.60/reference/services/location.html#LocationService) service
compatible with
[VSCode](https://code.visualstudio.com/),
[PyCharm](https://www.jetbrains.com/pycharm/),
[Emacs](https://www.gnu.org/software/emacs/),
[Sublime Text](https://www.sublimetext.com/),
[mypy](https://github.com/python/mypy),
[pyright](https://github.com/microsoft/pyright)
and other tools.

Generated by [mypy-boto3-buider 4.6.0](https://github.com/vemel/mypy_boto3_builder).

More information can be found on [boto3-stubs](https://pypi.org/project/boto3-stubs/) page.

See how it helps to find and fix potential bugs:

![boto3-stubs demo](https://github.com/vemel/mypy_boto3_builder/raw/master/demo.gif)

- [mypy-boto3-location](#mypy-boto3-location)
  - [How to install](#how-to-install)
  - [Usage](#usage)
    - [VSCode](#vscode)
    - [PyCharm](#pycharm)
    - [Other IDEs](#other-ides)
    - [mypy](#mypy)
    - [pyright](#pyright)
  - [Explicit type annotations](#explicit-type-annotations)
    - [Client annotations](#client-annotations)
    - [Paginators annotations](#paginators-annotations)
    - [Waiters annotations](#waiters-annotations)
    - [Service Resource annotations](#service-resource-annotations)
    - [Other resources annotations](#other-resources-annotations)
    - [Collections annotations](#collections-annotations)
    - [Typed dictionations](#typed-dictionations)

## How to install

Install `boto3-stubs` for `LocationService` service.

```bash
python -m pip install boto3-stubs[location]
```

## Usage

### VSCode

- Install [Python extension](https://marketplace.visualstudio.com/items?itemName=ms-python.python)
- Install [Pylance extension](https://marketplace.visualstudio.com/items?itemName=ms-python.vscode-pylance)
- Set `Pylance` as your Python Language Server
- Install `boto-stubs[location]` in your environment: `python -m pip install 'boto3-stubs[location]'`

Both type checking and auto-complete should work for `LocationService` service.
No explicit type annotations required, write your `boto3` code as usual.

### PyCharm

- Install `boto-stubs[location]` in your environment: `python -m pip install 'boto3-stubs[location]'`

Both type checking and auto-complete should work for `LocationService` service.
No explicit type annotations required, write your `boto3` code as usual.
Auto-complete can be slow on big projects or if you have a lot of installed `boto3-stubs` submodules.

### Other IDEs

Not tested, but as long as your IDE support `mypy` or `pyright`, everything should work.

### mypy

- Install `mypy`: `python -m pip install mypy`
- Install `boto-stubs[location]` in your environment: `python -m pip install 'boto3-stubs[location]'`
- Run `mypy` as usual

Type checking should work for `LocationService` service.
No explicit type annotations required, write your `boto3` code as usual.

### pyright

- Install `pyright`: `yarn global add pyright`
- Install `boto-stubs[location]` in your environment: `python -m pip install 'boto3-stubs[location]'`
- Optionally, you can install `boto3-stubs` to `typings` folder.

Type checking should work for `LocationService` service.
No explicit type annotations required, write your `boto3` code as usual.

## Explicit type annotations

### Client annotations

`LocationServiceClient` provides annotations for `boto3.client("location")`.

```python
import boto3

from mypy_boto3_location import LocationServiceClient

client: LocationServiceClient = boto3.client("location")

# now client usage is checked by mypy and IDE should provide code auto-complete

# works for session as well
session = boto3.session.Session(region="us-west-1")
session_client: LocationServiceClient = session.client("location")
```

### Paginators annotations

`mypy_boto3_location.paginator` module contains type annotations for all paginators.

```python
from mypy_boto3_location import LocationServiceClient
from mypy_boto3_location.paginator import (
    GetDevicePositionHistoryPaginator,
    ListGeofenceCollectionsPaginator,
    ListGeofencesPaginator,
    ListMapsPaginator,
    ListPlaceIndexesPaginator,
    ListTrackerConsumersPaginator,
    ListTrackersPaginator,
)

client: LocationServiceClient = boto3.client("location")

# Explicit type annotations are optional here
# Type should be correctly discovered by mypy and IDEs
# VSCode requires explicit type annotations
get_device_position_history_paginator: GetDevicePositionHistoryPaginator = client.get_paginator("get_device_position_history")
list_geofence_collections_paginator: ListGeofenceCollectionsPaginator = client.get_paginator("list_geofence_collections")
list_geofences_paginator: ListGeofencesPaginator = client.get_paginator("list_geofences")
list_maps_paginator: ListMapsPaginator = client.get_paginator("list_maps")
list_place_indexes_paginator: ListPlaceIndexesPaginator = client.get_paginator("list_place_indexes")
list_tracker_consumers_paginator: ListTrackerConsumersPaginator = client.get_paginator("list_tracker_consumers")
list_trackers_paginator: ListTrackersPaginator = client.get_paginator("list_trackers")
```







### Typed dictionations

`mypy_boto3_location.type_defs` module contains structures and shapes assembled
to typed dictionaries for additional type checking.

```python
from mypy_boto3_location.type_defs import (
    BatchDeleteGeofenceErrorTypeDef,
    BatchEvaluateGeofencesErrorTypeDef,
    BatchGetDevicePositionErrorTypeDef,
    BatchItemErrorTypeDef,
    BatchPutGeofenceErrorTypeDef,
    BatchPutGeofenceSuccessTypeDef,
    BatchUpdateDevicePositionErrorTypeDef,
    DataSourceConfigurationTypeDef,
    DevicePositionTypeDef,
    GeofenceGeometryTypeDef,
    ListGeofenceCollectionsResponseEntryTypeDef,
    ListGeofenceResponseEntryTypeDef,
    ListMapsResponseEntryTypeDef,
    ListPlaceIndexesResponseEntryTypeDef,
    ListTrackersResponseEntryTypeDef,
    MapConfigurationTypeDef,
    PlaceGeometryTypeDef,
    PlaceTypeDef,
    SearchForPositionResultTypeDef,
    SearchForTextResultTypeDef,
    SearchPlaceIndexForPositionSummaryTypeDef,
    SearchPlaceIndexForTextSummaryTypeDef,
    BatchDeleteGeofenceResponseTypeDef,
    BatchEvaluateGeofencesResponseTypeDef,
    BatchGetDevicePositionResponseTypeDef,
    BatchPutGeofenceRequestEntryTypeDef,
    BatchPutGeofenceResponseTypeDef,
    BatchUpdateDevicePositionResponseTypeDef,
    CreateGeofenceCollectionResponseTypeDef,
    CreateMapResponseTypeDef,
    CreatePlaceIndexResponseTypeDef,
    CreateTrackerResponseTypeDef,
    DescribeGeofenceCollectionResponseTypeDef,
    DescribeMapResponseTypeDef,
    DescribePlaceIndexResponseTypeDef,
    DescribeTrackerResponseTypeDef,
    DevicePositionUpdateTypeDef,
    GetDevicePositionHistoryResponseTypeDef,
    GetDevicePositionResponseTypeDef,
    GetGeofenceResponseTypeDef,
    GetMapGlyphsResponseTypeDef,
    GetMapSpritesResponseTypeDef,
    GetMapStyleDescriptorResponseTypeDef,
    GetMapTileResponseTypeDef,
    ListGeofenceCollectionsResponseTypeDef,
    ListGeofencesResponseTypeDef,
    ListMapsResponseTypeDef,
    ListPlaceIndexesResponseTypeDef,
    ListTrackerConsumersResponseTypeDef,
    ListTrackersResponseTypeDef,
    PaginatorConfigTypeDef,
    PutGeofenceResponseTypeDef,
    SearchPlaceIndexForPositionResponseTypeDef,
    SearchPlaceIndexForTextResponseTypeDef,
)

def get_structure() -> BatchDeleteGeofenceErrorTypeDef:
    return {
      ...
    }
```
