# coding=utf-8
from otlmow_model.OtlmowModel.BaseClasses.KeuzelijstField import KeuzelijstField
from otlmow_model.OtlmowModel.BaseClasses.KeuzelijstWaarde import KeuzelijstWaarde


# Generated with OTLEnumerationCreator. To modify: extend, do not edit
class KlWetenschappelijkeSoortnaam(KeuzelijstField):
    """De mogelijke wetenschappelijke soortnamen van de vegetatie."""
    naam = 'KlWetenschappelijkeSoortnaam'
    label = 'Wetenschappelijke soortnaam'
    objectUri = 'https://wegenenverkeer.data.vlaanderen.be/ns/onderdeel#KlWetenschappelijkeSoortnaam'
    definition = 'De mogelijke wetenschappelijke soortnamen van de vegetatie.'
    status = 'ingebruik'
    codelist = 'https://wegenenverkeer.data.vlaanderen.be/id/conceptscheme/KlWetenschappelijkeSoortnaam'
    options = {
        'abies-alba': KeuzelijstWaarde(invulwaarde='abies-alba',
                                       label='Abies alba',
                                       status='ingebruik',
                                       objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/abies-alba'),
        'acer-campestre': KeuzelijstWaarde(invulwaarde='acer-campestre',
                                           label='Acer campestre',
                                           status='ingebruik',
                                           objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/acer-campestre'),
        'acer-campestre-elsrijk': KeuzelijstWaarde(invulwaarde='acer-campestre-elsrijk',
                                                   label="Acer campestre 'Elsrijk'",
                                                   status='ingebruik',
                                                   objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/acer-campestre-elsrijk'),
        'acer-campestre-fastigiatum': KeuzelijstWaarde(invulwaarde='acer-campestre-fastigiatum',
                                                       label="Acer campestre 'Fastigiatum'",
                                                       status='ingebruik',
                                                       objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/acer-campestre-fastigiatum'),
        'acer-campestre-geessinck': KeuzelijstWaarde(invulwaarde='acer-campestre-geessinck',
                                                     label="Acer campestre 'Geessinck'",
                                                     status='ingebruik',
                                                     objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/acer-campestre-geessinck'),
        'acer-campestre-green-column': KeuzelijstWaarde(invulwaarde='acer-campestre-green-column',
                                                        label="Acer campestre 'Green Column'",
                                                        status='ingebruik',
                                                        objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/acer-campestre-green-column'),
        'acer-campestre-lienco': KeuzelijstWaarde(invulwaarde='acer-campestre-lienco',
                                                  label="Acer campestre 'Lienco'",
                                                  status='ingebruik',
                                                  objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/acer-campestre-lienco'),
        'acer-campestre-nanum': KeuzelijstWaarde(invulwaarde='acer-campestre-nanum',
                                                 label="Acer campestre 'Nanum'",
                                                 status='ingebruik',
                                                 objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/acer-campestre-nanum'),
        'acer-campestre-queen-elisabeth': KeuzelijstWaarde(invulwaarde='acer-campestre-queen-elisabeth',
                                                           label="Acer campestre 'Queen Elisabeth'",
                                                           status='ingebruik',
                                                           objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/acer-campestre-queen-elisabeth'),
        'acer-campestre-red-shine': KeuzelijstWaarde(invulwaarde='acer-campestre-red-shine',
                                                     label="Acer campestre 'Red Shine'",
                                                     status='ingebruik',
                                                     objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/acer-campestre-red-shine'),
        'acer-capillipes': KeuzelijstWaarde(invulwaarde='acer-capillipes',
                                            label='Acer capillipes',
                                            status='ingebruik',
                                            objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/acer-capillipes'),
        'acer-cappadocicum': KeuzelijstWaarde(invulwaarde='acer-cappadocicum',
                                              label='Acer cappadocicum',
                                              status='ingebruik',
                                              objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/acer-cappadocicum'),
        'acer-cappadocicum-aureum': KeuzelijstWaarde(invulwaarde='acer-cappadocicum-aureum',
                                                     label="Acer cappadocicum 'Aureum'",
                                                     status='ingebruik',
                                                     objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/acer-cappadocicum-aureum'),
        'acer-cappadocicum-lobel': KeuzelijstWaarde(invulwaarde='acer-cappadocicum-lobel',
                                                    label="Acer cappadocicum 'Lobel'",
                                                    status='ingebruik',
                                                    objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/acer-cappadocicum-lobel'),
        'acer-cappadocicum-rubrum': KeuzelijstWaarde(invulwaarde='acer-cappadocicum-rubrum',
                                                     label="Acer cappadocicum 'Rubrum'",
                                                     status='ingebruik',
                                                     objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/acer-cappadocicum-rubrum'),
        'acer-carpinifolium': KeuzelijstWaarde(invulwaarde='acer-carpinifolium',
                                               label='Acer carpinifolium',
                                               status='ingebruik',
                                               objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/acer-carpinifolium'),
        'acer-cissifolium': KeuzelijstWaarde(invulwaarde='acer-cissifolium',
                                             label='Acer cissifolium',
                                             status='ingebruik',
                                             objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/acer-cissifolium'),
        'acer-davidii': KeuzelijstWaarde(invulwaarde='acer-davidii',
                                         label='Acer davidii',
                                         status='ingebruik',
                                         objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/acer-davidii'),
        'acer-davidii-rosalie': KeuzelijstWaarde(invulwaarde='acer-davidii-rosalie',
                                                 label="Acer davidii 'Rosalie'",
                                                 status='ingebruik',
                                                 objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/acer-davidii-rosalie'),
        'acer-negundo': KeuzelijstWaarde(invulwaarde='acer-negundo',
                                         label='Acer negundo',
                                         status='ingebruik',
                                         objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/acer-negundo'),
        'acer-negundo-aureomarginatum': KeuzelijstWaarde(invulwaarde='acer-negundo-aureomarginatum',
                                                         label="Acer negundo 'Aureomarginatum'",
                                                         status='ingebruik',
                                                         objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/acer-negundo-aureomarginatum'),
        'acer-negundo-flamingo': KeuzelijstWaarde(invulwaarde='acer-negundo-flamingo',
                                                  label="Acer negundo 'Flamingo'",
                                                  status='ingebruik',
                                                  objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/acer-negundo-flamingo'),
        'acer-negundo-variegatum': KeuzelijstWaarde(invulwaarde='acer-negundo-variegatum',
                                                    label="Acer negundo 'Variegatum'",
                                                    status='ingebruik',
                                                    objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/acer-negundo-variegatum'),
        'acer-platanoides': KeuzelijstWaarde(invulwaarde='acer-platanoides',
                                             label='Acer platanoides',
                                             status='ingebruik',
                                             objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/acer-platanoides'),
        'acer-platanoides-autumn-blaze': KeuzelijstWaarde(invulwaarde='acer-platanoides-autumn-blaze',
                                                          label="Acer platanoides 'Autumn Blaze'",
                                                          status='ingebruik',
                                                          objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/acer-platanoides-autumn-blaze'),
        'acer-platanoides-cleveland': KeuzelijstWaarde(invulwaarde='acer-platanoides-cleveland',
                                                       label="Acer platanoides 'Cleveland'",
                                                       status='ingebruik',
                                                       objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/acer-platanoides-cleveland'),
        'acer-platanoides-columnare': KeuzelijstWaarde(invulwaarde='acer-platanoides-columnare',
                                                       label="Acer platanoides 'Columnare'",
                                                       status='ingebruik',
                                                       objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/acer-platanoides-columnare'),
        'acer-platanoides-crimson-king': KeuzelijstWaarde(invulwaarde='acer-platanoides-crimson-king',
                                                          label="Acer platanoides 'Crimson King'",
                                                          status='ingebruik',
                                                          objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/acer-platanoides-crimson-king'),
        'acer-platanoides-crimson-sentry': KeuzelijstWaarde(invulwaarde='acer-platanoides-crimson-sentry',
                                                            label="Acer platanoides 'Crimson Sentry'",
                                                            status='ingebruik',
                                                            objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/acer-platanoides-crimson-sentry'),
        'acer-platanoides-deborah': KeuzelijstWaarde(invulwaarde='acer-platanoides-deborah',
                                                     label="Acer platanoides 'Deborah'",
                                                     status='ingebruik',
                                                     objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/acer-platanoides-deborah'),
        'acer-platanoides-drummondii': KeuzelijstWaarde(invulwaarde='acer-platanoides-drummondii',
                                                        label="Acer platanoides 'Drummondii'",
                                                        status='ingebruik',
                                                        objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/acer-platanoides-drummondii'),
        'acer-platanoides-emerald-queen': KeuzelijstWaarde(invulwaarde='acer-platanoides-emerald-queen',
                                                           label="Acer platanoides 'Emerald Queen'",
                                                           status='ingebruik',
                                                           objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/acer-platanoides-emerald-queen'),
        'acer-platanoides-faassens-black': KeuzelijstWaarde(invulwaarde='acer-platanoides-faassens-black',
                                                            label="Acer platanoides 'Faassen's Black'",
                                                            status='ingebruik',
                                                            objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/acer-platanoides-faassens-black'),
        'acer-platanoides-farlakess-green': KeuzelijstWaarde(invulwaarde='acer-platanoides-farlakess-green',
                                                             label="Acer platanoides 'Farlakes's Green'",
                                                             status='ingebruik',
                                                             objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/acer-platanoides-farlakess-green'),
        'acer-platanoides-globosum': KeuzelijstWaarde(invulwaarde='acer-platanoides-globosum',
                                                      label="Acer platanoides 'Globosum'",
                                                      status='ingebruik',
                                                      objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/acer-platanoides-globosum'),
        'acer-platanoides-meyering': KeuzelijstWaarde(invulwaarde='acer-platanoides-meyering',
                                                      label="Acer platanoides 'Meyering'",
                                                      status='ingebruik',
                                                      objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/acer-platanoides-meyering'),
        'acer-platanoides-olmsted': KeuzelijstWaarde(invulwaarde='acer-platanoides-olmsted',
                                                     label="Acer platanoides 'Olmsted",
                                                     status='ingebruik',
                                                     objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/acer-platanoides-olmsted'),
        'acer-platanoides-royal-red': KeuzelijstWaarde(invulwaarde='acer-platanoides-royal-red',
                                                       label="Acer platanoides 'Royal Red'",
                                                       status='ingebruik',
                                                       objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/acer-platanoides-royal-red'),
        'acer-platanoides-schwedleri': KeuzelijstWaarde(invulwaarde='acer-platanoides-schwedleri',
                                                        label="Acer platanoides 'Schwedleri'",
                                                        status='ingebruik',
                                                        objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/acer-platanoides-schwedleri'),
        'acer-pseudoplatanus': KeuzelijstWaarde(invulwaarde='acer-pseudoplatanus',
                                                label='Acer pseudoplatanus',
                                                status='ingebruik',
                                                objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/acer-pseudoplatanus'),
        'acer-pseudoplatanus-amry': KeuzelijstWaarde(invulwaarde='acer-pseudoplatanus-amry',
                                                     label="Acer pseudoplatanus 'Amry'",
                                                     status='ingebruik',
                                                     objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/acer-pseudoplatanus-amry'),
        'acer-pseudoplatanus-atropurpureum': KeuzelijstWaarde(invulwaarde='acer-pseudoplatanus-atropurpureum',
                                                              label="Acer pseudoplatanus 'Atropurpureum'",
                                                              status='ingebruik',
                                                              objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/acer-pseudoplatanus-atropurpureum'),
        'acer-pseudoplatanus-brilliantissimum': KeuzelijstWaarde(invulwaarde='acer-pseudoplatanus-brilliantissimum',
                                                                 label="Acer pseudoplatanus 'Brilliantissimum'",
                                                                 status='ingebruik',
                                                                 objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/acer-pseudoplatanus-brilliantissimum'),
        'acer-pseudoplatanus-bruchem': KeuzelijstWaarde(invulwaarde='acer-pseudoplatanus-bruchem',
                                                        label="Acer pseudoplatanus 'Bruchem'",
                                                        status='ingebruik',
                                                        objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/acer-pseudoplatanus-bruchem'),
        'acer-pseudoplatanus-constant-p': KeuzelijstWaarde(invulwaarde='acer-pseudoplatanus-constant-p',
                                                           label="Acer pseudoplatanus 'Constant P'",
                                                           status='ingebruik',
                                                           objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/acer-pseudoplatanus-constant-p'),
        'acer-pseudoplatanus-erectum': KeuzelijstWaarde(invulwaarde='acer-pseudoplatanus-erectum',
                                                        label="Acer pseudoplatanus 'Erectum'",
                                                        status='ingebruik',
                                                        objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/acer-pseudoplatanus-erectum'),
        'acer-pseudoplatanus-leopoldii': KeuzelijstWaarde(invulwaarde='acer-pseudoplatanus-leopoldii',
                                                          label="Acer pseudoplatanus 'Leopoldii'",
                                                          status='ingebruik',
                                                          objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/acer-pseudoplatanus-leopoldii'),
        'acer-pseudoplatanus-negenia': KeuzelijstWaarde(invulwaarde='acer-pseudoplatanus-negenia',
                                                        label="Acer pseudoplatanus 'Negenia'",
                                                        status='ingebruik',
                                                        objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/acer-pseudoplatanus-negenia'),
        'acer-pseudoplatanus-nizetii': KeuzelijstWaarde(invulwaarde='acer-pseudoplatanus-nizetii',
                                                        label="Acer pseudoplatanus 'Nizetii",
                                                        status='ingebruik',
                                                        objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/acer-pseudoplatanus-nizetii'),
        'acer-pseudoplatanus-prinz-handjery': KeuzelijstWaarde(invulwaarde='acer-pseudoplatanus-prinz-handjery',
                                                               label="Acer pseudoplatanus 'Prinz Handjery'",
                                                               status='ingebruik',
                                                               objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/acer-pseudoplatanus-prinz-handjery'),
        'acer-pseudoplatanus-rotterdam': KeuzelijstWaarde(invulwaarde='acer-pseudoplatanus-rotterdam',
                                                          label="Acer pseudoplatanus 'Rotterdam'",
                                                          status='ingebruik',
                                                          objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/acer-pseudoplatanus-rotterdam'),
        'acer-pseudoplatanus-worley': KeuzelijstWaarde(invulwaarde='acer-pseudoplatanus-worley',
                                                       label="Acer pseudoplatanus 'Worley'",
                                                       status='ingebruik',
                                                       objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/acer-pseudoplatanus-worley'),
        'acer-rubrum': KeuzelijstWaarde(invulwaarde='acer-rubrum',
                                        label='Acer rubrum',
                                        status='ingebruik',
                                        objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/acer-rubrum'),
        'acer-rubrum-fairview-flame': KeuzelijstWaarde(invulwaarde='acer-rubrum-fairview-flame',
                                                       label="Acer rubrum 'Fairview Flame'",
                                                       status='ingebruik',
                                                       objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/acer-rubrum-fairview-flame'),
        'acer-rubrum-franksred': KeuzelijstWaarde(invulwaarde='acer-rubrum-franksred',
                                                  label="Acer rubrum 'Franksred'",
                                                  status='ingebruik',
                                                  objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/acer-rubrum-franksred'),
        'acer-rubrum-karpick': KeuzelijstWaarde(invulwaarde='acer-rubrum-karpick',
                                                label="Acer rubrum 'Karpick'",
                                                status='ingebruik',
                                                objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/acer-rubrum-karpick'),
        'acer-rubrum-october-glory': KeuzelijstWaarde(invulwaarde='acer-rubrum-october-glory',
                                                      label="Acer rubrum 'October Glory'",
                                                      status='ingebruik',
                                                      objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/acer-rubrum-october-glory'),
        'acer-rubrum-red-sunset': KeuzelijstWaarde(invulwaarde='acer-rubrum-red-sunset',
                                                   label="Acer rubrum 'Red Sunset'",
                                                   status='ingebruik',
                                                   objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/acer-rubrum-red-sunset'),
        'acer-rubrum-scanlon': KeuzelijstWaarde(invulwaarde='acer-rubrum-scanlon',
                                                label="Acer rubrum 'Scanlon'",
                                                status='ingebruik',
                                                objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/acer-rubrum-scanlon'),
        'acer-rubrum-tilford': KeuzelijstWaarde(invulwaarde='acer-rubrum-tilford',
                                                label="Acer rubrum 'Tilford'",
                                                status='ingebruik',
                                                objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/acer-rubrum-tilford'),
        'acer-rufinerve': KeuzelijstWaarde(invulwaarde='acer-rufinerve',
                                           label='Acer rufinerve',
                                           status='ingebruik',
                                           objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/acer-rufinerve'),
        'acer-saccharinum': KeuzelijstWaarde(invulwaarde='acer-saccharinum',
                                             label='Acer saccharinum',
                                             status='ingebruik',
                                             objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/acer-saccharinum'),
        'acer-saccharinum-laciniatum-wieri': KeuzelijstWaarde(invulwaarde='acer-saccharinum-laciniatum-wieri',
                                                              label="Acer saccharinum 'Laciniatum Wieri'",
                                                              status='ingebruik',
                                                              objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/acer-saccharinum-laciniatum-wieri'),
        'acer-saccharinum-pyramidale': KeuzelijstWaarde(invulwaarde='acer-saccharinum-pyramidale',
                                                        label="Acer saccharinum 'Pyramidale'",
                                                        status='ingebruik',
                                                        objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/acer-saccharinum-pyramidale'),
        'acer-saccharum': KeuzelijstWaarde(invulwaarde='acer-saccharum',
                                           label='Acer saccharum',
                                           status='ingebruik',
                                           objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/acer-saccharum'),
        'acer-sp.': KeuzelijstWaarde(invulwaarde='acer-sp.',
                                     label='Acer sp.',
                                     status='ingebruik',
                                     objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/acer-sp.'),
        'acer-tataricum-subsp.-ginnala': KeuzelijstWaarde(invulwaarde='acer-tataricum-subsp.-ginnala',
                                                          label='Acer tataricum subsp. ginnala',
                                                          status='ingebruik',
                                                          objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/acer-tataricum-subsp.-ginnala'),
        'acer-x-freemanii': KeuzelijstWaarde(invulwaarde='acer-x-freemanii',
                                             label='Acer x freemanii',
                                             status='ingebruik',
                                             objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/acer-x-freemanii'),
        'acer-x-freemanii-armstrong': KeuzelijstWaarde(invulwaarde='acer-x-freemanii-armstrong',
                                                       label="Acer x freemanii 'Armstrong'",
                                                       status='ingebruik',
                                                       objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/acer-x-freemanii-armstrong'),
        'acer-x-freemanii-autumn-blaze': KeuzelijstWaarde(invulwaarde='acer-x-freemanii-autumn-blaze',
                                                          label="Acer x freemanii 'Autumn Blaze'",
                                                          status='ingebruik',
                                                          objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/acer-x-freemanii-autumn-blaze'),
        'acer-x-freemanii-elegant': KeuzelijstWaarde(invulwaarde='acer-x-freemanii-elegant',
                                                     label="Acer x freemanii 'Elegant'",
                                                     status='ingebruik',
                                                     objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/acer-x-freemanii-elegant'),
        'acer-x-freemanii-jeffersred': KeuzelijstWaarde(invulwaarde='acer-x-freemanii-jeffersred',
                                                        label="Acer x freemanii 'Jeffersred'",
                                                        status='ingebruik',
                                                        objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/acer-x-freemanii-jeffersred'),
        'acer-zoeschense-annae': KeuzelijstWaarde(invulwaarde='acer-zoeschense-annae',
                                                  label="Acer zoeschense 'Annae'",
                                                  status='ingebruik',
                                                  objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/acer-zoeschense-annae'),
        'aesculus-flava': KeuzelijstWaarde(invulwaarde='aesculus-flava',
                                           label='Aesculus flava',
                                           status='ingebruik',
                                           objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/aesculus-flava'),
        'aesculus-flava-vestita': KeuzelijstWaarde(invulwaarde='aesculus-flava-vestita',
                                                   label="Aesculus flava 'Vestita'",
                                                   status='ingebruik',
                                                   objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/aesculus-flava-vestita'),
        'aesculus-hippocastanum': KeuzelijstWaarde(invulwaarde='aesculus-hippocastanum',
                                                   label='Aesculus hippocastanum',
                                                   status='ingebruik',
                                                   objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/aesculus-hippocastanum'),
        'aesculus-hippocastanum-baumannii': KeuzelijstWaarde(invulwaarde='aesculus-hippocastanum-baumannii',
                                                             label="Aesculus hippocastanum 'Baumannii'",
                                                             status='ingebruik',
                                                             objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/aesculus-hippocastanum-baumannii'),
        'aesculus-hippocastanum-pyramidalis': KeuzelijstWaarde(invulwaarde='aesculus-hippocastanum-pyramidalis',
                                                               label="Aesculus hippocastanum 'Pyramidalis'",
                                                               status='ingebruik',
                                                               objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/aesculus-hippocastanum-pyramidalis'),
        'aesculus-mutabilis-induta': KeuzelijstWaarde(invulwaarde='aesculus-mutabilis-induta',
                                                      label="Aesculus mutabilis 'Induta'",
                                                      status='ingebruik',
                                                      objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/aesculus-mutabilis-induta'),
        'aesculus-neglecta-autumn-fire': KeuzelijstWaarde(invulwaarde='aesculus-neglecta-autumn-fire',
                                                          label="Aesculus neglecta 'Autumn Fire'",
                                                          status='ingebruik',
                                                          objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/aesculus-neglecta-autumn-fire'),
        'aesculus-pavia': KeuzelijstWaarde(invulwaarde='aesculus-pavia',
                                           label='Aesculus pavia',
                                           status='ingebruik',
                                           objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/aesculus-pavia'),
        'aesculus-x-carnea': KeuzelijstWaarde(invulwaarde='aesculus-x-carnea',
                                              label='Aesculus x carnea',
                                              status='ingebruik',
                                              objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/aesculus-x-carnea'),
        'aesculus-x-carnea-briotii': KeuzelijstWaarde(invulwaarde='aesculus-x-carnea-briotii',
                                                      label="Aesculus x carnea 'Briotii'",
                                                      status='ingebruik',
                                                      objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/aesculus-x-carnea-briotii'),
        'ailanthus-altissima': KeuzelijstWaarde(invulwaarde='ailanthus-altissima',
                                                label='Ailanthus altissima',
                                                status='ingebruik',
                                                objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/ailanthus-altissima'),
        'alnus-cordata': KeuzelijstWaarde(invulwaarde='alnus-cordata',
                                          label='Alnus cordata',
                                          status='ingebruik',
                                          objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/alnus-cordata'),
        'alnus-glutinosa': KeuzelijstWaarde(invulwaarde='alnus-glutinosa',
                                            label='Alnus glutinosa',
                                            status='ingebruik',
                                            objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/alnus-glutinosa'),
        'alnus-glutinosa-aurea': KeuzelijstWaarde(invulwaarde='alnus-glutinosa-aurea',
                                                  label="Alnus glutinosa 'Aurea'",
                                                  status='ingebruik',
                                                  objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/alnus-glutinosa-aurea'),
        'alnus-glutinosa-imperialis': KeuzelijstWaarde(invulwaarde='alnus-glutinosa-imperialis',
                                                       label="Alnus glutinosa 'Imperialis'",
                                                       status='ingebruik',
                                                       objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/alnus-glutinosa-imperialis'),
        'alnus-glutinosa-laciniata': KeuzelijstWaarde(invulwaarde='alnus-glutinosa-laciniata',
                                                      label="Alnus glutinosa 'Laciniata'",
                                                      status='ingebruik',
                                                      objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/alnus-glutinosa-laciniata'),
        'alnus-incana': KeuzelijstWaarde(invulwaarde='alnus-incana',
                                         label='Alnus incana',
                                         status='ingebruik',
                                         objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/alnus-incana'),
        'alnus-incana-aurea': KeuzelijstWaarde(invulwaarde='alnus-incana-aurea',
                                               label="Alnus incana 'Aurea'",
                                               status='ingebruik',
                                               objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/alnus-incana-aurea'),
        'alnus-incana-pendula': KeuzelijstWaarde(invulwaarde='alnus-incana-pendula',
                                                 label="Alnus incana 'Pendula'",
                                                 status='ingebruik',
                                                 objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/alnus-incana-pendula'),
        'alnus-rubra': KeuzelijstWaarde(invulwaarde='alnus-rubra',
                                        label='Alnus rubra',
                                        status='ingebruik',
                                        objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/alnus-rubra'),
        'alnus-spaethii': KeuzelijstWaarde(invulwaarde='alnus-spaethii',
                                           label='Alnus spaethii',
                                           status='ingebruik',
                                           objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/alnus-spaethii'),
        'alnus-spaethii-spaeth': KeuzelijstWaarde(invulwaarde='alnus-spaethii-spaeth',
                                                  label="Alnus spaethii 'Spaeth'",
                                                  status='ingebruik',
                                                  objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/alnus-spaethii-spaeth'),
        'alnus-subcordata-oberon': KeuzelijstWaarde(invulwaarde='alnus-subcordata-oberon',
                                                    label="Alnus subcordata 'Oberon'",
                                                    status='ingebruik',
                                                    objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/alnus-subcordata-oberon'),
        'amelanchier-arborea-robin-hill': KeuzelijstWaarde(invulwaarde='amelanchier-arborea-robin-hill',
                                                           label="Amelanchier arborea 'Robin Hill'",
                                                           status='ingebruik',
                                                           objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/amelanchier-arborea-robin-hill'),
        'amelanchier-laevis-ballerina': KeuzelijstWaarde(invulwaarde='amelanchier-laevis-ballerina',
                                                         label="Amelanchier laevis 'Ballerina'",
                                                         status='ingebruik',
                                                         objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/amelanchier-laevis-ballerina'),
        'amelanchier-lamarckii': KeuzelijstWaarde(invulwaarde='amelanchier-lamarckii',
                                                  label='Amelanchier lamarckii',
                                                  status='ingebruik',
                                                  objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/amelanchier-lamarckii'),
        'amelanchier-lamarckii-fastigiata': KeuzelijstWaarde(invulwaarde='amelanchier-lamarckii-fastigiata',
                                                             label="Amelanchier lamarckii 'Fastigiata'",
                                                             status='ingebruik',
                                                             objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/amelanchier-lamarckii-fastigiata'),
        'araucaria-araucana': KeuzelijstWaarde(invulwaarde='araucaria-araucana',
                                               label='Araucaria araucana',
                                               status='ingebruik',
                                               definitie='Araucaria araucana',
                                               objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/araucaria-araucana'),
        'betula-albosinensis': KeuzelijstWaarde(invulwaarde='betula-albosinensis',
                                                label='Betula albosinensis',
                                                status='ingebruik',
                                                objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/betula-albosinensis'),
        'betula-costata': KeuzelijstWaarde(invulwaarde='betula-costata',
                                           label='Betula costata',
                                           status='ingebruik',
                                           objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/betula-costata'),
        'betula-ermanii': KeuzelijstWaarde(invulwaarde='betula-ermanii',
                                           label='Betula ermanii',
                                           status='ingebruik',
                                           objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/betula-ermanii'),
        'betula-nigra': KeuzelijstWaarde(invulwaarde='betula-nigra',
                                         label='Betula nigra',
                                         status='ingebruik',
                                         objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/betula-nigra'),
        'betula-papyrifera': KeuzelijstWaarde(invulwaarde='betula-papyrifera',
                                              label='Betula papyrifera',
                                              status='ingebruik',
                                              objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/betula-papyrifera'),
        'betula-pendula': KeuzelijstWaarde(invulwaarde='betula-pendula',
                                           label='Betula pendula',
                                           status='ingebruik',
                                           objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/betula-pendula'),
        'betula-pendula-crispa': KeuzelijstWaarde(invulwaarde='betula-pendula-crispa',
                                                  label="Betula pendula 'Crispa'",
                                                  status='ingebruik',
                                                  objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/betula-pendula-crispa'),
        'betula-pendula-fastigiata': KeuzelijstWaarde(invulwaarde='betula-pendula-fastigiata',
                                                      label="Betula pendula 'Fastigiata'",
                                                      status='ingebruik',
                                                      objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/betula-pendula-fastigiata'),
        'betula-pendula-gracilis': KeuzelijstWaarde(invulwaarde='betula-pendula-gracilis',
                                                    label="Betula pendula 'Gracilis'",
                                                    status='ingebruik',
                                                    objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/betula-pendula-gracilis'),
        'betula-pendula-laciniata': KeuzelijstWaarde(invulwaarde='betula-pendula-laciniata',
                                                     label="Betula pendula 'Laciniata'",
                                                     status='ingebruik',
                                                     objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/betula-pendula-laciniata'),
        'betula-pendula-purpurea': KeuzelijstWaarde(invulwaarde='betula-pendula-purpurea',
                                                    label="Betula pendula 'Purpurea'",
                                                    status='ingebruik',
                                                    objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/betula-pendula-purpurea'),
        'betula-pendula-tristis': KeuzelijstWaarde(invulwaarde='betula-pendula-tristis',
                                                   label="Betula pendula 'Tristis'",
                                                   status='ingebruik',
                                                   objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/betula-pendula-tristis'),
        'betula-pendula-youngii': KeuzelijstWaarde(invulwaarde='betula-pendula-youngii',
                                                   label="Betula pendula 'Youngii'",
                                                   status='ingebruik',
                                                   objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/betula-pendula-youngii'),
        'betula-pubescens': KeuzelijstWaarde(invulwaarde='betula-pubescens',
                                             label='Betula pubescens',
                                             status='ingebruik',
                                             objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/betula-pubescens'),
        'betula-utilis-subsp.-jacquemontii': KeuzelijstWaarde(invulwaarde='betula-utilis-subsp.-jacquemontii',
                                                              label='Betula utilis subsp. jacquemontii',
                                                              status='ingebruik',
                                                              objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/betula-utilis-subsp.-jacquemontii'),
        'caragana-arborescens': KeuzelijstWaarde(invulwaarde='caragana-arborescens',
                                                 label='Caragana arborescens',
                                                 status='ingebruik',
                                                 objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/caragana-arborescens'),
        'caragana-arborescens-pendula': KeuzelijstWaarde(invulwaarde='caragana-arborescens-pendula',
                                                         label="Caragana arborescens 'Pendula'",
                                                         status='ingebruik',
                                                         objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/caragana-arborescens-pendula'),
        'carpinus-betulus': KeuzelijstWaarde(invulwaarde='carpinus-betulus',
                                             label='Carpinus betulus',
                                             status='ingebruik',
                                             objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/carpinus-betulus'),
        'carpinus-betulus-columnare-nana': KeuzelijstWaarde(invulwaarde='carpinus-betulus-columnare-nana',
                                                            label="Carpinus betulus 'Columnare Nana'",
                                                            status='ingebruik',
                                                            objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/carpinus-betulus-columnare-nana'),
        'carpinus-betulus-culumnare-nana': KeuzelijstWaarde(invulwaarde='carpinus-betulus-culumnare-nana',
                                                            label="Carpinus betulus 'Culumnare Nana'",
                                                            status='ingebruik',
                                                            objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/carpinus-betulus-culumnare-nana'),
        'carpinus-betulus-fastigiata': KeuzelijstWaarde(invulwaarde='carpinus-betulus-fastigiata',
                                                        label="Carpinus betulus 'Fastigiata'",
                                                        status='ingebruik',
                                                        objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/carpinus-betulus-fastigiata'),
        'carpinus-betulus-frans-fontaine': KeuzelijstWaarde(invulwaarde='carpinus-betulus-frans-fontaine',
                                                            label="Carpinus betulus 'Frans Fontaine'",
                                                            status='ingebruik',
                                                            objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/carpinus-betulus-frans-fontaine'),
        'carpinus-betulus-lucas': KeuzelijstWaarde(invulwaarde='carpinus-betulus-lucas',
                                                   label="Carpinus betulus 'Lucas'",
                                                   status='ingebruik',
                                                   objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/carpinus-betulus-lucas'),
        'carpinus-betulus-pendula': KeuzelijstWaarde(invulwaarde='carpinus-betulus-pendula',
                                                     label="Carpinus betulus 'Pendula'",
                                                     status='ingebruik',
                                                     objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/carpinus-betulus-pendula'),
        'carpinus-betulus-purpurea': KeuzelijstWaarde(invulwaarde='carpinus-betulus-purpurea',
                                                      label="Carpinus betulus 'Purpurea'",
                                                      status='ingebruik',
                                                      objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/carpinus-betulus-purpurea'),
        'carpinus-betulus-quercifolia': KeuzelijstWaarde(invulwaarde='carpinus-betulus-quercifolia',
                                                         label="Carpinus betulus 'Quercifolia'",
                                                         status='ingebruik',
                                                         objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/carpinus-betulus-quercifolia'),
        'carpinus-japonica': KeuzelijstWaarde(invulwaarde='carpinus-japonica',
                                              label='Carpinus japonica',
                                              status='ingebruik',
                                              objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/carpinus-japonica'),
        'castanea-sativa': KeuzelijstWaarde(invulwaarde='castanea-sativa',
                                            label='Castanea sativa',
                                            status='ingebruik',
                                            objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/castanea-sativa'),
        'castanea-sativa-albomarginata': KeuzelijstWaarde(invulwaarde='castanea-sativa-albomarginata',
                                                          label="Castanea sativa 'Albomarginata'",
                                                          status='ingebruik',
                                                          objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/castanea-sativa-albomarginata'),
        'castanea-sativa-doree-de-lyon': KeuzelijstWaarde(invulwaarde='castanea-sativa-doree-de-lyon',
                                                          label="Castanea sativa 'Dorée de Lyon'",
                                                          status='ingebruik',
                                                          objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/castanea-sativa-doree-de-lyon'),
        'castanea-sativa-glabra': KeuzelijstWaarde(invulwaarde='castanea-sativa-glabra',
                                                   label="Castanea sativa 'Glabra'",
                                                   status='ingebruik',
                                                   objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/castanea-sativa-glabra'),
        'catalpa-bignonioides': KeuzelijstWaarde(invulwaarde='catalpa-bignonioides',
                                                 label='Catalpa bignonioides',
                                                 status='ingebruik',
                                                 objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/catalpa-bignonioides'),
        'catalpa-bignonioides-aurea': KeuzelijstWaarde(invulwaarde='catalpa-bignonioides-aurea',
                                                       label="Catalpa bignonioïdes 'Aurea'",
                                                       status='ingebruik',
                                                       objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/catalpa-bignonioides-aurea'),
        'catalpa-bignonioides-nana': KeuzelijstWaarde(invulwaarde='catalpa-bignonioides-nana',
                                                      label="Catalpa bignonioïdes 'Nana'",
                                                      status='ingebruik',
                                                      objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/catalpa-bignonioides-nana'),
        'catalpa-bungei': KeuzelijstWaarde(invulwaarde='catalpa-bungei',
                                           label='Catalpa bungei',
                                           status='ingebruik',
                                           objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/catalpa-bungei'),
        'cedrus-atlantica': KeuzelijstWaarde(invulwaarde='cedrus-atlantica',
                                             label='Cedrus atlantica',
                                             status='ingebruik',
                                             objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/cedrus-atlantica'),
        'celtis-australis': KeuzelijstWaarde(invulwaarde='celtis-australis',
                                             label='Celtis australis',
                                             status='ingebruik',
                                             objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/celtis-australis'),
        'celtis-occidentalis': KeuzelijstWaarde(invulwaarde='celtis-occidentalis',
                                                label='Celtis occidentalis',
                                                status='ingebruik',
                                                objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/celtis-occidentalis'),
        'cercidiphyllum-japonicum': KeuzelijstWaarde(invulwaarde='cercidiphyllum-japonicum',
                                                     label='Cercidiphyllum japonicum',
                                                     status='ingebruik',
                                                     objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/cercidiphyllum-japonicum'),
        'cercis-siliquastrum': KeuzelijstWaarde(invulwaarde='cercis-siliquastrum',
                                                label='Cercis siliquastrum',
                                                status='ingebruik',
                                                objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/cercis-siliquastrum'),
        'chamaecyparis': KeuzelijstWaarde(invulwaarde='chamaecyparis',
                                          label='Chamaecyparis',
                                          status='ingebruik',
                                          objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/chamaecyparis'),
        'chamaecyparis-lawsoniana': KeuzelijstWaarde(invulwaarde='chamaecyparis-lawsoniana',
                                                     label='Chamaecyparis lawsoniana',
                                                     status='ingebruik',
                                                     objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/chamaecyparis-lawsoniana'),
        'chamaecyparis-obtusa': KeuzelijstWaarde(invulwaarde='chamaecyparis-obtusa',
                                                 label='Chamaecyparis obtusa',
                                                 status='ingebruik',
                                                 definitie='Chamaecyparis obtusa',
                                                 objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/chamaecyparis-obtusa'),
        'cornus-mas': KeuzelijstWaarde(invulwaarde='cornus-mas',
                                       label='Cornus mas',
                                       status='ingebruik',
                                       objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/cornus-mas'),
        'cornus-nuttallii-monarch': KeuzelijstWaarde(invulwaarde='cornus-nuttallii-monarch',
                                                     label="Cornus nuttallii 'Monarch'",
                                                     status='ingebruik',
                                                     objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/cornus-nuttallii-monarch'),
        'corylus-avellana': KeuzelijstWaarde(invulwaarde='corylus-avellana',
                                             label='Corylus avellana',
                                             status='ingebruik',
                                             objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/corylus-avellana'),
        'corylus-colurna': KeuzelijstWaarde(invulwaarde='corylus-colurna',
                                            label='Corylus colurna',
                                            status='ingebruik',
                                            objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/corylus-colurna'),
        'corylus-colurna-te-terra-red': KeuzelijstWaarde(invulwaarde='corylus-colurna-te-terra-red',
                                                         label="Corylus colurna 'Te-Terra Red'",
                                                         status='ingebruik',
                                                         objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/corylus-colurna-te-terra-red'),
        'cotoneaster-x-watereri': KeuzelijstWaarde(invulwaarde='cotoneaster-x-watereri',
                                                   label='Cotoneaster x watereri',
                                                   status='ingebruik',
                                                   objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/cotoneaster-x-watereri'),
        'crataegus-coccinea': KeuzelijstWaarde(invulwaarde='crataegus-coccinea',
                                               label='Crataegus coccinea',
                                               status='ingebruik',
                                               objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/crataegus-coccinea'),
        'crataegus-grignonensis': KeuzelijstWaarde(invulwaarde='crataegus-grignonensis',
                                                   label='Crataegus grignonensis',
                                                   status='ingebruik',
                                                   objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/crataegus-grignonensis'),
        'crataegus-laevigata': KeuzelijstWaarde(invulwaarde='crataegus-laevigata',
                                                label='Crataegus laevigata',
                                                status='ingebruik',
                                                objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/crataegus-laevigata'),
        'crataegus-laevigata-alba-plena': KeuzelijstWaarde(invulwaarde='crataegus-laevigata-alba-plena',
                                                           label="Crataegus laevigata 'Alba Plena'",
                                                           status='ingebruik',
                                                           objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/crataegus-laevigata-alba-plena'),
        'crataegus-laevigata-mutabilis': KeuzelijstWaarde(invulwaarde='crataegus-laevigata-mutabilis',
                                                          label="Crataegus laevigata 'Mutabilis'",
                                                          status='ingebruik',
                                                          objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/crataegus-laevigata-mutabilis'),
        'crataegus-laevigata-pauls-scarlet': KeuzelijstWaarde(invulwaarde='crataegus-laevigata-pauls-scarlet',
                                                              label="Crataegus laevigata 'Paul's Scarlet'",
                                                              status='ingebruik',
                                                              objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/crataegus-laevigata-pauls-scarlet'),
        'crataegus-laevigata-plena': KeuzelijstWaarde(invulwaarde='crataegus-laevigata-plena',
                                                      label="Crataegus laevigata 'Plena'",
                                                      status='ingebruik',
                                                      objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/crataegus-laevigata-plena'),
        'crataegus-monogyna': KeuzelijstWaarde(invulwaarde='crataegus-monogyna',
                                               label='Crataegus monogyna',
                                               status='ingebruik',
                                               objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/crataegus-monogyna'),
        'crataegus-monogyna-stricta': KeuzelijstWaarde(invulwaarde='crataegus-monogyna-stricta',
                                                       label="Crataegus monogyna 'Stricta'",
                                                       status='ingebruik',
                                                       objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/crataegus-monogyna-stricta'),
        'crataegus-pedicellata': KeuzelijstWaarde(invulwaarde='crataegus-pedicellata',
                                                  label='Crataegus pedicellata',
                                                  status='ingebruik',
                                                  objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/crataegus-pedicellata'),
        'crataegus-x-lavalleei': KeuzelijstWaarde(invulwaarde='crataegus-x-lavalleei',
                                                  label='Crataegus x lavalleei',
                                                  status='ingebruik',
                                                  objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/crataegus-x-lavalleei'),
        'crataegus-x-lavalleei-carrierei': KeuzelijstWaarde(invulwaarde='crataegus-x-lavalleei-carrierei',
                                                            label="Crataegus x lavalleei 'Carrierei'",
                                                            status='ingebruik',
                                                            objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/crataegus-x-lavalleei-carrierei'),
        'crataegus-x-media-pauls-scarlet': KeuzelijstWaarde(invulwaarde='crataegus-x-media-pauls-scarlet',
                                                            label="Crataegus x media 'Paul's Scarlet'",
                                                            status='ingebruik',
                                                            objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/crataegus-x-media-pauls-scarlet'),
        'crataegus-x-media-rubra-plena': KeuzelijstWaarde(invulwaarde='crataegus-x-media-rubra-plena',
                                                          label="Crataegus x media 'Rubra Plena'",
                                                          status='ingebruik',
                                                          objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/crataegus-x-media-rubra-plena'),
        'crataegus-x-persimilis': KeuzelijstWaarde(invulwaarde='crataegus-x-persimilis',
                                                   label='Crataegus x persimilis',
                                                   status='ingebruik',
                                                   objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/crataegus-x-persimilis'),
        'crataegus-x-persimilis-splendens': KeuzelijstWaarde(invulwaarde='crataegus-x-persimilis-splendens',
                                                             label="Crataegus x persimilis 'Splendens'",
                                                             status='ingebruik',
                                                             objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/crataegus-x-persimilis-splendens'),
        'cupressocyparis-x-leylandii': KeuzelijstWaarde(invulwaarde='cupressocyparis-x-leylandii',
                                                        label='Cupressocyparis x leylandii',
                                                        status='ingebruik',
                                                        objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/cupressocyparis-x-leylandii'),
        'davidia-involucrata-vilmoriniana': KeuzelijstWaarde(invulwaarde='davidia-involucrata-vilmoriniana',
                                                             label="Davidia involucrata 'Vilmoriniana'",
                                                             status='ingebruik',
                                                             objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/davidia-involucrata-vilmoriniana'),
        'elaeagnus-ebbingei': KeuzelijstWaarde(invulwaarde='elaeagnus-ebbingei',
                                               label='Elaeagnus ebbingei',
                                               status='ingebruik',
                                               objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/elaeagnus-ebbingei'),
        'fagus-sylvatica': KeuzelijstWaarde(invulwaarde='fagus-sylvatica',
                                            label='Fagus sylvatica',
                                            status='ingebruik',
                                            objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/fagus-sylvatica'),
        'fagus-sylvatica-atropunicea': KeuzelijstWaarde(invulwaarde='fagus-sylvatica-atropunicea',
                                                        label="Fagus sylvatica 'Atropunicea'",
                                                        status='ingebruik',
                                                        objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/fagus-sylvatica-atropunicea'),
        'fagus-sylvatica-atropurpurea': KeuzelijstWaarde(invulwaarde='fagus-sylvatica-atropurpurea',
                                                         label="Fagus sylvatica 'Atropurpurea'",
                                                         status='ingebruik',
                                                         objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/fagus-sylvatica-atropurpurea'),
        'fagus-sylvatica-dawyck': KeuzelijstWaarde(invulwaarde='fagus-sylvatica-dawyck',
                                                   label="Fagus sylvatica 'Dawyck'",
                                                   status='ingebruik',
                                                   objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/fagus-sylvatica-dawyck'),
        'fagus-sylvatica-dawyck-gold': KeuzelijstWaarde(invulwaarde='fagus-sylvatica-dawyck-gold',
                                                        label="Fagus sylvatica 'Dawyck Gold'",
                                                        status='ingebruik',
                                                        objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/fagus-sylvatica-dawyck-gold'),
        'fagus-sylvatica-dawyck-purple': KeuzelijstWaarde(invulwaarde='fagus-sylvatica-dawyck-purple',
                                                          label="Fagus sylvatica 'Dawyck Purple'",
                                                          status='ingebruik',
                                                          objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/fagus-sylvatica-dawyck-purple'),
        'fagus-sylvatica-lacinata': KeuzelijstWaarde(invulwaarde='fagus-sylvatica-lacinata',
                                                     label="Fagus sylvatica 'Lacinata'",
                                                     status='ingebruik',
                                                     objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/fagus-sylvatica-lacinata'),
        'fagus-sylvatica-laciniata': KeuzelijstWaarde(invulwaarde='fagus-sylvatica-laciniata',
                                                      label="Fagus sylvatica 'Laciniata'",
                                                      status='ingebruik',
                                                      objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/fagus-sylvatica-laciniata'),
        'fagus-sylvatica-pendula': KeuzelijstWaarde(invulwaarde='fagus-sylvatica-pendula',
                                                    label="Fagus sylvatica 'Pendula'",
                                                    status='ingebruik',
                                                    objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/fagus-sylvatica-pendula'),
        'fagus-sylvatica-purpurea-pendula': KeuzelijstWaarde(invulwaarde='fagus-sylvatica-purpurea-pendula',
                                                             label="Fagus sylvatica 'Purpurea Pendula'",
                                                             status='ingebruik',
                                                             objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/fagus-sylvatica-purpurea-pendula'),
        'fagus-sylvatica-purpurea-tricolor': KeuzelijstWaarde(invulwaarde='fagus-sylvatica-purpurea-tricolor',
                                                              label="Fagus sylvatica 'Purpurea Tricolor'",
                                                              status='ingebruik',
                                                              objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/fagus-sylvatica-purpurea-tricolor'),
        'fagus-sylvatica-riversii': KeuzelijstWaarde(invulwaarde='fagus-sylvatica-riversii',
                                                     label="Fagus sylvatica 'Riversii'",
                                                     status='ingebruik',
                                                     objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/fagus-sylvatica-riversii'),
        'fraxinus-americana': KeuzelijstWaarde(invulwaarde='fraxinus-americana',
                                               label='Fraxinus americana',
                                               status='ingebruik',
                                               objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/fraxinus-americana'),
        'fraxinus-americana-empire': KeuzelijstWaarde(invulwaarde='fraxinus-americana-empire',
                                                      label="Fraxinus americana 'Empire'",
                                                      status='ingebruik',
                                                      objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/fraxinus-americana-empire'),
        'fraxinus-angustifolia': KeuzelijstWaarde(invulwaarde='fraxinus-angustifolia',
                                                  label='Fraxinus angustifolia',
                                                  status='ingebruik',
                                                  objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/fraxinus-angustifolia'),
        'fraxinus-angustifolia-raywood': KeuzelijstWaarde(invulwaarde='fraxinus-angustifolia-raywood',
                                                          label="Fraxinus angustifolia 'Raywood'",
                                                          status='ingebruik',
                                                          objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/fraxinus-angustifolia-raywood'),
        'fraxinus-excelsior': KeuzelijstWaarde(invulwaarde='fraxinus-excelsior',
                                               label='Fraxinus excelsior',
                                               status='ingebruik',
                                               objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/fraxinus-excelsior'),
        'fraxinus-excelsior-altena': KeuzelijstWaarde(invulwaarde='fraxinus-excelsior-altena',
                                                      label="Fraxinus excelsior 'Altena'",
                                                      status='ingebruik',
                                                      objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/fraxinus-excelsior-altena'),
        'fraxinus-excelsior-atlas': KeuzelijstWaarde(invulwaarde='fraxinus-excelsior-atlas',
                                                     label="Fraxinus excelsior 'Atlas'",
                                                     status='ingebruik',
                                                     objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/fraxinus-excelsior-atlas'),
        'fraxinus-excelsior-aurea': KeuzelijstWaarde(invulwaarde='fraxinus-excelsior-aurea',
                                                     label="Fraxinus excelsior 'Aurea'",
                                                     status='ingebruik',
                                                     objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/fraxinus-excelsior-aurea'),
        'fraxinus-excelsior-diversifolia': KeuzelijstWaarde(invulwaarde='fraxinus-excelsior-diversifolia',
                                                            label="Fraxinus excelsior 'Diversifolia'",
                                                            status='ingebruik',
                                                            objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/fraxinus-excelsior-diversifolia'),
        'fraxinus-excelsior-eldik': KeuzelijstWaarde(invulwaarde='fraxinus-excelsior-eldik',
                                                     label="Fraxinus excelsior 'Eldik'",
                                                     status='ingebruik',
                                                     objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/fraxinus-excelsior-eldik'),
        'fraxinus-excelsior-eureka': KeuzelijstWaarde(invulwaarde='fraxinus-excelsior-eureka',
                                                      label="Fraxinus excelsior 'Eureka'",
                                                      status='ingebruik',
                                                      objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/fraxinus-excelsior-eureka'),
        'fraxinus-excelsior-geessink': KeuzelijstWaarde(invulwaarde='fraxinus-excelsior-geessink',
                                                        label="Fraxinus excelsior 'Geessink'",
                                                        status='ingebruik',
                                                        objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/fraxinus-excelsior-geessink'),
        'fraxinus-excelsior-jaspidea': KeuzelijstWaarde(invulwaarde='fraxinus-excelsior-jaspidea',
                                                        label="Fraxinus excelsior 'Jaspidea'",
                                                        status='ingebruik',
                                                        objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/fraxinus-excelsior-jaspidea'),
        'fraxinus-excelsior-nana': KeuzelijstWaarde(invulwaarde='fraxinus-excelsior-nana',
                                                    label="Fraxinus excelsior 'Nana'",
                                                    status='ingebruik',
                                                    objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/fraxinus-excelsior-nana'),
        'fraxinus-excelsior-pendula': KeuzelijstWaarde(invulwaarde='fraxinus-excelsior-pendula',
                                                       label="Fraxinus excelsior 'Pendula'",
                                                       status='ingebruik',
                                                       objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/fraxinus-excelsior-pendula'),
        'fraxinus-excelsior-westhofs-glorie': KeuzelijstWaarde(invulwaarde='fraxinus-excelsior-westhofs-glorie',
                                                               label="Fraxinus excelsior 'Westhof's Glorie'",
                                                               status='ingebruik',
                                                               objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/fraxinus-excelsior-westhofs-glorie'),
        'fraxinus-exceslior-grift': KeuzelijstWaarde(invulwaarde='fraxinus-exceslior-grift',
                                                     label="Fraxinus exceslior 'Grift'",
                                                     status='ingebruik',
                                                     objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/fraxinus-exceslior-grift'),
        'fraxinus-ornus': KeuzelijstWaarde(invulwaarde='fraxinus-ornus',
                                           label='Fraxinus ornus',
                                           status='ingebruik',
                                           objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/fraxinus-ornus'),
        'fraxinus-ornus-arie-peters': KeuzelijstWaarde(invulwaarde='fraxinus-ornus-arie-peters',
                                                       label="Fraxinus ornus 'Arie Peters'",
                                                       status='ingebruik',
                                                       objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/fraxinus-ornus-arie-peters'),
        'fraxinus-ornus-meczek': KeuzelijstWaarde(invulwaarde='fraxinus-ornus-meczek',
                                                  label="Fraxinus ornus 'Meczek'",
                                                  status='ingebruik',
                                                  objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/fraxinus-ornus-meczek'),
        'fraxinus-ornus-obelisk': KeuzelijstWaarde(invulwaarde='fraxinus-ornus-obelisk',
                                                   label="Fraxinus ornus 'Obelisk'",
                                                   status='ingebruik',
                                                   objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/fraxinus-ornus-obelisk'),
        'fraxinus-ornus-paus-johannes-paulus-ii': KeuzelijstWaarde(invulwaarde='fraxinus-ornus-paus-johannes-paulus-ii',
                                                                   label="Fraxinus ornus 'Paus Johannes-Paulus II'",
                                                                   status='ingebruik',
                                                                   objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/fraxinus-ornus-paus-johannes-paulus-ii'),
        'fraxinus-pennsylvanica': KeuzelijstWaarde(invulwaarde='fraxinus-pennsylvanica',
                                                   label='Fraxinus pennsylvanica',
                                                   status='ingebruik',
                                                   objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/fraxinus-pennsylvanica'),
        'ginkgo-biloba': KeuzelijstWaarde(invulwaarde='ginkgo-biloba',
                                          label='Ginkgo biloba',
                                          status='ingebruik',
                                          objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/ginkgo-biloba'),
        'ginkgo-biloba-autumn-glory': KeuzelijstWaarde(invulwaarde='ginkgo-biloba-autumn-glory',
                                                       label="Ginkgo biloba 'Autumn Glory'",
                                                       status='ingebruik',
                                                       objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/ginkgo-biloba-autumn-glory'),
        'gleditsia-triacanthos': KeuzelijstWaarde(invulwaarde='gleditsia-triacanthos',
                                                  label='Gleditsia triacanthos',
                                                  status='ingebruik',
                                                  objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/gleditsia-triacanthos'),
        'gleditsia-triacanthos-f.-inermis': KeuzelijstWaarde(invulwaarde='gleditsia-triacanthos-f.-inermis',
                                                             label="Gleditsia triacanthos f. 'inermis'",
                                                             status='ingebruik',
                                                             objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/gleditsia-triacanthos-f.-inermis'),
        'gleditsia-triacanthos-inermis': KeuzelijstWaarde(invulwaarde='gleditsia-triacanthos-inermis',
                                                          label="Gleditsia triacanthos 'Inermis'",
                                                          status='ingebruik',
                                                          objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/gleditsia-triacanthos-inermis'),
        'gleditsia-triacanthos-skyline': KeuzelijstWaarde(invulwaarde='gleditsia-triacanthos-skyline',
                                                          label="Gleditsia triacanthos 'Skyline'",
                                                          status='ingebruik',
                                                          objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/gleditsia-triacanthos-skyline'),
        'gleditsia-triacanthos-sunburst': KeuzelijstWaarde(invulwaarde='gleditsia-triacanthos-sunburst',
                                                           label="Gleditsia triacanthos 'Sunburst'",
                                                           status='ingebruik',
                                                           objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/gleditsia-triacanthos-sunburst'),
        'gymnocladus-dioicus': KeuzelijstWaarde(invulwaarde='gymnocladus-dioicus',
                                                label='Gymnocladus dioicus',
                                                status='ingebruik',
                                                objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/gymnocladus-dioicus'),
        'halesia-monticola': KeuzelijstWaarde(invulwaarde='halesia-monticola',
                                              label='Halesia monticola',
                                              status='ingebruik',
                                              definitie='Halesia monticola',
                                              objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/halesia-monticola'),
        'hyppophae-salicifolia': KeuzelijstWaarde(invulwaarde='hyppophae-salicifolia',
                                                  label='Hyppophae salicifolia',
                                                  status='ingebruik',
                                                  objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/hyppophae-salicifolia'),
        'ilex-aquifolium': KeuzelijstWaarde(invulwaarde='ilex-aquifolium',
                                            label='Ilex aquifolium',
                                            status='ingebruik',
                                            objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/ilex-aquifolium'),
        'juglans-nigra': KeuzelijstWaarde(invulwaarde='juglans-nigra',
                                          label='Juglans nigra',
                                          status='ingebruik',
                                          objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/juglans-nigra'),
        'juglans-regia': KeuzelijstWaarde(invulwaarde='juglans-regia',
                                          label='Juglans regia',
                                          status='ingebruik',
                                          objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/juglans-regia'),
        'koelreuteria-paniculata': KeuzelijstWaarde(invulwaarde='koelreuteria-paniculata',
                                                    label='Koelreuteria paniculata',
                                                    status='ingebruik',
                                                    objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/koelreuteria-paniculata'),
        'koelreuteria-paniculata-fastigiata': KeuzelijstWaarde(invulwaarde='koelreuteria-paniculata-fastigiata',
                                                               label="Koelreuteria paniculata 'Fastigiata'",
                                                               status='ingebruik',
                                                               objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/koelreuteria-paniculata-fastigiata'),
        'laburnum-alpinum-pendulum': KeuzelijstWaarde(invulwaarde='laburnum-alpinum-pendulum',
                                                      label="Laburnum alpinum 'Pendulum'",
                                                      status='ingebruik',
                                                      objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/laburnum-alpinum-pendulum'),
        'laburnum-anagyroides': KeuzelijstWaarde(invulwaarde='laburnum-anagyroides',
                                                 label='Laburnum anagyroides',
                                                 status='ingebruik',
                                                 objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/laburnum-anagyroides'),
        'laburnum-x-watereri-vossii': KeuzelijstWaarde(invulwaarde='laburnum-x-watereri-vossii',
                                                       label="Laburnum x watereri 'Vossii'",
                                                       status='ingebruik',
                                                       objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/laburnum-x-watereri-vossii'),
        'larix-decidua': KeuzelijstWaarde(invulwaarde='larix-decidua',
                                          label='Larix decidua',
                                          status='ingebruik',
                                          objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/larix-decidua'),
        'larix-kaempferi': KeuzelijstWaarde(invulwaarde='larix-kaempferi',
                                            label='Larix kaempferi',
                                            status='ingebruik',
                                            objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/larix-kaempferi'),
        'larix-kaempferi-pendula': KeuzelijstWaarde(invulwaarde='larix-kaempferi-pendula',
                                                    label="Larix kaempferi 'Pendula'",
                                                    status='ingebruik',
                                                    objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/larix-kaempferi-pendula'),
        'liquidambar-formosana': KeuzelijstWaarde(invulwaarde='liquidambar-formosana',
                                                  label='Liquidambar formosana',
                                                  status='ingebruik',
                                                  objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/liquidambar-formosana'),
        'liquidambar-orientalis': KeuzelijstWaarde(invulwaarde='liquidambar-orientalis',
                                                   label='Liquidambar orientalis',
                                                   status='ingebruik',
                                                   objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/liquidambar-orientalis'),
        'liquidambar-styraciflua': KeuzelijstWaarde(invulwaarde='liquidambar-styraciflua',
                                                    label='Liquidambar styraciflua',
                                                    status='ingebruik',
                                                    objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/liquidambar-styraciflua'),
        'liquidambar-styraciflua-aurea': KeuzelijstWaarde(invulwaarde='liquidambar-styraciflua-aurea',
                                                          label="Liquidambar styraciflua 'Aurea'",
                                                          status='ingebruik',
                                                          objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/liquidambar-styraciflua-aurea'),
        'liquidambar-styraciflua-cultivaris': KeuzelijstWaarde(invulwaarde='liquidambar-styraciflua-cultivaris',
                                                               label="Liquidambar styraciflua 'Cultivaris'",
                                                               status='ingebruik',
                                                               objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/liquidambar-styraciflua-cultivaris'),
        'liquidambar-styraciflua-gum-ball': KeuzelijstWaarde(invulwaarde='liquidambar-styraciflua-gum-ball',
                                                             label="Liquidambar styraciflua 'Gum Ball'",
                                                             status='ingebruik',
                                                             objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/liquidambar-styraciflua-gum-ball'),
        'liquidambar-styraciflua-gumball': KeuzelijstWaarde(invulwaarde='liquidambar-styraciflua-gumball',
                                                            label="Liquidambar styraciflua 'Gumball'",
                                                            status='ingebruik',
                                                            objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/liquidambar-styraciflua-gumball'),
        'liquidambar-styraciflua-lane-roberts': KeuzelijstWaarde(invulwaarde='liquidambar-styraciflua-lane-roberts',
                                                                 label="Liquidambar styraciflua 'Lane Roberts'",
                                                                 status='ingebruik',
                                                                 objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/liquidambar-styraciflua-lane-roberts'),
        'liquidambar-styraciflua-silver-king': KeuzelijstWaarde(invulwaarde='liquidambar-styraciflua-silver-king',
                                                                label="Liquidambar styraciflua 'Silver King'",
                                                                status='ingebruik',
                                                                objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/liquidambar-styraciflua-silver-king'),
        'liquidambar-styraciflua-slender-silhouet': KeuzelijstWaarde(invulwaarde='liquidambar-styraciflua-slender-silhouet',
                                                                     label="Liquidambar styraciflua 'Slender Silhouet'",
                                                                     status='ingebruik',
                                                                     objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/liquidambar-styraciflua-slender-silhouet'),
        'liquidambar-styraciflua-worplesdon': KeuzelijstWaarde(invulwaarde='liquidambar-styraciflua-worplesdon',
                                                               label="Liquidambar styraciflua 'Worplesdon'",
                                                               status='ingebruik',
                                                               objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/liquidambar-styraciflua-worplesdon'),
        'liriodendron-tulipifera': KeuzelijstWaarde(invulwaarde='liriodendron-tulipifera',
                                                    label='Liriodendron tulipifera',
                                                    status='ingebruik',
                                                    objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/liriodendron-tulipifera'),
        'liriodendron-tulipifera-aureomarginatum': KeuzelijstWaarde(invulwaarde='liriodendron-tulipifera-aureomarginatum',
                                                                    label="Liriodendron tulipifera 'Aureomarginatum'",
                                                                    status='ingebruik',
                                                                    objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/liriodendron-tulipifera-aureomarginatum'),
        'liriodendron-tulipifera-fastigiatum': KeuzelijstWaarde(invulwaarde='liriodendron-tulipifera-fastigiatum',
                                                                label="Liriodendron tulipifera 'Fastigiatum'",
                                                                status='ingebruik',
                                                                objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/liriodendron-tulipifera-fastigiatum'),
        'magnolia-galaxy': KeuzelijstWaarde(invulwaarde='magnolia-galaxy',
                                            label='Magnolia galaxy',
                                            status='ingebruik',
                                            objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/magnolia-galaxy'),
        'magnolia-grandiflora': KeuzelijstWaarde(invulwaarde='magnolia-grandiflora',
                                                 label='Magnolia grandiflora',
                                                 status='ingebruik',
                                                 definitie='Magnolia grandiflora',
                                                 objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/magnolia-grandiflora'),
        'magnolia-kobus': KeuzelijstWaarde(invulwaarde='magnolia-kobus',
                                           label='Magnolia kobus',
                                           status='ingebruik',
                                           objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/magnolia-kobus'),
        'malus-(in-varieteiten-en-cultivars)': KeuzelijstWaarde(invulwaarde='malus-(in-varieteiten-en-cultivars)',
                                                                label='Malus (in variéteiten en cultivars)',
                                                                status='ingebruik',
                                                                objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/malus-(in-varieteiten-en-cultivars)'),
        'malus-red-obelisk': KeuzelijstWaarde(invulwaarde='malus-red-obelisk',
                                              label="Malus 'Red Obelisk'",
                                              status='ingebruik',
                                              objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/malus-red-obelisk'),
        'malus-sylvestris': KeuzelijstWaarde(invulwaarde='malus-sylvestris',
                                             label='Malus sylvestris',
                                             status='ingebruik',
                                             objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/malus-sylvestris'),
        'metasequioa-glyptostroboides': KeuzelijstWaarde(invulwaarde='metasequioa-glyptostroboides',
                                                         label='Metasequioa glyptostroboides',
                                                         status='ingebruik',
                                                         objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/metasequioa-glyptostroboides'),
        'metasequioa-glyptostroboides-fastigiata': KeuzelijstWaarde(invulwaarde='metasequioa-glyptostroboides-fastigiata',
                                                                    label="Metasequioa glyptostroboides 'Fastigiata'",
                                                                    status='ingebruik',
                                                                    objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/metasequioa-glyptostroboides-fastigiata'),
        'morus-alba': KeuzelijstWaarde(invulwaarde='morus-alba',
                                       label='Morus alba',
                                       status='ingebruik',
                                       objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/morus-alba'),
        'morus-alba-macrophylla': KeuzelijstWaarde(invulwaarde='morus-alba-macrophylla',
                                                   label="Morus alba 'Macrophylla'",
                                                   status='ingebruik',
                                                   objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/morus-alba-macrophylla'),
        'morus-alba-pendula': KeuzelijstWaarde(invulwaarde='morus-alba-pendula',
                                               label="Morus alba 'Pendula'",
                                               status='ingebruik',
                                               objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/morus-alba-pendula'),
        'nothofagus-antarctica': KeuzelijstWaarde(invulwaarde='nothofagus-antarctica',
                                                  label='Nothofagus antarctica',
                                                  status='ingebruik',
                                                  objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/nothofagus-antarctica'),
        'nyssa-sylvatica': KeuzelijstWaarde(invulwaarde='nyssa-sylvatica',
                                            label='Nyssa sylvatica',
                                            status='ingebruik',
                                            objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/nyssa-sylvatica'),
        'ostrya-carpinifolia': KeuzelijstWaarde(invulwaarde='ostrya-carpinifolia',
                                                label='Ostrya carpinifolia',
                                                status='ingebruik',
                                                objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/ostrya-carpinifolia'),
        'parrotia-persica': KeuzelijstWaarde(invulwaarde='parrotia-persica',
                                             label='Parrotia persica',
                                             status='ingebruik',
                                             objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/parrotia-persica'),
        'parrotia-persica-vanessa': KeuzelijstWaarde(invulwaarde='parrotia-persica-vanessa',
                                                     label="Parrotia persica 'Vanessa'",
                                                     status='ingebruik',
                                                     objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/parrotia-persica-vanessa'),
        'paulownia-tomentosa': KeuzelijstWaarde(invulwaarde='paulownia-tomentosa',
                                                label='Paulownia tomentosa',
                                                status='ingebruik',
                                                objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/paulownia-tomentosa'),
        'phellodendron-amurense': KeuzelijstWaarde(invulwaarde='phellodendron-amurense',
                                                   label='Phellodendron amurense',
                                                   status='ingebruik',
                                                   objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/phellodendron-amurense'),
        'photinia-fraseri': KeuzelijstWaarde(invulwaarde='photinia-fraseri',
                                             label='Photinia × fraseri',
                                             status='ingebruik',
                                             definitie='Photinia × fraseri',
                                             objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/photinia-fraseri'),
        'picea-abies': KeuzelijstWaarde(invulwaarde='picea-abies',
                                        label='Picea abies',
                                        status='ingebruik',
                                        objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/picea-abies'),
        'pinus-nigra': KeuzelijstWaarde(invulwaarde='pinus-nigra',
                                        label='Pinus nigra',
                                        status='ingebruik',
                                        objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/pinus-nigra'),
        'pinus-sylvestris': KeuzelijstWaarde(invulwaarde='pinus-sylvestris',
                                             label='Pinus sylvestris',
                                             status='ingebruik',
                                             objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/pinus-sylvestris'),
        'platanus-orientalis': KeuzelijstWaarde(invulwaarde='platanus-orientalis',
                                                label='Platanus orientalis',
                                                status='ingebruik',
                                                objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/platanus-orientalis'),
        'platanus-orientalis-minaret': KeuzelijstWaarde(invulwaarde='platanus-orientalis-minaret',
                                                        label="Platanus orientalis 'Minaret'",
                                                        status='ingebruik',
                                                        objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/platanus-orientalis-minaret'),
        'platanus-sp': KeuzelijstWaarde(invulwaarde='platanus-sp',
                                        label='Platanus sp.',
                                        status='ingebruik',
                                        definitie='Platanus sp.',
                                        objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/platanus-sp'),
        'platanus-x-hispanica': KeuzelijstWaarde(invulwaarde='platanus-x-hispanica',
                                                 label='Platanus x hispanica',
                                                 status='ingebruik',
                                                 objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/platanus-x-hispanica'),
        'platanus-x-hispanica-alphens-globe': KeuzelijstWaarde(invulwaarde='platanus-x-hispanica-alphens-globe',
                                                               label="Platanus x hispanica 'Alphen's Globe'",
                                                               status='ingebruik',
                                                               objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/platanus-x-hispanica-alphens-globe'),
        'platanus-x-hispanica-malburg': KeuzelijstWaarde(invulwaarde='platanus-x-hispanica-malburg',
                                                         label="Platanus x hispanica 'Malburg'",
                                                         status='ingebruik',
                                                         objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/platanus-x-hispanica-malburg'),
        'populus-alba': KeuzelijstWaarde(invulwaarde='populus-alba',
                                         label='Populus alba',
                                         status='ingebruik',
                                         objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/populus-alba'),
        'populus-alba-nivea': KeuzelijstWaarde(invulwaarde='populus-alba-nivea',
                                               label="Populus alba 'Nivea'",
                                               status='ingebruik',
                                               objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/populus-alba-nivea'),
        'populus-alba-raket': KeuzelijstWaarde(invulwaarde='populus-alba-raket',
                                               label="Populus alba 'Raket'",
                                               status='ingebruik',
                                               objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/populus-alba-raket'),
        'populus-balsamifera': KeuzelijstWaarde(invulwaarde='populus-balsamifera',
                                                label='Populus balsamifera',
                                                status='ingebruik',
                                                objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/populus-balsamifera'),
        'populus-candicans-aurora': KeuzelijstWaarde(invulwaarde='populus-candicans-aurora',
                                                     label="Populus candicans 'Aurora'",
                                                     status='ingebruik',
                                                     objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/populus-candicans-aurora'),
        'populus-lasiocarpa': KeuzelijstWaarde(invulwaarde='populus-lasiocarpa',
                                               label='Populus lasiocarpa',
                                               status='ingebruik',
                                               objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/populus-lasiocarpa'),
        'populus-nigra': KeuzelijstWaarde(invulwaarde='populus-nigra',
                                          label='Populus nigra',
                                          status='ingebruik',
                                          objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/populus-nigra'),
        'populus-nigra-italica': KeuzelijstWaarde(invulwaarde='populus-nigra-italica',
                                                  label="Populus nigra 'Italica'",
                                                  status='ingebruik',
                                                  objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/populus-nigra-italica'),
        'populus-nigra-vereecken': KeuzelijstWaarde(invulwaarde='populus-nigra-vereecken',
                                                    label="Populus nigra 'Vereecken'",
                                                    status='ingebruik',
                                                    objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/populus-nigra-vereecken'),
        'populus-simonii-fastigiata': KeuzelijstWaarde(invulwaarde='populus-simonii-fastigiata',
                                                       label="Populus simonii 'Fastigiata'",
                                                       status='ingebruik',
                                                       objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/populus-simonii-fastigiata'),
        'populus-tremula': KeuzelijstWaarde(invulwaarde='populus-tremula',
                                            label='Populus tremula',
                                            status='ingebruik',
                                            objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/populus-tremula'),
        'populus-tremula-erecta': KeuzelijstWaarde(invulwaarde='populus-tremula-erecta',
                                                   label="Populus tremula 'Erecta'",
                                                   status='ingebruik',
                                                   objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/populus-tremula-erecta'),
        'populus-tremula-pendula': KeuzelijstWaarde(invulwaarde='populus-tremula-pendula',
                                                    label="Populus tremula 'Pendula'",
                                                    status='ingebruik',
                                                    objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/populus-tremula-pendula'),
        'populus-unal': KeuzelijstWaarde(invulwaarde='populus-unal',
                                         label="Populus 'Unal'",
                                         status='ingebruik',
                                         objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/populus-unal'),
        'populus-x-canadensis': KeuzelijstWaarde(invulwaarde='populus-x-canadensis',
                                                 label='Populus x canadensis',
                                                 status='ingebruik',
                                                 objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/populus-x-canadensis'),
        'populus-x-canadensis-ghoy': KeuzelijstWaarde(invulwaarde='populus-x-canadensis-ghoy',
                                                      label="Populus x canadensis 'Ghoy'",
                                                      status='ingebruik',
                                                      objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/populus-x-canadensis-ghoy'),
        'populus-x-canadensis-isieres': KeuzelijstWaarde(invulwaarde='populus-x-canadensis-isieres',
                                                         label="Populus x canadensis 'Isières'",
                                                         status='ingebruik',
                                                         objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/populus-x-canadensis-isieres'),
        'populus-x-canadensis-marilandica': KeuzelijstWaarde(invulwaarde='populus-x-canadensis-marilandica',
                                                             label="Populus x canadensis 'Marilandica'",
                                                             status='ingebruik',
                                                             objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/populus-x-canadensis-marilandica'),
        'populus-x-canadensis-muur': KeuzelijstWaarde(invulwaarde='populus-x-canadensis-muur',
                                                      label="Populus x canadensis 'Muur'",
                                                      status='ingebruik',
                                                      objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/populus-x-canadensis-muur'),
        'populus-x-canadensis-robusta': KeuzelijstWaarde(invulwaarde='populus-x-canadensis-robusta',
                                                         label="Populus x canadensis 'Robusta'",
                                                         status='ingebruik',
                                                         objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/populus-x-canadensis-robusta'),
        'populus-x-canescens': KeuzelijstWaarde(invulwaarde='populus-x-canescens',
                                                label='Populus x canescens',
                                                status='ingebruik',
                                                objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/populus-x-canescens'),
        'populus-x-canescens-de-moffart': KeuzelijstWaarde(invulwaarde='populus-x-canescens-de-moffart',
                                                           label="Populus x canescens 'De Moffart'",
                                                           status='ingebruik',
                                                           objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/populus-x-canescens-de-moffart'),
        'populus-x-canescens-enniger': KeuzelijstWaarde(invulwaarde='populus-x-canescens-enniger',
                                                        label="Populus x canescens 'Enniger'",
                                                        status='ingebruik',
                                                        objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/populus-x-canescens-enniger'),
        'prunus-(fruit-kers-kriek)': KeuzelijstWaarde(invulwaarde='prunus-(fruit-kers-kriek)',
                                                      label='Prunus (fruit-kers/kriek)',
                                                      status='ingebruik',
                                                      objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/prunus-(fruit-kers-kriek)'),
        'prunus-accolade': KeuzelijstWaarde(invulwaarde='prunus-accolade',
                                            label="Prunus 'Accolade'",
                                            status='ingebruik',
                                            objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/prunus-accolade'),
        'prunus-avium': KeuzelijstWaarde(invulwaarde='prunus-avium',
                                         label='Prunus avium',
                                         status='ingebruik',
                                         objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/prunus-avium'),
        'prunus-avium-landscape-bloom': KeuzelijstWaarde(invulwaarde='prunus-avium-landscape-bloom',
                                                         label='Prunus avium landscape bloom',
                                                         status='ingebruik',
                                                         definitie='Prunus avium landscape bloom',
                                                         objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/prunus-avium-landscape-bloom'),
        'prunus-avium-plena': KeuzelijstWaarde(invulwaarde='prunus-avium-plena',
                                               label="Prunus avium 'Plena'",
                                               status='ingebruik',
                                               objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/prunus-avium-plena'),
        'prunus-cerasifera': KeuzelijstWaarde(invulwaarde='prunus-cerasifera',
                                              label='Prunus cerasifera',
                                              status='ingebruik',
                                              objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/prunus-cerasifera'),
        'prunus-cerasifera-nigra': KeuzelijstWaarde(invulwaarde='prunus-cerasifera-nigra',
                                                    label="Prunus cerasifera 'Nigra'",
                                                    status='ingebruik',
                                                    objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/prunus-cerasifera-nigra'),
        'prunus-domestica-(fruit-pruim)': KeuzelijstWaarde(invulwaarde='prunus-domestica-(fruit-pruim)',
                                                           label='Prunus domestica (fruit: pruim)',
                                                           status='ingebruik',
                                                           objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/prunus-domestica-(fruit-pruim)'),
        'prunus-hally-jolivette': KeuzelijstWaarde(invulwaarde='prunus-hally-jolivette',
                                                   label="Prunus 'Hally Jolivette'",
                                                   status='ingebruik',
                                                   objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/prunus-hally-jolivette'),
        'prunus-laurocerasus': KeuzelijstWaarde(invulwaarde='prunus-laurocerasus',
                                                label='Prunus laurocerasus',
                                                status='ingebruik',
                                                definitie='Prunus laurocerasus',
                                                objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/prunus-laurocerasus'),
        'prunus-maackii': KeuzelijstWaarde(invulwaarde='prunus-maackii',
                                           label='Prunus maackii',
                                           status='ingebruik',
                                           objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/prunus-maackii'),
        'prunus-maackii-amber-beauty': KeuzelijstWaarde(invulwaarde='prunus-maackii-amber-beauty',
                                                        label="Prunus maackii 'Amber Beauty'",
                                                        status='ingebruik',
                                                        objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/prunus-maackii-amber-beauty'),
        'prunus-maackii-tibetica': KeuzelijstWaarde(invulwaarde='prunus-maackii-tibetica',
                                                    label="Prunus maackii 'Tibetica'",
                                                    status='ingebruik',
                                                    objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/prunus-maackii-tibetica'),
        'prunus-padus': KeuzelijstWaarde(invulwaarde='prunus-padus',
                                         label='Prunus padus',
                                         status='ingebruik',
                                         objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/prunus-padus'),
        'prunus-padus-albertii': KeuzelijstWaarde(invulwaarde='prunus-padus-albertii',
                                                  label="Prunus padus 'Albertii'",
                                                  status='ingebruik',
                                                  objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/prunus-padus-albertii'),
        'prunus-padus-colorata': KeuzelijstWaarde(invulwaarde='prunus-padus-colorata',
                                                  label="Prunus padus 'Colorata'",
                                                  status='ingebruik',
                                                  objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/prunus-padus-colorata'),
        'prunus-padus-watereri': KeuzelijstWaarde(invulwaarde='prunus-padus-watereri',
                                                  label="Prunus padus 'Watereri'",
                                                  status='ingebruik',
                                                  objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/prunus-padus-watereri'),
        'prunus-pandora': KeuzelijstWaarde(invulwaarde='prunus-pandora',
                                           label="Prunus 'Pandora'",
                                           status='ingebruik',
                                           objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/prunus-pandora'),
        'prunus-pendula': KeuzelijstWaarde(invulwaarde='prunus-pendula',
                                           label='Prunus pendula',
                                           status='ingebruik',
                                           objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/prunus-pendula'),
        'prunus-persica-melred': KeuzelijstWaarde(invulwaarde='prunus-persica-melred',
                                                  label="Prunus persica 'Melred'",
                                                  status='ingebruik',
                                                  objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/prunus-persica-melred'),
        'prunus-sargentii': KeuzelijstWaarde(invulwaarde='prunus-sargentii',
                                             label='Prunus sargentii',
                                             status='ingebruik',
                                             objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/prunus-sargentii'),
        'prunus-serotina': KeuzelijstWaarde(invulwaarde='prunus-serotina',
                                            label='Prunus serotina',
                                            status='ingebruik',
                                            objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/prunus-serotina'),
        'prunus-serrula': KeuzelijstWaarde(invulwaarde='prunus-serrula',
                                           label='Prunus serrula',
                                           status='ingebruik',
                                           objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/prunus-serrula'),
        'prunus-serrulata': KeuzelijstWaarde(invulwaarde='prunus-serrulata',
                                             label='Prunus serrulata',
                                             status='ingebruik',
                                             objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/prunus-serrulata'),
        'prunus-serrulata-amanogawa': KeuzelijstWaarde(invulwaarde='prunus-serrulata-amanogawa',
                                                       label="Prunus serrulata 'Amanogawa'",
                                                       status='ingebruik',
                                                       objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/prunus-serrulata-amanogawa'),
        'prunus-serrulata-fugenzo': KeuzelijstWaarde(invulwaarde='prunus-serrulata-fugenzo',
                                                     label="Prunus serrulata 'Fugenzo'",
                                                     status='ingebruik',
                                                     objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/prunus-serrulata-fugenzo'),
        'prunus-serrulata-hizakura': KeuzelijstWaarde(invulwaarde='prunus-serrulata-hizakura',
                                                      label="Prunus serrulata 'Hizakura'",
                                                      status='ingebruik',
                                                      objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/prunus-serrulata-hizakura'),
        'prunus-serrulata-kanzan': KeuzelijstWaarde(invulwaarde='prunus-serrulata-kanzan',
                                                    label="Prunus serrulata 'Kanzan'",
                                                    status='ingebruik',
                                                    objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/prunus-serrulata-kanzan'),
        'prunus-serrulata-kiku-shidare-zakura': KeuzelijstWaarde(invulwaarde='prunus-serrulata-kiku-shidare-zakura',
                                                                 label="Prunus serrulata 'Kiku-shidare-zakura'",
                                                                 status='ingebruik',
                                                                 objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/prunus-serrulata-kiku-shidare-zakura'),
        'prunus-serrulata-royal-burgundy': KeuzelijstWaarde(invulwaarde='prunus-serrulata-royal-burgundy',
                                                            label="Prunus serrulata 'Royal Burgundy'",
                                                            status='ingebruik',
                                                            objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/prunus-serrulata-royal-burgundy'),
        'prunus-serrulata-shirofugen': KeuzelijstWaarde(invulwaarde='prunus-serrulata-shirofugen',
                                                        label="Prunus serrulata 'Shirofugen'",
                                                        status='ingebruik',
                                                        objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/prunus-serrulata-shirofugen'),
        'prunus-serrulata-shirotae': KeuzelijstWaarde(invulwaarde='prunus-serrulata-shirotae',
                                                      label="Prunus serrulata 'Shirotae'",
                                                      status='ingebruik',
                                                      objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/prunus-serrulata-shirotae'),
        'prunus-spinosa': KeuzelijstWaarde(invulwaarde='prunus-spinosa',
                                           label='Prunus spinosa',
                                           status='ingebruik',
                                           objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/prunus-spinosa'),
        'prunus-spire': KeuzelijstWaarde(invulwaarde='prunus-spire',
                                         label="Prunus 'Spire'",
                                         status='ingebruik',
                                         objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/prunus-spire'),
        'prunus-tenella-fire-hill': KeuzelijstWaarde(invulwaarde='prunus-tenella-fire-hill',
                                                     label="Prunus tenella 'Fire Hill'",
                                                     status='ingebruik',
                                                     objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/prunus-tenella-fire-hill'),
        'prunus-triloba': KeuzelijstWaarde(invulwaarde='prunus-triloba',
                                           label='Prunus triloba',
                                           status='ingebruik',
                                           objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/prunus-triloba'),
        'prunus-umineko': KeuzelijstWaarde(invulwaarde='prunus-umineko',
                                           label="Prunus 'Umineko'",
                                           status='ingebruik',
                                           objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/prunus-umineko'),
        'prunus-virginiana-shubert': KeuzelijstWaarde(invulwaarde='prunus-virginiana-shubert',
                                                      label="Prunus virginiana 'Shubert'",
                                                      status='ingebruik',
                                                      objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/prunus-virginiana-shubert'),
        'prunus-x-blireana-moseri': KeuzelijstWaarde(invulwaarde='prunus-x-blireana-moseri',
                                                     label="Prunus x blireana 'Moseri'",
                                                     status='ingebruik',
                                                     objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/prunus-x-blireana-moseri'),
        'prunus-x-domestica-var.-syriaca': KeuzelijstWaarde(invulwaarde='prunus-x-domestica-var.-syriaca',
                                                            label='Prunus x domestica var. Syriaca',
                                                            status='ingebruik',
                                                            objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/prunus-x-domestica-var.-syriaca'),
        'prunus-x-eminens-umbraculifera': KeuzelijstWaarde(invulwaarde='prunus-x-eminens-umbraculifera',
                                                           label="Prunus x eminens 'Umbraculifera'",
                                                           status='ingebruik',
                                                           objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/prunus-x-eminens-umbraculifera'),
        'prunus-x-gondouinii-schnee': KeuzelijstWaarde(invulwaarde='prunus-x-gondouinii-schnee',
                                                       label="Prunus x gondouinii 'Schnee'",
                                                       status='ingebruik',
                                                       objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/prunus-x-gondouinii-schnee'),
        'prunus-x-subhirtella': KeuzelijstWaarde(invulwaarde='prunus-x-subhirtella',
                                                 label='Prunus x subhirtella',
                                                 status='ingebruik',
                                                 objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/prunus-x-subhirtella'),
        'prunus-x-subhirtella-autumnalis': KeuzelijstWaarde(invulwaarde='prunus-x-subhirtella-autumnalis',
                                                            label="Prunus x subhirtella 'Autumnalis'",
                                                            status='ingebruik',
                                                            objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/prunus-x-subhirtella-autumnalis'),
        'prunus-x-subhirtella-autumnalis-rosea': KeuzelijstWaarde(invulwaarde='prunus-x-subhirtella-autumnalis-rosea',
                                                                  label="Prunus x subhirtella 'Autumnalis Rosea'",
                                                                  status='ingebruik',
                                                                  objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/prunus-x-subhirtella-autumnalis-rosea'),
        'prunus-x-subhirtella-fukubana': KeuzelijstWaarde(invulwaarde='prunus-x-subhirtella-fukubana',
                                                          label="Prunus x subhirtella 'Fukubana'",
                                                          status='ingebruik',
                                                          objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/prunus-x-subhirtella-fukubana'),
        'prunus-x-subhirtella-pendula': KeuzelijstWaarde(invulwaarde='prunus-x-subhirtella-pendula',
                                                         label="Prunus x subhirtella 'Pendula'",
                                                         status='ingebruik',
                                                         objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/prunus-x-subhirtella-pendula'),
        'prunus-x-yedoensis': KeuzelijstWaarde(invulwaarde='prunus-x-yedoensis',
                                               label='Prunus x yedoensis',
                                               status='ingebruik',
                                               objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/prunus-x-yedoensis'),
        'prunus-x-yedoensis-shidare-yoshino': KeuzelijstWaarde(invulwaarde='prunus-x-yedoensis-shidare-yoshino',
                                                               label="Prunus x yedoensis 'Shidare Yoshino'",
                                                               status='ingebruik',
                                                               objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/prunus-x-yedoensis-shidare-yoshino'),
        'pterocarya-fraxinifolia': KeuzelijstWaarde(invulwaarde='pterocarya-fraxinifolia',
                                                    label='Pterocarya fraxinifolia',
                                                    status='ingebruik',
                                                    objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/pterocarya-fraxinifolia'),
        'pterocarya-stenoptera': KeuzelijstWaarde(invulwaarde='pterocarya-stenoptera',
                                                  label='Pterocarya stenoptera',
                                                  status='ingebruik',
                                                  definitie='Pterocarya stenoptera',
                                                  objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/pterocarya-stenoptera'),
        'pyrus-calleryana': KeuzelijstWaarde(invulwaarde='pyrus-calleryana',
                                             label='Pyrus calleryana',
                                             status='ingebruik',
                                             objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/pyrus-calleryana'),
        'pyrus-calleryana-chanticleer': KeuzelijstWaarde(invulwaarde='pyrus-calleryana-chanticleer',
                                                         label="Pyrus calleryana 'Chanticleer'",
                                                         status='ingebruik',
                                                         objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/pyrus-calleryana-chanticleer'),
        'pyrus-calleryana-redspire': KeuzelijstWaarde(invulwaarde='pyrus-calleryana-redspire',
                                                      label="Pyrus calleryana 'Redspire'",
                                                      status='ingebruik',
                                                      objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/pyrus-calleryana-redspire'),
        'pyrus-communis': KeuzelijstWaarde(invulwaarde='pyrus-communis',
                                           label='Pyrus communis',
                                           status='ingebruik',
                                           objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/pyrus-communis'),
        'pyrus-communis-(fruit)': KeuzelijstWaarde(invulwaarde='pyrus-communis-(fruit)',
                                                   label='Pyrus communis (fruit)',
                                                   status='ingebruik',
                                                   objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/pyrus-communis-(fruit)'),
        'pyrus-communis-beech-hill': KeuzelijstWaarde(invulwaarde='pyrus-communis-beech-hill',
                                                      label="Pyrus communis 'Beech Hill'",
                                                      status='ingebruik',
                                                      objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/pyrus-communis-beech-hill'),
        'pyrus-communis-louisa-anna': KeuzelijstWaarde(invulwaarde='pyrus-communis-louisa-anna',
                                                       label="Pyrus communis 'Louisa Anna'",
                                                       status='ingebruik',
                                                       objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/pyrus-communis-louisa-anna'),
        'pyrus-communis-subsp.-caucasica': KeuzelijstWaarde(invulwaarde='pyrus-communis-subsp.-caucasica',
                                                            label='Pyrus communis subsp. caucasica',
                                                            status='ingebruik',
                                                            objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/pyrus-communis-subsp.-caucasica'),
        'pyrus-nivalis': KeuzelijstWaarde(invulwaarde='pyrus-nivalis',
                                          label='Pyrus nivalis',
                                          status='ingebruik',
                                          objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/pyrus-nivalis'),
        'pyrus-salicifolia-pendula': KeuzelijstWaarde(invulwaarde='pyrus-salicifolia-pendula',
                                                      label="Pyrus salicifolia 'Pendula'",
                                                      status='ingebruik',
                                                      objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/pyrus-salicifolia-pendula'),
        'quercus-bimundorum-crimson-spire': KeuzelijstWaarde(invulwaarde='quercus-bimundorum-crimson-spire',
                                                             label="Quercus bimundorum 'Crimson Spire'",
                                                             status='ingebruik',
                                                             objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/quercus-bimundorum-crimson-spire'),
        'quercus-cerris': KeuzelijstWaarde(invulwaarde='quercus-cerris',
                                           label='Quercus cerris',
                                           status='ingebruik',
                                           objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/quercus-cerris'),
        'quercus-coccinea-splendens': KeuzelijstWaarde(invulwaarde='quercus-coccinea-splendens',
                                                       label="Quercus coccinea 'Splendens'",
                                                       status='ingebruik',
                                                       objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/quercus-coccinea-splendens'),
        'quercus-frainetto': KeuzelijstWaarde(invulwaarde='quercus-frainetto',
                                              label='Quercus frainetto',
                                              status='ingebruik',
                                              objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/quercus-frainetto'),
        'quercus-ilex': KeuzelijstWaarde(invulwaarde='quercus-ilex',
                                         label='Quercus ilex',
                                         status='ingebruik',
                                         objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/quercus-ilex'),
        'quercus-imbricaria': KeuzelijstWaarde(invulwaarde='quercus-imbricaria',
                                               label='Quercus imbricaria',
                                               status='ingebruik',
                                               objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/quercus-imbricaria'),
        'quercus-macranthera': KeuzelijstWaarde(invulwaarde='quercus-macranthera',
                                                label='Quercus macranthera',
                                                status='ingebruik',
                                                objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/quercus-macranthera'),
        'quercus-palustris': KeuzelijstWaarde(invulwaarde='quercus-palustris',
                                              label='Quercus palustris',
                                              status='ingebruik',
                                              objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/quercus-palustris'),
        'quercus-palustris-green-dwarf': KeuzelijstWaarde(invulwaarde='quercus-palustris-green-dwarf',
                                                          label="Quercus palustris 'Green Dwarf'",
                                                          status='ingebruik',
                                                          objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/quercus-palustris-green-dwarf'),
        'quercus-palustris-green-pillar': KeuzelijstWaarde(invulwaarde='quercus-palustris-green-pillar',
                                                           label="Quercus palustris 'Green Pillar'",
                                                           status='ingebruik',
                                                           objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/quercus-palustris-green-pillar'),
        'quercus-palustris-helmond': KeuzelijstWaarde(invulwaarde='quercus-palustris-helmond',
                                                      label="Quercus palustris 'Helmond'",
                                                      status='ingebruik',
                                                      objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/quercus-palustris-helmond'),
        'quercus-petraea': KeuzelijstWaarde(invulwaarde='quercus-petraea',
                                            label='Quercus petraea',
                                            status='ingebruik',
                                            objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/quercus-petraea'),
        'quercus-phellos': KeuzelijstWaarde(invulwaarde='quercus-phellos',
                                            label='Quercus phellos',
                                            status='ingebruik',
                                            objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/quercus-phellos'),
        'quercus-pontica': KeuzelijstWaarde(invulwaarde='quercus-pontica',
                                            label='Quercus pontica',
                                            status='ingebruik',
                                            objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/quercus-pontica'),
        'quercus-robur': KeuzelijstWaarde(invulwaarde='quercus-robur',
                                          label='Quercus robur',
                                          status='ingebruik',
                                          objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/quercus-robur'),
        'quercus-robur-fastigiata': KeuzelijstWaarde(invulwaarde='quercus-robur-fastigiata',
                                                     label="Quercus robur 'Fastigiata'",
                                                     status='ingebruik',
                                                     objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/quercus-robur-fastigiata'),
        'quercus-robur-fastigiata-koster': KeuzelijstWaarde(invulwaarde='quercus-robur-fastigiata-koster',
                                                            label="Quercus robur 'Fastigiata Koster'",
                                                            status='ingebruik',
                                                            objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/quercus-robur-fastigiata-koster'),
        'quercus-robur-fastigiate-koster': KeuzelijstWaarde(invulwaarde='quercus-robur-fastigiate-koster',
                                                            label="Quercus robur 'Fastigiate Koster'",
                                                            status='ingebruik',
                                                            objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/quercus-robur-fastigiate-koster'),
        'quercus-rubra': KeuzelijstWaarde(invulwaarde='quercus-rubra',
                                          label='Quercus rubra',
                                          status='ingebruik',
                                          objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/quercus-rubra'),
        'quercus-x-hispanica': KeuzelijstWaarde(invulwaarde='quercus-x-hispanica',
                                                label='Quercus x hispanica',
                                                status='ingebruik',
                                                objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/quercus-x-hispanica'),
        'quercus-x-hispanica-wageningen': KeuzelijstWaarde(invulwaarde='quercus-x-hispanica-wageningen',
                                                           label="Quercus x hispanica 'Wageningen'",
                                                           status='ingebruik',
                                                           objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/quercus-x-hispanica-wageningen'),
        'quercus-x-turneri': KeuzelijstWaarde(invulwaarde='quercus-x-turneri',
                                              label='Quercus x turneri',
                                              status='ingebruik',
                                              objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/quercus-x-turneri'),
        'rhus-typhina': KeuzelijstWaarde(invulwaarde='rhus-typhina',
                                         label='Rhus typhina',
                                         status='ingebruik',
                                         objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/rhus-typhina'),
        'robinia-elliottii': KeuzelijstWaarde(invulwaarde='robinia-elliottii',
                                              label='Robinia elliottii',
                                              status='ingebruik',
                                              objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/robinia-elliottii'),
        'robinia-pseudoacacia': KeuzelijstWaarde(invulwaarde='robinia-pseudoacacia',
                                                 label='Robinia pseudoacacia',
                                                 status='ingebruik',
                                                 objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/robinia-pseudoacacia'),
        'robinia-pseudoacacia-bessoniana': KeuzelijstWaarde(invulwaarde='robinia-pseudoacacia-bessoniana',
                                                            label="Robinia pseudoacacia 'Bessoniana'",
                                                            status='ingebruik',
                                                            objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/robinia-pseudoacacia-bessoniana'),
        'robinia-pseudoacacia-frisia': KeuzelijstWaarde(invulwaarde='robinia-pseudoacacia-frisia',
                                                        label="Robinia pseudoacacia 'Frisia'",
                                                        status='ingebruik',
                                                        objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/robinia-pseudoacacia-frisia'),
        'robinia-pseudoacacia-myrtifolia': KeuzelijstWaarde(invulwaarde='robinia-pseudoacacia-myrtifolia',
                                                            label="Robinia pseudoacacia 'Myrtifolia'",
                                                            status='ingebruik',
                                                            objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/robinia-pseudoacacia-myrtifolia'),
        'robinia-pseudoacacia-pyramidalis': KeuzelijstWaarde(invulwaarde='robinia-pseudoacacia-pyramidalis',
                                                             label="Robinia pseudoacacia 'Pyramidalis'",
                                                             status='ingebruik',
                                                             objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/robinia-pseudoacacia-pyramidalis'),
        'robinia-pseudoacacia-sandraudiga': KeuzelijstWaarde(invulwaarde='robinia-pseudoacacia-sandraudiga',
                                                             label="Robinia pseudoacacia 'Sandraudiga'",
                                                             status='ingebruik',
                                                             objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/robinia-pseudoacacia-sandraudiga'),
        'robinia-pseudoacacia-semperflorens': KeuzelijstWaarde(invulwaarde='robinia-pseudoacacia-semperflorens',
                                                               label="Robinia pseudoacacia 'Semperflorens'",
                                                               status='ingebruik',
                                                               objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/robinia-pseudoacacia-semperflorens'),
        'robinia-pseudoacacia-tortuosa': KeuzelijstWaarde(invulwaarde='robinia-pseudoacacia-tortuosa',
                                                          label="Robinia pseudoacacia 'Tortuosa'",
                                                          status='ingebruik',
                                                          objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/robinia-pseudoacacia-tortuosa'),
        'robinia-pseudoacacia-umbraculifera': KeuzelijstWaarde(invulwaarde='robinia-pseudoacacia-umbraculifera',
                                                               label="Robinia pseudoacacia 'Umbraculifera'",
                                                               status='ingebruik',
                                                               objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/robinia-pseudoacacia-umbraculifera'),
        'robinia-pseudoacacia-unifoliola': KeuzelijstWaarde(invulwaarde='robinia-pseudoacacia-unifoliola',
                                                            label="Robinia pseudoacacia 'Unifoliola'",
                                                            status='ingebruik',
                                                            objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/robinia-pseudoacacia-unifoliola'),
        'robinia-x-margaretta-casque-rouge': KeuzelijstWaarde(invulwaarde='robinia-x-margaretta-casque-rouge',
                                                              label="Robinia x margaretta 'Casque Rouge'",
                                                              status='ingebruik',
                                                              objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/robinia-x-margaretta-casque-rouge'),
        'robinia-x-margaretta-pink-cascade': KeuzelijstWaarde(invulwaarde='robinia-x-margaretta-pink-cascade',
                                                              label="Robinia x margaretta 'Pink Cascade'",
                                                              status='ingebruik',
                                                              objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/robinia-x-margaretta-pink-cascade'),
        'salix-acutifolia-pendulifolia': KeuzelijstWaarde(invulwaarde='salix-acutifolia-pendulifolia',
                                                          label="Salix acutifolia 'Pendulifolia'",
                                                          status='ingebruik',
                                                          objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/salix-acutifolia-pendulifolia'),
        'salix-alba': KeuzelijstWaarde(invulwaarde='salix-alba',
                                       label='Salix alba',
                                       status='ingebruik',
                                       objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/salix-alba'),
        'salix-alba-belders': KeuzelijstWaarde(invulwaarde='salix-alba-belders',
                                               label="Salix alba 'Belders'",
                                               status='ingebruik',
                                               objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/salix-alba-belders'),
        'salix-alba-chermesina': KeuzelijstWaarde(invulwaarde='salix-alba-chermesina',
                                                  label="Salix alba 'Chermesina'",
                                                  status='ingebruik',
                                                  objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/salix-alba-chermesina'),
        'salix-alba-liempde': KeuzelijstWaarde(invulwaarde='salix-alba-liempde',
                                               label="Salix alba 'Liempde'",
                                               status='ingebruik',
                                               objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/salix-alba-liempde'),
        'salix-babylonica-sp': KeuzelijstWaarde(invulwaarde='salix-babylonica-sp',
                                                label='Salix babylonica sp.',
                                                status='ingebruik',
                                                definitie='Salix babylonica sp.',
                                                objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/salix-babylonica-sp'),
        'salix-babylonica-tortuosa': KeuzelijstWaarde(invulwaarde='salix-babylonica-tortuosa',
                                                      label="Salix babylonica 'Tortuosa'",
                                                      status='ingebruik',
                                                      objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/salix-babylonica-tortuosa'),
        'salix-babylonica-umbraculifera': KeuzelijstWaarde(invulwaarde='salix-babylonica-umbraculifera',
                                                           label="Salix babylonica 'Umbraculifera'",
                                                           status='ingebruik',
                                                           objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/salix-babylonica-umbraculifera'),
        'salix-caprea': KeuzelijstWaarde(invulwaarde='salix-caprea',
                                         label='Salix caprea',
                                         status='ingebruik',
                                         objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/salix-caprea'),
        'salix-caprea-kilmarnock': KeuzelijstWaarde(invulwaarde='salix-caprea-kilmarnock',
                                                    label="Salix caprea 'Kilmarnock'",
                                                    status='ingebruik',
                                                    objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/salix-caprea-kilmarnock'),
        'salix-pentandra': KeuzelijstWaarde(invulwaarde='salix-pentandra',
                                            label='Salix pentandra',
                                            status='ingebruik',
                                            objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/salix-pentandra'),
        'salix-sepulcralis-chrysocoma': KeuzelijstWaarde(invulwaarde='salix-sepulcralis-chrysocoma',
                                                         label="Salix sepulcralis 'Chrysocoma'",
                                                         status='ingebruik',
                                                         objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/salix-sepulcralis-chrysocoma'),
        'salix-sp': KeuzelijstWaarde(invulwaarde='salix-sp',
                                     label='Salix sp.',
                                     status='ingebruik',
                                     definitie='Salix sp.',
                                     objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/salix-sp'),
        'salix-viminalis': KeuzelijstWaarde(invulwaarde='salix-viminalis',
                                            label='Salix viminalis',
                                            status='ingebruik',
                                            objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/salix-viminalis'),
        'sambucus-nigra': KeuzelijstWaarde(invulwaarde='sambucus-nigra',
                                           label='Sambucus nigra',
                                           status='ingebruik',
                                           objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/sambucus-nigra'),
        'sophora-japonica': KeuzelijstWaarde(invulwaarde='sophora-japonica',
                                             label='Sophora japonica',
                                             status='ingebruik',
                                             objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/sophora-japonica'),
        'sorbus-aria': KeuzelijstWaarde(invulwaarde='sorbus-aria',
                                        label='Sorbus aria',
                                        status='ingebruik',
                                        objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/sorbus-aria'),
        'sorbus-aria-lutescens': KeuzelijstWaarde(invulwaarde='sorbus-aria-lutescens',
                                                  label="Sorbus aria 'Lutescens'",
                                                  status='ingebruik',
                                                  objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/sorbus-aria-lutescens'),
        'sorbus-aria-magnifica': KeuzelijstWaarde(invulwaarde='sorbus-aria-magnifica',
                                                  label="Sorbus aria 'Magnifica'",
                                                  status='ingebruik',
                                                  objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/sorbus-aria-magnifica'),
        'sorbus-aria-majestica': KeuzelijstWaarde(invulwaarde='sorbus-aria-majestica',
                                                  label="Sorbus aria 'Majestica'",
                                                  status='ingebruik',
                                                  objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/sorbus-aria-majestica'),
        'sorbus-aucuparia': KeuzelijstWaarde(invulwaarde='sorbus-aucuparia',
                                             label='Sorbus aucuparia',
                                             status='ingebruik',
                                             objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/sorbus-aucuparia'),
        'sorbus-aucuparia-asplenifolia': KeuzelijstWaarde(invulwaarde='sorbus-aucuparia-asplenifolia',
                                                          label="Sorbus aucuparia 'Asplenifolia'",
                                                          status='ingebruik',
                                                          objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/sorbus-aucuparia-asplenifolia'),
        'sorbus-aucuparia-edulis': KeuzelijstWaarde(invulwaarde='sorbus-aucuparia-edulis',
                                                    label="Sorbus aucuparia 'Edulis'",
                                                    status='ingebruik',
                                                    objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/sorbus-aucuparia-edulis'),
        'sorbus-aucuparia-rossica-major': KeuzelijstWaarde(invulwaarde='sorbus-aucuparia-rossica-major',
                                                           label="Sorbus aucuparia 'Rossica Major'",
                                                           status='ingebruik',
                                                           objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/sorbus-aucuparia-rossica-major'),
        'sorbus-aucuparia-sheerwater-seedling': KeuzelijstWaarde(invulwaarde='sorbus-aucuparia-sheerwater-seedling',
                                                                 label="Sorbus aucuparia 'Sheerwater Seedling'",
                                                                 status='ingebruik',
                                                                 objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/sorbus-aucuparia-sheerwater-seedling'),
        'sorbus-aucuparia-var.-edulis': KeuzelijstWaarde(invulwaarde='sorbus-aucuparia-var.-edulis',
                                                         label='Sorbus aucuparia var. edulis',
                                                         status='ingebruik',
                                                         objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/sorbus-aucuparia-var.-edulis'),
        'sorbus-aucuparia-wettra': KeuzelijstWaarde(invulwaarde='sorbus-aucuparia-wettra',
                                                    label="Sorbus aucuparia 'Wettra'",
                                                    status='ingebruik',
                                                    objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/sorbus-aucuparia-wettra'),
        'sorbus-aucuparia-xanthocarpa': KeuzelijstWaarde(invulwaarde='sorbus-aucuparia-xanthocarpa',
                                                         label="Sorbus aucuparia 'Xanthocarpa'",
                                                         status='ingebruik',
                                                         objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/sorbus-aucuparia-xanthocarpa'),
        'sorbus-commixta': KeuzelijstWaarde(invulwaarde='sorbus-commixta',
                                            label='Sorbus commixta',
                                            status='ingebruik',
                                            objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/sorbus-commixta'),
        'sorbus-commixta-belmonte': KeuzelijstWaarde(invulwaarde='sorbus-commixta-belmonte',
                                                     label="Sorbus commixta 'Belmonte'",
                                                     status='ingebruik',
                                                     objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/sorbus-commixta-belmonte'),
        'sorbus-decora': KeuzelijstWaarde(invulwaarde='sorbus-decora',
                                          label='Sorbus decora',
                                          status='ingebruik',
                                          objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/sorbus-decora'),
        'sorbus-intermedia': KeuzelijstWaarde(invulwaarde='sorbus-intermedia',
                                              label='Sorbus intermedia',
                                              status='ingebruik',
                                              objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/sorbus-intermedia'),
        'sorbus-intermedia-brouwers': KeuzelijstWaarde(invulwaarde='sorbus-intermedia-brouwers',
                                                       label="Sorbus intermedia 'Brouwers'",
                                                       status='ingebruik',
                                                       objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/sorbus-intermedia-brouwers'),
        'sorbus-latifolia': KeuzelijstWaarde(invulwaarde='sorbus-latifolia',
                                             label='Sorbus latifolia',
                                             status='ingebruik',
                                             objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/sorbus-latifolia'),
        'sorbus-latifolia-henk-vink': KeuzelijstWaarde(invulwaarde='sorbus-latifolia-henk-vink',
                                                       label="Sorbus latifolia 'Henk Vink'",
                                                       status='ingebruik',
                                                       objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/sorbus-latifolia-henk-vink'),
        'sorbus-torminalis': KeuzelijstWaarde(invulwaarde='sorbus-torminalis',
                                              label='Sorbus torminalis',
                                              status='ingebruik',
                                              objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/sorbus-torminalis'),
        'sorbus-x-arnoldiana-apricot-queen': KeuzelijstWaarde(invulwaarde='sorbus-x-arnoldiana-apricot-queen',
                                                              label="Sorbus x arnoldiana 'Apricot Queen'",
                                                              status='ingebruik',
                                                              objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/sorbus-x-arnoldiana-apricot-queen'),
        'sorbus-x-arnoldiana-golden-wonder': KeuzelijstWaarde(invulwaarde='sorbus-x-arnoldiana-golden-wonder',
                                                              label="Sorbus x arnoldiana 'Golden Wonder'",
                                                              status='ingebruik',
                                                              objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/sorbus-x-arnoldiana-golden-wonder'),
        'sorbus-x-arnoldiana-kirsten-pink': KeuzelijstWaarde(invulwaarde='sorbus-x-arnoldiana-kirsten-pink',
                                                             label="Sorbus x arnoldiana 'Kirsten Pink'",
                                                             status='ingebruik',
                                                             objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/sorbus-x-arnoldiana-kirsten-pink'),
        'sorbus-x-arnoldiana-maidens-blush': KeuzelijstWaarde(invulwaarde='sorbus-x-arnoldiana-maidens-blush',
                                                              label="Sorbus x arnoldiana 'Maiden's Blush'",
                                                              status='ingebruik',
                                                              objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/sorbus-x-arnoldiana-maidens-blush'),
        'sorbus-x-arnoldiana-orange-parade': KeuzelijstWaarde(invulwaarde='sorbus-x-arnoldiana-orange-parade',
                                                              label="Sorbus x arnoldiana 'Orange Parade'",
                                                              status='ingebruik',
                                                              objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/sorbus-x-arnoldiana-orange-parade'),
        'sorbus-x-arnoldiana-white-wax': KeuzelijstWaarde(invulwaarde='sorbus-x-arnoldiana-white-wax',
                                                          label="Sorbus x arnoldiana 'White Wax'",
                                                          status='ingebruik',
                                                          objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/sorbus-x-arnoldiana-white-wax'),
        'sorbus-x-thuringiaca-fastigiata': KeuzelijstWaarde(invulwaarde='sorbus-x-thuringiaca-fastigiata',
                                                            label="Sorbus x thuringiaca 'Fastigiata'",
                                                            status='ingebruik',
                                                            objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/sorbus-x-thuringiaca-fastigiata'),
        'styphnolobium-japonicum': KeuzelijstWaarde(invulwaarde='styphnolobium-japonicum',
                                                    label='Styphnolobium japonicum',
                                                    status='ingebruik',
                                                    objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/styphnolobium-japonicum'),
        'styphnolobium-japonicum-pendula': KeuzelijstWaarde(invulwaarde='styphnolobium-japonicum-pendula',
                                                            label="Styphnolobium japonicum 'Pendula'",
                                                            status='ingebruik',
                                                            objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/styphnolobium-japonicum-pendula'),
        'styphnolobium-japonicum-regent': KeuzelijstWaarde(invulwaarde='styphnolobium-japonicum-regent',
                                                           label="Styphnolobium japonicum 'Regent'",
                                                           status='ingebruik',
                                                           objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/styphnolobium-japonicum-regent'),
        'tamarix': KeuzelijstWaarde(invulwaarde='tamarix',
                                    label='Tamarix',
                                    status='ingebruik',
                                    objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/tamarix'),
        'tamarix-tetrandra': KeuzelijstWaarde(invulwaarde='tamarix-tetrandra',
                                              label='Tamarix tetrandra',
                                              status='ingebruik',
                                              objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/tamarix-tetrandra'),
        'taxodium-distichum': KeuzelijstWaarde(invulwaarde='taxodium-distichum',
                                               label='Taxodium distichum',
                                               status='ingebruik',
                                               objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/taxodium-distichum'),
        'taxus-baccata': KeuzelijstWaarde(invulwaarde='taxus-baccata',
                                          label='Taxus baccata',
                                          status='ingebruik',
                                          objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/taxus-baccata'),
        'thuja-plicata-aurea': KeuzelijstWaarde(invulwaarde='thuja-plicata-aurea',
                                                label='Thuja plicata aurea',
                                                status='ingebruik',
                                                objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/thuja-plicata-aurea'),
        'tilia': KeuzelijstWaarde(invulwaarde='tilia',
                                  label='Tilia',
                                  status='ingebruik',
                                  objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/tilia'),
        'tilia-americana': KeuzelijstWaarde(invulwaarde='tilia-americana',
                                            label='Tilia americana',
                                            status='ingebruik',
                                            objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/tilia-americana'),
        'tilia-americana-nova': KeuzelijstWaarde(invulwaarde='tilia-americana-nova',
                                                 label="Tilia americana 'Nova'",
                                                 status='ingebruik',
                                                 objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/tilia-americana-nova'),
        'tilia-cordata': KeuzelijstWaarde(invulwaarde='tilia-cordata',
                                          label='Tilia cordata',
                                          status='ingebruik',
                                          objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/tilia-cordata'),
        'tilia-cordata-bohlje': KeuzelijstWaarde(invulwaarde='tilia-cordata-bohlje',
                                                 label="Tilia cordata 'Böhlje'",
                                                 status='ingebruik',
                                                 objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/tilia-cordata-bohlje'),
        'tilia-cordata-erecta': KeuzelijstWaarde(invulwaarde='tilia-cordata-erecta',
                                                 label="Tilia cordata 'Erecta'",
                                                 status='ingebruik',
                                                 objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/tilia-cordata-erecta'),
        'tilia-cordata-green-globe': KeuzelijstWaarde(invulwaarde='tilia-cordata-green-globe',
                                                      label="Tilia cordata 'Green Globe'",
                                                      status='ingebruik',
                                                      objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/tilia-cordata-green-globe'),
        'tilia-cordata-greenspire': KeuzelijstWaarde(invulwaarde='tilia-cordata-greenspire',
                                                     label="Tilia cordata 'Greenspire'",
                                                     status='ingebruik',
                                                     objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/tilia-cordata-greenspire'),
        'tilia-cordata-rancho': KeuzelijstWaarde(invulwaarde='tilia-cordata-rancho',
                                                 label="Tilia cordata 'Rancho'",
                                                 status='ingebruik',
                                                 objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/tilia-cordata-rancho'),
        'tilia-cordata-roelvo': KeuzelijstWaarde(invulwaarde='tilia-cordata-roelvo',
                                                 label="Tilia cordata 'Roelvo'",
                                                 status='ingebruik',
                                                 objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/tilia-cordata-roelvo'),
        'tilia-europaea': KeuzelijstWaarde(invulwaarde='tilia-europaea',
                                           label='Tilia europaea',
                                           status='ingebruik',
                                           objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/tilia-europaea'),
        'tilia-flavescens-x-glenleven': KeuzelijstWaarde(invulwaarde='tilia-flavescens-x-glenleven',
                                                         label="Tilia flavescens x 'Glenleven'",
                                                         status='ingebruik',
                                                         objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/tilia-flavescens-x-glenleven'),
        'tilia-mongolica': KeuzelijstWaarde(invulwaarde='tilia-mongolica',
                                            label='Tilia mongolica',
                                            status='ingebruik',
                                            objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/tilia-mongolica'),
        'tilia-mongolica-buda': KeuzelijstWaarde(invulwaarde='tilia-mongolica-buda',
                                                 label="Tilia mongolica 'Buda'",
                                                 status='ingebruik',
                                                 objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/tilia-mongolica-buda'),
        'tilia-platyphyllos': KeuzelijstWaarde(invulwaarde='tilia-platyphyllos',
                                               label='Tilia platyphyllos',
                                               status='ingebruik',
                                               objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/tilia-platyphyllos'),
        'tilia-platyphyllos-delft': KeuzelijstWaarde(invulwaarde='tilia-platyphyllos-delft',
                                                     label="Tilia platyphyllos 'Delft'",
                                                     status='ingebruik',
                                                     objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/tilia-platyphyllos-delft'),
        'tilia-platyphyllos-fastigiata': KeuzelijstWaarde(invulwaarde='tilia-platyphyllos-fastigiata',
                                                          label="Tilia platyphyllos 'Fastigiata'",
                                                          status='ingebruik',
                                                          objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/tilia-platyphyllos-fastigiata'),
        'tilia-platyphyllos-pannonia': KeuzelijstWaarde(invulwaarde='tilia-platyphyllos-pannonia',
                                                        label="Tilia platyphyllos 'Pannonia'",
                                                        status='ingebruik',
                                                        objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/tilia-platyphyllos-pannonia'),
        'tilia-platyphyllos-rubra': KeuzelijstWaarde(invulwaarde='tilia-platyphyllos-rubra',
                                                     label="Tilia platyphyllos 'Rubra'",
                                                     status='ingebruik',
                                                     objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/tilia-platyphyllos-rubra'),
        'tilia-tomentosa': KeuzelijstWaarde(invulwaarde='tilia-tomentosa',
                                            label='Tilia tomentosa',
                                            status='ingebruik',
                                            objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/tilia-tomentosa'),
        'tilia-tomentosa-brabant': KeuzelijstWaarde(invulwaarde='tilia-tomentosa-brabant',
                                                    label="Tilia tomentosa 'Brabant'",
                                                    status='ingebruik',
                                                    objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/tilia-tomentosa-brabant'),
        'tilia-tomentosa-doornik': KeuzelijstWaarde(invulwaarde='tilia-tomentosa-doornik',
                                                    label="Tilia tomentosa 'Doornik'",
                                                    status='ingebruik',
                                                    objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/tilia-tomentosa-doornik'),
        'tilia-tomentosa-hungary-globe': KeuzelijstWaarde(invulwaarde='tilia-tomentosa-hungary-globe',
                                                          label="Tilia tomentosa 'Hungary Globe'",
                                                          status='ingebruik',
                                                          objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/tilia-tomentosa-hungary-globe'),
        'tilia-tomentosa-pendula': KeuzelijstWaarde(invulwaarde='tilia-tomentosa-pendula',
                                                    label="Tilia tomentosa 'Pendula'",
                                                    status='ingebruik',
                                                    objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/tilia-tomentosa-pendula'),
        'tilia-x-europaea': KeuzelijstWaarde(invulwaarde='tilia-x-europaea',
                                             label='Tilia x europaea',
                                             status='ingebruik',
                                             objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/tilia-x-europaea'),
        'tilia-x-europaea-euchlora': KeuzelijstWaarde(invulwaarde='tilia-x-europaea-euchlora',
                                                      label="Tilia x europaea 'Euchlora'",
                                                      status='ingebruik',
                                                      objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/tilia-x-europaea-euchlora'),
        'tilia-x-europaea-pallida': KeuzelijstWaarde(invulwaarde='tilia-x-europaea-pallida',
                                                     label="Tilia x europaea 'Pallida'",
                                                     status='ingebruik',
                                                     objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/tilia-x-europaea-pallida'),
        'tilia-x-flavescens-glenleven': KeuzelijstWaarde(invulwaarde='tilia-x-flavescens-glenleven',
                                                         label="Tilia x flavescens 'Glenleven'",
                                                         status='ingebruik',
                                                         objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/tilia-x-flavescens-glenleven'),
        'ulmus-camperdownii': KeuzelijstWaarde(invulwaarde='ulmus-camperdownii',
                                               label="Ulmus 'Camperdownii'",
                                               status='ingebruik',
                                               objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/ulmus-camperdownii'),
        'ulmus-columella': KeuzelijstWaarde(invulwaarde='ulmus-columella',
                                            label="Ulmus 'Columella'",
                                            status='ingebruik',
                                            objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/ulmus-columella'),
        'ulmus-dodoens': KeuzelijstWaarde(invulwaarde='ulmus-dodoens',
                                          label="Ulmus 'Dodoens'",
                                          status='ingebruik',
                                          objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/ulmus-dodoens'),
        'ulmus-glabra': KeuzelijstWaarde(invulwaarde='ulmus-glabra',
                                         label='Ulmus glabra',
                                         status='ingebruik',
                                         objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/ulmus-glabra'),
        'ulmus-glabra-lutescens': KeuzelijstWaarde(invulwaarde='ulmus-glabra-lutescens',
                                                   label="Ulmus glabra 'Lutescens'",
                                                   status='ingebruik',
                                                   objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/ulmus-glabra-lutescens'),
        'ulmus-laevis': KeuzelijstWaarde(invulwaarde='ulmus-laevis',
                                         label='Ulmus laevis',
                                         status='ingebruik',
                                         objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/ulmus-laevis'),
        'ulmus-lobel': KeuzelijstWaarde(invulwaarde='ulmus-lobel',
                                        label="Ulmus 'Lobel'",
                                        status='ingebruik',
                                        objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/ulmus-lobel'),
        'ulmus-lutece': KeuzelijstWaarde(invulwaarde='ulmus-lutece',
                                         label='Ulmus lutece',
                                         status='ingebruik',
                                         definitie='Ulmus lutece',
                                         objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/ulmus-lutece'),
        'ulmus-minor': KeuzelijstWaarde(invulwaarde='ulmus-minor',
                                        label='Ulmus minor',
                                        status='ingebruik',
                                        objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/ulmus-minor'),
        'ulmus-minor-sarniensis': KeuzelijstWaarde(invulwaarde='ulmus-minor-sarniensis',
                                                   label="Ulmus minor 'Sarniensis'",
                                                   status='ingebruik',
                                                   objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/ulmus-minor-sarniensis'),
        'ulmus-minor-vada': KeuzelijstWaarde(invulwaarde='ulmus-minor-vada',
                                             label="Ulmus minor 'Vada'",
                                             status='ingebruik',
                                             objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/ulmus-minor-vada'),
        'ulmus-minor-var.-vulgaris': KeuzelijstWaarde(invulwaarde='ulmus-minor-var.-vulgaris',
                                                      label='Ulmus minor var. vulgaris',
                                                      status='ingebruik',
                                                      objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/ulmus-minor-var.-vulgaris'),
        'ulmus-nanguen': KeuzelijstWaarde(invulwaarde='ulmus-nanguen',
                                          label="Ulmus 'Nanguen'",
                                          status='ingebruik',
                                          objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/ulmus-nanguen'),
        'ulmus-plantijn': KeuzelijstWaarde(invulwaarde='ulmus-plantijn',
                                           label="Ulmus 'Plantijn'",
                                           status='ingebruik',
                                           objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/ulmus-plantijn'),
        'ulmus-rebella-sp': KeuzelijstWaarde(invulwaarde='ulmus-rebella-sp',
                                             label='Ulmus rebella sp.',
                                             status='ingebruik',
                                             definitie='Ulmus rebella sp.',
                                             objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/ulmus-rebella-sp'),
        'ulmus-rebona-sp': KeuzelijstWaarde(invulwaarde='ulmus-rebona-sp',
                                            label='Ulmus rebona sp.',
                                            status='ingebruik',
                                            definitie='Ulmus rebona sp.',
                                            objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/ulmus-rebona-sp'),
        'ulmus-resista-fiorente': KeuzelijstWaarde(invulwaarde='ulmus-resista-fiorente',
                                                   label="Ulmus resista 'Fiorente'",
                                                   status='ingebruik',
                                                   objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/ulmus-resista-fiorente'),
        'ulmus-resista-new-horizon': KeuzelijstWaarde(invulwaarde='ulmus-resista-new-horizon',
                                                      label="Ulmus resista 'New Horizon'",
                                                      status='ingebruik',
                                                      objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/ulmus-resista-new-horizon'),
        'ulmus-resista-rebella': KeuzelijstWaarde(invulwaarde='ulmus-resista-rebella',
                                                  label="Ulmus resista 'Rebella",
                                                  status='ingebruik',
                                                  objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/ulmus-resista-rebella'),
        'ulmus-resista-rebona': KeuzelijstWaarde(invulwaarde='ulmus-resista-rebona',
                                                 label="Ulmus resista 'Rebona'",
                                                 status='ingebruik',
                                                 objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/ulmus-resista-rebona'),
        'ulmus-sapporo-autumn-gold': KeuzelijstWaarde(invulwaarde='ulmus-sapporo-autumn-gold',
                                                      label="Ulmus 'Sapporo Autumn Gold'",
                                                      status='ingebruik',
                                                      objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/ulmus-sapporo-autumn-gold'),
        'ulmus-sp.': KeuzelijstWaarde(invulwaarde='ulmus-sp.',
                                      label='Ulmus sp.',
                                      status='ingebruik',
                                      objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/ulmus-sp.'),
        'ulmus-x-hollandica': KeuzelijstWaarde(invulwaarde='ulmus-x-hollandica',
                                               label='Ulmus x hollandica',
                                               status='ingebruik',
                                               objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/ulmus-x-hollandica'),
        'ulmus-x-hollandica-commelin': KeuzelijstWaarde(invulwaarde='ulmus-x-hollandica-commelin',
                                                        label="Ulmus x hollandica 'Commelin'",
                                                        status='ingebruik',
                                                        objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/ulmus-x-hollandica-commelin'),
        'ulmus-x-hollandica-groeneveld': KeuzelijstWaarde(invulwaarde='ulmus-x-hollandica-groeneveld',
                                                          label="Ulmus x hollandica 'Groeneveld'",
                                                          status='ingebruik',
                                                          objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/ulmus-x-hollandica-groeneveld'),
        'ulmus-x-hollandica-vegata': KeuzelijstWaarde(invulwaarde='ulmus-x-hollandica-vegata',
                                                      label="Ulmus x hollandica 'Vegata'",
                                                      status='ingebruik',
                                                      objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/ulmus-x-hollandica-vegata'),
        'ulmus-x-hollandica-wredei': KeuzelijstWaarde(invulwaarde='ulmus-x-hollandica-wredei',
                                                      label="Ulmus x hollandica 'Wredei'",
                                                      status='ingebruik',
                                                      objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/ulmus-x-hollandica-wredei'),
        'zelkova-carpinifolia': KeuzelijstWaarde(invulwaarde='zelkova-carpinifolia',
                                                 label='Zelkova carpinifolia',
                                                 status='ingebruik',
                                                 objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/zelkova-carpinifolia'),
        'zelkova-serrata': KeuzelijstWaarde(invulwaarde='zelkova-serrata',
                                            label='Zelkova serrata',
                                            status='ingebruik',
                                            objectUri='https://wegenenverkeer.data.vlaanderen.be/id/concept/KlWetenschappelijkeSoortnaam/zelkova-serrata')
    }

    @classmethod
    def create_dummy_data(cls):
        return cls.create_dummy_data_keuzelijst(cls.options)

