#!/usr/bin/env ts-node

import * as cdk from 'aws-cdk-lib';
import { Construct } from 'constructs';
import { AmplifyApp } from '../../lib/amplify';

class TestAmplifyStack extends cdk.Stack {
  constructor(scope: Construct, id: string, props?: cdk.StackProps) {
    super(scope, id, props);

    // This is your exact use case
    new AmplifyApp(this, 'Amplify', {
      appName: 'must-cdk',
      repository: 'https://github.com/globalmsq/must-cdk'
    });
  }
}

// Test the construct
const app = new cdk.App();
new TestAmplifyStack(app, "TestAmplifyStack");

console.log("🎯 Testing Amplify construct with your configuration...");
console.log("📋 CloudFormation template preview:");

// Synthesize and show template
const assembly = app.synth();
const template = assembly.getStackByName("TestAmplifyStack").template;
console.log(JSON.stringify(template, null, 2));
