import * as cdk from 'aws-cdk-lib';
import { CloudFrontToOrigins } from 'must-cdk';

export class CloudFrontApiStack extends cdk.Stack {
  constructor(scope: cdk.App, id: string, props?: cdk.StackProps) {
    super(scope, id, props);

    new CloudFrontToOrigins(this, 'ApiDistribution', {
      originConfigs: [
        {
          originPath: '/api',
          originDomain: 'api.example.com',
          allowedMethods: ['GET', 'POST', 'PUT', 'DELETE', 'HEAD', 'OPTIONS', 'PATCH'],
          cachePolicyName: 'ApiCachePolicy',
          originRequestPolicyName: 'ApiOriginPolicy',
          responseHeadersPolicyName: 'ApiHeadersPolicy',
        },
        {
          originPath: '/static',
          originDomain: 'static.example.com',
          allowedMethods: ['GET', 'HEAD'],
          cachePolicyName: 'StaticCachePolicy',
        },
      ],
      customDomainName: 'cdn.example.com',
      certificateArn: 'arn:aws:acm:us-east-1:123456789012:certificate/xxx',
      webAclId: 'arn:aws:wafv2:us-east-1:123456789012:global/webacl/xxx',
      priceClass: 'PRICE_CLASS_200',
      enableLogging: true,
      logBucket: 'logs-bucket',
      logFilePrefix: 'cdn-logs/',
    });
  }
}

const app = new cdk.App();
new CloudFrontApiStack(app, 'CloudFrontApiStack', {
  env: {
    account: process.env.CDK_DEFAULT_ACCOUNT,
    region: 'ap-northeast-2',
  },
});
