#!/usr/bin/env node
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.main = main;
const fs = require("fs");
const path = require("path");
const commander_1 = require("commander");
const amplify_1 = require("./commands/amplify");
/**
 * Get the version from package.json
 */
function getVersion() {
    try {
        // First try relative to current directory (development mode)
        const packageJsonPath = path.resolve(__dirname, "../../package.json");
        if (fs.existsSync(packageJsonPath)) {
            const packageJson = JSON.parse(fs.readFileSync(packageJsonPath, "utf8"));
            return packageJson.version;
        }
    }
    catch (error) {
        // Ignore error and try next approach
    }
    try {
        // Fallback: try to resolve the package.json of must-cdk (installed mode)
        const packageJsonPath = require.resolve("must-cdk/package.json");
        const packageJson = JSON.parse(fs.readFileSync(packageJsonPath, "utf8"));
        return packageJson.version;
    }
    catch (error) {
        // Last resort fallback
        return "0.0.0";
    }
}
/**
 * Main CLI entry point for must-cdk
 */
function main() {
    const program = new commander_1.Command();
    program
        .name("must-cdk")
        .description("A CLI tool for AWS CDK constructs that implement common architectural patterns and best practices")
        .version(getVersion());
    // Add the amplify command
    program.addCommand(amplify_1.amplifyCommand);
    // Parse command line arguments
    program.parse();
}
// If this file is run directly, execute the main function
if (require.main === module) {
    main();
}
//# sourceMappingURL=data:application/json;base64,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