import * as acm from "aws-cdk-lib/aws-certificatemanager";
import * as cloudfront from "aws-cdk-lib/aws-cloudfront";
import * as origins from "aws-cdk-lib/aws-cloudfront-origins";
import * as route53 from "aws-cdk-lib/aws-route53";
import * as s3 from "aws-cdk-lib/aws-s3";
import { Construct } from "constructs";
import { CloudFrontToOriginsProps, S3OriginInfo, HttpOriginInfo } from "./interface";
export declare class CloudFrontToOrigins extends Construct {
    readonly distribution: cloudfront.Distribution;
    readonly logBucket?: s3.IBucket;
    readonly certificate?: acm.ICertificate;
    readonly aRecords: route53.ARecord[];
    readonly domainNames?: string[];
    private readonly s3BucketsMap;
    private readonly httpOriginsMap;
    private readonly s3OriginsMap;
    constructor(scope: Construct, id: string, props: CloudFrontToOriginsProps);
    /**
     * Get all domain names (primary + additional)
     */
    private getAllDomainNames;
    /**
     * Apply intelligent defaults based on origin configuration
     */
    private applyDefaults;
    /**
     * Setup S3 origin using Origin Access Identity (OAI)
     */
    private setupS3Origin;
    /**
     * Setup HTTP origin
     */
    private setupHttpOrigin;
    /**
     * Setup custom domain and certificate
     */
    private setupCustomDomain;
    /**
     * Create certificate in us-east-1 for CloudFront
     */
    private createCrossRegionCertificate;
    /**
     * Setup CloudFront logging
     */
    private setupLogging;
    /**
     * Get origin by ID
     */
    private getOriginById;
    /**
     * Determine default origin ID
     */
    private getDefaultOriginId;
    /**
     * Create CloudFront distribution
     */
    private createDistribution;
    /**
     * Setup Route53 alias records for all domains
     */
    private setupRoute53Records;
    /**
     * Get S3 bucket by origin ID
     */
    getS3Bucket(originId: string): s3.IBucket | undefined;
    /**
     * Get HTTP origin by origin ID
     */
    getHttpOrigin(originId: string): origins.HttpOrigin | undefined;
    /**
     * Get all S3 bucket origin IDs
     */
    get s3OriginIds(): string[];
    /**
     * Get all HTTP origin IDs
     */
    get httpOriginIds(): string[];
    /**
     * Get all S3 buckets as an array of objects with ID and bucket
     */
    get s3Origins(): S3OriginInfo[];
    /**
     * Get all HTTP origins as an array of objects with ID and origin
     */
    get httpOrigins(): HttpOriginInfo[];
    /**
     * Get the CloudFront distribution domain name
     */
    get distributionDomainName(): string;
    /**
     * Get the CloudFront distribution URL with protocol
     */
    get distributionUrl(): string;
    /**
     * Get the custom domain URL (if configured)
     */
    get customDomainUrl(): string | undefined;
}
