"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.EcsCodeDeploy = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const constructs_1 = require("constructs");
const ecs_components_1 = require("./ecs-components");
const tags_1 = require("../common/tags");
/**
 * A CDK construct that creates an ECS Fargate service with CodeDeploy blue-green deployment capability.
 * This construct provides a modular approach to deploy containerized applications with blue-green deployment.
 */
class EcsCodeDeploy extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        // Apply tags to the construct
        (0, tags_1.applyTags)(this, props.tags);
        // Determine the target port from container port mappings
        const targetPort = props.targetPort ??
            props.containers[0]?.options.portMappings?.[0]?.containerPort ??
            8080;
        // 1. Create the ECS Service resources (service, task definition, containers)
        this._serviceBuilder = new ecs_components_1.EcsServiceComponent(this, "EcsService", {
            vpc: props.vpc,
            cluster: props.cluster,
            serviceName: props.serviceName,
            containers: props.containers,
            taskDefinitionConfig: props.taskDefinition,
            serviceConfig: props.service,
            securityGroups: props.securityGroups,
            subnets: props.taskSubnets,
            tags: props.tags,
            targetPort: targetPort,
        });
        // 2. Create the Application Load Balancer resources (ALB, listeners, target groups)
        this._albBuilder = new ecs_components_1.LoadBalancerComponent(this, "LoadBalancer", {
            vpc: props.vpc,
            serviceName: props.serviceName,
            service: this._serviceBuilder.service,
            targetPort: targetPort,
            loadBalancerConfig: props.loadBalancer,
            listenerConfigs: {
                production: props.productionListener,
                test: props.testListener,
            },
            targetGroupConfigs: {
                production: props.productionTargetGroup,
                test: props.testTargetGroup,
            },
            subnets: props.loadBalancerSubnets ?? props.taskSubnets,
            tags: props.tags,
        });
        // 3. Create the CodeDeploy resources (application, deployment group)
        this._deploymentBuilder = new ecs_components_1.CodeDeployComponent(this, "CodeDeploy", {
            appName: props.serviceName,
            service: this._serviceBuilder.service,
            productionListener: this._albBuilder.productionListener,
            testListener: this._albBuilder.testListener,
            productionTargetGroup: this._albBuilder.productionTargetGroup,
            testTargetGroup: this._albBuilder.testTargetGroup,
            applicationConfig: props.codeDeployApplication,
            deploymentGroupConfig: props.deploymentGroup,
            tags: props.tags,
        });
        // Expose the actual AWS resources as public properties for direct use
        this.service = this._serviceBuilder.service;
        this.loadBalancer = this._albBuilder.loadBalancer;
        this.taskDefinition = this._serviceBuilder.taskDef;
        this.productionTargetGroup = this._albBuilder.productionTargetGroup;
        this.testTargetGroup = this._albBuilder.testTargetGroup;
        this.application = this._deploymentBuilder.application;
        this.containers = this._serviceBuilder.containers;
    }
    /**
     * Get the production listener
     */
    get productionListener() {
        return this._albBuilder.productionListener;
    }
    /**
     * Get the test listener
     */
    get testListener() {
        return this._albBuilder.testListener;
    }
    /**
     * Get all listeners from the load balancer
     */
    get listeners() {
        return this.loadBalancer.listeners;
    }
    /**
     * Get the load balancer DNS name
     */
    get loadBalancerDnsName() {
        return this.loadBalancer.loadBalancerDnsName;
    }
    /**
     * Get the service ARN
     */
    get serviceArn() {
        return this.service.serviceArn;
    }
    // For backward compatibility with tests
    blueListener() {
        return this.productionListener;
    }
    greenListener() {
        return this.testListener;
    }
    allListeners() {
        return this.listeners;
    }
}
exports.EcsCodeDeploy = EcsCodeDeploy;
_a = JSII_RTTI_SYMBOL_1;
EcsCodeDeploy[_a] = { fqn: "must-cdk.EcsCodeDeploy", version: "0.0.112" };
//# sourceMappingURL=data:application/json;base64,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