# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['OceanImportArgs', 'OceanImport']

@pulumi.input_type
class OceanImportArgs:
    def __init__(__self__, *,
                 cluster_name: pulumi.Input[_builtins.str],
                 location: pulumi.Input[_builtins.str],
                 auto_updates: Optional[pulumi.Input[Sequence[pulumi.Input['OceanImportAutoUpdateArgs']]]] = None,
                 autoscaler: Optional[pulumi.Input['OceanImportAutoscalerArgs']] = None,
                 backend_services: Optional[pulumi.Input[Sequence[pulumi.Input['OceanImportBackendServiceArgs']]]] = None,
                 blacklists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 controller_cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                 desired_capacity: Optional[pulumi.Input[_builtins.int]] = None,
                 filters: Optional[pulumi.Input['OceanImportFiltersArgs']] = None,
                 max_size: Optional[pulumi.Input[_builtins.int]] = None,
                 min_size: Optional[pulumi.Input[_builtins.int]] = None,
                 root_volume_type: Optional[pulumi.Input[_builtins.str]] = None,
                 scheduled_tasks: Optional[pulumi.Input[Sequence[pulumi.Input['OceanImportScheduledTaskArgs']]]] = None,
                 shielded_instance_config: Optional[pulumi.Input['OceanImportShieldedInstanceConfigArgs']] = None,
                 strategies: Optional[pulumi.Input[Sequence[pulumi.Input['OceanImportStrategyArgs']]]] = None,
                 update_policy: Optional[pulumi.Input['OceanImportUpdatePolicyArgs']] = None,
                 use_as_template_only: Optional[pulumi.Input[_builtins.bool]] = None,
                 whitelists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a OceanImport resource.
        :param pulumi.Input[_builtins.str] cluster_name: The GKE cluster name.
        :param pulumi.Input[_builtins.str] location: The zone the master cluster is located in.
        :param pulumi.Input[Sequence[pulumi.Input['OceanImportAutoUpdateArgs']]] auto_updates: The Ocean Kubernetes AutoUpdate object. If set to 'true', Ocean will ensure that your clusters have an up-to-date configuration according to the respective GKE cluster.
        :param pulumi.Input['OceanImportAutoscalerArgs'] autoscaler: The Ocean Kubernetes Autoscaler object.
        :param pulumi.Input[Sequence[pulumi.Input['OceanImportBackendServiceArgs']]] backend_services: Describes the backend service configurations.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] blacklists: Instance types to avoid launching in the Ocean cluster. Cannot be configured if whitelist list is configured.
        :param pulumi.Input[_builtins.str] controller_cluster_id: A unique identifier used for connecting the Ocean SaaS platform and the Kubernetes cluster. Typically, the cluster name is used as its identifier.
        :param pulumi.Input[_builtins.int] desired_capacity: The number of instances to launch and maintain in the cluster.
        :param pulumi.Input['OceanImportFiltersArgs'] filters: List of filters. The Instance types that match with all filters compose the Ocean's whitelist parameter. Cannot be configured together with whitelist/blacklist.
        :param pulumi.Input[_builtins.int] max_size: The upper limit of instances the cluster can scale up to.
        :param pulumi.Input[_builtins.int] min_size: The lower limit of instances the cluster can scale down to.
        :param pulumi.Input[_builtins.str] root_volume_type: The root volume disk type.
        :param pulumi.Input[Sequence[pulumi.Input['OceanImportScheduledTaskArgs']]] scheduled_tasks: Set scheduling object.
        :param pulumi.Input['OceanImportShieldedInstanceConfigArgs'] shielded_instance_config: The Ocean shielded instance configuration object.
        :param pulumi.Input[Sequence[pulumi.Input['OceanImportStrategyArgs']]] strategies: Strategy object.
        :param pulumi.Input[_builtins.bool] use_as_template_only: launch specification defined on the Ocean object will function only as a template for virtual node groups.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] whitelists: Instance types allowed in the Ocean cluster. Cannot be configured if blacklist list is configured.
        """
        pulumi.set(__self__, "cluster_name", cluster_name)
        pulumi.set(__self__, "location", location)
        if auto_updates is not None:
            pulumi.set(__self__, "auto_updates", auto_updates)
        if autoscaler is not None:
            pulumi.set(__self__, "autoscaler", autoscaler)
        if backend_services is not None:
            pulumi.set(__self__, "backend_services", backend_services)
        if blacklists is not None:
            pulumi.set(__self__, "blacklists", blacklists)
        if controller_cluster_id is not None:
            pulumi.set(__self__, "controller_cluster_id", controller_cluster_id)
        if desired_capacity is not None:
            pulumi.set(__self__, "desired_capacity", desired_capacity)
        if filters is not None:
            pulumi.set(__self__, "filters", filters)
        if max_size is not None:
            pulumi.set(__self__, "max_size", max_size)
        if min_size is not None:
            pulumi.set(__self__, "min_size", min_size)
        if root_volume_type is not None:
            pulumi.set(__self__, "root_volume_type", root_volume_type)
        if scheduled_tasks is not None:
            pulumi.set(__self__, "scheduled_tasks", scheduled_tasks)
        if shielded_instance_config is not None:
            pulumi.set(__self__, "shielded_instance_config", shielded_instance_config)
        if strategies is not None:
            pulumi.set(__self__, "strategies", strategies)
        if update_policy is not None:
            pulumi.set(__self__, "update_policy", update_policy)
        if use_as_template_only is not None:
            pulumi.set(__self__, "use_as_template_only", use_as_template_only)
        if whitelists is not None:
            pulumi.set(__self__, "whitelists", whitelists)

    @_builtins.property
    @pulumi.getter(name="clusterName")
    def cluster_name(self) -> pulumi.Input[_builtins.str]:
        """
        The GKE cluster name.
        """
        return pulumi.get(self, "cluster_name")

    @cluster_name.setter
    def cluster_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "cluster_name", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Input[_builtins.str]:
        """
        The zone the master cluster is located in.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter(name="autoUpdates")
    def auto_updates(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['OceanImportAutoUpdateArgs']]]]:
        """
        The Ocean Kubernetes AutoUpdate object. If set to 'true', Ocean will ensure that your clusters have an up-to-date configuration according to the respective GKE cluster.
        """
        return pulumi.get(self, "auto_updates")

    @auto_updates.setter
    def auto_updates(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['OceanImportAutoUpdateArgs']]]]):
        pulumi.set(self, "auto_updates", value)

    @_builtins.property
    @pulumi.getter
    def autoscaler(self) -> Optional[pulumi.Input['OceanImportAutoscalerArgs']]:
        """
        The Ocean Kubernetes Autoscaler object.
        """
        return pulumi.get(self, "autoscaler")

    @autoscaler.setter
    def autoscaler(self, value: Optional[pulumi.Input['OceanImportAutoscalerArgs']]):
        pulumi.set(self, "autoscaler", value)

    @_builtins.property
    @pulumi.getter(name="backendServices")
    def backend_services(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['OceanImportBackendServiceArgs']]]]:
        """
        Describes the backend service configurations.
        """
        return pulumi.get(self, "backend_services")

    @backend_services.setter
    def backend_services(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['OceanImportBackendServiceArgs']]]]):
        pulumi.set(self, "backend_services", value)

    @_builtins.property
    @pulumi.getter
    def blacklists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Instance types to avoid launching in the Ocean cluster. Cannot be configured if whitelist list is configured.
        """
        return pulumi.get(self, "blacklists")

    @blacklists.setter
    def blacklists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "blacklists", value)

    @_builtins.property
    @pulumi.getter(name="controllerClusterId")
    def controller_cluster_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A unique identifier used for connecting the Ocean SaaS platform and the Kubernetes cluster. Typically, the cluster name is used as its identifier.
        """
        return pulumi.get(self, "controller_cluster_id")

    @controller_cluster_id.setter
    def controller_cluster_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "controller_cluster_id", value)

    @_builtins.property
    @pulumi.getter(name="desiredCapacity")
    def desired_capacity(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of instances to launch and maintain in the cluster.
        """
        return pulumi.get(self, "desired_capacity")

    @desired_capacity.setter
    def desired_capacity(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "desired_capacity", value)

    @_builtins.property
    @pulumi.getter
    def filters(self) -> Optional[pulumi.Input['OceanImportFiltersArgs']]:
        """
        List of filters. The Instance types that match with all filters compose the Ocean's whitelist parameter. Cannot be configured together with whitelist/blacklist.
        """
        return pulumi.get(self, "filters")

    @filters.setter
    def filters(self, value: Optional[pulumi.Input['OceanImportFiltersArgs']]):
        pulumi.set(self, "filters", value)

    @_builtins.property
    @pulumi.getter(name="maxSize")
    def max_size(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The upper limit of instances the cluster can scale up to.
        """
        return pulumi.get(self, "max_size")

    @max_size.setter
    def max_size(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_size", value)

    @_builtins.property
    @pulumi.getter(name="minSize")
    def min_size(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The lower limit of instances the cluster can scale down to.
        """
        return pulumi.get(self, "min_size")

    @min_size.setter
    def min_size(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "min_size", value)

    @_builtins.property
    @pulumi.getter(name="rootVolumeType")
    def root_volume_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The root volume disk type.
        """
        return pulumi.get(self, "root_volume_type")

    @root_volume_type.setter
    def root_volume_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "root_volume_type", value)

    @_builtins.property
    @pulumi.getter(name="scheduledTasks")
    def scheduled_tasks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['OceanImportScheduledTaskArgs']]]]:
        """
        Set scheduling object.
        """
        return pulumi.get(self, "scheduled_tasks")

    @scheduled_tasks.setter
    def scheduled_tasks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['OceanImportScheduledTaskArgs']]]]):
        pulumi.set(self, "scheduled_tasks", value)

    @_builtins.property
    @pulumi.getter(name="shieldedInstanceConfig")
    def shielded_instance_config(self) -> Optional[pulumi.Input['OceanImportShieldedInstanceConfigArgs']]:
        """
        The Ocean shielded instance configuration object.
        """
        return pulumi.get(self, "shielded_instance_config")

    @shielded_instance_config.setter
    def shielded_instance_config(self, value: Optional[pulumi.Input['OceanImportShieldedInstanceConfigArgs']]):
        pulumi.set(self, "shielded_instance_config", value)

    @_builtins.property
    @pulumi.getter
    def strategies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['OceanImportStrategyArgs']]]]:
        """
        Strategy object.
        """
        return pulumi.get(self, "strategies")

    @strategies.setter
    def strategies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['OceanImportStrategyArgs']]]]):
        pulumi.set(self, "strategies", value)

    @_builtins.property
    @pulumi.getter(name="updatePolicy")
    def update_policy(self) -> Optional[pulumi.Input['OceanImportUpdatePolicyArgs']]:
        return pulumi.get(self, "update_policy")

    @update_policy.setter
    def update_policy(self, value: Optional[pulumi.Input['OceanImportUpdatePolicyArgs']]):
        pulumi.set(self, "update_policy", value)

    @_builtins.property
    @pulumi.getter(name="useAsTemplateOnly")
    def use_as_template_only(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        launch specification defined on the Ocean object will function only as a template for virtual node groups.
        """
        return pulumi.get(self, "use_as_template_only")

    @use_as_template_only.setter
    def use_as_template_only(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "use_as_template_only", value)

    @_builtins.property
    @pulumi.getter
    def whitelists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Instance types allowed in the Ocean cluster. Cannot be configured if blacklist list is configured.
        """
        return pulumi.get(self, "whitelists")

    @whitelists.setter
    def whitelists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "whitelists", value)


@pulumi.input_type
class _OceanImportState:
    def __init__(__self__, *,
                 auto_updates: Optional[pulumi.Input[Sequence[pulumi.Input['OceanImportAutoUpdateArgs']]]] = None,
                 autoscaler: Optional[pulumi.Input['OceanImportAutoscalerArgs']] = None,
                 backend_services: Optional[pulumi.Input[Sequence[pulumi.Input['OceanImportBackendServiceArgs']]]] = None,
                 blacklists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 cluster_controller_id: Optional[pulumi.Input[_builtins.str]] = None,
                 cluster_name: Optional[pulumi.Input[_builtins.str]] = None,
                 controller_cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                 desired_capacity: Optional[pulumi.Input[_builtins.int]] = None,
                 filters: Optional[pulumi.Input['OceanImportFiltersArgs']] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 max_size: Optional[pulumi.Input[_builtins.int]] = None,
                 min_size: Optional[pulumi.Input[_builtins.int]] = None,
                 root_volume_type: Optional[pulumi.Input[_builtins.str]] = None,
                 scheduled_tasks: Optional[pulumi.Input[Sequence[pulumi.Input['OceanImportScheduledTaskArgs']]]] = None,
                 shielded_instance_config: Optional[pulumi.Input['OceanImportShieldedInstanceConfigArgs']] = None,
                 strategies: Optional[pulumi.Input[Sequence[pulumi.Input['OceanImportStrategyArgs']]]] = None,
                 update_policy: Optional[pulumi.Input['OceanImportUpdatePolicyArgs']] = None,
                 use_as_template_only: Optional[pulumi.Input[_builtins.bool]] = None,
                 whitelists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering OceanImport resources.
        :param pulumi.Input[Sequence[pulumi.Input['OceanImportAutoUpdateArgs']]] auto_updates: The Ocean Kubernetes AutoUpdate object. If set to 'true', Ocean will ensure that your clusters have an up-to-date configuration according to the respective GKE cluster.
        :param pulumi.Input['OceanImportAutoscalerArgs'] autoscaler: The Ocean Kubernetes Autoscaler object.
        :param pulumi.Input[Sequence[pulumi.Input['OceanImportBackendServiceArgs']]] backend_services: Describes the backend service configurations.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] blacklists: Instance types to avoid launching in the Ocean cluster. Cannot be configured if whitelist list is configured.
        :param pulumi.Input[_builtins.str] cluster_name: The GKE cluster name.
        :param pulumi.Input[_builtins.str] controller_cluster_id: A unique identifier used for connecting the Ocean SaaS platform and the Kubernetes cluster. Typically, the cluster name is used as its identifier.
        :param pulumi.Input[_builtins.int] desired_capacity: The number of instances to launch and maintain in the cluster.
        :param pulumi.Input['OceanImportFiltersArgs'] filters: List of filters. The Instance types that match with all filters compose the Ocean's whitelist parameter. Cannot be configured together with whitelist/blacklist.
        :param pulumi.Input[_builtins.str] location: The zone the master cluster is located in.
        :param pulumi.Input[_builtins.int] max_size: The upper limit of instances the cluster can scale up to.
        :param pulumi.Input[_builtins.int] min_size: The lower limit of instances the cluster can scale down to.
        :param pulumi.Input[_builtins.str] root_volume_type: The root volume disk type.
        :param pulumi.Input[Sequence[pulumi.Input['OceanImportScheduledTaskArgs']]] scheduled_tasks: Set scheduling object.
        :param pulumi.Input['OceanImportShieldedInstanceConfigArgs'] shielded_instance_config: The Ocean shielded instance configuration object.
        :param pulumi.Input[Sequence[pulumi.Input['OceanImportStrategyArgs']]] strategies: Strategy object.
        :param pulumi.Input[_builtins.bool] use_as_template_only: launch specification defined on the Ocean object will function only as a template for virtual node groups.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] whitelists: Instance types allowed in the Ocean cluster. Cannot be configured if blacklist list is configured.
        """
        if auto_updates is not None:
            pulumi.set(__self__, "auto_updates", auto_updates)
        if autoscaler is not None:
            pulumi.set(__self__, "autoscaler", autoscaler)
        if backend_services is not None:
            pulumi.set(__self__, "backend_services", backend_services)
        if blacklists is not None:
            pulumi.set(__self__, "blacklists", blacklists)
        if cluster_controller_id is not None:
            pulumi.set(__self__, "cluster_controller_id", cluster_controller_id)
        if cluster_name is not None:
            pulumi.set(__self__, "cluster_name", cluster_name)
        if controller_cluster_id is not None:
            pulumi.set(__self__, "controller_cluster_id", controller_cluster_id)
        if desired_capacity is not None:
            pulumi.set(__self__, "desired_capacity", desired_capacity)
        if filters is not None:
            pulumi.set(__self__, "filters", filters)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if max_size is not None:
            pulumi.set(__self__, "max_size", max_size)
        if min_size is not None:
            pulumi.set(__self__, "min_size", min_size)
        if root_volume_type is not None:
            pulumi.set(__self__, "root_volume_type", root_volume_type)
        if scheduled_tasks is not None:
            pulumi.set(__self__, "scheduled_tasks", scheduled_tasks)
        if shielded_instance_config is not None:
            pulumi.set(__self__, "shielded_instance_config", shielded_instance_config)
        if strategies is not None:
            pulumi.set(__self__, "strategies", strategies)
        if update_policy is not None:
            pulumi.set(__self__, "update_policy", update_policy)
        if use_as_template_only is not None:
            pulumi.set(__self__, "use_as_template_only", use_as_template_only)
        if whitelists is not None:
            pulumi.set(__self__, "whitelists", whitelists)

    @_builtins.property
    @pulumi.getter(name="autoUpdates")
    def auto_updates(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['OceanImportAutoUpdateArgs']]]]:
        """
        The Ocean Kubernetes AutoUpdate object. If set to 'true', Ocean will ensure that your clusters have an up-to-date configuration according to the respective GKE cluster.
        """
        return pulumi.get(self, "auto_updates")

    @auto_updates.setter
    def auto_updates(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['OceanImportAutoUpdateArgs']]]]):
        pulumi.set(self, "auto_updates", value)

    @_builtins.property
    @pulumi.getter
    def autoscaler(self) -> Optional[pulumi.Input['OceanImportAutoscalerArgs']]:
        """
        The Ocean Kubernetes Autoscaler object.
        """
        return pulumi.get(self, "autoscaler")

    @autoscaler.setter
    def autoscaler(self, value: Optional[pulumi.Input['OceanImportAutoscalerArgs']]):
        pulumi.set(self, "autoscaler", value)

    @_builtins.property
    @pulumi.getter(name="backendServices")
    def backend_services(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['OceanImportBackendServiceArgs']]]]:
        """
        Describes the backend service configurations.
        """
        return pulumi.get(self, "backend_services")

    @backend_services.setter
    def backend_services(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['OceanImportBackendServiceArgs']]]]):
        pulumi.set(self, "backend_services", value)

    @_builtins.property
    @pulumi.getter
    def blacklists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Instance types to avoid launching in the Ocean cluster. Cannot be configured if whitelist list is configured.
        """
        return pulumi.get(self, "blacklists")

    @blacklists.setter
    def blacklists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "blacklists", value)

    @_builtins.property
    @pulumi.getter(name="clusterControllerId")
    def cluster_controller_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "cluster_controller_id")

    @cluster_controller_id.setter
    def cluster_controller_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cluster_controller_id", value)

    @_builtins.property
    @pulumi.getter(name="clusterName")
    def cluster_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The GKE cluster name.
        """
        return pulumi.get(self, "cluster_name")

    @cluster_name.setter
    def cluster_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cluster_name", value)

    @_builtins.property
    @pulumi.getter(name="controllerClusterId")
    def controller_cluster_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A unique identifier used for connecting the Ocean SaaS platform and the Kubernetes cluster. Typically, the cluster name is used as its identifier.
        """
        return pulumi.get(self, "controller_cluster_id")

    @controller_cluster_id.setter
    def controller_cluster_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "controller_cluster_id", value)

    @_builtins.property
    @pulumi.getter(name="desiredCapacity")
    def desired_capacity(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of instances to launch and maintain in the cluster.
        """
        return pulumi.get(self, "desired_capacity")

    @desired_capacity.setter
    def desired_capacity(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "desired_capacity", value)

    @_builtins.property
    @pulumi.getter
    def filters(self) -> Optional[pulumi.Input['OceanImportFiltersArgs']]:
        """
        List of filters. The Instance types that match with all filters compose the Ocean's whitelist parameter. Cannot be configured together with whitelist/blacklist.
        """
        return pulumi.get(self, "filters")

    @filters.setter
    def filters(self, value: Optional[pulumi.Input['OceanImportFiltersArgs']]):
        pulumi.set(self, "filters", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The zone the master cluster is located in.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter(name="maxSize")
    def max_size(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The upper limit of instances the cluster can scale up to.
        """
        return pulumi.get(self, "max_size")

    @max_size.setter
    def max_size(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_size", value)

    @_builtins.property
    @pulumi.getter(name="minSize")
    def min_size(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The lower limit of instances the cluster can scale down to.
        """
        return pulumi.get(self, "min_size")

    @min_size.setter
    def min_size(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "min_size", value)

    @_builtins.property
    @pulumi.getter(name="rootVolumeType")
    def root_volume_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The root volume disk type.
        """
        return pulumi.get(self, "root_volume_type")

    @root_volume_type.setter
    def root_volume_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "root_volume_type", value)

    @_builtins.property
    @pulumi.getter(name="scheduledTasks")
    def scheduled_tasks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['OceanImportScheduledTaskArgs']]]]:
        """
        Set scheduling object.
        """
        return pulumi.get(self, "scheduled_tasks")

    @scheduled_tasks.setter
    def scheduled_tasks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['OceanImportScheduledTaskArgs']]]]):
        pulumi.set(self, "scheduled_tasks", value)

    @_builtins.property
    @pulumi.getter(name="shieldedInstanceConfig")
    def shielded_instance_config(self) -> Optional[pulumi.Input['OceanImportShieldedInstanceConfigArgs']]:
        """
        The Ocean shielded instance configuration object.
        """
        return pulumi.get(self, "shielded_instance_config")

    @shielded_instance_config.setter
    def shielded_instance_config(self, value: Optional[pulumi.Input['OceanImportShieldedInstanceConfigArgs']]):
        pulumi.set(self, "shielded_instance_config", value)

    @_builtins.property
    @pulumi.getter
    def strategies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['OceanImportStrategyArgs']]]]:
        """
        Strategy object.
        """
        return pulumi.get(self, "strategies")

    @strategies.setter
    def strategies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['OceanImportStrategyArgs']]]]):
        pulumi.set(self, "strategies", value)

    @_builtins.property
    @pulumi.getter(name="updatePolicy")
    def update_policy(self) -> Optional[pulumi.Input['OceanImportUpdatePolicyArgs']]:
        return pulumi.get(self, "update_policy")

    @update_policy.setter
    def update_policy(self, value: Optional[pulumi.Input['OceanImportUpdatePolicyArgs']]):
        pulumi.set(self, "update_policy", value)

    @_builtins.property
    @pulumi.getter(name="useAsTemplateOnly")
    def use_as_template_only(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        launch specification defined on the Ocean object will function only as a template for virtual node groups.
        """
        return pulumi.get(self, "use_as_template_only")

    @use_as_template_only.setter
    def use_as_template_only(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "use_as_template_only", value)

    @_builtins.property
    @pulumi.getter
    def whitelists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Instance types allowed in the Ocean cluster. Cannot be configured if blacklist list is configured.
        """
        return pulumi.get(self, "whitelists")

    @whitelists.setter
    def whitelists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "whitelists", value)


@pulumi.type_token("spotinst:gke/oceanImport:OceanImport")
class OceanImport(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_updates: Optional[pulumi.Input[Sequence[pulumi.Input[Union['OceanImportAutoUpdateArgs', 'OceanImportAutoUpdateArgsDict']]]]] = None,
                 autoscaler: Optional[pulumi.Input[Union['OceanImportAutoscalerArgs', 'OceanImportAutoscalerArgsDict']]] = None,
                 backend_services: Optional[pulumi.Input[Sequence[pulumi.Input[Union['OceanImportBackendServiceArgs', 'OceanImportBackendServiceArgsDict']]]]] = None,
                 blacklists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 cluster_name: Optional[pulumi.Input[_builtins.str]] = None,
                 controller_cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                 desired_capacity: Optional[pulumi.Input[_builtins.int]] = None,
                 filters: Optional[pulumi.Input[Union['OceanImportFiltersArgs', 'OceanImportFiltersArgsDict']]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 max_size: Optional[pulumi.Input[_builtins.int]] = None,
                 min_size: Optional[pulumi.Input[_builtins.int]] = None,
                 root_volume_type: Optional[pulumi.Input[_builtins.str]] = None,
                 scheduled_tasks: Optional[pulumi.Input[Sequence[pulumi.Input[Union['OceanImportScheduledTaskArgs', 'OceanImportScheduledTaskArgsDict']]]]] = None,
                 shielded_instance_config: Optional[pulumi.Input[Union['OceanImportShieldedInstanceConfigArgs', 'OceanImportShieldedInstanceConfigArgsDict']]] = None,
                 strategies: Optional[pulumi.Input[Sequence[pulumi.Input[Union['OceanImportStrategyArgs', 'OceanImportStrategyArgsDict']]]]] = None,
                 update_policy: Optional[pulumi.Input[Union['OceanImportUpdatePolicyArgs', 'OceanImportUpdatePolicyArgsDict']]] = None,
                 use_as_template_only: Optional[pulumi.Input[_builtins.bool]] = None,
                 whitelists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_spotinst as spotinst

        example = spotinst.gke.OceanImport("example",
            cluster_name="example-cluster-name",
            controller_cluster_id="example-controller-123124",
            location="us-central1-a",
            min_size=0,
            max_size=2,
            desired_capacity=0,
            auto_updates=[{
                "is_enabled": True,
            }],
            whitelists=[
                "n1-standard-1",
                "n1-standard-2",
            ],
            filters={
                "exclude_families": ["n2"],
                "include_families": [
                    "c2",
                    "c3",
                ],
                "min_memory_gib": 8,
                "max_memory_gib": 16,
                "min_vcpu": 2,
                "max_vcpu": 16,
            },
            backend_services=[{
                "service_name": "example-backend-service",
                "location_type": "regional",
                "scheme": "INTERNAL",
                "named_ports": [{
                    "name": "http",
                    "ports": [
                        "80",
                        "8080",
                    ],
                }],
            }],
            root_volume_type="pd-ssd",
            shielded_instance_config={
                "enable_secure_boot": True,
                "enable_integrity_monitoring": True,
            },
            use_as_template_only=False)
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['OceanImportAutoUpdateArgs', 'OceanImportAutoUpdateArgsDict']]]] auto_updates: The Ocean Kubernetes AutoUpdate object. If set to 'true', Ocean will ensure that your clusters have an up-to-date configuration according to the respective GKE cluster.
        :param pulumi.Input[Union['OceanImportAutoscalerArgs', 'OceanImportAutoscalerArgsDict']] autoscaler: The Ocean Kubernetes Autoscaler object.
        :param pulumi.Input[Sequence[pulumi.Input[Union['OceanImportBackendServiceArgs', 'OceanImportBackendServiceArgsDict']]]] backend_services: Describes the backend service configurations.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] blacklists: Instance types to avoid launching in the Ocean cluster. Cannot be configured if whitelist list is configured.
        :param pulumi.Input[_builtins.str] cluster_name: The GKE cluster name.
        :param pulumi.Input[_builtins.str] controller_cluster_id: A unique identifier used for connecting the Ocean SaaS platform and the Kubernetes cluster. Typically, the cluster name is used as its identifier.
        :param pulumi.Input[_builtins.int] desired_capacity: The number of instances to launch and maintain in the cluster.
        :param pulumi.Input[Union['OceanImportFiltersArgs', 'OceanImportFiltersArgsDict']] filters: List of filters. The Instance types that match with all filters compose the Ocean's whitelist parameter. Cannot be configured together with whitelist/blacklist.
        :param pulumi.Input[_builtins.str] location: The zone the master cluster is located in.
        :param pulumi.Input[_builtins.int] max_size: The upper limit of instances the cluster can scale up to.
        :param pulumi.Input[_builtins.int] min_size: The lower limit of instances the cluster can scale down to.
        :param pulumi.Input[_builtins.str] root_volume_type: The root volume disk type.
        :param pulumi.Input[Sequence[pulumi.Input[Union['OceanImportScheduledTaskArgs', 'OceanImportScheduledTaskArgsDict']]]] scheduled_tasks: Set scheduling object.
        :param pulumi.Input[Union['OceanImportShieldedInstanceConfigArgs', 'OceanImportShieldedInstanceConfigArgsDict']] shielded_instance_config: The Ocean shielded instance configuration object.
        :param pulumi.Input[Sequence[pulumi.Input[Union['OceanImportStrategyArgs', 'OceanImportStrategyArgsDict']]]] strategies: Strategy object.
        :param pulumi.Input[_builtins.bool] use_as_template_only: launch specification defined on the Ocean object will function only as a template for virtual node groups.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] whitelists: Instance types allowed in the Ocean cluster. Cannot be configured if blacklist list is configured.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: OceanImportArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_spotinst as spotinst

        example = spotinst.gke.OceanImport("example",
            cluster_name="example-cluster-name",
            controller_cluster_id="example-controller-123124",
            location="us-central1-a",
            min_size=0,
            max_size=2,
            desired_capacity=0,
            auto_updates=[{
                "is_enabled": True,
            }],
            whitelists=[
                "n1-standard-1",
                "n1-standard-2",
            ],
            filters={
                "exclude_families": ["n2"],
                "include_families": [
                    "c2",
                    "c3",
                ],
                "min_memory_gib": 8,
                "max_memory_gib": 16,
                "min_vcpu": 2,
                "max_vcpu": 16,
            },
            backend_services=[{
                "service_name": "example-backend-service",
                "location_type": "regional",
                "scheme": "INTERNAL",
                "named_ports": [{
                    "name": "http",
                    "ports": [
                        "80",
                        "8080",
                    ],
                }],
            }],
            root_volume_type="pd-ssd",
            shielded_instance_config={
                "enable_secure_boot": True,
                "enable_integrity_monitoring": True,
            },
            use_as_template_only=False)
        ```

        :param str resource_name: The name of the resource.
        :param OceanImportArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(OceanImportArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_updates: Optional[pulumi.Input[Sequence[pulumi.Input[Union['OceanImportAutoUpdateArgs', 'OceanImportAutoUpdateArgsDict']]]]] = None,
                 autoscaler: Optional[pulumi.Input[Union['OceanImportAutoscalerArgs', 'OceanImportAutoscalerArgsDict']]] = None,
                 backend_services: Optional[pulumi.Input[Sequence[pulumi.Input[Union['OceanImportBackendServiceArgs', 'OceanImportBackendServiceArgsDict']]]]] = None,
                 blacklists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 cluster_name: Optional[pulumi.Input[_builtins.str]] = None,
                 controller_cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                 desired_capacity: Optional[pulumi.Input[_builtins.int]] = None,
                 filters: Optional[pulumi.Input[Union['OceanImportFiltersArgs', 'OceanImportFiltersArgsDict']]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 max_size: Optional[pulumi.Input[_builtins.int]] = None,
                 min_size: Optional[pulumi.Input[_builtins.int]] = None,
                 root_volume_type: Optional[pulumi.Input[_builtins.str]] = None,
                 scheduled_tasks: Optional[pulumi.Input[Sequence[pulumi.Input[Union['OceanImportScheduledTaskArgs', 'OceanImportScheduledTaskArgsDict']]]]] = None,
                 shielded_instance_config: Optional[pulumi.Input[Union['OceanImportShieldedInstanceConfigArgs', 'OceanImportShieldedInstanceConfigArgsDict']]] = None,
                 strategies: Optional[pulumi.Input[Sequence[pulumi.Input[Union['OceanImportStrategyArgs', 'OceanImportStrategyArgsDict']]]]] = None,
                 update_policy: Optional[pulumi.Input[Union['OceanImportUpdatePolicyArgs', 'OceanImportUpdatePolicyArgsDict']]] = None,
                 use_as_template_only: Optional[pulumi.Input[_builtins.bool]] = None,
                 whitelists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = OceanImportArgs.__new__(OceanImportArgs)

            __props__.__dict__["auto_updates"] = auto_updates
            __props__.__dict__["autoscaler"] = autoscaler
            __props__.__dict__["backend_services"] = backend_services
            __props__.__dict__["blacklists"] = blacklists
            if cluster_name is None and not opts.urn:
                raise TypeError("Missing required property 'cluster_name'")
            __props__.__dict__["cluster_name"] = cluster_name
            __props__.__dict__["controller_cluster_id"] = controller_cluster_id
            __props__.__dict__["desired_capacity"] = desired_capacity
            __props__.__dict__["filters"] = filters
            if location is None and not opts.urn:
                raise TypeError("Missing required property 'location'")
            __props__.__dict__["location"] = location
            __props__.__dict__["max_size"] = max_size
            __props__.__dict__["min_size"] = min_size
            __props__.__dict__["root_volume_type"] = root_volume_type
            __props__.__dict__["scheduled_tasks"] = scheduled_tasks
            __props__.__dict__["shielded_instance_config"] = shielded_instance_config
            __props__.__dict__["strategies"] = strategies
            __props__.__dict__["update_policy"] = update_policy
            __props__.__dict__["use_as_template_only"] = use_as_template_only
            __props__.__dict__["whitelists"] = whitelists
            __props__.__dict__["cluster_controller_id"] = None
        super(OceanImport, __self__).__init__(
            'spotinst:gke/oceanImport:OceanImport',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            auto_updates: Optional[pulumi.Input[Sequence[pulumi.Input[Union['OceanImportAutoUpdateArgs', 'OceanImportAutoUpdateArgsDict']]]]] = None,
            autoscaler: Optional[pulumi.Input[Union['OceanImportAutoscalerArgs', 'OceanImportAutoscalerArgsDict']]] = None,
            backend_services: Optional[pulumi.Input[Sequence[pulumi.Input[Union['OceanImportBackendServiceArgs', 'OceanImportBackendServiceArgsDict']]]]] = None,
            blacklists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            cluster_controller_id: Optional[pulumi.Input[_builtins.str]] = None,
            cluster_name: Optional[pulumi.Input[_builtins.str]] = None,
            controller_cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
            desired_capacity: Optional[pulumi.Input[_builtins.int]] = None,
            filters: Optional[pulumi.Input[Union['OceanImportFiltersArgs', 'OceanImportFiltersArgsDict']]] = None,
            location: Optional[pulumi.Input[_builtins.str]] = None,
            max_size: Optional[pulumi.Input[_builtins.int]] = None,
            min_size: Optional[pulumi.Input[_builtins.int]] = None,
            root_volume_type: Optional[pulumi.Input[_builtins.str]] = None,
            scheduled_tasks: Optional[pulumi.Input[Sequence[pulumi.Input[Union['OceanImportScheduledTaskArgs', 'OceanImportScheduledTaskArgsDict']]]]] = None,
            shielded_instance_config: Optional[pulumi.Input[Union['OceanImportShieldedInstanceConfigArgs', 'OceanImportShieldedInstanceConfigArgsDict']]] = None,
            strategies: Optional[pulumi.Input[Sequence[pulumi.Input[Union['OceanImportStrategyArgs', 'OceanImportStrategyArgsDict']]]]] = None,
            update_policy: Optional[pulumi.Input[Union['OceanImportUpdatePolicyArgs', 'OceanImportUpdatePolicyArgsDict']]] = None,
            use_as_template_only: Optional[pulumi.Input[_builtins.bool]] = None,
            whitelists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None) -> 'OceanImport':
        """
        Get an existing OceanImport resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['OceanImportAutoUpdateArgs', 'OceanImportAutoUpdateArgsDict']]]] auto_updates: The Ocean Kubernetes AutoUpdate object. If set to 'true', Ocean will ensure that your clusters have an up-to-date configuration according to the respective GKE cluster.
        :param pulumi.Input[Union['OceanImportAutoscalerArgs', 'OceanImportAutoscalerArgsDict']] autoscaler: The Ocean Kubernetes Autoscaler object.
        :param pulumi.Input[Sequence[pulumi.Input[Union['OceanImportBackendServiceArgs', 'OceanImportBackendServiceArgsDict']]]] backend_services: Describes the backend service configurations.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] blacklists: Instance types to avoid launching in the Ocean cluster. Cannot be configured if whitelist list is configured.
        :param pulumi.Input[_builtins.str] cluster_name: The GKE cluster name.
        :param pulumi.Input[_builtins.str] controller_cluster_id: A unique identifier used for connecting the Ocean SaaS platform and the Kubernetes cluster. Typically, the cluster name is used as its identifier.
        :param pulumi.Input[_builtins.int] desired_capacity: The number of instances to launch and maintain in the cluster.
        :param pulumi.Input[Union['OceanImportFiltersArgs', 'OceanImportFiltersArgsDict']] filters: List of filters. The Instance types that match with all filters compose the Ocean's whitelist parameter. Cannot be configured together with whitelist/blacklist.
        :param pulumi.Input[_builtins.str] location: The zone the master cluster is located in.
        :param pulumi.Input[_builtins.int] max_size: The upper limit of instances the cluster can scale up to.
        :param pulumi.Input[_builtins.int] min_size: The lower limit of instances the cluster can scale down to.
        :param pulumi.Input[_builtins.str] root_volume_type: The root volume disk type.
        :param pulumi.Input[Sequence[pulumi.Input[Union['OceanImportScheduledTaskArgs', 'OceanImportScheduledTaskArgsDict']]]] scheduled_tasks: Set scheduling object.
        :param pulumi.Input[Union['OceanImportShieldedInstanceConfigArgs', 'OceanImportShieldedInstanceConfigArgsDict']] shielded_instance_config: The Ocean shielded instance configuration object.
        :param pulumi.Input[Sequence[pulumi.Input[Union['OceanImportStrategyArgs', 'OceanImportStrategyArgsDict']]]] strategies: Strategy object.
        :param pulumi.Input[_builtins.bool] use_as_template_only: launch specification defined on the Ocean object will function only as a template for virtual node groups.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] whitelists: Instance types allowed in the Ocean cluster. Cannot be configured if blacklist list is configured.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _OceanImportState.__new__(_OceanImportState)

        __props__.__dict__["auto_updates"] = auto_updates
        __props__.__dict__["autoscaler"] = autoscaler
        __props__.__dict__["backend_services"] = backend_services
        __props__.__dict__["blacklists"] = blacklists
        __props__.__dict__["cluster_controller_id"] = cluster_controller_id
        __props__.__dict__["cluster_name"] = cluster_name
        __props__.__dict__["controller_cluster_id"] = controller_cluster_id
        __props__.__dict__["desired_capacity"] = desired_capacity
        __props__.__dict__["filters"] = filters
        __props__.__dict__["location"] = location
        __props__.__dict__["max_size"] = max_size
        __props__.__dict__["min_size"] = min_size
        __props__.__dict__["root_volume_type"] = root_volume_type
        __props__.__dict__["scheduled_tasks"] = scheduled_tasks
        __props__.__dict__["shielded_instance_config"] = shielded_instance_config
        __props__.__dict__["strategies"] = strategies
        __props__.__dict__["update_policy"] = update_policy
        __props__.__dict__["use_as_template_only"] = use_as_template_only
        __props__.__dict__["whitelists"] = whitelists
        return OceanImport(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="autoUpdates")
    def auto_updates(self) -> pulumi.Output[Optional[Sequence['outputs.OceanImportAutoUpdate']]]:
        """
        The Ocean Kubernetes AutoUpdate object. If set to 'true', Ocean will ensure that your clusters have an up-to-date configuration according to the respective GKE cluster.
        """
        return pulumi.get(self, "auto_updates")

    @_builtins.property
    @pulumi.getter
    def autoscaler(self) -> pulumi.Output['outputs.OceanImportAutoscaler']:
        """
        The Ocean Kubernetes Autoscaler object.
        """
        return pulumi.get(self, "autoscaler")

    @_builtins.property
    @pulumi.getter(name="backendServices")
    def backend_services(self) -> pulumi.Output[Optional[Sequence['outputs.OceanImportBackendService']]]:
        """
        Describes the backend service configurations.
        """
        return pulumi.get(self, "backend_services")

    @_builtins.property
    @pulumi.getter
    def blacklists(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        Instance types to avoid launching in the Ocean cluster. Cannot be configured if whitelist list is configured.
        """
        return pulumi.get(self, "blacklists")

    @_builtins.property
    @pulumi.getter(name="clusterControllerId")
    def cluster_controller_id(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "cluster_controller_id")

    @_builtins.property
    @pulumi.getter(name="clusterName")
    def cluster_name(self) -> pulumi.Output[_builtins.str]:
        """
        The GKE cluster name.
        """
        return pulumi.get(self, "cluster_name")

    @_builtins.property
    @pulumi.getter(name="controllerClusterId")
    def controller_cluster_id(self) -> pulumi.Output[_builtins.str]:
        """
        A unique identifier used for connecting the Ocean SaaS platform and the Kubernetes cluster. Typically, the cluster name is used as its identifier.
        """
        return pulumi.get(self, "controller_cluster_id")

    @_builtins.property
    @pulumi.getter(name="desiredCapacity")
    def desired_capacity(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The number of instances to launch and maintain in the cluster.
        """
        return pulumi.get(self, "desired_capacity")

    @_builtins.property
    @pulumi.getter
    def filters(self) -> pulumi.Output[Optional['outputs.OceanImportFilters']]:
        """
        List of filters. The Instance types that match with all filters compose the Ocean's whitelist parameter. Cannot be configured together with whitelist/blacklist.
        """
        return pulumi.get(self, "filters")

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Output[_builtins.str]:
        """
        The zone the master cluster is located in.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter(name="maxSize")
    def max_size(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The upper limit of instances the cluster can scale up to.
        """
        return pulumi.get(self, "max_size")

    @_builtins.property
    @pulumi.getter(name="minSize")
    def min_size(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The lower limit of instances the cluster can scale down to.
        """
        return pulumi.get(self, "min_size")

    @_builtins.property
    @pulumi.getter(name="rootVolumeType")
    def root_volume_type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The root volume disk type.
        """
        return pulumi.get(self, "root_volume_type")

    @_builtins.property
    @pulumi.getter(name="scheduledTasks")
    def scheduled_tasks(self) -> pulumi.Output[Optional[Sequence['outputs.OceanImportScheduledTask']]]:
        """
        Set scheduling object.
        """
        return pulumi.get(self, "scheduled_tasks")

    @_builtins.property
    @pulumi.getter(name="shieldedInstanceConfig")
    def shielded_instance_config(self) -> pulumi.Output['outputs.OceanImportShieldedInstanceConfig']:
        """
        The Ocean shielded instance configuration object.
        """
        return pulumi.get(self, "shielded_instance_config")

    @_builtins.property
    @pulumi.getter
    def strategies(self) -> pulumi.Output[Optional[Sequence['outputs.OceanImportStrategy']]]:
        """
        Strategy object.
        """
        return pulumi.get(self, "strategies")

    @_builtins.property
    @pulumi.getter(name="updatePolicy")
    def update_policy(self) -> pulumi.Output[Optional['outputs.OceanImportUpdatePolicy']]:
        return pulumi.get(self, "update_policy")

    @_builtins.property
    @pulumi.getter(name="useAsTemplateOnly")
    def use_as_template_only(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        launch specification defined on the Ocean object will function only as a template for virtual node groups.
        """
        return pulumi.get(self, "use_as_template_only")

    @_builtins.property
    @pulumi.getter
    def whitelists(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        Instance types allowed in the Ocean cluster. Cannot be configured if blacklist list is configured.
        """
        return pulumi.get(self, "whitelists")

