# AppObject.py - Application objects
from smoacks.util import to_camelcase, to_mixedcase, to_snakecase

scr_objects = dict()

class AppObject:
    def __init__(self, name, desc = None):
        self.name = name
        self.description = desc if desc else name
        self._schemas = []
        self._properties = []
        self._idCount = 0
        self._idProperty = None
        self.identitySchemaName = None
        self.extendedSchemaName = None
        self.emitTestData = False
        self.relationships = None
    
    def addSchema(self, schema):
        self._schemas.append(schema)
        if schema.identityObject and not self.identitySchemaName:
            self.identitySchemaName = schema.name
            if schema.relationships:
                self.relationships = schema.relationships
            for prop in schema.getProperties().values():
                self._properties.append(prop)
                if prop.isId:
                    self._idProperty = prop
                    self._idCount += 1
        if schema.extendedObject:
            self.extendedSchemaName = schema.name
    
    def getSnakeName(self):
        return to_snakecase(self.name)
    
    def getCamelName(self):
        return to_camelcase(self.name)
    
    def getMixedName(self):
        return to_mixedcase(self.name)

    def getCreateObject(self):
        # Loop through the properties and update the structure where needed
        result = {}
        for prop in self._properties:
            if not prop.isId or self._idCount > 1:
                result[prop.name] = prop.example
        return result

    def getAllProperties(self):
        return self._properties
