import json
import setuptools

kwargs = json.loads(
    """
{
    "name": "aws-cdk.aws-chatbot",
    "version": "1.65.0",
    "description": "The CDK Construct Library for AWS::Chatbot",
    "license": "Apache-2.0",
    "url": "https://github.com/aws/aws-cdk",
    "long_description_content_type": "text/markdown",
    "author": "Amazon Web Services",
    "bdist_wheel": {
        "universal": true
    },
    "project_urls": {
        "Source": "https://github.com/aws/aws-cdk.git"
    },
    "package_dir": {
        "": "src"
    },
    "packages": [
        "aws_cdk.aws_chatbot",
        "aws_cdk.aws_chatbot._jsii"
    ],
    "package_data": {
        "aws_cdk.aws_chatbot._jsii": [
            "aws-chatbot@1.65.0.jsii.tgz"
        ],
        "aws_cdk.aws_chatbot": [
            "py.typed"
        ]
    },
    "python_requires": ">=3.6",
    "install_requires": [
        "aws-cdk.aws-cloudwatch==1.65.0",
        "aws-cdk.aws-iam==1.65.0",
        "aws-cdk.aws-logs==1.65.0",
        "aws-cdk.aws-sns==1.65.0",
        "aws-cdk.core==1.65.0",
        "constructs>=3.0.4, <4.0.0",
        "jsii>=1.12.0, <2.0.0",
        "publication>=0.0.3"
    ],
    "classifiers": [
        "Intended Audience :: Developers",
        "Operating System :: OS Independent",
        "Programming Language :: JavaScript",
        "Programming Language :: Python :: 3 :: Only",
        "Programming Language :: Python :: 3.6",
        "Programming Language :: Python :: 3.7",
        "Programming Language :: Python :: 3.8",
        "Typing :: Typed",
        "Development Status :: 4 - Beta",
        "License :: OSI Approved",
        "Framework :: AWS CDK",
        "Framework :: AWS CDK :: 1"
    ]
}
"""
)

with open("README.md") as fp:
    kwargs["long_description"] = fp.read()


setuptools.setup(**kwargs)
