# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['AlertGroupingSettingArgs', 'AlertGroupingSetting']

@pulumi.input_type
class AlertGroupingSettingArgs:
    def __init__(__self__, *,
                 services: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 type: pulumi.Input[_builtins.str],
                 config: Optional[pulumi.Input['AlertGroupingSettingConfigArgs']] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a AlertGroupingSetting resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] services: [Updating can cause a resource replacement] The list IDs of services associated to this setting.
        :param pulumi.Input[_builtins.str] type: The type of alert grouping; one of `intelligent`, `time`, `content_based` or  `content_based_intelligent`.
        :param pulumi.Input['AlertGroupingSettingConfigArgs'] config: The set of values used for configuration.
        :param pulumi.Input[_builtins.str] description: A human-friendly text to describe and identify this alert grouping setting.
        :param pulumi.Input[_builtins.str] name: The name for the alert groupig settings.
        """
        pulumi.set(__self__, "services", services)
        pulumi.set(__self__, "type", type)
        if config is not None:
            pulumi.set(__self__, "config", config)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter
    def services(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        [Updating can cause a resource replacement] The list IDs of services associated to this setting.
        """
        return pulumi.get(self, "services")

    @services.setter
    def services(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "services", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Input[_builtins.str]:
        """
        The type of alert grouping; one of `intelligent`, `time`, `content_based` or  `content_based_intelligent`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter
    def config(self) -> Optional[pulumi.Input['AlertGroupingSettingConfigArgs']]:
        """
        The set of values used for configuration.
        """
        return pulumi.get(self, "config")

    @config.setter
    def config(self, value: Optional[pulumi.Input['AlertGroupingSettingConfigArgs']]):
        pulumi.set(self, "config", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A human-friendly text to describe and identify this alert grouping setting.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name for the alert groupig settings.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _AlertGroupingSettingState:
    def __init__(__self__, *,
                 config: Optional[pulumi.Input['AlertGroupingSettingConfigArgs']] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 services: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering AlertGroupingSetting resources.
        :param pulumi.Input['AlertGroupingSettingConfigArgs'] config: The set of values used for configuration.
        :param pulumi.Input[_builtins.str] description: A human-friendly text to describe and identify this alert grouping setting.
        :param pulumi.Input[_builtins.str] name: The name for the alert groupig settings.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] services: [Updating can cause a resource replacement] The list IDs of services associated to this setting.
        :param pulumi.Input[_builtins.str] type: The type of alert grouping; one of `intelligent`, `time`, `content_based` or  `content_based_intelligent`.
        """
        if config is not None:
            pulumi.set(__self__, "config", config)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if services is not None:
            pulumi.set(__self__, "services", services)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def config(self) -> Optional[pulumi.Input['AlertGroupingSettingConfigArgs']]:
        """
        The set of values used for configuration.
        """
        return pulumi.get(self, "config")

    @config.setter
    def config(self, value: Optional[pulumi.Input['AlertGroupingSettingConfigArgs']]):
        pulumi.set(self, "config", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A human-friendly text to describe and identify this alert grouping setting.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name for the alert groupig settings.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def services(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        [Updating can cause a resource replacement] The list IDs of services associated to this setting.
        """
        return pulumi.get(self, "services")

    @services.setter
    def services(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "services", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of alert grouping; one of `intelligent`, `time`, `content_based` or  `content_based_intelligent`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)


@pulumi.type_token("pagerduty:index/alertGroupingSetting:AlertGroupingSetting")
class AlertGroupingSetting(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 config: Optional[pulumi.Input[Union['AlertGroupingSettingConfigArgs', 'AlertGroupingSettingConfigArgsDict']]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 services: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        An [alert grouping setting](https://developer.pagerduty.com/api-reference/587edbc8ff416-create-an-alert-grouping-setting)
        stores and centralize the configuration used during grouping of the alerts.

        ## Migration from `alert_grouping_parameters`

        To migrate from using the field `alert_grouping_parameters` of a
        service
        to a `AlertGroupingSetting` resource, you can cut-and-paste the
        contents of an `alert_grouping_parameters` field from a `Service`
        resource into the new resource, but you also need to add at least one value in
        the field `services` to create the alert grouping setting with a service
        associated to it.

        If you are using `timeout = 0` or `time_window = 0` in order to use the values
        recommended by PagerDuty you also need to set its value to null or delete it,
        since a value of `0` is no longer accepted.

        **Example**:

        Before:
        ```python
        import pulumi
        import pulumi_pagerduty as pagerduty

        default = pagerduty.get_escalation_policy(name="Default")
        foo = pagerduty.Service("foo",
            name="Foo",
            escalation_policy=default.id,
            alert_grouping_parameters={
                "type": "time",
                "config": {
                    "timeout": 0,
                },
            })
        ```

        After:
        ## Import

        Alert grouping settings can be imported using its `id`, e.g.

        ```sh
        $ pulumi import pagerduty:index/alertGroupingSetting:AlertGroupingSetting example P3DH5M6
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['AlertGroupingSettingConfigArgs', 'AlertGroupingSettingConfigArgsDict']] config: The set of values used for configuration.
        :param pulumi.Input[_builtins.str] description: A human-friendly text to describe and identify this alert grouping setting.
        :param pulumi.Input[_builtins.str] name: The name for the alert groupig settings.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] services: [Updating can cause a resource replacement] The list IDs of services associated to this setting.
        :param pulumi.Input[_builtins.str] type: The type of alert grouping; one of `intelligent`, `time`, `content_based` or  `content_based_intelligent`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AlertGroupingSettingArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        An [alert grouping setting](https://developer.pagerduty.com/api-reference/587edbc8ff416-create-an-alert-grouping-setting)
        stores and centralize the configuration used during grouping of the alerts.

        ## Migration from `alert_grouping_parameters`

        To migrate from using the field `alert_grouping_parameters` of a
        service
        to a `AlertGroupingSetting` resource, you can cut-and-paste the
        contents of an `alert_grouping_parameters` field from a `Service`
        resource into the new resource, but you also need to add at least one value in
        the field `services` to create the alert grouping setting with a service
        associated to it.

        If you are using `timeout = 0` or `time_window = 0` in order to use the values
        recommended by PagerDuty you also need to set its value to null or delete it,
        since a value of `0` is no longer accepted.

        **Example**:

        Before:
        ```python
        import pulumi
        import pulumi_pagerduty as pagerduty

        default = pagerduty.get_escalation_policy(name="Default")
        foo = pagerduty.Service("foo",
            name="Foo",
            escalation_policy=default.id,
            alert_grouping_parameters={
                "type": "time",
                "config": {
                    "timeout": 0,
                },
            })
        ```

        After:
        ## Import

        Alert grouping settings can be imported using its `id`, e.g.

        ```sh
        $ pulumi import pagerduty:index/alertGroupingSetting:AlertGroupingSetting example P3DH5M6
        ```

        :param str resource_name: The name of the resource.
        :param AlertGroupingSettingArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AlertGroupingSettingArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 config: Optional[pulumi.Input[Union['AlertGroupingSettingConfigArgs', 'AlertGroupingSettingConfigArgsDict']]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 services: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AlertGroupingSettingArgs.__new__(AlertGroupingSettingArgs)

            __props__.__dict__["config"] = config
            __props__.__dict__["description"] = description
            __props__.__dict__["name"] = name
            if services is None and not opts.urn:
                raise TypeError("Missing required property 'services'")
            __props__.__dict__["services"] = services
            if type is None and not opts.urn:
                raise TypeError("Missing required property 'type'")
            __props__.__dict__["type"] = type
        super(AlertGroupingSetting, __self__).__init__(
            'pagerduty:index/alertGroupingSetting:AlertGroupingSetting',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            config: Optional[pulumi.Input[Union['AlertGroupingSettingConfigArgs', 'AlertGroupingSettingConfigArgsDict']]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            services: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            type: Optional[pulumi.Input[_builtins.str]] = None) -> 'AlertGroupingSetting':
        """
        Get an existing AlertGroupingSetting resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['AlertGroupingSettingConfigArgs', 'AlertGroupingSettingConfigArgsDict']] config: The set of values used for configuration.
        :param pulumi.Input[_builtins.str] description: A human-friendly text to describe and identify this alert grouping setting.
        :param pulumi.Input[_builtins.str] name: The name for the alert groupig settings.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] services: [Updating can cause a resource replacement] The list IDs of services associated to this setting.
        :param pulumi.Input[_builtins.str] type: The type of alert grouping; one of `intelligent`, `time`, `content_based` or  `content_based_intelligent`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AlertGroupingSettingState.__new__(_AlertGroupingSettingState)

        __props__.__dict__["config"] = config
        __props__.__dict__["description"] = description
        __props__.__dict__["name"] = name
        __props__.__dict__["services"] = services
        __props__.__dict__["type"] = type
        return AlertGroupingSetting(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def config(self) -> pulumi.Output[Optional['outputs.AlertGroupingSettingConfig']]:
        """
        The set of values used for configuration.
        """
        return pulumi.get(self, "config")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[_builtins.str]:
        """
        A human-friendly text to describe and identify this alert grouping setting.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name for the alert groupig settings.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def services(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        [Updating can cause a resource replacement] The list IDs of services associated to this setting.
        """
        return pulumi.get(self, "services")

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Output[_builtins.str]:
        """
        The type of alert grouping; one of `intelligent`, `time`, `content_based` or  `content_based_intelligent`.
        """
        return pulumi.get(self, "type")

