# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'BuildxBuilderDockerContainer',
    'BuildxBuilderKubernetes',
    'BuildxBuilderKubernetesLimits',
    'BuildxBuilderKubernetesQemu',
    'BuildxBuilderKubernetesRequests',
    'BuildxBuilderRemote',
    'ContainerCapabilities',
    'ContainerDevice',
    'ContainerHealthcheck',
    'ContainerHost',
    'ContainerLabel',
    'ContainerMount',
    'ContainerMountBindOptions',
    'ContainerMountTmpfsOptions',
    'ContainerMountVolumeOptions',
    'ContainerMountVolumeOptionsLabel',
    'ContainerNetworkData',
    'ContainerNetworksAdvanced',
    'ContainerPort',
    'ContainerUlimit',
    'ContainerUpload',
    'ContainerVolume',
    'NetworkIpamConfig',
    'NetworkLabel',
    'PluginGrantPermission',
    'RegistryImageAuthConfig',
    'RegistryImageBuild',
    'RegistryImageBuildAuthConfig',
    'RegistryImageBuildSecret',
    'RegistryImageBuildUlimit',
    'RemoteImageBuild',
    'RemoteImageBuildAuthConfig',
    'RemoteImageBuildSecret',
    'RemoteImageBuildUlimit',
    'SecretLabel',
    'ServiceAuth',
    'ServiceConvergeConfig',
    'ServiceEndpointSpec',
    'ServiceEndpointSpecPort',
    'ServiceLabel',
    'ServiceMode',
    'ServiceModeReplicated',
    'ServiceRollbackConfig',
    'ServiceTaskSpec',
    'ServiceTaskSpecContainerSpec',
    'ServiceTaskSpecContainerSpecConfig',
    'ServiceTaskSpecContainerSpecDnsConfig',
    'ServiceTaskSpecContainerSpecHealthcheck',
    'ServiceTaskSpecContainerSpecHost',
    'ServiceTaskSpecContainerSpecLabel',
    'ServiceTaskSpecContainerSpecMount',
    'ServiceTaskSpecContainerSpecMountBindOptions',
    'ServiceTaskSpecContainerSpecMountTmpfsOptions',
    'ServiceTaskSpecContainerSpecMountVolumeOptions',
    'ServiceTaskSpecContainerSpecMountVolumeOptionsLabel',
    'ServiceTaskSpecContainerSpecPrivileges',
    'ServiceTaskSpecContainerSpecPrivilegesCredentialSpec',
    'ServiceTaskSpecContainerSpecPrivilegesSeLinuxContext',
    'ServiceTaskSpecContainerSpecSecret',
    'ServiceTaskSpecLogDriver',
    'ServiceTaskSpecNetworksAdvanced',
    'ServiceTaskSpecPlacement',
    'ServiceTaskSpecPlacementPlatform',
    'ServiceTaskSpecResources',
    'ServiceTaskSpecResourcesLimits',
    'ServiceTaskSpecResourcesReservation',
    'ServiceTaskSpecResourcesReservationGenericResources',
    'ServiceTaskSpecRestartPolicy',
    'ServiceUpdateConfig',
    'VolumeCluster',
    'VolumeLabel',
    'GetNetworkIpamConfigResult',
    'GetRegistryImageManifestsAuthConfigResult',
    'GetRegistryImageManifestsManifestResult',
]

@pulumi.output_type
class BuildxBuilderDockerContainer(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cgroupParent":
            suggest = "cgroup_parent"
        elif key == "cpuPeriod":
            suggest = "cpu_period"
        elif key == "cpuQuota":
            suggest = "cpu_quota"
        elif key == "cpuShares":
            suggest = "cpu_shares"
        elif key == "cpusetCpus":
            suggest = "cpuset_cpus"
        elif key == "cpusetMems":
            suggest = "cpuset_mems"
        elif key == "defaultLoad":
            suggest = "default_load"
        elif key == "memorySwap":
            suggest = "memory_swap"
        elif key == "restartPolicy":
            suggest = "restart_policy"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BuildxBuilderDockerContainer. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BuildxBuilderDockerContainer.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BuildxBuilderDockerContainer.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cgroup_parent: Optional[_builtins.str] = None,
                 cpu_period: Optional[_builtins.str] = None,
                 cpu_quota: Optional[_builtins.str] = None,
                 cpu_shares: Optional[_builtins.str] = None,
                 cpuset_cpus: Optional[_builtins.str] = None,
                 cpuset_mems: Optional[_builtins.str] = None,
                 default_load: Optional[_builtins.bool] = None,
                 env: Optional[Mapping[str, _builtins.str]] = None,
                 image: Optional[_builtins.str] = None,
                 memory: Optional[_builtins.str] = None,
                 memory_swap: Optional[_builtins.str] = None,
                 network: Optional[_builtins.str] = None,
                 restart_policy: Optional[_builtins.str] = None):
        """
        :param _builtins.str cgroup_parent: Sets the cgroup parent of the container if Docker is using the "cgroupfs" driver.
        :param _builtins.str cpu_period: Sets the CPU CFS scheduler period for the container.
        :param _builtins.str cpu_quota: Imposes a CPU CFS quota on the container.
        :param _builtins.str cpu_shares: Configures CPU shares (relative weight) of the container.
        :param _builtins.str cpuset_cpus: Limits the set of CPU cores the container can use.
        :param _builtins.str cpuset_mems: Limits the set of CPU memory nodes the container can use.
        :param _builtins.bool default_load: Automatically load images to the Docker Engine image store. Defaults to `false`
        :param Mapping[str, _builtins.str] env: Sets environment variables in the container.
        :param _builtins.str image: Sets the BuildKit image to use for the container.
        :param _builtins.str memory: Sets the amount of memory the container can use.
        :param _builtins.str memory_swap: Sets the memory swap limit for the container.
        :param _builtins.str network: Sets the network mode for the container.
        :param _builtins.str restart_policy: Sets the container's restart policy.
        """
        if cgroup_parent is not None:
            pulumi.set(__self__, "cgroup_parent", cgroup_parent)
        if cpu_period is not None:
            pulumi.set(__self__, "cpu_period", cpu_period)
        if cpu_quota is not None:
            pulumi.set(__self__, "cpu_quota", cpu_quota)
        if cpu_shares is not None:
            pulumi.set(__self__, "cpu_shares", cpu_shares)
        if cpuset_cpus is not None:
            pulumi.set(__self__, "cpuset_cpus", cpuset_cpus)
        if cpuset_mems is not None:
            pulumi.set(__self__, "cpuset_mems", cpuset_mems)
        if default_load is not None:
            pulumi.set(__self__, "default_load", default_load)
        if env is not None:
            pulumi.set(__self__, "env", env)
        if image is not None:
            pulumi.set(__self__, "image", image)
        if memory is not None:
            pulumi.set(__self__, "memory", memory)
        if memory_swap is not None:
            pulumi.set(__self__, "memory_swap", memory_swap)
        if network is not None:
            pulumi.set(__self__, "network", network)
        if restart_policy is not None:
            pulumi.set(__self__, "restart_policy", restart_policy)

    @_builtins.property
    @pulumi.getter(name="cgroupParent")
    def cgroup_parent(self) -> Optional[_builtins.str]:
        """
        Sets the cgroup parent of the container if Docker is using the "cgroupfs" driver.
        """
        return pulumi.get(self, "cgroup_parent")

    @_builtins.property
    @pulumi.getter(name="cpuPeriod")
    def cpu_period(self) -> Optional[_builtins.str]:
        """
        Sets the CPU CFS scheduler period for the container.
        """
        return pulumi.get(self, "cpu_period")

    @_builtins.property
    @pulumi.getter(name="cpuQuota")
    def cpu_quota(self) -> Optional[_builtins.str]:
        """
        Imposes a CPU CFS quota on the container.
        """
        return pulumi.get(self, "cpu_quota")

    @_builtins.property
    @pulumi.getter(name="cpuShares")
    def cpu_shares(self) -> Optional[_builtins.str]:
        """
        Configures CPU shares (relative weight) of the container.
        """
        return pulumi.get(self, "cpu_shares")

    @_builtins.property
    @pulumi.getter(name="cpusetCpus")
    def cpuset_cpus(self) -> Optional[_builtins.str]:
        """
        Limits the set of CPU cores the container can use.
        """
        return pulumi.get(self, "cpuset_cpus")

    @_builtins.property
    @pulumi.getter(name="cpusetMems")
    def cpuset_mems(self) -> Optional[_builtins.str]:
        """
        Limits the set of CPU memory nodes the container can use.
        """
        return pulumi.get(self, "cpuset_mems")

    @_builtins.property
    @pulumi.getter(name="defaultLoad")
    def default_load(self) -> Optional[_builtins.bool]:
        """
        Automatically load images to the Docker Engine image store. Defaults to `false`
        """
        return pulumi.get(self, "default_load")

    @_builtins.property
    @pulumi.getter
    def env(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        Sets environment variables in the container.
        """
        return pulumi.get(self, "env")

    @_builtins.property
    @pulumi.getter
    def image(self) -> Optional[_builtins.str]:
        """
        Sets the BuildKit image to use for the container.
        """
        return pulumi.get(self, "image")

    @_builtins.property
    @pulumi.getter
    def memory(self) -> Optional[_builtins.str]:
        """
        Sets the amount of memory the container can use.
        """
        return pulumi.get(self, "memory")

    @_builtins.property
    @pulumi.getter(name="memorySwap")
    def memory_swap(self) -> Optional[_builtins.str]:
        """
        Sets the memory swap limit for the container.
        """
        return pulumi.get(self, "memory_swap")

    @_builtins.property
    @pulumi.getter
    def network(self) -> Optional[_builtins.str]:
        """
        Sets the network mode for the container.
        """
        return pulumi.get(self, "network")

    @_builtins.property
    @pulumi.getter(name="restartPolicy")
    def restart_policy(self) -> Optional[_builtins.str]:
        """
        Sets the container's restart policy.
        """
        return pulumi.get(self, "restart_policy")


@pulumi.output_type
class BuildxBuilderKubernetes(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "defaultLoad":
            suggest = "default_load"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BuildxBuilderKubernetes. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BuildxBuilderKubernetes.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BuildxBuilderKubernetes.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 annotations: Optional[_builtins.str] = None,
                 default_load: Optional[_builtins.bool] = None,
                 image: Optional[_builtins.str] = None,
                 labels: Optional[_builtins.str] = None,
                 limits: Optional['outputs.BuildxBuilderKubernetesLimits'] = None,
                 loadbalance: Optional[_builtins.str] = None,
                 namespace: Optional[_builtins.str] = None,
                 nodeselector: Optional[_builtins.str] = None,
                 qemu: Optional['outputs.BuildxBuilderKubernetesQemu'] = None,
                 replicas: Optional[_builtins.int] = None,
                 requests: Optional['outputs.BuildxBuilderKubernetesRequests'] = None,
                 rootless: Optional[_builtins.bool] = None,
                 schedulername: Optional[_builtins.str] = None,
                 serviceaccount: Optional[_builtins.str] = None,
                 timeout: Optional[_builtins.str] = None,
                 tolerations: Optional[_builtins.str] = None):
        """
        :param _builtins.str annotations: Sets additional annotations on the deployments and pods.
        :param _builtins.bool default_load: Automatically load images to the Docker Engine image store. Defaults to `false`
        :param _builtins.str image: Sets the image to use for running BuildKit.
        :param _builtins.str labels: Sets additional labels on the deployments and pods.
        :param 'BuildxBuilderKubernetesLimitsArgs' limits: Resource limits for CPU, memory, and ephemeral storage.
        :param _builtins.str loadbalance: Load-balancing strategy (sticky or random).
        :param _builtins.str namespace: Sets the Kubernetes namespace.
        :param _builtins.str nodeselector: Sets the pod's nodeSelector label(s).
        :param 'BuildxBuilderKubernetesQemuArgs' qemu: QEMU emulation configuration.
        :param _builtins.int replicas: Sets the number of Pod replicas to create.
        :param 'BuildxBuilderKubernetesRequestsArgs' requests: Resource requests for CPU, memory, and ephemeral storage.
        :param _builtins.bool rootless: Run the container as a non-root user.
        :param _builtins.str schedulername: Sets the scheduler responsible for scheduling the pod.
        :param _builtins.str serviceaccount: Sets the pod's serviceAccountName.
        :param _builtins.str timeout: Set the timeout limit for pod provisioning.
        :param _builtins.str tolerations: Configures the pod's taint toleration.
        """
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if default_load is not None:
            pulumi.set(__self__, "default_load", default_load)
        if image is not None:
            pulumi.set(__self__, "image", image)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if limits is not None:
            pulumi.set(__self__, "limits", limits)
        if loadbalance is not None:
            pulumi.set(__self__, "loadbalance", loadbalance)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if nodeselector is not None:
            pulumi.set(__self__, "nodeselector", nodeselector)
        if qemu is not None:
            pulumi.set(__self__, "qemu", qemu)
        if replicas is not None:
            pulumi.set(__self__, "replicas", replicas)
        if requests is not None:
            pulumi.set(__self__, "requests", requests)
        if rootless is not None:
            pulumi.set(__self__, "rootless", rootless)
        if schedulername is not None:
            pulumi.set(__self__, "schedulername", schedulername)
        if serviceaccount is not None:
            pulumi.set(__self__, "serviceaccount", serviceaccount)
        if timeout is not None:
            pulumi.set(__self__, "timeout", timeout)
        if tolerations is not None:
            pulumi.set(__self__, "tolerations", tolerations)

    @_builtins.property
    @pulumi.getter
    def annotations(self) -> Optional[_builtins.str]:
        """
        Sets additional annotations on the deployments and pods.
        """
        return pulumi.get(self, "annotations")

    @_builtins.property
    @pulumi.getter(name="defaultLoad")
    def default_load(self) -> Optional[_builtins.bool]:
        """
        Automatically load images to the Docker Engine image store. Defaults to `false`
        """
        return pulumi.get(self, "default_load")

    @_builtins.property
    @pulumi.getter
    def image(self) -> Optional[_builtins.str]:
        """
        Sets the image to use for running BuildKit.
        """
        return pulumi.get(self, "image")

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[_builtins.str]:
        """
        Sets additional labels on the deployments and pods.
        """
        return pulumi.get(self, "labels")

    @_builtins.property
    @pulumi.getter
    def limits(self) -> Optional['outputs.BuildxBuilderKubernetesLimits']:
        """
        Resource limits for CPU, memory, and ephemeral storage.
        """
        return pulumi.get(self, "limits")

    @_builtins.property
    @pulumi.getter
    def loadbalance(self) -> Optional[_builtins.str]:
        """
        Load-balancing strategy (sticky or random).
        """
        return pulumi.get(self, "loadbalance")

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> Optional[_builtins.str]:
        """
        Sets the Kubernetes namespace.
        """
        return pulumi.get(self, "namespace")

    @_builtins.property
    @pulumi.getter
    def nodeselector(self) -> Optional[_builtins.str]:
        """
        Sets the pod's nodeSelector label(s).
        """
        return pulumi.get(self, "nodeselector")

    @_builtins.property
    @pulumi.getter
    def qemu(self) -> Optional['outputs.BuildxBuilderKubernetesQemu']:
        """
        QEMU emulation configuration.
        """
        return pulumi.get(self, "qemu")

    @_builtins.property
    @pulumi.getter
    def replicas(self) -> Optional[_builtins.int]:
        """
        Sets the number of Pod replicas to create.
        """
        return pulumi.get(self, "replicas")

    @_builtins.property
    @pulumi.getter
    def requests(self) -> Optional['outputs.BuildxBuilderKubernetesRequests']:
        """
        Resource requests for CPU, memory, and ephemeral storage.
        """
        return pulumi.get(self, "requests")

    @_builtins.property
    @pulumi.getter
    def rootless(self) -> Optional[_builtins.bool]:
        """
        Run the container as a non-root user.
        """
        return pulumi.get(self, "rootless")

    @_builtins.property
    @pulumi.getter
    def schedulername(self) -> Optional[_builtins.str]:
        """
        Sets the scheduler responsible for scheduling the pod.
        """
        return pulumi.get(self, "schedulername")

    @_builtins.property
    @pulumi.getter
    def serviceaccount(self) -> Optional[_builtins.str]:
        """
        Sets the pod's serviceAccountName.
        """
        return pulumi.get(self, "serviceaccount")

    @_builtins.property
    @pulumi.getter
    def timeout(self) -> Optional[_builtins.str]:
        """
        Set the timeout limit for pod provisioning.
        """
        return pulumi.get(self, "timeout")

    @_builtins.property
    @pulumi.getter
    def tolerations(self) -> Optional[_builtins.str]:
        """
        Configures the pod's taint toleration.
        """
        return pulumi.get(self, "tolerations")


@pulumi.output_type
class BuildxBuilderKubernetesLimits(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ephemeralStorage":
            suggest = "ephemeral_storage"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BuildxBuilderKubernetesLimits. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BuildxBuilderKubernetesLimits.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BuildxBuilderKubernetesLimits.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cpu: Optional[_builtins.str] = None,
                 ephemeral_storage: Optional[_builtins.str] = None,
                 memory: Optional[_builtins.str] = None):
        """
        :param _builtins.str cpu: CPU limit for the Kubernetes pod.
        :param _builtins.str ephemeral_storage: Ephemeral storage limit for the Kubernetes pod.
        :param _builtins.str memory: Memory limit for the Kubernetes pod.
        """
        if cpu is not None:
            pulumi.set(__self__, "cpu", cpu)
        if ephemeral_storage is not None:
            pulumi.set(__self__, "ephemeral_storage", ephemeral_storage)
        if memory is not None:
            pulumi.set(__self__, "memory", memory)

    @_builtins.property
    @pulumi.getter
    def cpu(self) -> Optional[_builtins.str]:
        """
        CPU limit for the Kubernetes pod.
        """
        return pulumi.get(self, "cpu")

    @_builtins.property
    @pulumi.getter(name="ephemeralStorage")
    def ephemeral_storage(self) -> Optional[_builtins.str]:
        """
        Ephemeral storage limit for the Kubernetes pod.
        """
        return pulumi.get(self, "ephemeral_storage")

    @_builtins.property
    @pulumi.getter
    def memory(self) -> Optional[_builtins.str]:
        """
        Memory limit for the Kubernetes pod.
        """
        return pulumi.get(self, "memory")


@pulumi.output_type
class BuildxBuilderKubernetesQemu(dict):
    def __init__(__self__, *,
                 image: Optional[_builtins.str] = None,
                 install: Optional[_builtins.bool] = None):
        """
        :param _builtins.str image: Sets the QEMU emulation image.
        :param _builtins.bool install: Install QEMU emulation for multi-platform support.
        """
        if image is not None:
            pulumi.set(__self__, "image", image)
        if install is not None:
            pulumi.set(__self__, "install", install)

    @_builtins.property
    @pulumi.getter
    def image(self) -> Optional[_builtins.str]:
        """
        Sets the QEMU emulation image.
        """
        return pulumi.get(self, "image")

    @_builtins.property
    @pulumi.getter
    def install(self) -> Optional[_builtins.bool]:
        """
        Install QEMU emulation for multi-platform support.
        """
        return pulumi.get(self, "install")


@pulumi.output_type
class BuildxBuilderKubernetesRequests(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ephemeralStorage":
            suggest = "ephemeral_storage"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BuildxBuilderKubernetesRequests. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BuildxBuilderKubernetesRequests.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BuildxBuilderKubernetesRequests.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cpu: Optional[_builtins.str] = None,
                 ephemeral_storage: Optional[_builtins.str] = None,
                 memory: Optional[_builtins.str] = None):
        """
        :param _builtins.str cpu: CPU limit for the Kubernetes pod.
        :param _builtins.str ephemeral_storage: Ephemeral storage limit for the Kubernetes pod.
        :param _builtins.str memory: Memory limit for the Kubernetes pod.
        """
        if cpu is not None:
            pulumi.set(__self__, "cpu", cpu)
        if ephemeral_storage is not None:
            pulumi.set(__self__, "ephemeral_storage", ephemeral_storage)
        if memory is not None:
            pulumi.set(__self__, "memory", memory)

    @_builtins.property
    @pulumi.getter
    def cpu(self) -> Optional[_builtins.str]:
        """
        CPU limit for the Kubernetes pod.
        """
        return pulumi.get(self, "cpu")

    @_builtins.property
    @pulumi.getter(name="ephemeralStorage")
    def ephemeral_storage(self) -> Optional[_builtins.str]:
        """
        Ephemeral storage limit for the Kubernetes pod.
        """
        return pulumi.get(self, "ephemeral_storage")

    @_builtins.property
    @pulumi.getter
    def memory(self) -> Optional[_builtins.str]:
        """
        Memory limit for the Kubernetes pod.
        """
        return pulumi.get(self, "memory")


@pulumi.output_type
class BuildxBuilderRemote(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "defaultLoad":
            suggest = "default_load"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BuildxBuilderRemote. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BuildxBuilderRemote.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BuildxBuilderRemote.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cacert: Optional[_builtins.str] = None,
                 cert: Optional[_builtins.str] = None,
                 default_load: Optional[_builtins.bool] = None,
                 key: Optional[_builtins.str] = None,
                 servername: Optional[_builtins.str] = None):
        """
        :param _builtins.str cacert: Absolute path to the TLS certificate authority used for validation.
        :param _builtins.str cert: Absolute path to the TLS client certificate to present to buildkitd.
        :param _builtins.bool default_load: Automatically load images to the Docker Engine image store. Defaults to `false`
        :param _builtins.str key: Sets the TLS client key.
        :param _builtins.str servername: TLS server name used in requests.
        """
        if cacert is not None:
            pulumi.set(__self__, "cacert", cacert)
        if cert is not None:
            pulumi.set(__self__, "cert", cert)
        if default_load is not None:
            pulumi.set(__self__, "default_load", default_load)
        if key is not None:
            pulumi.set(__self__, "key", key)
        if servername is not None:
            pulumi.set(__self__, "servername", servername)

    @_builtins.property
    @pulumi.getter
    def cacert(self) -> Optional[_builtins.str]:
        """
        Absolute path to the TLS certificate authority used for validation.
        """
        return pulumi.get(self, "cacert")

    @_builtins.property
    @pulumi.getter
    def cert(self) -> Optional[_builtins.str]:
        """
        Absolute path to the TLS client certificate to present to buildkitd.
        """
        return pulumi.get(self, "cert")

    @_builtins.property
    @pulumi.getter(name="defaultLoad")
    def default_load(self) -> Optional[_builtins.bool]:
        """
        Automatically load images to the Docker Engine image store. Defaults to `false`
        """
        return pulumi.get(self, "default_load")

    @_builtins.property
    @pulumi.getter
    def key(self) -> Optional[_builtins.str]:
        """
        Sets the TLS client key.
        """
        return pulumi.get(self, "key")

    @_builtins.property
    @pulumi.getter
    def servername(self) -> Optional[_builtins.str]:
        """
        TLS server name used in requests.
        """
        return pulumi.get(self, "servername")


@pulumi.output_type
class ContainerCapabilities(dict):
    def __init__(__self__, *,
                 adds: Optional[Sequence[_builtins.str]] = None,
                 drops: Optional[Sequence[_builtins.str]] = None):
        """
        :param Sequence[_builtins.str] adds: List of linux capabilities to add.
        :param Sequence[_builtins.str] drops: List of linux capabilities to drop.
        """
        if adds is not None:
            pulumi.set(__self__, "adds", adds)
        if drops is not None:
            pulumi.set(__self__, "drops", drops)

    @_builtins.property
    @pulumi.getter
    def adds(self) -> Optional[Sequence[_builtins.str]]:
        """
        List of linux capabilities to add.
        """
        return pulumi.get(self, "adds")

    @_builtins.property
    @pulumi.getter
    def drops(self) -> Optional[Sequence[_builtins.str]]:
        """
        List of linux capabilities to drop.
        """
        return pulumi.get(self, "drops")


@pulumi.output_type
class ContainerDevice(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "hostPath":
            suggest = "host_path"
        elif key == "containerPath":
            suggest = "container_path"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ContainerDevice. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ContainerDevice.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ContainerDevice.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 host_path: _builtins.str,
                 container_path: Optional[_builtins.str] = None,
                 permissions: Optional[_builtins.str] = None):
        """
        :param _builtins.str host_path: The path on the host where the device is located.
        :param _builtins.str container_path: The path in the container where the device will be bound.
        :param _builtins.str permissions: The cgroup permissions given to the container to access the device. Defaults to `rwm`.
        """
        pulumi.set(__self__, "host_path", host_path)
        if container_path is not None:
            pulumi.set(__self__, "container_path", container_path)
        if permissions is not None:
            pulumi.set(__self__, "permissions", permissions)

    @_builtins.property
    @pulumi.getter(name="hostPath")
    def host_path(self) -> _builtins.str:
        """
        The path on the host where the device is located.
        """
        return pulumi.get(self, "host_path")

    @_builtins.property
    @pulumi.getter(name="containerPath")
    def container_path(self) -> Optional[_builtins.str]:
        """
        The path in the container where the device will be bound.
        """
        return pulumi.get(self, "container_path")

    @_builtins.property
    @pulumi.getter
    def permissions(self) -> Optional[_builtins.str]:
        """
        The cgroup permissions given to the container to access the device. Defaults to `rwm`.
        """
        return pulumi.get(self, "permissions")


@pulumi.output_type
class ContainerHealthcheck(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "startInterval":
            suggest = "start_interval"
        elif key == "startPeriod":
            suggest = "start_period"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ContainerHealthcheck. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ContainerHealthcheck.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ContainerHealthcheck.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 tests: Sequence[_builtins.str],
                 interval: Optional[_builtins.str] = None,
                 retries: Optional[_builtins.int] = None,
                 start_interval: Optional[_builtins.str] = None,
                 start_period: Optional[_builtins.str] = None,
                 timeout: Optional[_builtins.str] = None):
        """
        :param Sequence[_builtins.str] tests: Command to run to check health. For example, to run `curl -f localhost/health` set the command to be `["CMD", "curl", "-f", "localhost/health"]`.
        :param _builtins.str interval: Time between running the check (ms|s|m|h). Defaults to `0s`.
        :param _builtins.int retries: Consecutive failures needed to report unhealthy. Defaults to `0`.
        :param _builtins.str start_interval: Interval before the healthcheck starts (ms|s|m|h). Defaults to `0s`.
        :param _builtins.str start_period: Start period for the container to initialize before counting retries towards unstable (ms|s|m|h). Defaults to `0s`.
        :param _builtins.str timeout: Maximum time to allow one check to run (ms|s|m|h). Defaults to `0s`.
        """
        pulumi.set(__self__, "tests", tests)
        if interval is not None:
            pulumi.set(__self__, "interval", interval)
        if retries is not None:
            pulumi.set(__self__, "retries", retries)
        if start_interval is not None:
            pulumi.set(__self__, "start_interval", start_interval)
        if start_period is not None:
            pulumi.set(__self__, "start_period", start_period)
        if timeout is not None:
            pulumi.set(__self__, "timeout", timeout)

    @_builtins.property
    @pulumi.getter
    def tests(self) -> Sequence[_builtins.str]:
        """
        Command to run to check health. For example, to run `curl -f localhost/health` set the command to be `["CMD", "curl", "-f", "localhost/health"]`.
        """
        return pulumi.get(self, "tests")

    @_builtins.property
    @pulumi.getter
    def interval(self) -> Optional[_builtins.str]:
        """
        Time between running the check (ms|s|m|h). Defaults to `0s`.
        """
        return pulumi.get(self, "interval")

    @_builtins.property
    @pulumi.getter
    def retries(self) -> Optional[_builtins.int]:
        """
        Consecutive failures needed to report unhealthy. Defaults to `0`.
        """
        return pulumi.get(self, "retries")

    @_builtins.property
    @pulumi.getter(name="startInterval")
    def start_interval(self) -> Optional[_builtins.str]:
        """
        Interval before the healthcheck starts (ms|s|m|h). Defaults to `0s`.
        """
        return pulumi.get(self, "start_interval")

    @_builtins.property
    @pulumi.getter(name="startPeriod")
    def start_period(self) -> Optional[_builtins.str]:
        """
        Start period for the container to initialize before counting retries towards unstable (ms|s|m|h). Defaults to `0s`.
        """
        return pulumi.get(self, "start_period")

    @_builtins.property
    @pulumi.getter
    def timeout(self) -> Optional[_builtins.str]:
        """
        Maximum time to allow one check to run (ms|s|m|h). Defaults to `0s`.
        """
        return pulumi.get(self, "timeout")


@pulumi.output_type
class ContainerHost(dict):
    def __init__(__self__, *,
                 host: _builtins.str,
                 ip: _builtins.str):
        """
        :param _builtins.str host: Hostname to add
        :param _builtins.str ip: IP address this hostname should resolve to.
        """
        pulumi.set(__self__, "host", host)
        pulumi.set(__self__, "ip", ip)

    @_builtins.property
    @pulumi.getter
    def host(self) -> _builtins.str:
        """
        Hostname to add
        """
        return pulumi.get(self, "host")

    @_builtins.property
    @pulumi.getter
    def ip(self) -> _builtins.str:
        """
        IP address this hostname should resolve to.
        """
        return pulumi.get(self, "ip")


@pulumi.output_type
class ContainerLabel(dict):
    def __init__(__self__, *,
                 label: _builtins.str,
                 value: _builtins.str):
        """
        :param _builtins.str label: Name of the label
        :param _builtins.str value: Value of the label
        """
        pulumi.set(__self__, "label", label)
        pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def label(self) -> _builtins.str:
        """
        Name of the label
        """
        return pulumi.get(self, "label")

    @_builtins.property
    @pulumi.getter
    def value(self) -> _builtins.str:
        """
        Value of the label
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class ContainerMount(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "bindOptions":
            suggest = "bind_options"
        elif key == "readOnly":
            suggest = "read_only"
        elif key == "tmpfsOptions":
            suggest = "tmpfs_options"
        elif key == "volumeOptions":
            suggest = "volume_options"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ContainerMount. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ContainerMount.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ContainerMount.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 target: _builtins.str,
                 type: _builtins.str,
                 bind_options: Optional['outputs.ContainerMountBindOptions'] = None,
                 read_only: Optional[_builtins.bool] = None,
                 source: Optional[_builtins.str] = None,
                 tmpfs_options: Optional['outputs.ContainerMountTmpfsOptions'] = None,
                 volume_options: Optional['outputs.ContainerMountVolumeOptions'] = None):
        """
        :param _builtins.str target: Container path
        :param _builtins.str type: The mount type
        :param 'ContainerMountBindOptionsArgs' bind_options: Optional configuration for the bind type.
        :param _builtins.bool read_only: Whether the mount should be read-only.
        :param _builtins.str source: Mount source (e.g. a volume name, a host path).
        :param 'ContainerMountTmpfsOptionsArgs' tmpfs_options: Optional configuration for the tmpfs type.
        :param 'ContainerMountVolumeOptionsArgs' volume_options: Optional configuration for the volume type.
        """
        pulumi.set(__self__, "target", target)
        pulumi.set(__self__, "type", type)
        if bind_options is not None:
            pulumi.set(__self__, "bind_options", bind_options)
        if read_only is not None:
            pulumi.set(__self__, "read_only", read_only)
        if source is not None:
            pulumi.set(__self__, "source", source)
        if tmpfs_options is not None:
            pulumi.set(__self__, "tmpfs_options", tmpfs_options)
        if volume_options is not None:
            pulumi.set(__self__, "volume_options", volume_options)

    @_builtins.property
    @pulumi.getter
    def target(self) -> _builtins.str:
        """
        Container path
        """
        return pulumi.get(self, "target")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        The mount type
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter(name="bindOptions")
    def bind_options(self) -> Optional['outputs.ContainerMountBindOptions']:
        """
        Optional configuration for the bind type.
        """
        return pulumi.get(self, "bind_options")

    @_builtins.property
    @pulumi.getter(name="readOnly")
    def read_only(self) -> Optional[_builtins.bool]:
        """
        Whether the mount should be read-only.
        """
        return pulumi.get(self, "read_only")

    @_builtins.property
    @pulumi.getter
    def source(self) -> Optional[_builtins.str]:
        """
        Mount source (e.g. a volume name, a host path).
        """
        return pulumi.get(self, "source")

    @_builtins.property
    @pulumi.getter(name="tmpfsOptions")
    def tmpfs_options(self) -> Optional['outputs.ContainerMountTmpfsOptions']:
        """
        Optional configuration for the tmpfs type.
        """
        return pulumi.get(self, "tmpfs_options")

    @_builtins.property
    @pulumi.getter(name="volumeOptions")
    def volume_options(self) -> Optional['outputs.ContainerMountVolumeOptions']:
        """
        Optional configuration for the volume type.
        """
        return pulumi.get(self, "volume_options")


@pulumi.output_type
class ContainerMountBindOptions(dict):
    def __init__(__self__, *,
                 propagation: Optional[_builtins.str] = None):
        """
        :param _builtins.str propagation: A propagation mode with the value.
        """
        if propagation is not None:
            pulumi.set(__self__, "propagation", propagation)

    @_builtins.property
    @pulumi.getter
    def propagation(self) -> Optional[_builtins.str]:
        """
        A propagation mode with the value.
        """
        return pulumi.get(self, "propagation")


@pulumi.output_type
class ContainerMountTmpfsOptions(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sizeBytes":
            suggest = "size_bytes"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ContainerMountTmpfsOptions. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ContainerMountTmpfsOptions.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ContainerMountTmpfsOptions.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 mode: Optional[_builtins.int] = None,
                 size_bytes: Optional[_builtins.int] = None):
        """
        :param _builtins.int mode: The permission mode for the tmpfs mount in an integer.
        :param _builtins.int size_bytes: The size for the tmpfs mount in bytes.
        """
        if mode is not None:
            pulumi.set(__self__, "mode", mode)
        if size_bytes is not None:
            pulumi.set(__self__, "size_bytes", size_bytes)

    @_builtins.property
    @pulumi.getter
    def mode(self) -> Optional[_builtins.int]:
        """
        The permission mode for the tmpfs mount in an integer.
        """
        return pulumi.get(self, "mode")

    @_builtins.property
    @pulumi.getter(name="sizeBytes")
    def size_bytes(self) -> Optional[_builtins.int]:
        """
        The size for the tmpfs mount in bytes.
        """
        return pulumi.get(self, "size_bytes")


@pulumi.output_type
class ContainerMountVolumeOptions(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "driverName":
            suggest = "driver_name"
        elif key == "driverOptions":
            suggest = "driver_options"
        elif key == "noCopy":
            suggest = "no_copy"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ContainerMountVolumeOptions. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ContainerMountVolumeOptions.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ContainerMountVolumeOptions.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 driver_name: Optional[_builtins.str] = None,
                 driver_options: Optional[Mapping[str, _builtins.str]] = None,
                 labels: Optional[Sequence['outputs.ContainerMountVolumeOptionsLabel']] = None,
                 no_copy: Optional[_builtins.bool] = None,
                 subpath: Optional[_builtins.str] = None):
        """
        :param _builtins.str driver_name: Name of the driver to use to create the volume.
        :param Mapping[str, _builtins.str] driver_options: key/value map of driver specific options.
        :param Sequence['ContainerMountVolumeOptionsLabelArgs'] labels: User-defined key/value metadata.
        :param _builtins.bool no_copy: Populate volume with data from the target.
        :param _builtins.str subpath: Path within the volume to mount. Requires docker server version 1.45 or higher.
        """
        if driver_name is not None:
            pulumi.set(__self__, "driver_name", driver_name)
        if driver_options is not None:
            pulumi.set(__self__, "driver_options", driver_options)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if no_copy is not None:
            pulumi.set(__self__, "no_copy", no_copy)
        if subpath is not None:
            pulumi.set(__self__, "subpath", subpath)

    @_builtins.property
    @pulumi.getter(name="driverName")
    def driver_name(self) -> Optional[_builtins.str]:
        """
        Name of the driver to use to create the volume.
        """
        return pulumi.get(self, "driver_name")

    @_builtins.property
    @pulumi.getter(name="driverOptions")
    def driver_options(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        key/value map of driver specific options.
        """
        return pulumi.get(self, "driver_options")

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[Sequence['outputs.ContainerMountVolumeOptionsLabel']]:
        """
        User-defined key/value metadata.
        """
        return pulumi.get(self, "labels")

    @_builtins.property
    @pulumi.getter(name="noCopy")
    def no_copy(self) -> Optional[_builtins.bool]:
        """
        Populate volume with data from the target.
        """
        return pulumi.get(self, "no_copy")

    @_builtins.property
    @pulumi.getter
    def subpath(self) -> Optional[_builtins.str]:
        """
        Path within the volume to mount. Requires docker server version 1.45 or higher.
        """
        return pulumi.get(self, "subpath")


@pulumi.output_type
class ContainerMountVolumeOptionsLabel(dict):
    def __init__(__self__, *,
                 label: _builtins.str,
                 value: _builtins.str):
        """
        :param _builtins.str label: Name of the label
        :param _builtins.str value: Value of the label
        """
        pulumi.set(__self__, "label", label)
        pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def label(self) -> _builtins.str:
        """
        Name of the label
        """
        return pulumi.get(self, "label")

    @_builtins.property
    @pulumi.getter
    def value(self) -> _builtins.str:
        """
        Value of the label
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class ContainerNetworkData(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "globalIpv6Address":
            suggest = "global_ipv6_address"
        elif key == "globalIpv6PrefixLength":
            suggest = "global_ipv6_prefix_length"
        elif key == "ipAddress":
            suggest = "ip_address"
        elif key == "ipPrefixLength":
            suggest = "ip_prefix_length"
        elif key == "ipv6Gateway":
            suggest = "ipv6_gateway"
        elif key == "macAddress":
            suggest = "mac_address"
        elif key == "networkName":
            suggest = "network_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ContainerNetworkData. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ContainerNetworkData.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ContainerNetworkData.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 gateway: Optional[_builtins.str] = None,
                 global_ipv6_address: Optional[_builtins.str] = None,
                 global_ipv6_prefix_length: Optional[_builtins.int] = None,
                 ip_address: Optional[_builtins.str] = None,
                 ip_prefix_length: Optional[_builtins.int] = None,
                 ipv6_gateway: Optional[_builtins.str] = None,
                 mac_address: Optional[_builtins.str] = None,
                 network_name: Optional[_builtins.str] = None):
        """
        :param _builtins.str gateway: The network gateway of the container.
        :param _builtins.str global_ipv6_address: The IPV6 address of the container.
        :param _builtins.int global_ipv6_prefix_length: The IPV6 prefix length address of the container.
        :param _builtins.str ip_address: The IP address of the container.
        :param _builtins.int ip_prefix_length: The IP prefix length of the container.
        :param _builtins.str ipv6_gateway: The IPV6 gateway of the container.
        :param _builtins.str mac_address: The MAC address of the container.
        :param _builtins.str network_name: The name of the network
        """
        if gateway is not None:
            pulumi.set(__self__, "gateway", gateway)
        if global_ipv6_address is not None:
            pulumi.set(__self__, "global_ipv6_address", global_ipv6_address)
        if global_ipv6_prefix_length is not None:
            pulumi.set(__self__, "global_ipv6_prefix_length", global_ipv6_prefix_length)
        if ip_address is not None:
            pulumi.set(__self__, "ip_address", ip_address)
        if ip_prefix_length is not None:
            pulumi.set(__self__, "ip_prefix_length", ip_prefix_length)
        if ipv6_gateway is not None:
            pulumi.set(__self__, "ipv6_gateway", ipv6_gateway)
        if mac_address is not None:
            pulumi.set(__self__, "mac_address", mac_address)
        if network_name is not None:
            pulumi.set(__self__, "network_name", network_name)

    @_builtins.property
    @pulumi.getter
    def gateway(self) -> Optional[_builtins.str]:
        """
        The network gateway of the container.
        """
        return pulumi.get(self, "gateway")

    @_builtins.property
    @pulumi.getter(name="globalIpv6Address")
    def global_ipv6_address(self) -> Optional[_builtins.str]:
        """
        The IPV6 address of the container.
        """
        return pulumi.get(self, "global_ipv6_address")

    @_builtins.property
    @pulumi.getter(name="globalIpv6PrefixLength")
    def global_ipv6_prefix_length(self) -> Optional[_builtins.int]:
        """
        The IPV6 prefix length address of the container.
        """
        return pulumi.get(self, "global_ipv6_prefix_length")

    @_builtins.property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> Optional[_builtins.str]:
        """
        The IP address of the container.
        """
        return pulumi.get(self, "ip_address")

    @_builtins.property
    @pulumi.getter(name="ipPrefixLength")
    def ip_prefix_length(self) -> Optional[_builtins.int]:
        """
        The IP prefix length of the container.
        """
        return pulumi.get(self, "ip_prefix_length")

    @_builtins.property
    @pulumi.getter(name="ipv6Gateway")
    def ipv6_gateway(self) -> Optional[_builtins.str]:
        """
        The IPV6 gateway of the container.
        """
        return pulumi.get(self, "ipv6_gateway")

    @_builtins.property
    @pulumi.getter(name="macAddress")
    def mac_address(self) -> Optional[_builtins.str]:
        """
        The MAC address of the container.
        """
        return pulumi.get(self, "mac_address")

    @_builtins.property
    @pulumi.getter(name="networkName")
    def network_name(self) -> Optional[_builtins.str]:
        """
        The name of the network
        """
        return pulumi.get(self, "network_name")


@pulumi.output_type
class ContainerNetworksAdvanced(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ipv4Address":
            suggest = "ipv4_address"
        elif key == "ipv6Address":
            suggest = "ipv6_address"
        elif key == "macAddress":
            suggest = "mac_address"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ContainerNetworksAdvanced. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ContainerNetworksAdvanced.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ContainerNetworksAdvanced.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: _builtins.str,
                 aliases: Optional[Sequence[_builtins.str]] = None,
                 ipv4_address: Optional[_builtins.str] = None,
                 ipv6_address: Optional[_builtins.str] = None,
                 mac_address: Optional[_builtins.str] = None):
        """
        :param _builtins.str name: The name or id of the network to use. You can use `name` or `id` attribute from a `Network` resource.
        :param Sequence[_builtins.str] aliases: The network aliases of the container in the specific network.
        :param _builtins.str ipv4_address: The IPV4 address of the container in the specific network.
        :param _builtins.str ipv6_address: The IPV6 address of the container in the specific network.
        :param _builtins.str mac_address: The MAC address of the container in the specific network.
        """
        pulumi.set(__self__, "name", name)
        if aliases is not None:
            pulumi.set(__self__, "aliases", aliases)
        if ipv4_address is not None:
            pulumi.set(__self__, "ipv4_address", ipv4_address)
        if ipv6_address is not None:
            pulumi.set(__self__, "ipv6_address", ipv6_address)
        if mac_address is not None:
            pulumi.set(__self__, "mac_address", mac_address)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name or id of the network to use. You can use `name` or `id` attribute from a `Network` resource.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def aliases(self) -> Optional[Sequence[_builtins.str]]:
        """
        The network aliases of the container in the specific network.
        """
        return pulumi.get(self, "aliases")

    @_builtins.property
    @pulumi.getter(name="ipv4Address")
    def ipv4_address(self) -> Optional[_builtins.str]:
        """
        The IPV4 address of the container in the specific network.
        """
        return pulumi.get(self, "ipv4_address")

    @_builtins.property
    @pulumi.getter(name="ipv6Address")
    def ipv6_address(self) -> Optional[_builtins.str]:
        """
        The IPV6 address of the container in the specific network.
        """
        return pulumi.get(self, "ipv6_address")

    @_builtins.property
    @pulumi.getter(name="macAddress")
    def mac_address(self) -> Optional[_builtins.str]:
        """
        The MAC address of the container in the specific network.
        """
        return pulumi.get(self, "mac_address")


@pulumi.output_type
class ContainerPort(dict):
    def __init__(__self__, *,
                 internal: _builtins.int,
                 external: Optional[_builtins.int] = None,
                 ip: Optional[_builtins.str] = None,
                 protocol: Optional[_builtins.str] = None):
        """
        :param _builtins.int internal: Port within the container.
        :param _builtins.int external: Port exposed out of the container. If not given a free random port `>= 32768` will be used.
        :param _builtins.str ip: IP address/mask that can access this port. Defaults to `0.0.0.0`.
        :param _builtins.str protocol: Protocol that can be used over this port. Defaults to `tcp`.
        """
        pulumi.set(__self__, "internal", internal)
        if external is not None:
            pulumi.set(__self__, "external", external)
        if ip is not None:
            pulumi.set(__self__, "ip", ip)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)

    @_builtins.property
    @pulumi.getter
    def internal(self) -> _builtins.int:
        """
        Port within the container.
        """
        return pulumi.get(self, "internal")

    @_builtins.property
    @pulumi.getter
    def external(self) -> Optional[_builtins.int]:
        """
        Port exposed out of the container. If not given a free random port `>= 32768` will be used.
        """
        return pulumi.get(self, "external")

    @_builtins.property
    @pulumi.getter
    def ip(self) -> Optional[_builtins.str]:
        """
        IP address/mask that can access this port. Defaults to `0.0.0.0`.
        """
        return pulumi.get(self, "ip")

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> Optional[_builtins.str]:
        """
        Protocol that can be used over this port. Defaults to `tcp`.
        """
        return pulumi.get(self, "protocol")


@pulumi.output_type
class ContainerUlimit(dict):
    def __init__(__self__, *,
                 hard: _builtins.int,
                 name: _builtins.str,
                 soft: _builtins.int):
        """
        :param _builtins.int hard: The hard limit
        :param _builtins.str name: The name of the ulimit
        :param _builtins.int soft: The soft limit
        """
        pulumi.set(__self__, "hard", hard)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "soft", soft)

    @_builtins.property
    @pulumi.getter
    def hard(self) -> _builtins.int:
        """
        The hard limit
        """
        return pulumi.get(self, "hard")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the ulimit
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def soft(self) -> _builtins.int:
        """
        The soft limit
        """
        return pulumi.get(self, "soft")


@pulumi.output_type
class ContainerUpload(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "contentBase64":
            suggest = "content_base64"
        elif key == "sourceHash":
            suggest = "source_hash"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ContainerUpload. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ContainerUpload.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ContainerUpload.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 file: _builtins.str,
                 content: Optional[_builtins.str] = None,
                 content_base64: Optional[_builtins.str] = None,
                 executable: Optional[_builtins.bool] = None,
                 permissions: Optional[_builtins.str] = None,
                 source: Optional[_builtins.str] = None,
                 source_hash: Optional[_builtins.str] = None):
        """
        :param _builtins.str file: Path to the file in the container where is upload goes to
        :param _builtins.str content: Literal string value to use as the object content, which will be uploaded as UTF-8-encoded text. Conflicts with `content_base64` & `source`
        :param _builtins.str content_base64: Base64-encoded data that will be decoded and uploaded as raw bytes for the object content. This allows safely uploading non-UTF8 binary data, but is recommended only for larger binary content such as the result of the `base64encode` interpolation function. See here for the reason. Conflicts with `content` & `source`
        :param _builtins.bool executable: If `true`, the file will be uploaded with user executable permission. Defaults to `false`.
        :param _builtins.str permissions: The permission mode for the file in the container. Has precedence over `executable`.
        :param _builtins.str source: A filename that references a file which will be uploaded as the object content. This allows for large file uploads that do not get stored in state. Conflicts with `content` & `content_base64`
        :param _builtins.str source_hash: If using `source`, this will force an update if the file content has updated but the filename has not.
        """
        pulumi.set(__self__, "file", file)
        if content is not None:
            pulumi.set(__self__, "content", content)
        if content_base64 is not None:
            pulumi.set(__self__, "content_base64", content_base64)
        if executable is not None:
            pulumi.set(__self__, "executable", executable)
        if permissions is not None:
            pulumi.set(__self__, "permissions", permissions)
        if source is not None:
            pulumi.set(__self__, "source", source)
        if source_hash is not None:
            pulumi.set(__self__, "source_hash", source_hash)

    @_builtins.property
    @pulumi.getter
    def file(self) -> _builtins.str:
        """
        Path to the file in the container where is upload goes to
        """
        return pulumi.get(self, "file")

    @_builtins.property
    @pulumi.getter
    def content(self) -> Optional[_builtins.str]:
        """
        Literal string value to use as the object content, which will be uploaded as UTF-8-encoded text. Conflicts with `content_base64` & `source`
        """
        return pulumi.get(self, "content")

    @_builtins.property
    @pulumi.getter(name="contentBase64")
    def content_base64(self) -> Optional[_builtins.str]:
        """
        Base64-encoded data that will be decoded and uploaded as raw bytes for the object content. This allows safely uploading non-UTF8 binary data, but is recommended only for larger binary content such as the result of the `base64encode` interpolation function. See here for the reason. Conflicts with `content` & `source`
        """
        return pulumi.get(self, "content_base64")

    @_builtins.property
    @pulumi.getter
    def executable(self) -> Optional[_builtins.bool]:
        """
        If `true`, the file will be uploaded with user executable permission. Defaults to `false`.
        """
        return pulumi.get(self, "executable")

    @_builtins.property
    @pulumi.getter
    def permissions(self) -> Optional[_builtins.str]:
        """
        The permission mode for the file in the container. Has precedence over `executable`.
        """
        return pulumi.get(self, "permissions")

    @_builtins.property
    @pulumi.getter
    def source(self) -> Optional[_builtins.str]:
        """
        A filename that references a file which will be uploaded as the object content. This allows for large file uploads that do not get stored in state. Conflicts with `content` & `content_base64`
        """
        return pulumi.get(self, "source")

    @_builtins.property
    @pulumi.getter(name="sourceHash")
    def source_hash(self) -> Optional[_builtins.str]:
        """
        If using `source`, this will force an update if the file content has updated but the filename has not.
        """
        return pulumi.get(self, "source_hash")


@pulumi.output_type
class ContainerVolume(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "containerPath":
            suggest = "container_path"
        elif key == "fromContainer":
            suggest = "from_container"
        elif key == "hostPath":
            suggest = "host_path"
        elif key == "readOnly":
            suggest = "read_only"
        elif key == "volumeName":
            suggest = "volume_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ContainerVolume. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ContainerVolume.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ContainerVolume.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 container_path: Optional[_builtins.str] = None,
                 from_container: Optional[_builtins.str] = None,
                 host_path: Optional[_builtins.str] = None,
                 read_only: Optional[_builtins.bool] = None,
                 volume_name: Optional[_builtins.str] = None):
        """
        :param _builtins.str container_path: The path in the container where the volume will be mounted.
        :param _builtins.str from_container: The container where the volume is coming from.
        :param _builtins.str host_path: The path on the host where the volume is coming from.
        :param _builtins.bool read_only: If `true`, this volume will be readonly. Defaults to `false`.
        :param _builtins.str volume_name: The name of the docker volume which should be mounted.
        """
        if container_path is not None:
            pulumi.set(__self__, "container_path", container_path)
        if from_container is not None:
            pulumi.set(__self__, "from_container", from_container)
        if host_path is not None:
            pulumi.set(__self__, "host_path", host_path)
        if read_only is not None:
            pulumi.set(__self__, "read_only", read_only)
        if volume_name is not None:
            pulumi.set(__self__, "volume_name", volume_name)

    @_builtins.property
    @pulumi.getter(name="containerPath")
    def container_path(self) -> Optional[_builtins.str]:
        """
        The path in the container where the volume will be mounted.
        """
        return pulumi.get(self, "container_path")

    @_builtins.property
    @pulumi.getter(name="fromContainer")
    def from_container(self) -> Optional[_builtins.str]:
        """
        The container where the volume is coming from.
        """
        return pulumi.get(self, "from_container")

    @_builtins.property
    @pulumi.getter(name="hostPath")
    def host_path(self) -> Optional[_builtins.str]:
        """
        The path on the host where the volume is coming from.
        """
        return pulumi.get(self, "host_path")

    @_builtins.property
    @pulumi.getter(name="readOnly")
    def read_only(self) -> Optional[_builtins.bool]:
        """
        If `true`, this volume will be readonly. Defaults to `false`.
        """
        return pulumi.get(self, "read_only")

    @_builtins.property
    @pulumi.getter(name="volumeName")
    def volume_name(self) -> Optional[_builtins.str]:
        """
        The name of the docker volume which should be mounted.
        """
        return pulumi.get(self, "volume_name")


@pulumi.output_type
class NetworkIpamConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "auxAddress":
            suggest = "aux_address"
        elif key == "ipRange":
            suggest = "ip_range"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NetworkIpamConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NetworkIpamConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NetworkIpamConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 aux_address: Optional[Mapping[str, _builtins.str]] = None,
                 gateway: Optional[_builtins.str] = None,
                 ip_range: Optional[_builtins.str] = None,
                 subnet: Optional[_builtins.str] = None):
        """
        :param Mapping[str, _builtins.str] aux_address: Auxiliary IPv4 or IPv6 addresses used by Network driver
        :param _builtins.str gateway: The IP address of the gateway
        :param _builtins.str ip_range: The ip range in CIDR form
        :param _builtins.str subnet: The subnet in CIDR form
        """
        if aux_address is not None:
            pulumi.set(__self__, "aux_address", aux_address)
        if gateway is not None:
            pulumi.set(__self__, "gateway", gateway)
        if ip_range is not None:
            pulumi.set(__self__, "ip_range", ip_range)
        if subnet is not None:
            pulumi.set(__self__, "subnet", subnet)

    @_builtins.property
    @pulumi.getter(name="auxAddress")
    def aux_address(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        Auxiliary IPv4 or IPv6 addresses used by Network driver
        """
        return pulumi.get(self, "aux_address")

    @_builtins.property
    @pulumi.getter
    def gateway(self) -> Optional[_builtins.str]:
        """
        The IP address of the gateway
        """
        return pulumi.get(self, "gateway")

    @_builtins.property
    @pulumi.getter(name="ipRange")
    def ip_range(self) -> Optional[_builtins.str]:
        """
        The ip range in CIDR form
        """
        return pulumi.get(self, "ip_range")

    @_builtins.property
    @pulumi.getter
    def subnet(self) -> Optional[_builtins.str]:
        """
        The subnet in CIDR form
        """
        return pulumi.get(self, "subnet")


@pulumi.output_type
class NetworkLabel(dict):
    def __init__(__self__, *,
                 label: _builtins.str,
                 value: _builtins.str):
        """
        :param _builtins.str label: Name of the label
        :param _builtins.str value: Value of the label
        """
        pulumi.set(__self__, "label", label)
        pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def label(self) -> _builtins.str:
        """
        Name of the label
        """
        return pulumi.get(self, "label")

    @_builtins.property
    @pulumi.getter
    def value(self) -> _builtins.str:
        """
        Value of the label
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class PluginGrantPermission(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 values: Sequence[_builtins.str]):
        """
        :param _builtins.str name: The name of the permission
        :param Sequence[_builtins.str] values: The value of the permission
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the permission
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        """
        The value of the permission
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class RegistryImageAuthConfig(dict):
    def __init__(__self__, *,
                 address: _builtins.str,
                 password: _builtins.str,
                 username: _builtins.str):
        """
        :param _builtins.str address: The address of the Docker registry.
        :param _builtins.str password: The password for the Docker registry.
        :param _builtins.str username: The username for the Docker registry.
        """
        pulumi.set(__self__, "address", address)
        pulumi.set(__self__, "password", password)
        pulumi.set(__self__, "username", username)

    @_builtins.property
    @pulumi.getter
    def address(self) -> _builtins.str:
        """
        The address of the Docker registry.
        """
        return pulumi.get(self, "address")

    @_builtins.property
    @pulumi.getter
    def password(self) -> _builtins.str:
        """
        The password for the Docker registry.
        """
        return pulumi.get(self, "password")

    @_builtins.property
    @pulumi.getter
    def username(self) -> _builtins.str:
        """
        The username for the Docker registry.
        """
        return pulumi.get(self, "username")


@pulumi.output_type
class RegistryImageBuild(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "additionalContexts":
            suggest = "additional_contexts"
        elif key == "authConfigs":
            suggest = "auth_configs"
        elif key == "buildArgs":
            suggest = "build_args"
        elif key == "buildId":
            suggest = "build_id"
        elif key == "buildLogFile":
            suggest = "build_log_file"
        elif key == "cacheFroms":
            suggest = "cache_froms"
        elif key == "cacheTos":
            suggest = "cache_tos"
        elif key == "cgroupParent":
            suggest = "cgroup_parent"
        elif key == "cpuPeriod":
            suggest = "cpu_period"
        elif key == "cpuQuota":
            suggest = "cpu_quota"
        elif key == "cpuSetCpus":
            suggest = "cpu_set_cpus"
        elif key == "cpuSetMems":
            suggest = "cpu_set_mems"
        elif key == "cpuShares":
            suggest = "cpu_shares"
        elif key == "extraHosts":
            suggest = "extra_hosts"
        elif key == "forceRemove":
            suggest = "force_remove"
        elif key == "memorySwap":
            suggest = "memory_swap"
        elif key == "networkMode":
            suggest = "network_mode"
        elif key == "noCache":
            suggest = "no_cache"
        elif key == "pullParent":
            suggest = "pull_parent"
        elif key == "remoteContext":
            suggest = "remote_context"
        elif key == "securityOpts":
            suggest = "security_opts"
        elif key == "sessionId":
            suggest = "session_id"
        elif key == "shmSize":
            suggest = "shm_size"
        elif key == "suppressOutput":
            suggest = "suppress_output"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RegistryImageBuild. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RegistryImageBuild.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RegistryImageBuild.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 context: _builtins.str,
                 additional_contexts: Optional[Sequence[_builtins.str]] = None,
                 auth_configs: Optional[Sequence['outputs.RegistryImageBuildAuthConfig']] = None,
                 build_args: Optional[Mapping[str, _builtins.str]] = None,
                 build_id: Optional[_builtins.str] = None,
                 build_log_file: Optional[_builtins.str] = None,
                 builder: Optional[_builtins.str] = None,
                 cache_froms: Optional[Sequence[_builtins.str]] = None,
                 cache_tos: Optional[Sequence[_builtins.str]] = None,
                 cgroup_parent: Optional[_builtins.str] = None,
                 cpu_period: Optional[_builtins.int] = None,
                 cpu_quota: Optional[_builtins.int] = None,
                 cpu_set_cpus: Optional[_builtins.str] = None,
                 cpu_set_mems: Optional[_builtins.str] = None,
                 cpu_shares: Optional[_builtins.int] = None,
                 dockerfile: Optional[_builtins.str] = None,
                 extra_hosts: Optional[Sequence[_builtins.str]] = None,
                 force_remove: Optional[_builtins.bool] = None,
                 isolation: Optional[_builtins.str] = None,
                 label: Optional[Mapping[str, _builtins.str]] = None,
                 labels: Optional[Mapping[str, _builtins.str]] = None,
                 memory: Optional[_builtins.int] = None,
                 memory_swap: Optional[_builtins.int] = None,
                 network_mode: Optional[_builtins.str] = None,
                 no_cache: Optional[_builtins.bool] = None,
                 platform: Optional[_builtins.str] = None,
                 pull_parent: Optional[_builtins.bool] = None,
                 remote_context: Optional[_builtins.str] = None,
                 remove: Optional[_builtins.bool] = None,
                 secrets: Optional[Sequence['outputs.RegistryImageBuildSecret']] = None,
                 security_opts: Optional[Sequence[_builtins.str]] = None,
                 session_id: Optional[_builtins.str] = None,
                 shm_size: Optional[_builtins.int] = None,
                 squash: Optional[_builtins.bool] = None,
                 suppress_output: Optional[_builtins.bool] = None,
                 tags: Optional[Sequence[_builtins.str]] = None,
                 target: Optional[_builtins.str] = None,
                 ulimits: Optional[Sequence['outputs.RegistryImageBuildUlimit']] = None,
                 version: Optional[_builtins.str] = None):
        """
        :param _builtins.str context: Value to specify the build context. Currently, only a `PATH` context is supported. You can use the helper function '${path.cwd}/context-dir'. This always refers to the local working directory, even when building images on remote hosts. Please see https://docs.docker.com/build/building/context/ for more information about build contexts.
        :param Sequence[_builtins.str] additional_contexts: A list of additional build contexts. Only supported when using a buildx builder. Example: `["name=path", "src = https://example.org"}`. Please see https://docs.docker.com/reference/cli/docker/buildx/build/#build-context for more information.
        :param Sequence['RegistryImageBuildAuthConfigArgs'] auth_configs: Authentication configuration for the Docker registry. It is only used for this resource.
        :param Mapping[str, _builtins.str] build_args: Pairs for build-time variables in the form of `ENDPOINT : "https://example.com"`
        :param _builtins.str build_id: BuildID is an optional identifier that can be passed together with the build request. The same identifier can be used to gracefully cancel the build with the cancel request.
        :param _builtins.str build_log_file: Path to a file where the buildx log are written to. Only available when `builder` is set. If not set, no logs are available. The path is taken as is, so make sure to use a path that is available.
        :param _builtins.str builder: Set the name of the buildx builder to use. If not set, the legacy builder is used.
        :param Sequence[_builtins.str] cache_froms: External cache sources (e.g., `user/app:cache`, `type=local,src=path/to/dir`). Only supported when using a buildx builder.
        :param Sequence[_builtins.str] cache_tos: Cache export destinations (e.g., `user/app:cache`, `type=local,dest=path/to/dir`). Only supported when using a buildx builder.
        :param _builtins.str cgroup_parent: Optional parent cgroup for the container
        :param _builtins.int cpu_period: The length of a CPU period in microseconds
        :param _builtins.int cpu_quota: Microseconds of CPU time that the container can get in a CPU period
        :param _builtins.str cpu_set_cpus: CPUs in which to allow execution (e.g., `0-3`, `0`, `1`)
        :param _builtins.str cpu_set_mems: MEMs in which to allow execution (`0-3`, `0`, `1`)
        :param _builtins.int cpu_shares: CPU shares (relative weight)
        :param _builtins.str dockerfile: Name of the Dockerfile. Defaults to `Dockerfile`.
        :param Sequence[_builtins.str] extra_hosts: A list of hostnames/IP mappings to add to the container’s /etc/hosts file. Specified in the form ["hostname:IP"]
        :param _builtins.bool force_remove: Always remove intermediate containers
        :param _builtins.str isolation: Isolation represents the isolation technology of a container. The supported values are
        :param Mapping[str, _builtins.str] label: Set metadata for an image
        :param Mapping[str, _builtins.str] labels: User-defined key/value metadata
        :param _builtins.int memory: Set memory limit for build
        :param _builtins.int memory_swap: Total memory (memory + swap), -1 to enable unlimited swap
        :param _builtins.str network_mode: Set the networking mode for the RUN instructions during build
        :param _builtins.bool no_cache: Do not use the cache when building the image
        :param _builtins.str platform: Set the target platform for the build. Defaults to `GOOS/GOARCH`. For more information see the [docker documentation](https://github.com/docker/buildx/blob/master/docs/reference/buildx.md#-set-the-target-platforms-for-the-build---platform)
        :param _builtins.bool pull_parent: Attempt to pull the image even if an older image exists locally
        :param _builtins.str remote_context: A Git repository URI or HTTP/HTTPS context URI. Will be ignored if `builder` is set.
        :param _builtins.bool remove: Remove intermediate containers after a successful build. Defaults to `true`.
        :param Sequence['RegistryImageBuildSecretArgs'] secrets: Set build-time secrets. Only available when you use a buildx builder.
        :param Sequence[_builtins.str] security_opts: The security options
        :param _builtins.str session_id: Set an ID for the build session
        :param _builtins.int shm_size: Size of /dev/shm in bytes. The size must be greater than 0
        :param _builtins.bool squash: If true the new layers are squashed into a new image with a single new layer
        :param _builtins.bool suppress_output: Suppress the build output and print image ID on success
        :param Sequence[_builtins.str] tags: Name and optionally a tag in the 'name:tag' format
        :param _builtins.str target: Set the target build stage to build
        :param Sequence['RegistryImageBuildUlimitArgs'] ulimits: Configuration for ulimits
        :param _builtins.str version: Version of the underlying builder to use
        """
        pulumi.set(__self__, "context", context)
        if additional_contexts is not None:
            pulumi.set(__self__, "additional_contexts", additional_contexts)
        if auth_configs is not None:
            pulumi.set(__self__, "auth_configs", auth_configs)
        if build_args is not None:
            pulumi.set(__self__, "build_args", build_args)
        if build_id is not None:
            pulumi.set(__self__, "build_id", build_id)
        if build_log_file is not None:
            pulumi.set(__self__, "build_log_file", build_log_file)
        if builder is not None:
            pulumi.set(__self__, "builder", builder)
        if cache_froms is not None:
            pulumi.set(__self__, "cache_froms", cache_froms)
        if cache_tos is not None:
            pulumi.set(__self__, "cache_tos", cache_tos)
        if cgroup_parent is not None:
            pulumi.set(__self__, "cgroup_parent", cgroup_parent)
        if cpu_period is not None:
            pulumi.set(__self__, "cpu_period", cpu_period)
        if cpu_quota is not None:
            pulumi.set(__self__, "cpu_quota", cpu_quota)
        if cpu_set_cpus is not None:
            pulumi.set(__self__, "cpu_set_cpus", cpu_set_cpus)
        if cpu_set_mems is not None:
            pulumi.set(__self__, "cpu_set_mems", cpu_set_mems)
        if cpu_shares is not None:
            pulumi.set(__self__, "cpu_shares", cpu_shares)
        if dockerfile is not None:
            pulumi.set(__self__, "dockerfile", dockerfile)
        if extra_hosts is not None:
            pulumi.set(__self__, "extra_hosts", extra_hosts)
        if force_remove is not None:
            pulumi.set(__self__, "force_remove", force_remove)
        if isolation is not None:
            pulumi.set(__self__, "isolation", isolation)
        if label is not None:
            pulumi.set(__self__, "label", label)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if memory is not None:
            pulumi.set(__self__, "memory", memory)
        if memory_swap is not None:
            pulumi.set(__self__, "memory_swap", memory_swap)
        if network_mode is not None:
            pulumi.set(__self__, "network_mode", network_mode)
        if no_cache is not None:
            pulumi.set(__self__, "no_cache", no_cache)
        if platform is not None:
            pulumi.set(__self__, "platform", platform)
        if pull_parent is not None:
            pulumi.set(__self__, "pull_parent", pull_parent)
        if remote_context is not None:
            pulumi.set(__self__, "remote_context", remote_context)
        if remove is not None:
            pulumi.set(__self__, "remove", remove)
        if secrets is not None:
            pulumi.set(__self__, "secrets", secrets)
        if security_opts is not None:
            pulumi.set(__self__, "security_opts", security_opts)
        if session_id is not None:
            pulumi.set(__self__, "session_id", session_id)
        if shm_size is not None:
            pulumi.set(__self__, "shm_size", shm_size)
        if squash is not None:
            pulumi.set(__self__, "squash", squash)
        if suppress_output is not None:
            pulumi.set(__self__, "suppress_output", suppress_output)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if target is not None:
            pulumi.set(__self__, "target", target)
        if ulimits is not None:
            pulumi.set(__self__, "ulimits", ulimits)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @_builtins.property
    @pulumi.getter
    def context(self) -> _builtins.str:
        """
        Value to specify the build context. Currently, only a `PATH` context is supported. You can use the helper function '${path.cwd}/context-dir'. This always refers to the local working directory, even when building images on remote hosts. Please see https://docs.docker.com/build/building/context/ for more information about build contexts.
        """
        return pulumi.get(self, "context")

    @_builtins.property
    @pulumi.getter(name="additionalContexts")
    def additional_contexts(self) -> Optional[Sequence[_builtins.str]]:
        """
        A list of additional build contexts. Only supported when using a buildx builder. Example: `["name=path", "src = https://example.org"}`. Please see https://docs.docker.com/reference/cli/docker/buildx/build/#build-context for more information.
        """
        return pulumi.get(self, "additional_contexts")

    @_builtins.property
    @pulumi.getter(name="authConfigs")
    def auth_configs(self) -> Optional[Sequence['outputs.RegistryImageBuildAuthConfig']]:
        """
        Authentication configuration for the Docker registry. It is only used for this resource.
        """
        return pulumi.get(self, "auth_configs")

    @_builtins.property
    @pulumi.getter(name="buildArgs")
    def build_args(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        Pairs for build-time variables in the form of `ENDPOINT : "https://example.com"`
        """
        return pulumi.get(self, "build_args")

    @_builtins.property
    @pulumi.getter(name="buildId")
    def build_id(self) -> Optional[_builtins.str]:
        """
        BuildID is an optional identifier that can be passed together with the build request. The same identifier can be used to gracefully cancel the build with the cancel request.
        """
        return pulumi.get(self, "build_id")

    @_builtins.property
    @pulumi.getter(name="buildLogFile")
    def build_log_file(self) -> Optional[_builtins.str]:
        """
        Path to a file where the buildx log are written to. Only available when `builder` is set. If not set, no logs are available. The path is taken as is, so make sure to use a path that is available.
        """
        return pulumi.get(self, "build_log_file")

    @_builtins.property
    @pulumi.getter
    def builder(self) -> Optional[_builtins.str]:
        """
        Set the name of the buildx builder to use. If not set, the legacy builder is used.
        """
        return pulumi.get(self, "builder")

    @_builtins.property
    @pulumi.getter(name="cacheFroms")
    def cache_froms(self) -> Optional[Sequence[_builtins.str]]:
        """
        External cache sources (e.g., `user/app:cache`, `type=local,src=path/to/dir`). Only supported when using a buildx builder.
        """
        return pulumi.get(self, "cache_froms")

    @_builtins.property
    @pulumi.getter(name="cacheTos")
    def cache_tos(self) -> Optional[Sequence[_builtins.str]]:
        """
        Cache export destinations (e.g., `user/app:cache`, `type=local,dest=path/to/dir`). Only supported when using a buildx builder.
        """
        return pulumi.get(self, "cache_tos")

    @_builtins.property
    @pulumi.getter(name="cgroupParent")
    def cgroup_parent(self) -> Optional[_builtins.str]:
        """
        Optional parent cgroup for the container
        """
        return pulumi.get(self, "cgroup_parent")

    @_builtins.property
    @pulumi.getter(name="cpuPeriod")
    def cpu_period(self) -> Optional[_builtins.int]:
        """
        The length of a CPU period in microseconds
        """
        return pulumi.get(self, "cpu_period")

    @_builtins.property
    @pulumi.getter(name="cpuQuota")
    def cpu_quota(self) -> Optional[_builtins.int]:
        """
        Microseconds of CPU time that the container can get in a CPU period
        """
        return pulumi.get(self, "cpu_quota")

    @_builtins.property
    @pulumi.getter(name="cpuSetCpus")
    def cpu_set_cpus(self) -> Optional[_builtins.str]:
        """
        CPUs in which to allow execution (e.g., `0-3`, `0`, `1`)
        """
        return pulumi.get(self, "cpu_set_cpus")

    @_builtins.property
    @pulumi.getter(name="cpuSetMems")
    def cpu_set_mems(self) -> Optional[_builtins.str]:
        """
        MEMs in which to allow execution (`0-3`, `0`, `1`)
        """
        return pulumi.get(self, "cpu_set_mems")

    @_builtins.property
    @pulumi.getter(name="cpuShares")
    def cpu_shares(self) -> Optional[_builtins.int]:
        """
        CPU shares (relative weight)
        """
        return pulumi.get(self, "cpu_shares")

    @_builtins.property
    @pulumi.getter
    def dockerfile(self) -> Optional[_builtins.str]:
        """
        Name of the Dockerfile. Defaults to `Dockerfile`.
        """
        return pulumi.get(self, "dockerfile")

    @_builtins.property
    @pulumi.getter(name="extraHosts")
    def extra_hosts(self) -> Optional[Sequence[_builtins.str]]:
        """
        A list of hostnames/IP mappings to add to the container’s /etc/hosts file. Specified in the form ["hostname:IP"]
        """
        return pulumi.get(self, "extra_hosts")

    @_builtins.property
    @pulumi.getter(name="forceRemove")
    def force_remove(self) -> Optional[_builtins.bool]:
        """
        Always remove intermediate containers
        """
        return pulumi.get(self, "force_remove")

    @_builtins.property
    @pulumi.getter
    def isolation(self) -> Optional[_builtins.str]:
        """
        Isolation represents the isolation technology of a container. The supported values are
        """
        return pulumi.get(self, "isolation")

    @_builtins.property
    @pulumi.getter
    def label(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        Set metadata for an image
        """
        return pulumi.get(self, "label")

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        User-defined key/value metadata
        """
        return pulumi.get(self, "labels")

    @_builtins.property
    @pulumi.getter
    def memory(self) -> Optional[_builtins.int]:
        """
        Set memory limit for build
        """
        return pulumi.get(self, "memory")

    @_builtins.property
    @pulumi.getter(name="memorySwap")
    def memory_swap(self) -> Optional[_builtins.int]:
        """
        Total memory (memory + swap), -1 to enable unlimited swap
        """
        return pulumi.get(self, "memory_swap")

    @_builtins.property
    @pulumi.getter(name="networkMode")
    def network_mode(self) -> Optional[_builtins.str]:
        """
        Set the networking mode for the RUN instructions during build
        """
        return pulumi.get(self, "network_mode")

    @_builtins.property
    @pulumi.getter(name="noCache")
    def no_cache(self) -> Optional[_builtins.bool]:
        """
        Do not use the cache when building the image
        """
        return pulumi.get(self, "no_cache")

    @_builtins.property
    @pulumi.getter
    def platform(self) -> Optional[_builtins.str]:
        """
        Set the target platform for the build. Defaults to `GOOS/GOARCH`. For more information see the [docker documentation](https://github.com/docker/buildx/blob/master/docs/reference/buildx.md#-set-the-target-platforms-for-the-build---platform)
        """
        return pulumi.get(self, "platform")

    @_builtins.property
    @pulumi.getter(name="pullParent")
    def pull_parent(self) -> Optional[_builtins.bool]:
        """
        Attempt to pull the image even if an older image exists locally
        """
        return pulumi.get(self, "pull_parent")

    @_builtins.property
    @pulumi.getter(name="remoteContext")
    def remote_context(self) -> Optional[_builtins.str]:
        """
        A Git repository URI or HTTP/HTTPS context URI. Will be ignored if `builder` is set.
        """
        return pulumi.get(self, "remote_context")

    @_builtins.property
    @pulumi.getter
    def remove(self) -> Optional[_builtins.bool]:
        """
        Remove intermediate containers after a successful build. Defaults to `true`.
        """
        return pulumi.get(self, "remove")

    @_builtins.property
    @pulumi.getter
    def secrets(self) -> Optional[Sequence['outputs.RegistryImageBuildSecret']]:
        """
        Set build-time secrets. Only available when you use a buildx builder.
        """
        return pulumi.get(self, "secrets")

    @_builtins.property
    @pulumi.getter(name="securityOpts")
    def security_opts(self) -> Optional[Sequence[_builtins.str]]:
        """
        The security options
        """
        return pulumi.get(self, "security_opts")

    @_builtins.property
    @pulumi.getter(name="sessionId")
    def session_id(self) -> Optional[_builtins.str]:
        """
        Set an ID for the build session
        """
        return pulumi.get(self, "session_id")

    @_builtins.property
    @pulumi.getter(name="shmSize")
    def shm_size(self) -> Optional[_builtins.int]:
        """
        Size of /dev/shm in bytes. The size must be greater than 0
        """
        return pulumi.get(self, "shm_size")

    @_builtins.property
    @pulumi.getter
    def squash(self) -> Optional[_builtins.bool]:
        """
        If true the new layers are squashed into a new image with a single new layer
        """
        return pulumi.get(self, "squash")

    @_builtins.property
    @pulumi.getter(name="suppressOutput")
    def suppress_output(self) -> Optional[_builtins.bool]:
        """
        Suppress the build output and print image ID on success
        """
        return pulumi.get(self, "suppress_output")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[Sequence[_builtins.str]]:
        """
        Name and optionally a tag in the 'name:tag' format
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter
    def target(self) -> Optional[_builtins.str]:
        """
        Set the target build stage to build
        """
        return pulumi.get(self, "target")

    @_builtins.property
    @pulumi.getter
    def ulimits(self) -> Optional[Sequence['outputs.RegistryImageBuildUlimit']]:
        """
        Configuration for ulimits
        """
        return pulumi.get(self, "ulimits")

    @_builtins.property
    @pulumi.getter
    def version(self) -> Optional[_builtins.str]:
        """
        Version of the underlying builder to use
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class RegistryImageBuildAuthConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "hostName":
            suggest = "host_name"
        elif key == "identityToken":
            suggest = "identity_token"
        elif key == "registryToken":
            suggest = "registry_token"
        elif key == "serverAddress":
            suggest = "server_address"
        elif key == "userName":
            suggest = "user_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RegistryImageBuildAuthConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RegistryImageBuildAuthConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RegistryImageBuildAuthConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 host_name: _builtins.str,
                 auth: Optional[_builtins.str] = None,
                 email: Optional[_builtins.str] = None,
                 identity_token: Optional[_builtins.str] = None,
                 password: Optional[_builtins.str] = None,
                 registry_token: Optional[_builtins.str] = None,
                 server_address: Optional[_builtins.str] = None,
                 user_name: Optional[_builtins.str] = None):
        """
        :param _builtins.str host_name: hostname of the registry
        :param _builtins.str auth: the auth token
        :param _builtins.str email: the user emal
        :param _builtins.str identity_token: the identity token
        :param _builtins.str password: The password for the Docker registry.
        :param _builtins.str registry_token: the registry token
        :param _builtins.str server_address: the server address
        :param _builtins.str user_name: the registry user name
        """
        pulumi.set(__self__, "host_name", host_name)
        if auth is not None:
            pulumi.set(__self__, "auth", auth)
        if email is not None:
            pulumi.set(__self__, "email", email)
        if identity_token is not None:
            pulumi.set(__self__, "identity_token", identity_token)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if registry_token is not None:
            pulumi.set(__self__, "registry_token", registry_token)
        if server_address is not None:
            pulumi.set(__self__, "server_address", server_address)
        if user_name is not None:
            pulumi.set(__self__, "user_name", user_name)

    @_builtins.property
    @pulumi.getter(name="hostName")
    def host_name(self) -> _builtins.str:
        """
        hostname of the registry
        """
        return pulumi.get(self, "host_name")

    @_builtins.property
    @pulumi.getter
    def auth(self) -> Optional[_builtins.str]:
        """
        the auth token
        """
        return pulumi.get(self, "auth")

    @_builtins.property
    @pulumi.getter
    def email(self) -> Optional[_builtins.str]:
        """
        the user emal
        """
        return pulumi.get(self, "email")

    @_builtins.property
    @pulumi.getter(name="identityToken")
    def identity_token(self) -> Optional[_builtins.str]:
        """
        the identity token
        """
        return pulumi.get(self, "identity_token")

    @_builtins.property
    @pulumi.getter
    def password(self) -> Optional[_builtins.str]:
        """
        The password for the Docker registry.
        """
        return pulumi.get(self, "password")

    @_builtins.property
    @pulumi.getter(name="registryToken")
    def registry_token(self) -> Optional[_builtins.str]:
        """
        the registry token
        """
        return pulumi.get(self, "registry_token")

    @_builtins.property
    @pulumi.getter(name="serverAddress")
    def server_address(self) -> Optional[_builtins.str]:
        """
        the server address
        """
        return pulumi.get(self, "server_address")

    @_builtins.property
    @pulumi.getter(name="userName")
    def user_name(self) -> Optional[_builtins.str]:
        """
        the registry user name
        """
        return pulumi.get(self, "user_name")


@pulumi.output_type
class RegistryImageBuildSecret(dict):
    def __init__(__self__, *,
                 id: _builtins.str,
                 env: Optional[_builtins.str] = None,
                 src: Optional[_builtins.str] = None):
        """
        :param _builtins.str id: The ID of this resource.
        :param _builtins.str env: Environment variable source of the secret
        :param _builtins.str src: File source of the secret. Takes precedence over `env`
        """
        pulumi.set(__self__, "id", id)
        if env is not None:
            pulumi.set(__self__, "env", env)
        if src is not None:
            pulumi.set(__self__, "src", src)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of this resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def env(self) -> Optional[_builtins.str]:
        """
        Environment variable source of the secret
        """
        return pulumi.get(self, "env")

    @_builtins.property
    @pulumi.getter
    def src(self) -> Optional[_builtins.str]:
        """
        File source of the secret. Takes precedence over `env`
        """
        return pulumi.get(self, "src")


@pulumi.output_type
class RegistryImageBuildUlimit(dict):
    def __init__(__self__, *,
                 hard: _builtins.int,
                 name: _builtins.str,
                 soft: _builtins.int):
        """
        :param _builtins.int hard: soft limit
        :param _builtins.str name: The name of the Docker image.
        :param _builtins.int soft: hard limit
        """
        pulumi.set(__self__, "hard", hard)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "soft", soft)

    @_builtins.property
    @pulumi.getter
    def hard(self) -> _builtins.int:
        """
        soft limit
        """
        return pulumi.get(self, "hard")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the Docker image.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def soft(self) -> _builtins.int:
        """
        hard limit
        """
        return pulumi.get(self, "soft")


@pulumi.output_type
class RemoteImageBuild(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "additionalContexts":
            suggest = "additional_contexts"
        elif key == "authConfigs":
            suggest = "auth_configs"
        elif key == "buildArgs":
            suggest = "build_args"
        elif key == "buildId":
            suggest = "build_id"
        elif key == "buildLogFile":
            suggest = "build_log_file"
        elif key == "cacheFroms":
            suggest = "cache_froms"
        elif key == "cacheTos":
            suggest = "cache_tos"
        elif key == "cgroupParent":
            suggest = "cgroup_parent"
        elif key == "cpuPeriod":
            suggest = "cpu_period"
        elif key == "cpuQuota":
            suggest = "cpu_quota"
        elif key == "cpuSetCpus":
            suggest = "cpu_set_cpus"
        elif key == "cpuSetMems":
            suggest = "cpu_set_mems"
        elif key == "cpuShares":
            suggest = "cpu_shares"
        elif key == "extraHosts":
            suggest = "extra_hosts"
        elif key == "forceRemove":
            suggest = "force_remove"
        elif key == "memorySwap":
            suggest = "memory_swap"
        elif key == "networkMode":
            suggest = "network_mode"
        elif key == "noCache":
            suggest = "no_cache"
        elif key == "pullParent":
            suggest = "pull_parent"
        elif key == "remoteContext":
            suggest = "remote_context"
        elif key == "securityOpts":
            suggest = "security_opts"
        elif key == "sessionId":
            suggest = "session_id"
        elif key == "shmSize":
            suggest = "shm_size"
        elif key == "suppressOutput":
            suggest = "suppress_output"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RemoteImageBuild. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RemoteImageBuild.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RemoteImageBuild.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 context: _builtins.str,
                 additional_contexts: Optional[Sequence[_builtins.str]] = None,
                 auth_configs: Optional[Sequence['outputs.RemoteImageBuildAuthConfig']] = None,
                 build_args: Optional[Mapping[str, _builtins.str]] = None,
                 build_id: Optional[_builtins.str] = None,
                 build_log_file: Optional[_builtins.str] = None,
                 builder: Optional[_builtins.str] = None,
                 cache_froms: Optional[Sequence[_builtins.str]] = None,
                 cache_tos: Optional[Sequence[_builtins.str]] = None,
                 cgroup_parent: Optional[_builtins.str] = None,
                 cpu_period: Optional[_builtins.int] = None,
                 cpu_quota: Optional[_builtins.int] = None,
                 cpu_set_cpus: Optional[_builtins.str] = None,
                 cpu_set_mems: Optional[_builtins.str] = None,
                 cpu_shares: Optional[_builtins.int] = None,
                 dockerfile: Optional[_builtins.str] = None,
                 extra_hosts: Optional[Sequence[_builtins.str]] = None,
                 force_remove: Optional[_builtins.bool] = None,
                 isolation: Optional[_builtins.str] = None,
                 label: Optional[Mapping[str, _builtins.str]] = None,
                 labels: Optional[Mapping[str, _builtins.str]] = None,
                 memory: Optional[_builtins.int] = None,
                 memory_swap: Optional[_builtins.int] = None,
                 network_mode: Optional[_builtins.str] = None,
                 no_cache: Optional[_builtins.bool] = None,
                 platform: Optional[_builtins.str] = None,
                 pull_parent: Optional[_builtins.bool] = None,
                 remote_context: Optional[_builtins.str] = None,
                 remove: Optional[_builtins.bool] = None,
                 secrets: Optional[Sequence['outputs.RemoteImageBuildSecret']] = None,
                 security_opts: Optional[Sequence[_builtins.str]] = None,
                 session_id: Optional[_builtins.str] = None,
                 shm_size: Optional[_builtins.int] = None,
                 squash: Optional[_builtins.bool] = None,
                 suppress_output: Optional[_builtins.bool] = None,
                 tags: Optional[Sequence[_builtins.str]] = None,
                 target: Optional[_builtins.str] = None,
                 ulimits: Optional[Sequence['outputs.RemoteImageBuildUlimit']] = None,
                 version: Optional[_builtins.str] = None):
        """
        :param _builtins.str context: Value to specify the build context. Currently, only a `PATH` context is supported. You can use the helper function '${path.cwd}/context-dir'. This always refers to the local working directory, even when building images on remote hosts. Please see https://docs.docker.com/build/building/context/ for more information about build contexts.
        :param Sequence[_builtins.str] additional_contexts: A list of additional build contexts. Only supported when using a buildx builder. Example: `["name=path", "src = https://example.org"}`. Please see https://docs.docker.com/reference/cli/docker/buildx/build/#build-context for more information.
        :param Sequence['RemoteImageBuildAuthConfigArgs'] auth_configs: The configuration for the authentication
        :param Mapping[str, _builtins.str] build_args: Pairs for build-time variables in the form of `ENDPOINT : "https://example.com"`
        :param _builtins.str build_id: BuildID is an optional identifier that can be passed together with the build request. The same identifier can be used to gracefully cancel the build with the cancel request.
        :param _builtins.str build_log_file: Path to a file where the buildx log are written to. Only available when `builder` is set. If not set, no logs are available. The path is taken as is, so make sure to use a path that is available.
        :param _builtins.str builder: Set the name of the buildx builder to use. If not set, the legacy builder is used.
        :param Sequence[_builtins.str] cache_froms: External cache sources (e.g., `user/app:cache`, `type=local,src=path/to/dir`). Only supported when using a buildx builder.
        :param Sequence[_builtins.str] cache_tos: Cache export destinations (e.g., `user/app:cache`, `type=local,dest=path/to/dir`). Only supported when using a buildx builder.
        :param _builtins.str cgroup_parent: Optional parent cgroup for the container
        :param _builtins.int cpu_period: The length of a CPU period in microseconds
        :param _builtins.int cpu_quota: Microseconds of CPU time that the container can get in a CPU period
        :param _builtins.str cpu_set_cpus: CPUs in which to allow execution (e.g., `0-3`, `0`, `1`)
        :param _builtins.str cpu_set_mems: MEMs in which to allow execution (`0-3`, `0`, `1`)
        :param _builtins.int cpu_shares: CPU shares (relative weight)
        :param _builtins.str dockerfile: Name of the Dockerfile. Defaults to `Dockerfile`.
        :param Sequence[_builtins.str] extra_hosts: A list of hostnames/IP mappings to add to the container’s /etc/hosts file. Specified in the form ["hostname:IP"]
        :param _builtins.bool force_remove: Always remove intermediate containers
        :param _builtins.str isolation: Isolation represents the isolation technology of a container. The supported values are
        :param Mapping[str, _builtins.str] label: Set metadata for an image
        :param Mapping[str, _builtins.str] labels: User-defined key/value metadata
        :param _builtins.int memory: Set memory limit for build
        :param _builtins.int memory_swap: Total memory (memory + swap), -1 to enable unlimited swap
        :param _builtins.str network_mode: Set the networking mode for the RUN instructions during build
        :param _builtins.bool no_cache: Do not use the cache when building the image
        :param _builtins.str platform: Set the target platform for the build. Defaults to `GOOS/GOARCH`. For more information see the [docker documentation](https://github.com/docker/buildx/blob/master/docs/reference/buildx.md#-set-the-target-platforms-for-the-build---platform)
        :param _builtins.bool pull_parent: Attempt to pull the image even if an older image exists locally
        :param _builtins.str remote_context: A Git repository URI or HTTP/HTTPS context URI. Will be ignored if `builder` is set.
        :param _builtins.bool remove: Remove intermediate containers after a successful build. Defaults to `true`.
        :param Sequence['RemoteImageBuildSecretArgs'] secrets: Set build-time secrets. Only available when you use a buildx builder.
        :param Sequence[_builtins.str] security_opts: The security options
        :param _builtins.str session_id: Set an ID for the build session
        :param _builtins.int shm_size: Size of /dev/shm in bytes. The size must be greater than 0
        :param _builtins.bool squash: If true the new layers are squashed into a new image with a single new layer
        :param _builtins.bool suppress_output: Suppress the build output and print image ID on success
        :param Sequence[_builtins.str] tags: Name and optionally a tag in the 'name:tag' format
        :param _builtins.str target: Set the target build stage to build
        :param Sequence['RemoteImageBuildUlimitArgs'] ulimits: Configuration for ulimits
        :param _builtins.str version: Version of the underlying builder to use
        """
        pulumi.set(__self__, "context", context)
        if additional_contexts is not None:
            pulumi.set(__self__, "additional_contexts", additional_contexts)
        if auth_configs is not None:
            pulumi.set(__self__, "auth_configs", auth_configs)
        if build_args is not None:
            pulumi.set(__self__, "build_args", build_args)
        if build_id is not None:
            pulumi.set(__self__, "build_id", build_id)
        if build_log_file is not None:
            pulumi.set(__self__, "build_log_file", build_log_file)
        if builder is not None:
            pulumi.set(__self__, "builder", builder)
        if cache_froms is not None:
            pulumi.set(__self__, "cache_froms", cache_froms)
        if cache_tos is not None:
            pulumi.set(__self__, "cache_tos", cache_tos)
        if cgroup_parent is not None:
            pulumi.set(__self__, "cgroup_parent", cgroup_parent)
        if cpu_period is not None:
            pulumi.set(__self__, "cpu_period", cpu_period)
        if cpu_quota is not None:
            pulumi.set(__self__, "cpu_quota", cpu_quota)
        if cpu_set_cpus is not None:
            pulumi.set(__self__, "cpu_set_cpus", cpu_set_cpus)
        if cpu_set_mems is not None:
            pulumi.set(__self__, "cpu_set_mems", cpu_set_mems)
        if cpu_shares is not None:
            pulumi.set(__self__, "cpu_shares", cpu_shares)
        if dockerfile is not None:
            pulumi.set(__self__, "dockerfile", dockerfile)
        if extra_hosts is not None:
            pulumi.set(__self__, "extra_hosts", extra_hosts)
        if force_remove is not None:
            pulumi.set(__self__, "force_remove", force_remove)
        if isolation is not None:
            pulumi.set(__self__, "isolation", isolation)
        if label is not None:
            pulumi.set(__self__, "label", label)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if memory is not None:
            pulumi.set(__self__, "memory", memory)
        if memory_swap is not None:
            pulumi.set(__self__, "memory_swap", memory_swap)
        if network_mode is not None:
            pulumi.set(__self__, "network_mode", network_mode)
        if no_cache is not None:
            pulumi.set(__self__, "no_cache", no_cache)
        if platform is not None:
            pulumi.set(__self__, "platform", platform)
        if pull_parent is not None:
            pulumi.set(__self__, "pull_parent", pull_parent)
        if remote_context is not None:
            pulumi.set(__self__, "remote_context", remote_context)
        if remove is not None:
            pulumi.set(__self__, "remove", remove)
        if secrets is not None:
            pulumi.set(__self__, "secrets", secrets)
        if security_opts is not None:
            pulumi.set(__self__, "security_opts", security_opts)
        if session_id is not None:
            pulumi.set(__self__, "session_id", session_id)
        if shm_size is not None:
            pulumi.set(__self__, "shm_size", shm_size)
        if squash is not None:
            pulumi.set(__self__, "squash", squash)
        if suppress_output is not None:
            pulumi.set(__self__, "suppress_output", suppress_output)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if target is not None:
            pulumi.set(__self__, "target", target)
        if ulimits is not None:
            pulumi.set(__self__, "ulimits", ulimits)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @_builtins.property
    @pulumi.getter
    def context(self) -> _builtins.str:
        """
        Value to specify the build context. Currently, only a `PATH` context is supported. You can use the helper function '${path.cwd}/context-dir'. This always refers to the local working directory, even when building images on remote hosts. Please see https://docs.docker.com/build/building/context/ for more information about build contexts.
        """
        return pulumi.get(self, "context")

    @_builtins.property
    @pulumi.getter(name="additionalContexts")
    def additional_contexts(self) -> Optional[Sequence[_builtins.str]]:
        """
        A list of additional build contexts. Only supported when using a buildx builder. Example: `["name=path", "src = https://example.org"}`. Please see https://docs.docker.com/reference/cli/docker/buildx/build/#build-context for more information.
        """
        return pulumi.get(self, "additional_contexts")

    @_builtins.property
    @pulumi.getter(name="authConfigs")
    def auth_configs(self) -> Optional[Sequence['outputs.RemoteImageBuildAuthConfig']]:
        """
        The configuration for the authentication
        """
        return pulumi.get(self, "auth_configs")

    @_builtins.property
    @pulumi.getter(name="buildArgs")
    def build_args(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        Pairs for build-time variables in the form of `ENDPOINT : "https://example.com"`
        """
        return pulumi.get(self, "build_args")

    @_builtins.property
    @pulumi.getter(name="buildId")
    def build_id(self) -> Optional[_builtins.str]:
        """
        BuildID is an optional identifier that can be passed together with the build request. The same identifier can be used to gracefully cancel the build with the cancel request.
        """
        return pulumi.get(self, "build_id")

    @_builtins.property
    @pulumi.getter(name="buildLogFile")
    def build_log_file(self) -> Optional[_builtins.str]:
        """
        Path to a file where the buildx log are written to. Only available when `builder` is set. If not set, no logs are available. The path is taken as is, so make sure to use a path that is available.
        """
        return pulumi.get(self, "build_log_file")

    @_builtins.property
    @pulumi.getter
    def builder(self) -> Optional[_builtins.str]:
        """
        Set the name of the buildx builder to use. If not set, the legacy builder is used.
        """
        return pulumi.get(self, "builder")

    @_builtins.property
    @pulumi.getter(name="cacheFroms")
    def cache_froms(self) -> Optional[Sequence[_builtins.str]]:
        """
        External cache sources (e.g., `user/app:cache`, `type=local,src=path/to/dir`). Only supported when using a buildx builder.
        """
        return pulumi.get(self, "cache_froms")

    @_builtins.property
    @pulumi.getter(name="cacheTos")
    def cache_tos(self) -> Optional[Sequence[_builtins.str]]:
        """
        Cache export destinations (e.g., `user/app:cache`, `type=local,dest=path/to/dir`). Only supported when using a buildx builder.
        """
        return pulumi.get(self, "cache_tos")

    @_builtins.property
    @pulumi.getter(name="cgroupParent")
    def cgroup_parent(self) -> Optional[_builtins.str]:
        """
        Optional parent cgroup for the container
        """
        return pulumi.get(self, "cgroup_parent")

    @_builtins.property
    @pulumi.getter(name="cpuPeriod")
    def cpu_period(self) -> Optional[_builtins.int]:
        """
        The length of a CPU period in microseconds
        """
        return pulumi.get(self, "cpu_period")

    @_builtins.property
    @pulumi.getter(name="cpuQuota")
    def cpu_quota(self) -> Optional[_builtins.int]:
        """
        Microseconds of CPU time that the container can get in a CPU period
        """
        return pulumi.get(self, "cpu_quota")

    @_builtins.property
    @pulumi.getter(name="cpuSetCpus")
    def cpu_set_cpus(self) -> Optional[_builtins.str]:
        """
        CPUs in which to allow execution (e.g., `0-3`, `0`, `1`)
        """
        return pulumi.get(self, "cpu_set_cpus")

    @_builtins.property
    @pulumi.getter(name="cpuSetMems")
    def cpu_set_mems(self) -> Optional[_builtins.str]:
        """
        MEMs in which to allow execution (`0-3`, `0`, `1`)
        """
        return pulumi.get(self, "cpu_set_mems")

    @_builtins.property
    @pulumi.getter(name="cpuShares")
    def cpu_shares(self) -> Optional[_builtins.int]:
        """
        CPU shares (relative weight)
        """
        return pulumi.get(self, "cpu_shares")

    @_builtins.property
    @pulumi.getter
    def dockerfile(self) -> Optional[_builtins.str]:
        """
        Name of the Dockerfile. Defaults to `Dockerfile`.
        """
        return pulumi.get(self, "dockerfile")

    @_builtins.property
    @pulumi.getter(name="extraHosts")
    def extra_hosts(self) -> Optional[Sequence[_builtins.str]]:
        """
        A list of hostnames/IP mappings to add to the container’s /etc/hosts file. Specified in the form ["hostname:IP"]
        """
        return pulumi.get(self, "extra_hosts")

    @_builtins.property
    @pulumi.getter(name="forceRemove")
    def force_remove(self) -> Optional[_builtins.bool]:
        """
        Always remove intermediate containers
        """
        return pulumi.get(self, "force_remove")

    @_builtins.property
    @pulumi.getter
    def isolation(self) -> Optional[_builtins.str]:
        """
        Isolation represents the isolation technology of a container. The supported values are
        """
        return pulumi.get(self, "isolation")

    @_builtins.property
    @pulumi.getter
    def label(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        Set metadata for an image
        """
        return pulumi.get(self, "label")

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        User-defined key/value metadata
        """
        return pulumi.get(self, "labels")

    @_builtins.property
    @pulumi.getter
    def memory(self) -> Optional[_builtins.int]:
        """
        Set memory limit for build
        """
        return pulumi.get(self, "memory")

    @_builtins.property
    @pulumi.getter(name="memorySwap")
    def memory_swap(self) -> Optional[_builtins.int]:
        """
        Total memory (memory + swap), -1 to enable unlimited swap
        """
        return pulumi.get(self, "memory_swap")

    @_builtins.property
    @pulumi.getter(name="networkMode")
    def network_mode(self) -> Optional[_builtins.str]:
        """
        Set the networking mode for the RUN instructions during build
        """
        return pulumi.get(self, "network_mode")

    @_builtins.property
    @pulumi.getter(name="noCache")
    def no_cache(self) -> Optional[_builtins.bool]:
        """
        Do not use the cache when building the image
        """
        return pulumi.get(self, "no_cache")

    @_builtins.property
    @pulumi.getter
    def platform(self) -> Optional[_builtins.str]:
        """
        Set the target platform for the build. Defaults to `GOOS/GOARCH`. For more information see the [docker documentation](https://github.com/docker/buildx/blob/master/docs/reference/buildx.md#-set-the-target-platforms-for-the-build---platform)
        """
        return pulumi.get(self, "platform")

    @_builtins.property
    @pulumi.getter(name="pullParent")
    def pull_parent(self) -> Optional[_builtins.bool]:
        """
        Attempt to pull the image even if an older image exists locally
        """
        return pulumi.get(self, "pull_parent")

    @_builtins.property
    @pulumi.getter(name="remoteContext")
    def remote_context(self) -> Optional[_builtins.str]:
        """
        A Git repository URI or HTTP/HTTPS context URI. Will be ignored if `builder` is set.
        """
        return pulumi.get(self, "remote_context")

    @_builtins.property
    @pulumi.getter
    def remove(self) -> Optional[_builtins.bool]:
        """
        Remove intermediate containers after a successful build. Defaults to `true`.
        """
        return pulumi.get(self, "remove")

    @_builtins.property
    @pulumi.getter
    def secrets(self) -> Optional[Sequence['outputs.RemoteImageBuildSecret']]:
        """
        Set build-time secrets. Only available when you use a buildx builder.
        """
        return pulumi.get(self, "secrets")

    @_builtins.property
    @pulumi.getter(name="securityOpts")
    def security_opts(self) -> Optional[Sequence[_builtins.str]]:
        """
        The security options
        """
        return pulumi.get(self, "security_opts")

    @_builtins.property
    @pulumi.getter(name="sessionId")
    def session_id(self) -> Optional[_builtins.str]:
        """
        Set an ID for the build session
        """
        return pulumi.get(self, "session_id")

    @_builtins.property
    @pulumi.getter(name="shmSize")
    def shm_size(self) -> Optional[_builtins.int]:
        """
        Size of /dev/shm in bytes. The size must be greater than 0
        """
        return pulumi.get(self, "shm_size")

    @_builtins.property
    @pulumi.getter
    def squash(self) -> Optional[_builtins.bool]:
        """
        If true the new layers are squashed into a new image with a single new layer
        """
        return pulumi.get(self, "squash")

    @_builtins.property
    @pulumi.getter(name="suppressOutput")
    def suppress_output(self) -> Optional[_builtins.bool]:
        """
        Suppress the build output and print image ID on success
        """
        return pulumi.get(self, "suppress_output")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[Sequence[_builtins.str]]:
        """
        Name and optionally a tag in the 'name:tag' format
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter
    def target(self) -> Optional[_builtins.str]:
        """
        Set the target build stage to build
        """
        return pulumi.get(self, "target")

    @_builtins.property
    @pulumi.getter
    def ulimits(self) -> Optional[Sequence['outputs.RemoteImageBuildUlimit']]:
        """
        Configuration for ulimits
        """
        return pulumi.get(self, "ulimits")

    @_builtins.property
    @pulumi.getter
    def version(self) -> Optional[_builtins.str]:
        """
        Version of the underlying builder to use
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class RemoteImageBuildAuthConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "hostName":
            suggest = "host_name"
        elif key == "identityToken":
            suggest = "identity_token"
        elif key == "registryToken":
            suggest = "registry_token"
        elif key == "serverAddress":
            suggest = "server_address"
        elif key == "userName":
            suggest = "user_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RemoteImageBuildAuthConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RemoteImageBuildAuthConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RemoteImageBuildAuthConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 host_name: _builtins.str,
                 auth: Optional[_builtins.str] = None,
                 email: Optional[_builtins.str] = None,
                 identity_token: Optional[_builtins.str] = None,
                 password: Optional[_builtins.str] = None,
                 registry_token: Optional[_builtins.str] = None,
                 server_address: Optional[_builtins.str] = None,
                 user_name: Optional[_builtins.str] = None):
        """
        :param _builtins.str host_name: hostname of the registry
        :param _builtins.str auth: the auth token
        :param _builtins.str email: the user emal
        :param _builtins.str identity_token: the identity token
        :param _builtins.str password: the registry password
        :param _builtins.str registry_token: the registry token
        :param _builtins.str server_address: the server address
        :param _builtins.str user_name: the registry user name
        """
        pulumi.set(__self__, "host_name", host_name)
        if auth is not None:
            pulumi.set(__self__, "auth", auth)
        if email is not None:
            pulumi.set(__self__, "email", email)
        if identity_token is not None:
            pulumi.set(__self__, "identity_token", identity_token)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if registry_token is not None:
            pulumi.set(__self__, "registry_token", registry_token)
        if server_address is not None:
            pulumi.set(__self__, "server_address", server_address)
        if user_name is not None:
            pulumi.set(__self__, "user_name", user_name)

    @_builtins.property
    @pulumi.getter(name="hostName")
    def host_name(self) -> _builtins.str:
        """
        hostname of the registry
        """
        return pulumi.get(self, "host_name")

    @_builtins.property
    @pulumi.getter
    def auth(self) -> Optional[_builtins.str]:
        """
        the auth token
        """
        return pulumi.get(self, "auth")

    @_builtins.property
    @pulumi.getter
    def email(self) -> Optional[_builtins.str]:
        """
        the user emal
        """
        return pulumi.get(self, "email")

    @_builtins.property
    @pulumi.getter(name="identityToken")
    def identity_token(self) -> Optional[_builtins.str]:
        """
        the identity token
        """
        return pulumi.get(self, "identity_token")

    @_builtins.property
    @pulumi.getter
    def password(self) -> Optional[_builtins.str]:
        """
        the registry password
        """
        return pulumi.get(self, "password")

    @_builtins.property
    @pulumi.getter(name="registryToken")
    def registry_token(self) -> Optional[_builtins.str]:
        """
        the registry token
        """
        return pulumi.get(self, "registry_token")

    @_builtins.property
    @pulumi.getter(name="serverAddress")
    def server_address(self) -> Optional[_builtins.str]:
        """
        the server address
        """
        return pulumi.get(self, "server_address")

    @_builtins.property
    @pulumi.getter(name="userName")
    def user_name(self) -> Optional[_builtins.str]:
        """
        the registry user name
        """
        return pulumi.get(self, "user_name")


@pulumi.output_type
class RemoteImageBuildSecret(dict):
    def __init__(__self__, *,
                 id: _builtins.str,
                 env: Optional[_builtins.str] = None,
                 src: Optional[_builtins.str] = None):
        """
        :param _builtins.str id: ID of the secret. By default, secrets are mounted to /run/secrets/\\n\\n
        :param _builtins.str env: Environment variable source of the secret
        :param _builtins.str src: File source of the secret. Takes precedence over `env`
        """
        pulumi.set(__self__, "id", id)
        if env is not None:
            pulumi.set(__self__, "env", env)
        if src is not None:
            pulumi.set(__self__, "src", src)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        ID of the secret. By default, secrets are mounted to /run/secrets/\\n\\n
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def env(self) -> Optional[_builtins.str]:
        """
        Environment variable source of the secret
        """
        return pulumi.get(self, "env")

    @_builtins.property
    @pulumi.getter
    def src(self) -> Optional[_builtins.str]:
        """
        File source of the secret. Takes precedence over `env`
        """
        return pulumi.get(self, "src")


@pulumi.output_type
class RemoteImageBuildUlimit(dict):
    def __init__(__self__, *,
                 hard: _builtins.int,
                 name: _builtins.str,
                 soft: _builtins.int):
        """
        :param _builtins.int hard: soft limit
        :param _builtins.str name: type of ulimit, e.g. `nofile`
        :param _builtins.int soft: hard limit
        """
        pulumi.set(__self__, "hard", hard)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "soft", soft)

    @_builtins.property
    @pulumi.getter
    def hard(self) -> _builtins.int:
        """
        soft limit
        """
        return pulumi.get(self, "hard")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        type of ulimit, e.g. `nofile`
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def soft(self) -> _builtins.int:
        """
        hard limit
        """
        return pulumi.get(self, "soft")


@pulumi.output_type
class SecretLabel(dict):
    def __init__(__self__, *,
                 label: _builtins.str,
                 value: _builtins.str):
        """
        :param _builtins.str label: Name of the label
        :param _builtins.str value: Value of the label
        """
        pulumi.set(__self__, "label", label)
        pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def label(self) -> _builtins.str:
        """
        Name of the label
        """
        return pulumi.get(self, "label")

    @_builtins.property
    @pulumi.getter
    def value(self) -> _builtins.str:
        """
        Value of the label
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class ServiceAuth(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "serverAddress":
            suggest = "server_address"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceAuth. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceAuth.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceAuth.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 server_address: _builtins.str,
                 password: Optional[_builtins.str] = None,
                 username: Optional[_builtins.str] = None):
        """
        :param _builtins.str server_address: The address of the server for the authentication
        :param _builtins.str password: The password
        :param _builtins.str username: The username
        """
        pulumi.set(__self__, "server_address", server_address)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if username is not None:
            pulumi.set(__self__, "username", username)

    @_builtins.property
    @pulumi.getter(name="serverAddress")
    def server_address(self) -> _builtins.str:
        """
        The address of the server for the authentication
        """
        return pulumi.get(self, "server_address")

    @_builtins.property
    @pulumi.getter
    def password(self) -> Optional[_builtins.str]:
        """
        The password
        """
        return pulumi.get(self, "password")

    @_builtins.property
    @pulumi.getter
    def username(self) -> Optional[_builtins.str]:
        """
        The username
        """
        return pulumi.get(self, "username")


@pulumi.output_type
class ServiceConvergeConfig(dict):
    def __init__(__self__, *,
                 delay: Optional[_builtins.str] = None,
                 timeout: Optional[_builtins.str] = None):
        """
        :param _builtins.str delay: The interval to check if the desired state is reached `(ms|s)`. Defaults to `7s`.
        :param _builtins.str timeout: The timeout of the service to reach the desired state `(s|m)`. Defaults to `3m`
        """
        if delay is not None:
            pulumi.set(__self__, "delay", delay)
        if timeout is not None:
            pulumi.set(__self__, "timeout", timeout)

    @_builtins.property
    @pulumi.getter
    def delay(self) -> Optional[_builtins.str]:
        """
        The interval to check if the desired state is reached `(ms|s)`. Defaults to `7s`.
        """
        return pulumi.get(self, "delay")

    @_builtins.property
    @pulumi.getter
    def timeout(self) -> Optional[_builtins.str]:
        """
        The timeout of the service to reach the desired state `(s|m)`. Defaults to `3m`
        """
        return pulumi.get(self, "timeout")


@pulumi.output_type
class ServiceEndpointSpec(dict):
    def __init__(__self__, *,
                 mode: Optional[_builtins.str] = None,
                 ports: Optional[Sequence['outputs.ServiceEndpointSpecPort']] = None):
        """
        :param _builtins.str mode: The mode of resolution to use for internal load balancing between tasks
        :param Sequence['ServiceEndpointSpecPortArgs'] ports: List of exposed ports that this service is accessible on from the outside. Ports can only be provided if 'vip' resolution mode is used
        """
        if mode is not None:
            pulumi.set(__self__, "mode", mode)
        if ports is not None:
            pulumi.set(__self__, "ports", ports)

    @_builtins.property
    @pulumi.getter
    def mode(self) -> Optional[_builtins.str]:
        """
        The mode of resolution to use for internal load balancing between tasks
        """
        return pulumi.get(self, "mode")

    @_builtins.property
    @pulumi.getter
    def ports(self) -> Optional[Sequence['outputs.ServiceEndpointSpecPort']]:
        """
        List of exposed ports that this service is accessible on from the outside. Ports can only be provided if 'vip' resolution mode is used
        """
        return pulumi.get(self, "ports")


@pulumi.output_type
class ServiceEndpointSpecPort(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "targetPort":
            suggest = "target_port"
        elif key == "publishMode":
            suggest = "publish_mode"
        elif key == "publishedPort":
            suggest = "published_port"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceEndpointSpecPort. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceEndpointSpecPort.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceEndpointSpecPort.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 target_port: _builtins.int,
                 name: Optional[_builtins.str] = None,
                 protocol: Optional[_builtins.str] = None,
                 publish_mode: Optional[_builtins.str] = None,
                 published_port: Optional[_builtins.int] = None):
        """
        :param _builtins.int target_port: The port inside the container
        :param _builtins.str name: A random name for the port
        :param _builtins.str protocol: Rrepresents the protocol of a port: `tcp`, `udp` or `sctp`. Defaults to `tcp`.
        :param _builtins.str publish_mode: Represents the mode in which the port is to be published: 'ingress' or 'host'. Defaults to `ingress`.
        :param _builtins.int published_port: The port on the swarm hosts
        """
        pulumi.set(__self__, "target_port", target_port)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)
        if publish_mode is not None:
            pulumi.set(__self__, "publish_mode", publish_mode)
        if published_port is not None:
            pulumi.set(__self__, "published_port", published_port)

    @_builtins.property
    @pulumi.getter(name="targetPort")
    def target_port(self) -> _builtins.int:
        """
        The port inside the container
        """
        return pulumi.get(self, "target_port")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        A random name for the port
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> Optional[_builtins.str]:
        """
        Rrepresents the protocol of a port: `tcp`, `udp` or `sctp`. Defaults to `tcp`.
        """
        return pulumi.get(self, "protocol")

    @_builtins.property
    @pulumi.getter(name="publishMode")
    def publish_mode(self) -> Optional[_builtins.str]:
        """
        Represents the mode in which the port is to be published: 'ingress' or 'host'. Defaults to `ingress`.
        """
        return pulumi.get(self, "publish_mode")

    @_builtins.property
    @pulumi.getter(name="publishedPort")
    def published_port(self) -> Optional[_builtins.int]:
        """
        The port on the swarm hosts
        """
        return pulumi.get(self, "published_port")


@pulumi.output_type
class ServiceLabel(dict):
    def __init__(__self__, *,
                 label: _builtins.str,
                 value: _builtins.str):
        """
        :param _builtins.str label: Name of the label
        :param _builtins.str value: Value of the label
        """
        pulumi.set(__self__, "label", label)
        pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def label(self) -> _builtins.str:
        """
        Name of the label
        """
        return pulumi.get(self, "label")

    @_builtins.property
    @pulumi.getter
    def value(self) -> _builtins.str:
        """
        Value of the label
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class ServiceMode(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "global":
            suggest = "global_"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceMode. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceMode.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceMode.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 global_: Optional[_builtins.bool] = None,
                 replicated: Optional['outputs.ServiceModeReplicated'] = None):
        """
        :param _builtins.bool global_: When `true`, tasks will run on every worker node. Conflicts with `replicated`
        :param 'ServiceModeReplicatedArgs' replicated: The replicated service mode
        """
        if global_ is not None:
            pulumi.set(__self__, "global_", global_)
        if replicated is not None:
            pulumi.set(__self__, "replicated", replicated)

    @_builtins.property
    @pulumi.getter(name="global")
    def global_(self) -> Optional[_builtins.bool]:
        """
        When `true`, tasks will run on every worker node. Conflicts with `replicated`
        """
        return pulumi.get(self, "global_")

    @_builtins.property
    @pulumi.getter
    def replicated(self) -> Optional['outputs.ServiceModeReplicated']:
        """
        The replicated service mode
        """
        return pulumi.get(self, "replicated")


@pulumi.output_type
class ServiceModeReplicated(dict):
    def __init__(__self__, *,
                 replicas: Optional[_builtins.int] = None):
        """
        :param _builtins.int replicas: The amount of replicas of the service. Defaults to `1`
        """
        if replicas is not None:
            pulumi.set(__self__, "replicas", replicas)

    @_builtins.property
    @pulumi.getter
    def replicas(self) -> Optional[_builtins.int]:
        """
        The amount of replicas of the service. Defaults to `1`
        """
        return pulumi.get(self, "replicas")


@pulumi.output_type
class ServiceRollbackConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "failureAction":
            suggest = "failure_action"
        elif key == "maxFailureRatio":
            suggest = "max_failure_ratio"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceRollbackConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceRollbackConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceRollbackConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 delay: Optional[_builtins.str] = None,
                 failure_action: Optional[_builtins.str] = None,
                 max_failure_ratio: Optional[_builtins.str] = None,
                 monitor: Optional[_builtins.str] = None,
                 order: Optional[_builtins.str] = None,
                 parallelism: Optional[_builtins.int] = None):
        """
        :param _builtins.str delay: Delay between task rollbacks (ns|us|ms|s|m|h). Defaults to `0s`.
        :param _builtins.str failure_action: Action on rollback failure: pause | continue. Defaults to `pause`.
        :param _builtins.str max_failure_ratio: Failure rate to tolerate during a rollback. Defaults to `0.0`.
        :param _builtins.str monitor: Duration after each task rollback to monitor for failure (ns|us|ms|s|m|h). Defaults to `5s`.
        :param _builtins.str order: Rollback order: either 'stop-first' or 'start-first'. Defaults to `stop-first`.
        :param _builtins.int parallelism: Maximum number of tasks to be rollbacked in one iteration. Defaults to `1`
        """
        if delay is not None:
            pulumi.set(__self__, "delay", delay)
        if failure_action is not None:
            pulumi.set(__self__, "failure_action", failure_action)
        if max_failure_ratio is not None:
            pulumi.set(__self__, "max_failure_ratio", max_failure_ratio)
        if monitor is not None:
            pulumi.set(__self__, "monitor", monitor)
        if order is not None:
            pulumi.set(__self__, "order", order)
        if parallelism is not None:
            pulumi.set(__self__, "parallelism", parallelism)

    @_builtins.property
    @pulumi.getter
    def delay(self) -> Optional[_builtins.str]:
        """
        Delay between task rollbacks (ns|us|ms|s|m|h). Defaults to `0s`.
        """
        return pulumi.get(self, "delay")

    @_builtins.property
    @pulumi.getter(name="failureAction")
    def failure_action(self) -> Optional[_builtins.str]:
        """
        Action on rollback failure: pause | continue. Defaults to `pause`.
        """
        return pulumi.get(self, "failure_action")

    @_builtins.property
    @pulumi.getter(name="maxFailureRatio")
    def max_failure_ratio(self) -> Optional[_builtins.str]:
        """
        Failure rate to tolerate during a rollback. Defaults to `0.0`.
        """
        return pulumi.get(self, "max_failure_ratio")

    @_builtins.property
    @pulumi.getter
    def monitor(self) -> Optional[_builtins.str]:
        """
        Duration after each task rollback to monitor for failure (ns|us|ms|s|m|h). Defaults to `5s`.
        """
        return pulumi.get(self, "monitor")

    @_builtins.property
    @pulumi.getter
    def order(self) -> Optional[_builtins.str]:
        """
        Rollback order: either 'stop-first' or 'start-first'. Defaults to `stop-first`.
        """
        return pulumi.get(self, "order")

    @_builtins.property
    @pulumi.getter
    def parallelism(self) -> Optional[_builtins.int]:
        """
        Maximum number of tasks to be rollbacked in one iteration. Defaults to `1`
        """
        return pulumi.get(self, "parallelism")


@pulumi.output_type
class ServiceTaskSpec(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "containerSpec":
            suggest = "container_spec"
        elif key == "forceUpdate":
            suggest = "force_update"
        elif key == "logDriver":
            suggest = "log_driver"
        elif key == "networksAdvanceds":
            suggest = "networks_advanceds"
        elif key == "restartPolicy":
            suggest = "restart_policy"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceTaskSpec. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceTaskSpec.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceTaskSpec.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 container_spec: 'outputs.ServiceTaskSpecContainerSpec',
                 force_update: Optional[_builtins.int] = None,
                 log_driver: Optional['outputs.ServiceTaskSpecLogDriver'] = None,
                 networks_advanceds: Optional[Sequence['outputs.ServiceTaskSpecNetworksAdvanced']] = None,
                 placement: Optional['outputs.ServiceTaskSpecPlacement'] = None,
                 resources: Optional['outputs.ServiceTaskSpecResources'] = None,
                 restart_policy: Optional['outputs.ServiceTaskSpecRestartPolicy'] = None,
                 runtime: Optional[_builtins.str] = None):
        """
        :param 'ServiceTaskSpecContainerSpecArgs' container_spec: The spec for each container
        :param _builtins.int force_update: A counter that triggers an update even if no relevant parameters have been changed. See the [spec](https://github.com/docker/swarmkit/blob/master/api/specs.proto#L126).
        :param 'ServiceTaskSpecLogDriverArgs' log_driver: Specifies the log driver to use for tasks created from this spec. If not present, the default one for the swarm will be used, finally falling back to the engine default if not specified
        :param Sequence['ServiceTaskSpecNetworksAdvancedArgs'] networks_advanceds: The networks the container is attached to
        :param 'ServiceTaskSpecPlacementArgs' placement: The placement preferences
        :param 'ServiceTaskSpecResourcesArgs' resources: Resource requirements which apply to each individual container created as part of the service
        :param 'ServiceTaskSpecRestartPolicyArgs' restart_policy: Specification for the restart policy which applies to containers created as part of this service.
        :param _builtins.str runtime: Runtime is the type of runtime specified for the task executor. See the [types](https://github.com/moby/moby/blob/master/api/types/swarm/runtime.go).
        """
        pulumi.set(__self__, "container_spec", container_spec)
        if force_update is not None:
            pulumi.set(__self__, "force_update", force_update)
        if log_driver is not None:
            pulumi.set(__self__, "log_driver", log_driver)
        if networks_advanceds is not None:
            pulumi.set(__self__, "networks_advanceds", networks_advanceds)
        if placement is not None:
            pulumi.set(__self__, "placement", placement)
        if resources is not None:
            pulumi.set(__self__, "resources", resources)
        if restart_policy is not None:
            pulumi.set(__self__, "restart_policy", restart_policy)
        if runtime is not None:
            pulumi.set(__self__, "runtime", runtime)

    @_builtins.property
    @pulumi.getter(name="containerSpec")
    def container_spec(self) -> 'outputs.ServiceTaskSpecContainerSpec':
        """
        The spec for each container
        """
        return pulumi.get(self, "container_spec")

    @_builtins.property
    @pulumi.getter(name="forceUpdate")
    def force_update(self) -> Optional[_builtins.int]:
        """
        A counter that triggers an update even if no relevant parameters have been changed. See the [spec](https://github.com/docker/swarmkit/blob/master/api/specs.proto#L126).
        """
        return pulumi.get(self, "force_update")

    @_builtins.property
    @pulumi.getter(name="logDriver")
    def log_driver(self) -> Optional['outputs.ServiceTaskSpecLogDriver']:
        """
        Specifies the log driver to use for tasks created from this spec. If not present, the default one for the swarm will be used, finally falling back to the engine default if not specified
        """
        return pulumi.get(self, "log_driver")

    @_builtins.property
    @pulumi.getter(name="networksAdvanceds")
    def networks_advanceds(self) -> Optional[Sequence['outputs.ServiceTaskSpecNetworksAdvanced']]:
        """
        The networks the container is attached to
        """
        return pulumi.get(self, "networks_advanceds")

    @_builtins.property
    @pulumi.getter
    def placement(self) -> Optional['outputs.ServiceTaskSpecPlacement']:
        """
        The placement preferences
        """
        return pulumi.get(self, "placement")

    @_builtins.property
    @pulumi.getter
    def resources(self) -> Optional['outputs.ServiceTaskSpecResources']:
        """
        Resource requirements which apply to each individual container created as part of the service
        """
        return pulumi.get(self, "resources")

    @_builtins.property
    @pulumi.getter(name="restartPolicy")
    def restart_policy(self) -> Optional['outputs.ServiceTaskSpecRestartPolicy']:
        """
        Specification for the restart policy which applies to containers created as part of this service.
        """
        return pulumi.get(self, "restart_policy")

    @_builtins.property
    @pulumi.getter
    def runtime(self) -> Optional[_builtins.str]:
        """
        Runtime is the type of runtime specified for the task executor. See the [types](https://github.com/moby/moby/blob/master/api/types/swarm/runtime.go).
        """
        return pulumi.get(self, "runtime")


@pulumi.output_type
class ServiceTaskSpecContainerSpec(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "capAdds":
            suggest = "cap_adds"
        elif key == "capDrops":
            suggest = "cap_drops"
        elif key == "dnsConfig":
            suggest = "dns_config"
        elif key == "readOnly":
            suggest = "read_only"
        elif key == "stopGracePeriod":
            suggest = "stop_grace_period"
        elif key == "stopSignal":
            suggest = "stop_signal"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceTaskSpecContainerSpec. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceTaskSpecContainerSpec.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceTaskSpecContainerSpec.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 image: _builtins.str,
                 args: Optional[Sequence[_builtins.str]] = None,
                 cap_adds: Optional[Sequence[_builtins.str]] = None,
                 cap_drops: Optional[Sequence[_builtins.str]] = None,
                 commands: Optional[Sequence[_builtins.str]] = None,
                 configs: Optional[Sequence['outputs.ServiceTaskSpecContainerSpecConfig']] = None,
                 dir: Optional[_builtins.str] = None,
                 dns_config: Optional['outputs.ServiceTaskSpecContainerSpecDnsConfig'] = None,
                 env: Optional[Mapping[str, _builtins.str]] = None,
                 groups: Optional[Sequence[_builtins.str]] = None,
                 healthcheck: Optional['outputs.ServiceTaskSpecContainerSpecHealthcheck'] = None,
                 hostname: Optional[_builtins.str] = None,
                 hosts: Optional[Sequence['outputs.ServiceTaskSpecContainerSpecHost']] = None,
                 isolation: Optional[_builtins.str] = None,
                 labels: Optional[Sequence['outputs.ServiceTaskSpecContainerSpecLabel']] = None,
                 mounts: Optional[Sequence['outputs.ServiceTaskSpecContainerSpecMount']] = None,
                 privileges: Optional['outputs.ServiceTaskSpecContainerSpecPrivileges'] = None,
                 read_only: Optional[_builtins.bool] = None,
                 secrets: Optional[Sequence['outputs.ServiceTaskSpecContainerSpecSecret']] = None,
                 stop_grace_period: Optional[_builtins.str] = None,
                 stop_signal: Optional[_builtins.str] = None,
                 sysctl: Optional[Mapping[str, _builtins.str]] = None,
                 user: Optional[_builtins.str] = None):
        """
        :param _builtins.str image: The image name to use for the containers of the service, like `nginx:1.17.6`. Also use the data-source or resource of `RemoteImage` with the `repo_digest` or `RegistryImage` with the `name` attribute for this, as shown in the examples.
        :param Sequence[_builtins.str] args: Arguments to the command
        :param Sequence[_builtins.str] cap_adds: List of Linux capabilities to add to the container
        :param Sequence[_builtins.str] cap_drops: List of Linux capabilities to drop from the container
        :param Sequence[_builtins.str] commands: The command/entrypoint to be run in the image. According to the [docker cli](https://github.com/docker/cli/blob/v20.10.7/cli/command/service/opts.go#L705) the override of the entrypoint is also passed to the `command` property and there is no `entrypoint` attribute in the `ContainerSpec` of the service.
        :param Sequence['ServiceTaskSpecContainerSpecConfigArgs'] configs: References to zero or more configs that will be exposed to the service
        :param _builtins.str dir: The working directory for commands to run in
        :param 'ServiceTaskSpecContainerSpecDnsConfigArgs' dns_config: Specification for DNS related configurations in resolver configuration file (`resolv.conf`)
        :param Mapping[str, _builtins.str] env: A list of environment variables in the form VAR="value"
        :param Sequence[_builtins.str] groups: A list of additional groups that the container process will run as
        :param 'ServiceTaskSpecContainerSpecHealthcheckArgs' healthcheck: A test to perform to check that the container is healthy
        :param _builtins.str hostname: The hostname to use for the container, as a valid RFC 1123 hostname
        :param Sequence['ServiceTaskSpecContainerSpecHostArgs'] hosts: A list of hostname/IP mappings to add to the container's hosts file
        :param _builtins.str isolation: Isolation technology of the containers running the service. (Windows only). Defaults to `default`.
        :param Sequence['ServiceTaskSpecContainerSpecLabelArgs'] labels: User-defined key/value metadata
        :param Sequence['ServiceTaskSpecContainerSpecMountArgs'] mounts: Specification for mounts to be added to containers created as part of the service
        :param 'ServiceTaskSpecContainerSpecPrivilegesArgs' privileges: Security options for the container
        :param _builtins.bool read_only: Mount the container's root filesystem as read only
        :param Sequence['ServiceTaskSpecContainerSpecSecretArgs'] secrets: References to zero or more secrets that will be exposed to the service
        :param _builtins.str stop_grace_period: Amount of time to wait for the container to terminate before forcefully removing it (ms|s|m|h). If not specified or '0s' the destroy will not check if all tasks/containers of the service terminate.
        :param _builtins.str stop_signal: Signal to stop the container
        :param Mapping[str, _builtins.str] sysctl: Sysctls config (Linux only)
        :param _builtins.str user: The user inside the container
        """
        pulumi.set(__self__, "image", image)
        if args is not None:
            pulumi.set(__self__, "args", args)
        if cap_adds is not None:
            pulumi.set(__self__, "cap_adds", cap_adds)
        if cap_drops is not None:
            pulumi.set(__self__, "cap_drops", cap_drops)
        if commands is not None:
            pulumi.set(__self__, "commands", commands)
        if configs is not None:
            pulumi.set(__self__, "configs", configs)
        if dir is not None:
            pulumi.set(__self__, "dir", dir)
        if dns_config is not None:
            pulumi.set(__self__, "dns_config", dns_config)
        if env is not None:
            pulumi.set(__self__, "env", env)
        if groups is not None:
            pulumi.set(__self__, "groups", groups)
        if healthcheck is not None:
            pulumi.set(__self__, "healthcheck", healthcheck)
        if hostname is not None:
            pulumi.set(__self__, "hostname", hostname)
        if hosts is not None:
            pulumi.set(__self__, "hosts", hosts)
        if isolation is not None:
            pulumi.set(__self__, "isolation", isolation)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if mounts is not None:
            pulumi.set(__self__, "mounts", mounts)
        if privileges is not None:
            pulumi.set(__self__, "privileges", privileges)
        if read_only is not None:
            pulumi.set(__self__, "read_only", read_only)
        if secrets is not None:
            pulumi.set(__self__, "secrets", secrets)
        if stop_grace_period is not None:
            pulumi.set(__self__, "stop_grace_period", stop_grace_period)
        if stop_signal is not None:
            pulumi.set(__self__, "stop_signal", stop_signal)
        if sysctl is not None:
            pulumi.set(__self__, "sysctl", sysctl)
        if user is not None:
            pulumi.set(__self__, "user", user)

    @_builtins.property
    @pulumi.getter
    def image(self) -> _builtins.str:
        """
        The image name to use for the containers of the service, like `nginx:1.17.6`. Also use the data-source or resource of `RemoteImage` with the `repo_digest` or `RegistryImage` with the `name` attribute for this, as shown in the examples.
        """
        return pulumi.get(self, "image")

    @_builtins.property
    @pulumi.getter
    def args(self) -> Optional[Sequence[_builtins.str]]:
        """
        Arguments to the command
        """
        return pulumi.get(self, "args")

    @_builtins.property
    @pulumi.getter(name="capAdds")
    def cap_adds(self) -> Optional[Sequence[_builtins.str]]:
        """
        List of Linux capabilities to add to the container
        """
        return pulumi.get(self, "cap_adds")

    @_builtins.property
    @pulumi.getter(name="capDrops")
    def cap_drops(self) -> Optional[Sequence[_builtins.str]]:
        """
        List of Linux capabilities to drop from the container
        """
        return pulumi.get(self, "cap_drops")

    @_builtins.property
    @pulumi.getter
    def commands(self) -> Optional[Sequence[_builtins.str]]:
        """
        The command/entrypoint to be run in the image. According to the [docker cli](https://github.com/docker/cli/blob/v20.10.7/cli/command/service/opts.go#L705) the override of the entrypoint is also passed to the `command` property and there is no `entrypoint` attribute in the `ContainerSpec` of the service.
        """
        return pulumi.get(self, "commands")

    @_builtins.property
    @pulumi.getter
    def configs(self) -> Optional[Sequence['outputs.ServiceTaskSpecContainerSpecConfig']]:
        """
        References to zero or more configs that will be exposed to the service
        """
        return pulumi.get(self, "configs")

    @_builtins.property
    @pulumi.getter
    def dir(self) -> Optional[_builtins.str]:
        """
        The working directory for commands to run in
        """
        return pulumi.get(self, "dir")

    @_builtins.property
    @pulumi.getter(name="dnsConfig")
    def dns_config(self) -> Optional['outputs.ServiceTaskSpecContainerSpecDnsConfig']:
        """
        Specification for DNS related configurations in resolver configuration file (`resolv.conf`)
        """
        return pulumi.get(self, "dns_config")

    @_builtins.property
    @pulumi.getter
    def env(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        A list of environment variables in the form VAR="value"
        """
        return pulumi.get(self, "env")

    @_builtins.property
    @pulumi.getter
    def groups(self) -> Optional[Sequence[_builtins.str]]:
        """
        A list of additional groups that the container process will run as
        """
        return pulumi.get(self, "groups")

    @_builtins.property
    @pulumi.getter
    def healthcheck(self) -> Optional['outputs.ServiceTaskSpecContainerSpecHealthcheck']:
        """
        A test to perform to check that the container is healthy
        """
        return pulumi.get(self, "healthcheck")

    @_builtins.property
    @pulumi.getter
    def hostname(self) -> Optional[_builtins.str]:
        """
        The hostname to use for the container, as a valid RFC 1123 hostname
        """
        return pulumi.get(self, "hostname")

    @_builtins.property
    @pulumi.getter
    def hosts(self) -> Optional[Sequence['outputs.ServiceTaskSpecContainerSpecHost']]:
        """
        A list of hostname/IP mappings to add to the container's hosts file
        """
        return pulumi.get(self, "hosts")

    @_builtins.property
    @pulumi.getter
    def isolation(self) -> Optional[_builtins.str]:
        """
        Isolation technology of the containers running the service. (Windows only). Defaults to `default`.
        """
        return pulumi.get(self, "isolation")

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[Sequence['outputs.ServiceTaskSpecContainerSpecLabel']]:
        """
        User-defined key/value metadata
        """
        return pulumi.get(self, "labels")

    @_builtins.property
    @pulumi.getter
    def mounts(self) -> Optional[Sequence['outputs.ServiceTaskSpecContainerSpecMount']]:
        """
        Specification for mounts to be added to containers created as part of the service
        """
        return pulumi.get(self, "mounts")

    @_builtins.property
    @pulumi.getter
    def privileges(self) -> Optional['outputs.ServiceTaskSpecContainerSpecPrivileges']:
        """
        Security options for the container
        """
        return pulumi.get(self, "privileges")

    @_builtins.property
    @pulumi.getter(name="readOnly")
    def read_only(self) -> Optional[_builtins.bool]:
        """
        Mount the container's root filesystem as read only
        """
        return pulumi.get(self, "read_only")

    @_builtins.property
    @pulumi.getter
    def secrets(self) -> Optional[Sequence['outputs.ServiceTaskSpecContainerSpecSecret']]:
        """
        References to zero or more secrets that will be exposed to the service
        """
        return pulumi.get(self, "secrets")

    @_builtins.property
    @pulumi.getter(name="stopGracePeriod")
    def stop_grace_period(self) -> Optional[_builtins.str]:
        """
        Amount of time to wait for the container to terminate before forcefully removing it (ms|s|m|h). If not specified or '0s' the destroy will not check if all tasks/containers of the service terminate.
        """
        return pulumi.get(self, "stop_grace_period")

    @_builtins.property
    @pulumi.getter(name="stopSignal")
    def stop_signal(self) -> Optional[_builtins.str]:
        """
        Signal to stop the container
        """
        return pulumi.get(self, "stop_signal")

    @_builtins.property
    @pulumi.getter
    def sysctl(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        Sysctls config (Linux only)
        """
        return pulumi.get(self, "sysctl")

    @_builtins.property
    @pulumi.getter
    def user(self) -> Optional[_builtins.str]:
        """
        The user inside the container
        """
        return pulumi.get(self, "user")


@pulumi.output_type
class ServiceTaskSpecContainerSpecConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "configId":
            suggest = "config_id"
        elif key == "fileName":
            suggest = "file_name"
        elif key == "configName":
            suggest = "config_name"
        elif key == "fileGid":
            suggest = "file_gid"
        elif key == "fileMode":
            suggest = "file_mode"
        elif key == "fileUid":
            suggest = "file_uid"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceTaskSpecContainerSpecConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceTaskSpecContainerSpecConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceTaskSpecContainerSpecConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 config_id: _builtins.str,
                 file_name: _builtins.str,
                 config_name: Optional[_builtins.str] = None,
                 file_gid: Optional[_builtins.str] = None,
                 file_mode: Optional[_builtins.int] = None,
                 file_uid: Optional[_builtins.str] = None):
        """
        :param _builtins.str config_id: ID of the specific config that we're referencing
        :param _builtins.str file_name: Represents the final filename in the filesystem
        :param _builtins.str config_name: Name of the config that this references, but this is just provided for lookup/display purposes. The config in the reference will be identified by its ID
        :param _builtins.str file_gid: Represents the file GID. Defaults to `0`.
        :param _builtins.int file_mode: Represents represents the FileMode of the file. Defaults to `0o444`.
        :param _builtins.str file_uid: Represents the file UID. Defaults to `0`.
        """
        pulumi.set(__self__, "config_id", config_id)
        pulumi.set(__self__, "file_name", file_name)
        if config_name is not None:
            pulumi.set(__self__, "config_name", config_name)
        if file_gid is not None:
            pulumi.set(__self__, "file_gid", file_gid)
        if file_mode is not None:
            pulumi.set(__self__, "file_mode", file_mode)
        if file_uid is not None:
            pulumi.set(__self__, "file_uid", file_uid)

    @_builtins.property
    @pulumi.getter(name="configId")
    def config_id(self) -> _builtins.str:
        """
        ID of the specific config that we're referencing
        """
        return pulumi.get(self, "config_id")

    @_builtins.property
    @pulumi.getter(name="fileName")
    def file_name(self) -> _builtins.str:
        """
        Represents the final filename in the filesystem
        """
        return pulumi.get(self, "file_name")

    @_builtins.property
    @pulumi.getter(name="configName")
    def config_name(self) -> Optional[_builtins.str]:
        """
        Name of the config that this references, but this is just provided for lookup/display purposes. The config in the reference will be identified by its ID
        """
        return pulumi.get(self, "config_name")

    @_builtins.property
    @pulumi.getter(name="fileGid")
    def file_gid(self) -> Optional[_builtins.str]:
        """
        Represents the file GID. Defaults to `0`.
        """
        return pulumi.get(self, "file_gid")

    @_builtins.property
    @pulumi.getter(name="fileMode")
    def file_mode(self) -> Optional[_builtins.int]:
        """
        Represents represents the FileMode of the file. Defaults to `0o444`.
        """
        return pulumi.get(self, "file_mode")

    @_builtins.property
    @pulumi.getter(name="fileUid")
    def file_uid(self) -> Optional[_builtins.str]:
        """
        Represents the file UID. Defaults to `0`.
        """
        return pulumi.get(self, "file_uid")


@pulumi.output_type
class ServiceTaskSpecContainerSpecDnsConfig(dict):
    def __init__(__self__, *,
                 nameservers: Sequence[_builtins.str],
                 options: Optional[Sequence[_builtins.str]] = None,
                 searches: Optional[Sequence[_builtins.str]] = None):
        """
        :param Sequence[_builtins.str] nameservers: The IP addresses of the name servers
        :param Sequence[_builtins.str] options: A list of internal resolver variables to be modified (e.g., `debug`, `ndots:3`, etc.)
        :param Sequence[_builtins.str] searches: A search list for host-name lookup
        """
        pulumi.set(__self__, "nameservers", nameservers)
        if options is not None:
            pulumi.set(__self__, "options", options)
        if searches is not None:
            pulumi.set(__self__, "searches", searches)

    @_builtins.property
    @pulumi.getter
    def nameservers(self) -> Sequence[_builtins.str]:
        """
        The IP addresses of the name servers
        """
        return pulumi.get(self, "nameservers")

    @_builtins.property
    @pulumi.getter
    def options(self) -> Optional[Sequence[_builtins.str]]:
        """
        A list of internal resolver variables to be modified (e.g., `debug`, `ndots:3`, etc.)
        """
        return pulumi.get(self, "options")

    @_builtins.property
    @pulumi.getter
    def searches(self) -> Optional[Sequence[_builtins.str]]:
        """
        A search list for host-name lookup
        """
        return pulumi.get(self, "searches")


@pulumi.output_type
class ServiceTaskSpecContainerSpecHealthcheck(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "startPeriod":
            suggest = "start_period"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceTaskSpecContainerSpecHealthcheck. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceTaskSpecContainerSpecHealthcheck.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceTaskSpecContainerSpecHealthcheck.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 tests: Sequence[_builtins.str],
                 interval: Optional[_builtins.str] = None,
                 retries: Optional[_builtins.int] = None,
                 start_period: Optional[_builtins.str] = None,
                 timeout: Optional[_builtins.str] = None):
        """
        :param Sequence[_builtins.str] tests: The test to perform as list
        :param _builtins.str interval: Time between running the check (ms|s|m|h). Defaults to `0s`.
        :param _builtins.int retries: Consecutive failures needed to report unhealthy. Defaults to `0`
        :param _builtins.str start_period: Start period for the container to initialize before counting retries towards unstable (ms|s|m|h). Defaults to `0s`.
        :param _builtins.str timeout: Maximum time to allow one check to run (ms|s|m|h). Defaults to `0s`.
        """
        pulumi.set(__self__, "tests", tests)
        if interval is not None:
            pulumi.set(__self__, "interval", interval)
        if retries is not None:
            pulumi.set(__self__, "retries", retries)
        if start_period is not None:
            pulumi.set(__self__, "start_period", start_period)
        if timeout is not None:
            pulumi.set(__self__, "timeout", timeout)

    @_builtins.property
    @pulumi.getter
    def tests(self) -> Sequence[_builtins.str]:
        """
        The test to perform as list
        """
        return pulumi.get(self, "tests")

    @_builtins.property
    @pulumi.getter
    def interval(self) -> Optional[_builtins.str]:
        """
        Time between running the check (ms|s|m|h). Defaults to `0s`.
        """
        return pulumi.get(self, "interval")

    @_builtins.property
    @pulumi.getter
    def retries(self) -> Optional[_builtins.int]:
        """
        Consecutive failures needed to report unhealthy. Defaults to `0`
        """
        return pulumi.get(self, "retries")

    @_builtins.property
    @pulumi.getter(name="startPeriod")
    def start_period(self) -> Optional[_builtins.str]:
        """
        Start period for the container to initialize before counting retries towards unstable (ms|s|m|h). Defaults to `0s`.
        """
        return pulumi.get(self, "start_period")

    @_builtins.property
    @pulumi.getter
    def timeout(self) -> Optional[_builtins.str]:
        """
        Maximum time to allow one check to run (ms|s|m|h). Defaults to `0s`.
        """
        return pulumi.get(self, "timeout")


@pulumi.output_type
class ServiceTaskSpecContainerSpecHost(dict):
    def __init__(__self__, *,
                 host: _builtins.str,
                 ip: _builtins.str):
        """
        :param _builtins.str host: The name of the host
        :param _builtins.str ip: The ip of the host
        """
        pulumi.set(__self__, "host", host)
        pulumi.set(__self__, "ip", ip)

    @_builtins.property
    @pulumi.getter
    def host(self) -> _builtins.str:
        """
        The name of the host
        """
        return pulumi.get(self, "host")

    @_builtins.property
    @pulumi.getter
    def ip(self) -> _builtins.str:
        """
        The ip of the host
        """
        return pulumi.get(self, "ip")


@pulumi.output_type
class ServiceTaskSpecContainerSpecLabel(dict):
    def __init__(__self__, *,
                 label: _builtins.str,
                 value: _builtins.str):
        """
        :param _builtins.str label: Name of the label
        :param _builtins.str value: Value of the label
        """
        pulumi.set(__self__, "label", label)
        pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def label(self) -> _builtins.str:
        """
        Name of the label
        """
        return pulumi.get(self, "label")

    @_builtins.property
    @pulumi.getter
    def value(self) -> _builtins.str:
        """
        Value of the label
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class ServiceTaskSpecContainerSpecMount(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "bindOptions":
            suggest = "bind_options"
        elif key == "readOnly":
            suggest = "read_only"
        elif key == "tmpfsOptions":
            suggest = "tmpfs_options"
        elif key == "volumeOptions":
            suggest = "volume_options"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceTaskSpecContainerSpecMount. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceTaskSpecContainerSpecMount.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceTaskSpecContainerSpecMount.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 target: _builtins.str,
                 type: _builtins.str,
                 bind_options: Optional['outputs.ServiceTaskSpecContainerSpecMountBindOptions'] = None,
                 read_only: Optional[_builtins.bool] = None,
                 source: Optional[_builtins.str] = None,
                 tmpfs_options: Optional['outputs.ServiceTaskSpecContainerSpecMountTmpfsOptions'] = None,
                 volume_options: Optional['outputs.ServiceTaskSpecContainerSpecMountVolumeOptions'] = None):
        """
        :param _builtins.str target: Container path
        :param _builtins.str type: The mount type
        :param 'ServiceTaskSpecContainerSpecMountBindOptionsArgs' bind_options: Optional configuration for the bind type
        :param _builtins.bool read_only: Whether the mount should be read-only
        :param _builtins.str source: Mount source (e.g. a volume name, a host path)
        :param 'ServiceTaskSpecContainerSpecMountTmpfsOptionsArgs' tmpfs_options: Optional configuration for the tmpfs type
        :param 'ServiceTaskSpecContainerSpecMountVolumeOptionsArgs' volume_options: Optional configuration for the volume type
        """
        pulumi.set(__self__, "target", target)
        pulumi.set(__self__, "type", type)
        if bind_options is not None:
            pulumi.set(__self__, "bind_options", bind_options)
        if read_only is not None:
            pulumi.set(__self__, "read_only", read_only)
        if source is not None:
            pulumi.set(__self__, "source", source)
        if tmpfs_options is not None:
            pulumi.set(__self__, "tmpfs_options", tmpfs_options)
        if volume_options is not None:
            pulumi.set(__self__, "volume_options", volume_options)

    @_builtins.property
    @pulumi.getter
    def target(self) -> _builtins.str:
        """
        Container path
        """
        return pulumi.get(self, "target")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        The mount type
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter(name="bindOptions")
    def bind_options(self) -> Optional['outputs.ServiceTaskSpecContainerSpecMountBindOptions']:
        """
        Optional configuration for the bind type
        """
        return pulumi.get(self, "bind_options")

    @_builtins.property
    @pulumi.getter(name="readOnly")
    def read_only(self) -> Optional[_builtins.bool]:
        """
        Whether the mount should be read-only
        """
        return pulumi.get(self, "read_only")

    @_builtins.property
    @pulumi.getter
    def source(self) -> Optional[_builtins.str]:
        """
        Mount source (e.g. a volume name, a host path)
        """
        return pulumi.get(self, "source")

    @_builtins.property
    @pulumi.getter(name="tmpfsOptions")
    def tmpfs_options(self) -> Optional['outputs.ServiceTaskSpecContainerSpecMountTmpfsOptions']:
        """
        Optional configuration for the tmpfs type
        """
        return pulumi.get(self, "tmpfs_options")

    @_builtins.property
    @pulumi.getter(name="volumeOptions")
    def volume_options(self) -> Optional['outputs.ServiceTaskSpecContainerSpecMountVolumeOptions']:
        """
        Optional configuration for the volume type
        """
        return pulumi.get(self, "volume_options")


@pulumi.output_type
class ServiceTaskSpecContainerSpecMountBindOptions(dict):
    def __init__(__self__, *,
                 propagation: Optional[_builtins.str] = None):
        """
        :param _builtins.str propagation: Bind propagation refers to whether or not mounts created within a given bind-mount or named volume can be propagated to replicas of that mount. See the [docs](https://docs.docker.com/storage/bind-mounts/#configure-bind-propagation) for details. Defaults to `rprivate`
        """
        if propagation is not None:
            pulumi.set(__self__, "propagation", propagation)

    @_builtins.property
    @pulumi.getter
    def propagation(self) -> Optional[_builtins.str]:
        """
        Bind propagation refers to whether or not mounts created within a given bind-mount or named volume can be propagated to replicas of that mount. See the [docs](https://docs.docker.com/storage/bind-mounts/#configure-bind-propagation) for details. Defaults to `rprivate`
        """
        return pulumi.get(self, "propagation")


@pulumi.output_type
class ServiceTaskSpecContainerSpecMountTmpfsOptions(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sizeBytes":
            suggest = "size_bytes"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceTaskSpecContainerSpecMountTmpfsOptions. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceTaskSpecContainerSpecMountTmpfsOptions.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceTaskSpecContainerSpecMountTmpfsOptions.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 mode: Optional[_builtins.int] = None,
                 size_bytes: Optional[_builtins.int] = None):
        """
        :param _builtins.int mode: The permission mode for the tmpfs mount in an integer
        :param _builtins.int size_bytes: The size for the tmpfs mount in bytes
        """
        if mode is not None:
            pulumi.set(__self__, "mode", mode)
        if size_bytes is not None:
            pulumi.set(__self__, "size_bytes", size_bytes)

    @_builtins.property
    @pulumi.getter
    def mode(self) -> Optional[_builtins.int]:
        """
        The permission mode for the tmpfs mount in an integer
        """
        return pulumi.get(self, "mode")

    @_builtins.property
    @pulumi.getter(name="sizeBytes")
    def size_bytes(self) -> Optional[_builtins.int]:
        """
        The size for the tmpfs mount in bytes
        """
        return pulumi.get(self, "size_bytes")


@pulumi.output_type
class ServiceTaskSpecContainerSpecMountVolumeOptions(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "driverName":
            suggest = "driver_name"
        elif key == "driverOptions":
            suggest = "driver_options"
        elif key == "noCopy":
            suggest = "no_copy"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceTaskSpecContainerSpecMountVolumeOptions. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceTaskSpecContainerSpecMountVolumeOptions.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceTaskSpecContainerSpecMountVolumeOptions.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 driver_name: Optional[_builtins.str] = None,
                 driver_options: Optional[Mapping[str, _builtins.str]] = None,
                 labels: Optional[Sequence['outputs.ServiceTaskSpecContainerSpecMountVolumeOptionsLabel']] = None,
                 no_copy: Optional[_builtins.bool] = None):
        """
        :param _builtins.str driver_name: Name of the driver to use to create the volume
        :param Mapping[str, _builtins.str] driver_options: key/value map of driver specific options
        :param Sequence['ServiceTaskSpecContainerSpecMountVolumeOptionsLabelArgs'] labels: User-defined key/value metadata
        :param _builtins.bool no_copy: Populate volume with data from the target
        """
        if driver_name is not None:
            pulumi.set(__self__, "driver_name", driver_name)
        if driver_options is not None:
            pulumi.set(__self__, "driver_options", driver_options)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if no_copy is not None:
            pulumi.set(__self__, "no_copy", no_copy)

    @_builtins.property
    @pulumi.getter(name="driverName")
    def driver_name(self) -> Optional[_builtins.str]:
        """
        Name of the driver to use to create the volume
        """
        return pulumi.get(self, "driver_name")

    @_builtins.property
    @pulumi.getter(name="driverOptions")
    def driver_options(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        key/value map of driver specific options
        """
        return pulumi.get(self, "driver_options")

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[Sequence['outputs.ServiceTaskSpecContainerSpecMountVolumeOptionsLabel']]:
        """
        User-defined key/value metadata
        """
        return pulumi.get(self, "labels")

    @_builtins.property
    @pulumi.getter(name="noCopy")
    def no_copy(self) -> Optional[_builtins.bool]:
        """
        Populate volume with data from the target
        """
        return pulumi.get(self, "no_copy")


@pulumi.output_type
class ServiceTaskSpecContainerSpecMountVolumeOptionsLabel(dict):
    def __init__(__self__, *,
                 label: _builtins.str,
                 value: _builtins.str):
        """
        :param _builtins.str label: Name of the label
        :param _builtins.str value: Value of the label
        """
        pulumi.set(__self__, "label", label)
        pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def label(self) -> _builtins.str:
        """
        Name of the label
        """
        return pulumi.get(self, "label")

    @_builtins.property
    @pulumi.getter
    def value(self) -> _builtins.str:
        """
        Value of the label
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class ServiceTaskSpecContainerSpecPrivileges(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "credentialSpec":
            suggest = "credential_spec"
        elif key == "seLinuxContext":
            suggest = "se_linux_context"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceTaskSpecContainerSpecPrivileges. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceTaskSpecContainerSpecPrivileges.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceTaskSpecContainerSpecPrivileges.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 credential_spec: Optional['outputs.ServiceTaskSpecContainerSpecPrivilegesCredentialSpec'] = None,
                 se_linux_context: Optional['outputs.ServiceTaskSpecContainerSpecPrivilegesSeLinuxContext'] = None):
        """
        :param 'ServiceTaskSpecContainerSpecPrivilegesCredentialSpecArgs' credential_spec: CredentialSpec for managed service account (Windows only)
        :param 'ServiceTaskSpecContainerSpecPrivilegesSeLinuxContextArgs' se_linux_context: SELinux labels of the container
        """
        if credential_spec is not None:
            pulumi.set(__self__, "credential_spec", credential_spec)
        if se_linux_context is not None:
            pulumi.set(__self__, "se_linux_context", se_linux_context)

    @_builtins.property
    @pulumi.getter(name="credentialSpec")
    def credential_spec(self) -> Optional['outputs.ServiceTaskSpecContainerSpecPrivilegesCredentialSpec']:
        """
        CredentialSpec for managed service account (Windows only)
        """
        return pulumi.get(self, "credential_spec")

    @_builtins.property
    @pulumi.getter(name="seLinuxContext")
    def se_linux_context(self) -> Optional['outputs.ServiceTaskSpecContainerSpecPrivilegesSeLinuxContext']:
        """
        SELinux labels of the container
        """
        return pulumi.get(self, "se_linux_context")


@pulumi.output_type
class ServiceTaskSpecContainerSpecPrivilegesCredentialSpec(dict):
    def __init__(__self__, *,
                 file: Optional[_builtins.str] = None,
                 registry: Optional[_builtins.str] = None):
        """
        :param _builtins.str file: Load credential spec from this file
        :param _builtins.str registry: Load credential spec from this value in the Windows registry
        """
        if file is not None:
            pulumi.set(__self__, "file", file)
        if registry is not None:
            pulumi.set(__self__, "registry", registry)

    @_builtins.property
    @pulumi.getter
    def file(self) -> Optional[_builtins.str]:
        """
        Load credential spec from this file
        """
        return pulumi.get(self, "file")

    @_builtins.property
    @pulumi.getter
    def registry(self) -> Optional[_builtins.str]:
        """
        Load credential spec from this value in the Windows registry
        """
        return pulumi.get(self, "registry")


@pulumi.output_type
class ServiceTaskSpecContainerSpecPrivilegesSeLinuxContext(dict):
    def __init__(__self__, *,
                 disable: Optional[_builtins.bool] = None,
                 level: Optional[_builtins.str] = None,
                 role: Optional[_builtins.str] = None,
                 type: Optional[_builtins.str] = None,
                 user: Optional[_builtins.str] = None):
        """
        :param _builtins.bool disable: Disable SELinux
        :param _builtins.str level: SELinux level label
        :param _builtins.str role: SELinux role label
        :param _builtins.str type: SELinux type label
        :param _builtins.str user: SELinux user label
        """
        if disable is not None:
            pulumi.set(__self__, "disable", disable)
        if level is not None:
            pulumi.set(__self__, "level", level)
        if role is not None:
            pulumi.set(__self__, "role", role)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if user is not None:
            pulumi.set(__self__, "user", user)

    @_builtins.property
    @pulumi.getter
    def disable(self) -> Optional[_builtins.bool]:
        """
        Disable SELinux
        """
        return pulumi.get(self, "disable")

    @_builtins.property
    @pulumi.getter
    def level(self) -> Optional[_builtins.str]:
        """
        SELinux level label
        """
        return pulumi.get(self, "level")

    @_builtins.property
    @pulumi.getter
    def role(self) -> Optional[_builtins.str]:
        """
        SELinux role label
        """
        return pulumi.get(self, "role")

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[_builtins.str]:
        """
        SELinux type label
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter
    def user(self) -> Optional[_builtins.str]:
        """
        SELinux user label
        """
        return pulumi.get(self, "user")


@pulumi.output_type
class ServiceTaskSpecContainerSpecSecret(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "fileName":
            suggest = "file_name"
        elif key == "secretId":
            suggest = "secret_id"
        elif key == "fileGid":
            suggest = "file_gid"
        elif key == "fileMode":
            suggest = "file_mode"
        elif key == "fileUid":
            suggest = "file_uid"
        elif key == "secretName":
            suggest = "secret_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceTaskSpecContainerSpecSecret. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceTaskSpecContainerSpecSecret.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceTaskSpecContainerSpecSecret.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 file_name: _builtins.str,
                 secret_id: _builtins.str,
                 file_gid: Optional[_builtins.str] = None,
                 file_mode: Optional[_builtins.int] = None,
                 file_uid: Optional[_builtins.str] = None,
                 secret_name: Optional[_builtins.str] = None):
        """
        :param _builtins.str file_name: Represents the final filename in the filesystem
        :param _builtins.str secret_id: ID of the specific secret that we're referencing
        :param _builtins.str file_gid: Represents the file GID. Defaults to `0`
        :param _builtins.int file_mode: Represents represents the FileMode of the file. Defaults to `0o444`
        :param _builtins.str file_uid: Represents the file UID. Defaults to `0`
        :param _builtins.str secret_name: Name of the secret that this references, but this is just provided for lookup/display purposes. The config in the reference will be identified by its ID
        """
        pulumi.set(__self__, "file_name", file_name)
        pulumi.set(__self__, "secret_id", secret_id)
        if file_gid is not None:
            pulumi.set(__self__, "file_gid", file_gid)
        if file_mode is not None:
            pulumi.set(__self__, "file_mode", file_mode)
        if file_uid is not None:
            pulumi.set(__self__, "file_uid", file_uid)
        if secret_name is not None:
            pulumi.set(__self__, "secret_name", secret_name)

    @_builtins.property
    @pulumi.getter(name="fileName")
    def file_name(self) -> _builtins.str:
        """
        Represents the final filename in the filesystem
        """
        return pulumi.get(self, "file_name")

    @_builtins.property
    @pulumi.getter(name="secretId")
    def secret_id(self) -> _builtins.str:
        """
        ID of the specific secret that we're referencing
        """
        return pulumi.get(self, "secret_id")

    @_builtins.property
    @pulumi.getter(name="fileGid")
    def file_gid(self) -> Optional[_builtins.str]:
        """
        Represents the file GID. Defaults to `0`
        """
        return pulumi.get(self, "file_gid")

    @_builtins.property
    @pulumi.getter(name="fileMode")
    def file_mode(self) -> Optional[_builtins.int]:
        """
        Represents represents the FileMode of the file. Defaults to `0o444`
        """
        return pulumi.get(self, "file_mode")

    @_builtins.property
    @pulumi.getter(name="fileUid")
    def file_uid(self) -> Optional[_builtins.str]:
        """
        Represents the file UID. Defaults to `0`
        """
        return pulumi.get(self, "file_uid")

    @_builtins.property
    @pulumi.getter(name="secretName")
    def secret_name(self) -> Optional[_builtins.str]:
        """
        Name of the secret that this references, but this is just provided for lookup/display purposes. The config in the reference will be identified by its ID
        """
        return pulumi.get(self, "secret_name")


@pulumi.output_type
class ServiceTaskSpecLogDriver(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 options: Optional[Mapping[str, _builtins.str]] = None):
        """
        :param _builtins.str name: The logging driver to use
        :param Mapping[str, _builtins.str] options: The options for the logging driver
        """
        pulumi.set(__self__, "name", name)
        if options is not None:
            pulumi.set(__self__, "options", options)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The logging driver to use
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def options(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        The options for the logging driver
        """
        return pulumi.get(self, "options")


@pulumi.output_type
class ServiceTaskSpecNetworksAdvanced(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "driverOpts":
            suggest = "driver_opts"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceTaskSpecNetworksAdvanced. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceTaskSpecNetworksAdvanced.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceTaskSpecNetworksAdvanced.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: _builtins.str,
                 aliases: Optional[Sequence[_builtins.str]] = None,
                 driver_opts: Optional[Sequence[_builtins.str]] = None):
        """
        :param _builtins.str name: The name/id of the network.
        :param Sequence[_builtins.str] aliases: The network aliases of the container in the specific network.
        :param Sequence[_builtins.str] driver_opts: An array of driver options for the network, e.g. `opts1=value`
        """
        pulumi.set(__self__, "name", name)
        if aliases is not None:
            pulumi.set(__self__, "aliases", aliases)
        if driver_opts is not None:
            pulumi.set(__self__, "driver_opts", driver_opts)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name/id of the network.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def aliases(self) -> Optional[Sequence[_builtins.str]]:
        """
        The network aliases of the container in the specific network.
        """
        return pulumi.get(self, "aliases")

    @_builtins.property
    @pulumi.getter(name="driverOpts")
    def driver_opts(self) -> Optional[Sequence[_builtins.str]]:
        """
        An array of driver options for the network, e.g. `opts1=value`
        """
        return pulumi.get(self, "driver_opts")


@pulumi.output_type
class ServiceTaskSpecPlacement(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maxReplicas":
            suggest = "max_replicas"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceTaskSpecPlacement. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceTaskSpecPlacement.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceTaskSpecPlacement.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 constraints: Optional[Sequence[_builtins.str]] = None,
                 max_replicas: Optional[_builtins.int] = None,
                 platforms: Optional[Sequence['outputs.ServiceTaskSpecPlacementPlatform']] = None,
                 prefs: Optional[Sequence[_builtins.str]] = None):
        """
        :param Sequence[_builtins.str] constraints: An array of constraints. e.g.: `node.role==manager`
        :param _builtins.int max_replicas: Maximum number of replicas for per node (default value is `0`, which is unlimited)
        :param Sequence['ServiceTaskSpecPlacementPlatformArgs'] platforms: Platforms stores all the platforms that the service's image can run on
        :param Sequence[_builtins.str] prefs: Preferences provide a way to make the scheduler aware of factors such as topology. They are provided in order from highest to lowest precedence, e.g.: `spread=node.role.manager`
        """
        if constraints is not None:
            pulumi.set(__self__, "constraints", constraints)
        if max_replicas is not None:
            pulumi.set(__self__, "max_replicas", max_replicas)
        if platforms is not None:
            pulumi.set(__self__, "platforms", platforms)
        if prefs is not None:
            pulumi.set(__self__, "prefs", prefs)

    @_builtins.property
    @pulumi.getter
    def constraints(self) -> Optional[Sequence[_builtins.str]]:
        """
        An array of constraints. e.g.: `node.role==manager`
        """
        return pulumi.get(self, "constraints")

    @_builtins.property
    @pulumi.getter(name="maxReplicas")
    def max_replicas(self) -> Optional[_builtins.int]:
        """
        Maximum number of replicas for per node (default value is `0`, which is unlimited)
        """
        return pulumi.get(self, "max_replicas")

    @_builtins.property
    @pulumi.getter
    def platforms(self) -> Optional[Sequence['outputs.ServiceTaskSpecPlacementPlatform']]:
        """
        Platforms stores all the platforms that the service's image can run on
        """
        return pulumi.get(self, "platforms")

    @_builtins.property
    @pulumi.getter
    def prefs(self) -> Optional[Sequence[_builtins.str]]:
        """
        Preferences provide a way to make the scheduler aware of factors such as topology. They are provided in order from highest to lowest precedence, e.g.: `spread=node.role.manager`
        """
        return pulumi.get(self, "prefs")


@pulumi.output_type
class ServiceTaskSpecPlacementPlatform(dict):
    def __init__(__self__, *,
                 architecture: _builtins.str,
                 os: _builtins.str):
        """
        :param _builtins.str architecture: The architecture, e.g. `amd64`
        :param _builtins.str os: The operation system, e.g. `linux`
        """
        pulumi.set(__self__, "architecture", architecture)
        pulumi.set(__self__, "os", os)

    @_builtins.property
    @pulumi.getter
    def architecture(self) -> _builtins.str:
        """
        The architecture, e.g. `amd64`
        """
        return pulumi.get(self, "architecture")

    @_builtins.property
    @pulumi.getter
    def os(self) -> _builtins.str:
        """
        The operation system, e.g. `linux`
        """
        return pulumi.get(self, "os")


@pulumi.output_type
class ServiceTaskSpecResources(dict):
    def __init__(__self__, *,
                 limits: Optional['outputs.ServiceTaskSpecResourcesLimits'] = None,
                 reservation: Optional['outputs.ServiceTaskSpecResourcesReservation'] = None):
        """
        :param 'ServiceTaskSpecResourcesLimitsArgs' limits: Describes the resources which can be advertised by a node and requested by a task
        :param 'ServiceTaskSpecResourcesReservationArgs' reservation: An object describing the resources which can be advertised by a node and requested by a task
        """
        if limits is not None:
            pulumi.set(__self__, "limits", limits)
        if reservation is not None:
            pulumi.set(__self__, "reservation", reservation)

    @_builtins.property
    @pulumi.getter
    def limits(self) -> Optional['outputs.ServiceTaskSpecResourcesLimits']:
        """
        Describes the resources which can be advertised by a node and requested by a task
        """
        return pulumi.get(self, "limits")

    @_builtins.property
    @pulumi.getter
    def reservation(self) -> Optional['outputs.ServiceTaskSpecResourcesReservation']:
        """
        An object describing the resources which can be advertised by a node and requested by a task
        """
        return pulumi.get(self, "reservation")


@pulumi.output_type
class ServiceTaskSpecResourcesLimits(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "memoryBytes":
            suggest = "memory_bytes"
        elif key == "nanoCpus":
            suggest = "nano_cpus"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceTaskSpecResourcesLimits. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceTaskSpecResourcesLimits.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceTaskSpecResourcesLimits.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 memory_bytes: Optional[_builtins.int] = None,
                 nano_cpus: Optional[_builtins.int] = None):
        """
        :param _builtins.int memory_bytes: The amounf of memory in bytes the container allocates
        :param _builtins.int nano_cpus: CPU shares in units of `1/1e9` (or `10^-9`) of the CPU. Should be at least `1000000`
        """
        if memory_bytes is not None:
            pulumi.set(__self__, "memory_bytes", memory_bytes)
        if nano_cpus is not None:
            pulumi.set(__self__, "nano_cpus", nano_cpus)

    @_builtins.property
    @pulumi.getter(name="memoryBytes")
    def memory_bytes(self) -> Optional[_builtins.int]:
        """
        The amounf of memory in bytes the container allocates
        """
        return pulumi.get(self, "memory_bytes")

    @_builtins.property
    @pulumi.getter(name="nanoCpus")
    def nano_cpus(self) -> Optional[_builtins.int]:
        """
        CPU shares in units of `1/1e9` (or `10^-9`) of the CPU. Should be at least `1000000`
        """
        return pulumi.get(self, "nano_cpus")


@pulumi.output_type
class ServiceTaskSpecResourcesReservation(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "genericResources":
            suggest = "generic_resources"
        elif key == "memoryBytes":
            suggest = "memory_bytes"
        elif key == "nanoCpus":
            suggest = "nano_cpus"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceTaskSpecResourcesReservation. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceTaskSpecResourcesReservation.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceTaskSpecResourcesReservation.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 generic_resources: Optional['outputs.ServiceTaskSpecResourcesReservationGenericResources'] = None,
                 memory_bytes: Optional[_builtins.int] = None,
                 nano_cpus: Optional[_builtins.int] = None):
        """
        :param 'ServiceTaskSpecResourcesReservationGenericResourcesArgs' generic_resources: User-defined resources can be either Integer resources (e.g, `SSD=3`) or String resources (e.g, GPU=UUID1)
        :param _builtins.int memory_bytes: The amounf of memory in bytes the container allocates
        :param _builtins.int nano_cpus: CPU shares in units of 1/1e9 (or 10^-9) of the CPU. Should be at least `1000000`
        """
        if generic_resources is not None:
            pulumi.set(__self__, "generic_resources", generic_resources)
        if memory_bytes is not None:
            pulumi.set(__self__, "memory_bytes", memory_bytes)
        if nano_cpus is not None:
            pulumi.set(__self__, "nano_cpus", nano_cpus)

    @_builtins.property
    @pulumi.getter(name="genericResources")
    def generic_resources(self) -> Optional['outputs.ServiceTaskSpecResourcesReservationGenericResources']:
        """
        User-defined resources can be either Integer resources (e.g, `SSD=3`) or String resources (e.g, GPU=UUID1)
        """
        return pulumi.get(self, "generic_resources")

    @_builtins.property
    @pulumi.getter(name="memoryBytes")
    def memory_bytes(self) -> Optional[_builtins.int]:
        """
        The amounf of memory in bytes the container allocates
        """
        return pulumi.get(self, "memory_bytes")

    @_builtins.property
    @pulumi.getter(name="nanoCpus")
    def nano_cpus(self) -> Optional[_builtins.int]:
        """
        CPU shares in units of 1/1e9 (or 10^-9) of the CPU. Should be at least `1000000`
        """
        return pulumi.get(self, "nano_cpus")


@pulumi.output_type
class ServiceTaskSpecResourcesReservationGenericResources(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "discreteResourcesSpecs":
            suggest = "discrete_resources_specs"
        elif key == "namedResourcesSpecs":
            suggest = "named_resources_specs"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceTaskSpecResourcesReservationGenericResources. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceTaskSpecResourcesReservationGenericResources.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceTaskSpecResourcesReservationGenericResources.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 discrete_resources_specs: Optional[Sequence[_builtins.str]] = None,
                 named_resources_specs: Optional[Sequence[_builtins.str]] = None):
        """
        :param Sequence[_builtins.str] discrete_resources_specs: The Integer resources
        :param Sequence[_builtins.str] named_resources_specs: The String resources
        """
        if discrete_resources_specs is not None:
            pulumi.set(__self__, "discrete_resources_specs", discrete_resources_specs)
        if named_resources_specs is not None:
            pulumi.set(__self__, "named_resources_specs", named_resources_specs)

    @_builtins.property
    @pulumi.getter(name="discreteResourcesSpecs")
    def discrete_resources_specs(self) -> Optional[Sequence[_builtins.str]]:
        """
        The Integer resources
        """
        return pulumi.get(self, "discrete_resources_specs")

    @_builtins.property
    @pulumi.getter(name="namedResourcesSpecs")
    def named_resources_specs(self) -> Optional[Sequence[_builtins.str]]:
        """
        The String resources
        """
        return pulumi.get(self, "named_resources_specs")


@pulumi.output_type
class ServiceTaskSpecRestartPolicy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maxAttempts":
            suggest = "max_attempts"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceTaskSpecRestartPolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceTaskSpecRestartPolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceTaskSpecRestartPolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 condition: Optional[_builtins.str] = None,
                 delay: Optional[_builtins.str] = None,
                 max_attempts: Optional[_builtins.int] = None,
                 window: Optional[_builtins.str] = None):
        """
        :param _builtins.str condition: Condition for restart
        :param _builtins.str delay: Delay between restart attempts (ms|s|m|h)
        :param _builtins.int max_attempts: Maximum attempts to restart a given container before giving up (default value is `0`, which is ignored)
        :param _builtins.str window: The time window used to evaluate the restart policy (default value is `0`, which is unbounded) (ms|s|m|h)
        """
        if condition is not None:
            pulumi.set(__self__, "condition", condition)
        if delay is not None:
            pulumi.set(__self__, "delay", delay)
        if max_attempts is not None:
            pulumi.set(__self__, "max_attempts", max_attempts)
        if window is not None:
            pulumi.set(__self__, "window", window)

    @_builtins.property
    @pulumi.getter
    def condition(self) -> Optional[_builtins.str]:
        """
        Condition for restart
        """
        return pulumi.get(self, "condition")

    @_builtins.property
    @pulumi.getter
    def delay(self) -> Optional[_builtins.str]:
        """
        Delay between restart attempts (ms|s|m|h)
        """
        return pulumi.get(self, "delay")

    @_builtins.property
    @pulumi.getter(name="maxAttempts")
    def max_attempts(self) -> Optional[_builtins.int]:
        """
        Maximum attempts to restart a given container before giving up (default value is `0`, which is ignored)
        """
        return pulumi.get(self, "max_attempts")

    @_builtins.property
    @pulumi.getter
    def window(self) -> Optional[_builtins.str]:
        """
        The time window used to evaluate the restart policy (default value is `0`, which is unbounded) (ms|s|m|h)
        """
        return pulumi.get(self, "window")


@pulumi.output_type
class ServiceUpdateConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "failureAction":
            suggest = "failure_action"
        elif key == "maxFailureRatio":
            suggest = "max_failure_ratio"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceUpdateConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceUpdateConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceUpdateConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 delay: Optional[_builtins.str] = None,
                 failure_action: Optional[_builtins.str] = None,
                 max_failure_ratio: Optional[_builtins.str] = None,
                 monitor: Optional[_builtins.str] = None,
                 order: Optional[_builtins.str] = None,
                 parallelism: Optional[_builtins.int] = None):
        """
        :param _builtins.str delay: Delay between task updates `(ns|us|ms|s|m|h)`. Defaults to `0s`.
        :param _builtins.str failure_action: Action on update failure: `pause`, `continue` or `rollback`. Defaults to `pause`.
        :param _builtins.str max_failure_ratio: Failure rate to tolerate during an update. Defaults to `0.0`.
        :param _builtins.str monitor: Duration after each task update to monitor for failure (ns|us|ms|s|m|h). Defaults to `5s`.
        :param _builtins.str order: Update order: either 'stop-first' or 'start-first'. Defaults to `stop-first`.
        :param _builtins.int parallelism: Maximum number of tasks to be updated in one iteration. Defaults to `1`
        """
        if delay is not None:
            pulumi.set(__self__, "delay", delay)
        if failure_action is not None:
            pulumi.set(__self__, "failure_action", failure_action)
        if max_failure_ratio is not None:
            pulumi.set(__self__, "max_failure_ratio", max_failure_ratio)
        if monitor is not None:
            pulumi.set(__self__, "monitor", monitor)
        if order is not None:
            pulumi.set(__self__, "order", order)
        if parallelism is not None:
            pulumi.set(__self__, "parallelism", parallelism)

    @_builtins.property
    @pulumi.getter
    def delay(self) -> Optional[_builtins.str]:
        """
        Delay between task updates `(ns|us|ms|s|m|h)`. Defaults to `0s`.
        """
        return pulumi.get(self, "delay")

    @_builtins.property
    @pulumi.getter(name="failureAction")
    def failure_action(self) -> Optional[_builtins.str]:
        """
        Action on update failure: `pause`, `continue` or `rollback`. Defaults to `pause`.
        """
        return pulumi.get(self, "failure_action")

    @_builtins.property
    @pulumi.getter(name="maxFailureRatio")
    def max_failure_ratio(self) -> Optional[_builtins.str]:
        """
        Failure rate to tolerate during an update. Defaults to `0.0`.
        """
        return pulumi.get(self, "max_failure_ratio")

    @_builtins.property
    @pulumi.getter
    def monitor(self) -> Optional[_builtins.str]:
        """
        Duration after each task update to monitor for failure (ns|us|ms|s|m|h). Defaults to `5s`.
        """
        return pulumi.get(self, "monitor")

    @_builtins.property
    @pulumi.getter
    def order(self) -> Optional[_builtins.str]:
        """
        Update order: either 'stop-first' or 'start-first'. Defaults to `stop-first`.
        """
        return pulumi.get(self, "order")

    @_builtins.property
    @pulumi.getter
    def parallelism(self) -> Optional[_builtins.int]:
        """
        Maximum number of tasks to be updated in one iteration. Defaults to `1`
        """
        return pulumi.get(self, "parallelism")


@pulumi.output_type
class VolumeCluster(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "limitBytes":
            suggest = "limit_bytes"
        elif key == "requiredBytes":
            suggest = "required_bytes"
        elif key == "topologyPreferred":
            suggest = "topology_preferred"
        elif key == "topologyRequired":
            suggest = "topology_required"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VolumeCluster. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VolumeCluster.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VolumeCluster.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 availability: Optional[_builtins.str] = None,
                 group: Optional[_builtins.str] = None,
                 id: Optional[_builtins.str] = None,
                 limit_bytes: Optional[_builtins.str] = None,
                 required_bytes: Optional[_builtins.str] = None,
                 scope: Optional[_builtins.str] = None,
                 sharing: Optional[_builtins.str] = None,
                 topology_preferred: Optional[_builtins.str] = None,
                 topology_required: Optional[_builtins.str] = None,
                 type: Optional[_builtins.str] = None):
        """
        :param _builtins.str availability: Availability of the volume. Can be `active` (default), `pause`, or `drain`.
        :param _builtins.str group: Cluster Volume group
        :param _builtins.str id: The ID of the cluster volume.
        :param _builtins.str limit_bytes: Minimum size of the Cluster Volume in human readable memory bytes (like 128MiB, 2GiB, etc). Must be in format of KiB, MiB, Gib, Tib or PiB.
        :param _builtins.str required_bytes: Maximum size of the Cluster Volume in human readable memory bytes (like 128MiB, 2GiB, etc). Must be in format of KiB, MiB, Gib, Tib or PiB.
        :param _builtins.str scope: The scope of the volume. Can be `single` (default) or `multi`.
        :param _builtins.str sharing: The sharing mode. Can be `none` (default), `readonly`, `onewriter` or `all`.
        :param _builtins.str topology_preferred: A topology that the Cluster Volume would be preferred in
        :param _builtins.str topology_required: A topology that the Cluster Volume must be accessible from
        :param _builtins.str type: Cluster Volume access type. Can be `mount` or `block` (default).
        """
        if availability is not None:
            pulumi.set(__self__, "availability", availability)
        if group is not None:
            pulumi.set(__self__, "group", group)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if limit_bytes is not None:
            pulumi.set(__self__, "limit_bytes", limit_bytes)
        if required_bytes is not None:
            pulumi.set(__self__, "required_bytes", required_bytes)
        if scope is not None:
            pulumi.set(__self__, "scope", scope)
        if sharing is not None:
            pulumi.set(__self__, "sharing", sharing)
        if topology_preferred is not None:
            pulumi.set(__self__, "topology_preferred", topology_preferred)
        if topology_required is not None:
            pulumi.set(__self__, "topology_required", topology_required)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def availability(self) -> Optional[_builtins.str]:
        """
        Availability of the volume. Can be `active` (default), `pause`, or `drain`.
        """
        return pulumi.get(self, "availability")

    @_builtins.property
    @pulumi.getter
    def group(self) -> Optional[_builtins.str]:
        """
        Cluster Volume group
        """
        return pulumi.get(self, "group")

    @_builtins.property
    @pulumi.getter
    def id(self) -> Optional[_builtins.str]:
        """
        The ID of the cluster volume.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="limitBytes")
    def limit_bytes(self) -> Optional[_builtins.str]:
        """
        Minimum size of the Cluster Volume in human readable memory bytes (like 128MiB, 2GiB, etc). Must be in format of KiB, MiB, Gib, Tib or PiB.
        """
        return pulumi.get(self, "limit_bytes")

    @_builtins.property
    @pulumi.getter(name="requiredBytes")
    def required_bytes(self) -> Optional[_builtins.str]:
        """
        Maximum size of the Cluster Volume in human readable memory bytes (like 128MiB, 2GiB, etc). Must be in format of KiB, MiB, Gib, Tib or PiB.
        """
        return pulumi.get(self, "required_bytes")

    @_builtins.property
    @pulumi.getter
    def scope(self) -> Optional[_builtins.str]:
        """
        The scope of the volume. Can be `single` (default) or `multi`.
        """
        return pulumi.get(self, "scope")

    @_builtins.property
    @pulumi.getter
    def sharing(self) -> Optional[_builtins.str]:
        """
        The sharing mode. Can be `none` (default), `readonly`, `onewriter` or `all`.
        """
        return pulumi.get(self, "sharing")

    @_builtins.property
    @pulumi.getter(name="topologyPreferred")
    def topology_preferred(self) -> Optional[_builtins.str]:
        """
        A topology that the Cluster Volume would be preferred in
        """
        return pulumi.get(self, "topology_preferred")

    @_builtins.property
    @pulumi.getter(name="topologyRequired")
    def topology_required(self) -> Optional[_builtins.str]:
        """
        A topology that the Cluster Volume must be accessible from
        """
        return pulumi.get(self, "topology_required")

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[_builtins.str]:
        """
        Cluster Volume access type. Can be `mount` or `block` (default).
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class VolumeLabel(dict):
    def __init__(__self__, *,
                 label: _builtins.str,
                 value: _builtins.str):
        """
        :param _builtins.str label: Name of the label
        :param _builtins.str value: Value of the label
        """
        pulumi.set(__self__, "label", label)
        pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def label(self) -> _builtins.str:
        """
        Name of the label
        """
        return pulumi.get(self, "label")

    @_builtins.property
    @pulumi.getter
    def value(self) -> _builtins.str:
        """
        Value of the label
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class GetNetworkIpamConfigResult(dict):
    def __init__(__self__, *,
                 aux_address: Optional[Mapping[str, _builtins.str]] = None,
                 gateway: Optional[_builtins.str] = None,
                 ip_range: Optional[_builtins.str] = None,
                 subnet: Optional[_builtins.str] = None):
        """
        :param Mapping[str, _builtins.str] aux_address: Auxiliary IPv4 or IPv6 addresses used by Network driver
        :param _builtins.str gateway: The IP address of the gateway
        :param _builtins.str ip_range: The ip range in CIDR form
        :param _builtins.str subnet: The subnet in CIDR form
        """
        if aux_address is not None:
            pulumi.set(__self__, "aux_address", aux_address)
        if gateway is not None:
            pulumi.set(__self__, "gateway", gateway)
        if ip_range is not None:
            pulumi.set(__self__, "ip_range", ip_range)
        if subnet is not None:
            pulumi.set(__self__, "subnet", subnet)

    @_builtins.property
    @pulumi.getter(name="auxAddress")
    def aux_address(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        Auxiliary IPv4 or IPv6 addresses used by Network driver
        """
        return pulumi.get(self, "aux_address")

    @_builtins.property
    @pulumi.getter
    def gateway(self) -> Optional[_builtins.str]:
        """
        The IP address of the gateway
        """
        return pulumi.get(self, "gateway")

    @_builtins.property
    @pulumi.getter(name="ipRange")
    def ip_range(self) -> Optional[_builtins.str]:
        """
        The ip range in CIDR form
        """
        return pulumi.get(self, "ip_range")

    @_builtins.property
    @pulumi.getter
    def subnet(self) -> Optional[_builtins.str]:
        """
        The subnet in CIDR form
        """
        return pulumi.get(self, "subnet")


@pulumi.output_type
class GetRegistryImageManifestsAuthConfigResult(dict):
    def __init__(__self__, *,
                 address: _builtins.str,
                 password: _builtins.str,
                 username: _builtins.str):
        """
        :param _builtins.str address: The address of the Docker registry.
        :param _builtins.str password: The password for the Docker registry.
        :param _builtins.str username: The username for the Docker registry.
        """
        pulumi.set(__self__, "address", address)
        pulumi.set(__self__, "password", password)
        pulumi.set(__self__, "username", username)

    @_builtins.property
    @pulumi.getter
    def address(self) -> _builtins.str:
        """
        The address of the Docker registry.
        """
        return pulumi.get(self, "address")

    @_builtins.property
    @pulumi.getter
    def password(self) -> _builtins.str:
        """
        The password for the Docker registry.
        """
        return pulumi.get(self, "password")

    @_builtins.property
    @pulumi.getter
    def username(self) -> _builtins.str:
        """
        The username for the Docker registry.
        """
        return pulumi.get(self, "username")


@pulumi.output_type
class GetRegistryImageManifestsManifestResult(dict):
    def __init__(__self__, *,
                 architecture: _builtins.str,
                 media_type: _builtins.str,
                 os: _builtins.str,
                 sha256_digest: _builtins.str):
        """
        :param _builtins.str architecture: The platform architecture supported by the manifest.
        :param _builtins.str media_type: The media type of the manifest.
        :param _builtins.str os: The operating system supported by the manifest.
        :param _builtins.str sha256_digest: The content digest of the manifest, as stored in the registry.
        """
        pulumi.set(__self__, "architecture", architecture)
        pulumi.set(__self__, "media_type", media_type)
        pulumi.set(__self__, "os", os)
        pulumi.set(__self__, "sha256_digest", sha256_digest)

    @_builtins.property
    @pulumi.getter
    def architecture(self) -> _builtins.str:
        """
        The platform architecture supported by the manifest.
        """
        return pulumi.get(self, "architecture")

    @_builtins.property
    @pulumi.getter(name="mediaType")
    def media_type(self) -> _builtins.str:
        """
        The media type of the manifest.
        """
        return pulumi.get(self, "media_type")

    @_builtins.property
    @pulumi.getter
    def os(self) -> _builtins.str:
        """
        The operating system supported by the manifest.
        """
        return pulumi.get(self, "os")

    @_builtins.property
    @pulumi.getter(name="sha256Digest")
    def sha256_digest(self) -> _builtins.str:
        """
        The content digest of the manifest, as stored in the registry.
        """
        return pulumi.get(self, "sha256_digest")


