# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['RegistryImageArgs', 'RegistryImage']

@pulumi.input_type
class RegistryImageArgs:
    def __init__(__self__, *,
                 auth_config: Optional[pulumi.Input['RegistryImageAuthConfigArgs']] = None,
                 build: Optional[pulumi.Input['RegistryImageBuildArgs']] = None,
                 insecure_skip_verify: Optional[pulumi.Input[_builtins.bool]] = None,
                 keep_remotely: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 triggers: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a RegistryImage resource.
        :param pulumi.Input['RegistryImageAuthConfigArgs'] auth_config: Authentication configuration for the Docker registry. It is only used for this resource.
        :param pulumi.Input[_builtins.bool] insecure_skip_verify: If `true`, the verification of TLS certificates of the server/registry is disabled. Defaults to `false`
        :param pulumi.Input[_builtins.bool] keep_remotely: If true, then the Docker image won't be deleted on destroy operation. If this is false, it will delete the image from the docker registry on destroy operation. Defaults to `false`
        :param pulumi.Input[_builtins.str] name: The name of the Docker image.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] triggers: A map of arbitrary strings that, when changed, will force the `RegistryImage` resource to be replaced. This can be used to repush a local image
        """
        if auth_config is not None:
            pulumi.set(__self__, "auth_config", auth_config)
        if build is not None:
            pulumi.set(__self__, "build", build)
        if insecure_skip_verify is not None:
            pulumi.set(__self__, "insecure_skip_verify", insecure_skip_verify)
        if keep_remotely is not None:
            pulumi.set(__self__, "keep_remotely", keep_remotely)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if triggers is not None:
            pulumi.set(__self__, "triggers", triggers)

    @_builtins.property
    @pulumi.getter(name="authConfig")
    def auth_config(self) -> Optional[pulumi.Input['RegistryImageAuthConfigArgs']]:
        """
        Authentication configuration for the Docker registry. It is only used for this resource.
        """
        return pulumi.get(self, "auth_config")

    @auth_config.setter
    def auth_config(self, value: Optional[pulumi.Input['RegistryImageAuthConfigArgs']]):
        pulumi.set(self, "auth_config", value)

    @_builtins.property
    @pulumi.getter
    def build(self) -> Optional[pulumi.Input['RegistryImageBuildArgs']]:
        return pulumi.get(self, "build")

    @build.setter
    def build(self, value: Optional[pulumi.Input['RegistryImageBuildArgs']]):
        pulumi.set(self, "build", value)

    @_builtins.property
    @pulumi.getter(name="insecureSkipVerify")
    def insecure_skip_verify(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If `true`, the verification of TLS certificates of the server/registry is disabled. Defaults to `false`
        """
        return pulumi.get(self, "insecure_skip_verify")

    @insecure_skip_verify.setter
    def insecure_skip_verify(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "insecure_skip_verify", value)

    @_builtins.property
    @pulumi.getter(name="keepRemotely")
    def keep_remotely(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If true, then the Docker image won't be deleted on destroy operation. If this is false, it will delete the image from the docker registry on destroy operation. Defaults to `false`
        """
        return pulumi.get(self, "keep_remotely")

    @keep_remotely.setter
    def keep_remotely(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "keep_remotely", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Docker image.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def triggers(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A map of arbitrary strings that, when changed, will force the `RegistryImage` resource to be replaced. This can be used to repush a local image
        """
        return pulumi.get(self, "triggers")

    @triggers.setter
    def triggers(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "triggers", value)


@pulumi.input_type
class _RegistryImageState:
    def __init__(__self__, *,
                 auth_config: Optional[pulumi.Input['RegistryImageAuthConfigArgs']] = None,
                 build: Optional[pulumi.Input['RegistryImageBuildArgs']] = None,
                 insecure_skip_verify: Optional[pulumi.Input[_builtins.bool]] = None,
                 keep_remotely: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 sha256_digest: Optional[pulumi.Input[_builtins.str]] = None,
                 triggers: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering RegistryImage resources.
        :param pulumi.Input['RegistryImageAuthConfigArgs'] auth_config: Authentication configuration for the Docker registry. It is only used for this resource.
        :param pulumi.Input[_builtins.bool] insecure_skip_verify: If `true`, the verification of TLS certificates of the server/registry is disabled. Defaults to `false`
        :param pulumi.Input[_builtins.bool] keep_remotely: If true, then the Docker image won't be deleted on destroy operation. If this is false, it will delete the image from the docker registry on destroy operation. Defaults to `false`
        :param pulumi.Input[_builtins.str] name: The name of the Docker image.
        :param pulumi.Input[_builtins.str] sha256_digest: The sha256 digest of the image.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] triggers: A map of arbitrary strings that, when changed, will force the `RegistryImage` resource to be replaced. This can be used to repush a local image
        """
        if auth_config is not None:
            pulumi.set(__self__, "auth_config", auth_config)
        if build is not None:
            pulumi.set(__self__, "build", build)
        if insecure_skip_verify is not None:
            pulumi.set(__self__, "insecure_skip_verify", insecure_skip_verify)
        if keep_remotely is not None:
            pulumi.set(__self__, "keep_remotely", keep_remotely)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if sha256_digest is not None:
            pulumi.set(__self__, "sha256_digest", sha256_digest)
        if triggers is not None:
            pulumi.set(__self__, "triggers", triggers)

    @_builtins.property
    @pulumi.getter(name="authConfig")
    def auth_config(self) -> Optional[pulumi.Input['RegistryImageAuthConfigArgs']]:
        """
        Authentication configuration for the Docker registry. It is only used for this resource.
        """
        return pulumi.get(self, "auth_config")

    @auth_config.setter
    def auth_config(self, value: Optional[pulumi.Input['RegistryImageAuthConfigArgs']]):
        pulumi.set(self, "auth_config", value)

    @_builtins.property
    @pulumi.getter
    def build(self) -> Optional[pulumi.Input['RegistryImageBuildArgs']]:
        return pulumi.get(self, "build")

    @build.setter
    def build(self, value: Optional[pulumi.Input['RegistryImageBuildArgs']]):
        pulumi.set(self, "build", value)

    @_builtins.property
    @pulumi.getter(name="insecureSkipVerify")
    def insecure_skip_verify(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If `true`, the verification of TLS certificates of the server/registry is disabled. Defaults to `false`
        """
        return pulumi.get(self, "insecure_skip_verify")

    @insecure_skip_verify.setter
    def insecure_skip_verify(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "insecure_skip_verify", value)

    @_builtins.property
    @pulumi.getter(name="keepRemotely")
    def keep_remotely(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If true, then the Docker image won't be deleted on destroy operation. If this is false, it will delete the image from the docker registry on destroy operation. Defaults to `false`
        """
        return pulumi.get(self, "keep_remotely")

    @keep_remotely.setter
    def keep_remotely(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "keep_remotely", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Docker image.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="sha256Digest")
    def sha256_digest(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The sha256 digest of the image.
        """
        return pulumi.get(self, "sha256_digest")

    @sha256_digest.setter
    def sha256_digest(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "sha256_digest", value)

    @_builtins.property
    @pulumi.getter
    def triggers(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A map of arbitrary strings that, when changed, will force the `RegistryImage` resource to be replaced. This can be used to repush a local image
        """
        return pulumi.get(self, "triggers")

    @triggers.setter
    def triggers(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "triggers", value)


@pulumi.type_token("docker:index/registryImage:RegistryImage")
class RegistryImage(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auth_config: Optional[pulumi.Input[Union['RegistryImageAuthConfigArgs', 'RegistryImageAuthConfigArgsDict']]] = None,
                 build: Optional[pulumi.Input[Union['RegistryImageBuildArgs', 'RegistryImageBuildArgsDict']]] = None,
                 insecure_skip_verify: Optional[pulumi.Input[_builtins.bool]] = None,
                 keep_remotely: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 triggers: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        <!-- Bug: Type and Name are switched -->
        Manages the lifecycle of docker image in a registry. You can upload images to a registry (= `docker push`) and also delete them again

        ## Example Usage

        Build an image with the `RemoteImage` resource and then push it to a registry:

        ```python
        import pulumi
        import os
        import pulumi_docker as docker

        image = docker.RemoteImage("image",
            name="registry.com/somename:1.0",
            build={
                "context": f"{os.getcwd()}/absolutePathToContextFolder",
            })
        helloworld = docker.RegistryImage("helloworld",
            name=image.name,
            keep_remotely=True)
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['RegistryImageAuthConfigArgs', 'RegistryImageAuthConfigArgsDict']] auth_config: Authentication configuration for the Docker registry. It is only used for this resource.
        :param pulumi.Input[_builtins.bool] insecure_skip_verify: If `true`, the verification of TLS certificates of the server/registry is disabled. Defaults to `false`
        :param pulumi.Input[_builtins.bool] keep_remotely: If true, then the Docker image won't be deleted on destroy operation. If this is false, it will delete the image from the docker registry on destroy operation. Defaults to `false`
        :param pulumi.Input[_builtins.str] name: The name of the Docker image.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] triggers: A map of arbitrary strings that, when changed, will force the `RegistryImage` resource to be replaced. This can be used to repush a local image
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[RegistryImageArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        <!-- Bug: Type and Name are switched -->
        Manages the lifecycle of docker image in a registry. You can upload images to a registry (= `docker push`) and also delete them again

        ## Example Usage

        Build an image with the `RemoteImage` resource and then push it to a registry:

        ```python
        import pulumi
        import os
        import pulumi_docker as docker

        image = docker.RemoteImage("image",
            name="registry.com/somename:1.0",
            build={
                "context": f"{os.getcwd()}/absolutePathToContextFolder",
            })
        helloworld = docker.RegistryImage("helloworld",
            name=image.name,
            keep_remotely=True)
        ```

        :param str resource_name: The name of the resource.
        :param RegistryImageArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(RegistryImageArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auth_config: Optional[pulumi.Input[Union['RegistryImageAuthConfigArgs', 'RegistryImageAuthConfigArgsDict']]] = None,
                 build: Optional[pulumi.Input[Union['RegistryImageBuildArgs', 'RegistryImageBuildArgsDict']]] = None,
                 insecure_skip_verify: Optional[pulumi.Input[_builtins.bool]] = None,
                 keep_remotely: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 triggers: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = RegistryImageArgs.__new__(RegistryImageArgs)

            __props__.__dict__["auth_config"] = auth_config
            __props__.__dict__["build"] = build
            __props__.__dict__["insecure_skip_verify"] = insecure_skip_verify
            __props__.__dict__["keep_remotely"] = keep_remotely
            __props__.__dict__["name"] = name
            __props__.__dict__["triggers"] = triggers
            __props__.__dict__["sha256_digest"] = None
        super(RegistryImage, __self__).__init__(
            'docker:index/registryImage:RegistryImage',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            auth_config: Optional[pulumi.Input[Union['RegistryImageAuthConfigArgs', 'RegistryImageAuthConfigArgsDict']]] = None,
            build: Optional[pulumi.Input[Union['RegistryImageBuildArgs', 'RegistryImageBuildArgsDict']]] = None,
            insecure_skip_verify: Optional[pulumi.Input[_builtins.bool]] = None,
            keep_remotely: Optional[pulumi.Input[_builtins.bool]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            sha256_digest: Optional[pulumi.Input[_builtins.str]] = None,
            triggers: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None) -> 'RegistryImage':
        """
        Get an existing RegistryImage resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['RegistryImageAuthConfigArgs', 'RegistryImageAuthConfigArgsDict']] auth_config: Authentication configuration for the Docker registry. It is only used for this resource.
        :param pulumi.Input[_builtins.bool] insecure_skip_verify: If `true`, the verification of TLS certificates of the server/registry is disabled. Defaults to `false`
        :param pulumi.Input[_builtins.bool] keep_remotely: If true, then the Docker image won't be deleted on destroy operation. If this is false, it will delete the image from the docker registry on destroy operation. Defaults to `false`
        :param pulumi.Input[_builtins.str] name: The name of the Docker image.
        :param pulumi.Input[_builtins.str] sha256_digest: The sha256 digest of the image.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] triggers: A map of arbitrary strings that, when changed, will force the `RegistryImage` resource to be replaced. This can be used to repush a local image
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _RegistryImageState.__new__(_RegistryImageState)

        __props__.__dict__["auth_config"] = auth_config
        __props__.__dict__["build"] = build
        __props__.__dict__["insecure_skip_verify"] = insecure_skip_verify
        __props__.__dict__["keep_remotely"] = keep_remotely
        __props__.__dict__["name"] = name
        __props__.__dict__["sha256_digest"] = sha256_digest
        __props__.__dict__["triggers"] = triggers
        return RegistryImage(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="authConfig")
    def auth_config(self) -> pulumi.Output[Optional['outputs.RegistryImageAuthConfig']]:
        """
        Authentication configuration for the Docker registry. It is only used for this resource.
        """
        return pulumi.get(self, "auth_config")

    @_builtins.property
    @pulumi.getter
    def build(self) -> pulumi.Output[Optional['outputs.RegistryImageBuild']]:
        return pulumi.get(self, "build")

    @_builtins.property
    @pulumi.getter(name="insecureSkipVerify")
    def insecure_skip_verify(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        If `true`, the verification of TLS certificates of the server/registry is disabled. Defaults to `false`
        """
        return pulumi.get(self, "insecure_skip_verify")

    @_builtins.property
    @pulumi.getter(name="keepRemotely")
    def keep_remotely(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        If true, then the Docker image won't be deleted on destroy operation. If this is false, it will delete the image from the docker registry on destroy operation. Defaults to `false`
        """
        return pulumi.get(self, "keep_remotely")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the Docker image.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="sha256Digest")
    def sha256_digest(self) -> pulumi.Output[_builtins.str]:
        """
        The sha256 digest of the image.
        """
        return pulumi.get(self, "sha256_digest")

    @_builtins.property
    @pulumi.getter
    def triggers(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        A map of arbitrary strings that, when changed, will force the `RegistryImage` resource to be replaced. This can be used to repush a local image
        """
        return pulumi.get(self, "triggers")

