# QLapi

QLapi 是一个用于青龙面板的 Python 异步 API 封装库。

## 安装

```bash
pip install qinglongtool
```

## 使用s

```python
import asyncio
from qlapi.ql import ql_api
from qlapi.ql_env import qlenv
from qlapi.ql_config import qlconfig
# 导入其他您需要使用的异步类


QL_HOST   = "127.0.0.1"
QL_PORT   = "5700"
CLIENT_ID = "CLIENT_ID"
CLIENT_SECRET = "CLIENT_SECRET"

async def main():
    # 实例化 ql_api，使用异步工厂方法 create 和 async with 语句
    # 确保 httpx 客户端在程序结束时自动关闭
    ql_env_instance = qlenv(QL_HOST, QL_PORT, CLIENT_ID, CLIENT_SECRET)
    envs = await ql_env_instance.search(search_value="651380741", name="MI_PAY_TOKEN")
    print("环境变量搜索结果:", envs)

    # 示例：使用 qlconfig 获取配置文件列表
    ql_config_instance = qlconfig(QL_HOST, QL_PORT, CLIENT_ID, CLIENT_SECRET)
    configs = await ql_config_instance.list()
    print("配置文件列表:", configs)

    # 示例：添加一个环境变量
    add_result = await ql_env_instance.add("TEST_ENV", "test_value")
    print("添加环境变量结果:", add_result)

if __name__ == "__main__":
    asyncio.run(main())

```

## 模块

- `ql.py`: 基础 API 认证和 HTTP 客户端。
- `ql_config.py`: 配置文件管理。
- `ql_dependence.py`: 依赖管理。
- `ql_env.py`: 环境变量管理。
- `ql_log.py`: 日志管理。
- `ql_script.py`: 脚本管理。
- `ql_system.py`: 系统信息和更新。
- `ql_task.py`: 定时任务管理。

## 贡献

欢迎贡献！请提交 Pull Request 或 Issues。

## 许可证

本项目使用 MIT 许可证。
