'''
Author: XDTEAM
Date: 2025-07-16 01:26:05
LastEditTime: 2025-07-16 01:40:25
LastEditors: XDTEAM
Description: 
'''
import json

from .ql import ql_api


class qlconfig(ql_api):
    """
    青龙面板api配置文件模块

    url: 青龙面板IP地址(不包含http://)

    post: 青龙面板端口

    client_id: 青龙面板openapi登录用户名

    client_secret: 青龙面板openapi登录密码

    Usage::
        >>> ql_config = qlconfig(
            url="12.22.43.23",
            port=5700,
            client_id="admin",
            client_secret="abcdefg_",
        )
        ql_config.list()
    """
    def __init__(self, url: str, post: int, client_id: str, client_secret: str):
        super().__init__(url, post, client_id, client_secret)

    async def _ensure_initialized(self):
        """确保已初始化"""
        if not self._initialized:
            await self.initialize()

    async def list(self):
        """获取配置文件列表

        :return: 源相应json
        """
        await self._ensure_initialized()
        url = f"{self.url}/open/configs/files"
        res = await self.s.get(url=url)
        return res.json()

    async def value(self, file_name):
        """获取配置文件内容

        :param file_name: 文件名
        :return: 源相应json
        """
        await self._ensure_initialized()
        url = f"{self.url}/open/configs/{file_name}"
        res = await self.s.get(url=url)
        return res.json()

    async def save(self, name, content):
        """保存配置文件

        :param name: 文件名
        :param content: 值
        :return: 源相应json
        """
        await self._ensure_initialized()
        url = f"{self.url}/open/configs/save"
        data = {
            "name": name,
            "content": content
        }
        res = await self.s.post(url=url, data=json.dumps(data))
        return res.json()
