'''
Author: XDTEAM
Date: 2025-07-15 22:24:04
LastEditTime: 2025-07-16 23:07:53
LastEditors: XDTEAM
Description: 
'''
import json

from .ql import ql_api


class qltask(ql_api):
    """
    青龙面板api定时任务模块

    url: 青龙面板IP地址(不包含http://)

    post: 青龙面板端口

    client_id: 青龙面板openapi登录用户名

    client_secret: 青龙面板openapi登录密码

    Usage::
        >>> ql_task = qltask(
            url="12.22.43.23",
            port=5700,
            client_id="admin",
            client_secret="abcdefg_",
        )
        ql_task.list()
    """
    def __init__(self, url: str, post: int, client_id: str, client_secret: str):
        super().__init__(url, post, client_id, client_secret)

    async def _ensure_initialized(self):
        """确保已初始化"""
        if not self._initialized:
            await self.initialize()

    async def add(self, command: str, schedule: str, name: str, labels: str = '') -> dict:
        """添加定时任务,返回相应状态码以及响应结果或任务ID

        :param command: 命令
        :param schedule: 定时时间
        :param name: 定时任务名称
        :param labels: 备注,测试不通过，留空
        :return:
            成功返回示例 {'code': 200, 'data': 47}

            失败返回示例 {'code': 500, 'data': 'Validation error'}
        """
        await self._ensure_initialized()
        url = f"{self.url}/open/crons"
        data = {
            "command": command,
            "schedule": schedule,
            "name": name,
            # "labels": labels
        }
        res = await self.s.post(url=url, json=data)
        if res.status_code == 200:
            return {"code": 200,
                    "data": res.json().get('data').get('id')
                    }
        else:
            return {
                "code": res.status_code,
                "data": res.json().get("message")
            }

    async def task_run(self, id: list) -> int:
        """根据id运行任务

        :param id: 任务ID列表
        :return: 响应码
        """
        await self._ensure_initialized()
        url = f"{self.url}/open/crons/run"
        data = json.dumps(id)
        res = await self.s.put(url=url, data=data)
        return res.status_code
