"use strict";
/**
 *  Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
// Imports
const aws_cdk_lib_1 = require("aws-cdk-lib");
const lib_1 = require("../lib");
const core_1 = require("@aws-solutions-constructs/core");
const ecs = require("aws-cdk-lib/aws-ecs");
const ssm = require("aws-cdk-lib/aws-ssm");
const integ_tests_alpha_1 = require("@aws-cdk/integ-tests-alpha");
// Setup
const app = new aws_cdk_lib_1.App();
const stack = new aws_cdk_lib_1.Stack(app, core_1.generateIntegStackName(__filename), {
    env: { account: aws_cdk_lib_1.Aws.ACCOUNT_ID, region: 'us-east-1' },
});
stack.templateOptions.description = 'Integration Test with existing VPC, Service and SSM String Parameter';
const existingVpc = core_1.getTestVpc(stack);
const existingStringParameterObj = new ssm.StringParameter(stack, 'Parameter', {
    allowedPattern: '.*',
    description: 'The value Foo',
    stringValue: 'Foo',
});
const image = ecs.ContainerImage.fromRegistry('nginx');
const createFargateServiceResponse = core_1.CreateFargateService(stack, 'test', {
    constructVpc: existingVpc,
    clientContainerDefinitionProps: {
        image
    },
});
const constructProps = {
    publicApi: true,
    existingVpc,
    existingStringParameterObj,
    existingContainerDefinitionObject: createFargateServiceResponse.containerDefinition,
    existingFargateServiceObject: createFargateServiceResponse.service,
    stringParameterEnvironmentVariableName: 'CUSTOM_NAME',
    stringParameterPermissions: "readwrite"
};
new lib_1.FargateToSsmstringparameter(stack, 'test-construct', constructProps);
core_1.suppressCustomHandlerCfnNagWarnings(stack, 'Custom::VpcRestrictDefaultSGCustomResourceProvider');
// Synth
new integ_tests_alpha_1.IntegTest(stack, 'Integ', { testCases: [
        stack
    ] });
//# sourceMappingURL=data:application/json;base64,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