# This file was auto-generated by Fern from our API Definition.

import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.request_options import RequestOptions
from ..types.client_facing_meal_response import ClientFacingMealResponse
from .raw_client import AsyncRawMealClient, RawMealClient


class MealClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawMealClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawMealClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawMealClient
        """
        return self._raw_client

    def get(
        self,
        user_id: str,
        *,
        start_date: str,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ClientFacingMealResponse:
        """
        Get user's meals

        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ClientFacingMealResponse
            Successful Response

        Examples
        --------
        from vital import Vital
        client = Vital(api_key="YOUR_API_KEY", )
        client.meal.get(user_id='user_id', start_date='start_date', )
        """
        _response = self._raw_client.get(
            user_id, start_date=start_date, provider=provider, end_date=end_date, request_options=request_options
        )
        return _response.data


class AsyncMealClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawMealClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawMealClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawMealClient
        """
        return self._raw_client

    async def get(
        self,
        user_id: str,
        *,
        start_date: str,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ClientFacingMealResponse:
        """
        Get user's meals

        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ClientFacingMealResponse
            Successful Response

        Examples
        --------
        from vital import AsyncVital
        import asyncio
        client = AsyncVital(api_key="YOUR_API_KEY", )
        async def main() -> None:
            await client.meal.get(user_id='user_id', start_date='start_date', )
        asyncio.run(main())
        """
        _response = await self._raw_client.get(
            user_id, start_date=start_date, provider=provider, end_date=end_date, request_options=request_options
        )
        return _response.data
