# Welcome to the Virtual Ecosystem

[![codecov](https://codecov.io/gh/ImperialCollegeLondon/virtual_rainforest/branch/develop/graph/badge.svg)](https://codecov.io/gh/ImperialCollegeLondon/virtual_rainforest)
[![pre-commit.ci status](https://results.pre-commit.ci/badge/github/ImperialCollegeLondon/virtual_rainforest/develop.svg)](https://results.pre-commit.ci/latest/github/ImperialCollegeLondon/virtual_rainforest/develop)

This repository is the home for the development of the Virtual Ecosystem. The
Virtual Ecosystem is a project to develop a simulation of all of the major
processes involved in a real ecosystem including the:

* growth and demographic processes of the primary producers within the forest,
* microclimatic processes within and around the ecosystem,
* hydrological processes within the canopy, soil and drainage networks,
* biotic and abiotic processes within the soil, and the
* growth and demography of heterotrophs.

## Project details

This project is funded by a 2021 Distinguished Scientist award from the NOMIS
Foundation to Professor Robert Ewers:

* [NOMIS Award details](https://nomisfoundation.ch/people/robert-ewers/)
* [NOMIS project summary](https://nomisfoundation.ch/research-projects/a-virtual-rainforest-for-understanding-the-stability-resilience-and-sustainability-of-complex-ecosystems/)

<!-- markdownlint-disable-next-line  MD033 MD013-->
[<img alt="NOMIS logo" src="https://github.com/ImperialCollegeLondon/virtual_ecosystem/blob/c94cef61d997764442d7beb9ac2eaedae71cfad1/docs/source/_static/images/logo-nomis-822-by-321.png?raw=true" width=250>](https://nomisfoundation.ch)

The research is based at Imperial College London:

<!-- markdownlint-disable-next-line  MD033 MD013-->
[<img alt="Imperial logo" src="https://github.com/ImperialCollegeLondon/virtual_ecosystem/blob/c94cef61d997764442d7beb9ac2eaedae71cfad1/docs/source/_static/images/IMP_ML_1CS_4CP_CLEAR-SPACE.png?raw=true" width=250>](https://imperial.ac.uk)

## Project Team

* Professor Robert Ewers
* Olivia Daniel
* Dr. Jaideep Joshi
* Dr. David Orme
* Dr. Vivienne Groner
* Dr. Jacob Cook
* Dr. Taran Rallings

The research team are supported by the Imperial College London
[Research Software
Engineering](https://www.imperial.ac.uk/admin-services/ict/self-service/research-support/rcs/service-offering/research-software-engineering/)
team.

## Model documentation

The full documentation for the Virtual Ecosystem model can be viewed
[here](https://virtual-ecosystem.readthedocs.io/en/latest/).
