# API Reference <a name="API Reference" id="api-reference"></a>

## Constructs <a name="Constructs" id="Constructs"></a>

### ApiGatewayToLambda <a name="ApiGatewayToLambda" id="must-cdk.ApiGatewayToLambda"></a>

#### Initializers <a name="Initializers" id="must-cdk.ApiGatewayToLambda.Initializer"></a>

```python
import must_cdk

must_cdk.ApiGatewayToLambda(
  scope: Construct,
  id: str,
  api_name: str,
  lambda_function: IFunction,
  create_usage_plan: bool = None,
  custom_domain_name: str = None,
  custom_routes: typing.List[CustomRoute] = None,
  enable_logging: bool = None,
  existing_certificate: ICertificate = None,
  hosted_zone: IHostedZone = None,
  lambda_api_props: LambdaRestApiProps = None,
  log_group_props: LogGroupProps = None,
  proxy: bool = None,
  rest_api_props: RestApiProps = None
)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#must-cdk.ApiGatewayToLambda.Initializer.parameter.scope">scope</a></code> | <code>constructs.Construct</code> | *No description.* |
| <code><a href="#must-cdk.ApiGatewayToLambda.Initializer.parameter.id">id</a></code> | <code>str</code> | *No description.* |
| <code><a href="#must-cdk.ApiGatewayToLambda.Initializer.parameter.apiName">api_name</a></code> | <code>str</code> | API configuration. |
| <code><a href="#must-cdk.ApiGatewayToLambda.Initializer.parameter.lambdaFunction">lambda_function</a></code> | <code>aws_cdk.aws_lambda.IFunction</code> | Primary Lambda function for the API. |
| <code><a href="#must-cdk.ApiGatewayToLambda.Initializer.parameter.createUsagePlan">create_usage_plan</a></code> | <code>bool</code> | Whether to create a Usage Plan. |
| <code><a href="#must-cdk.ApiGatewayToLambda.Initializer.parameter.customDomainName">custom_domain_name</a></code> | <code>str</code> | Optional custom domain name for API Gateway. |
| <code><a href="#must-cdk.ApiGatewayToLambda.Initializer.parameter.customRoutes">custom_routes</a></code> | <code>typing.List[<a href="#must-cdk.CustomRoute">CustomRoute</a>]</code> | Custom routes for manual API setup (when proxy is false) If provided, will use RestApi instead of LambdaRestApi. |
| <code><a href="#must-cdk.ApiGatewayToLambda.Initializer.parameter.enableLogging">enable_logging</a></code> | <code>bool</code> | Enable CloudWatch logging for API Gateway. |
| <code><a href="#must-cdk.ApiGatewayToLambda.Initializer.parameter.existingCertificate">existing_certificate</a></code> | <code>aws_cdk.aws_certificatemanager.ICertificate</code> | Optional ACM certificate to use instead of creating a new one. |
| <code><a href="#must-cdk.ApiGatewayToLambda.Initializer.parameter.hostedZone">hosted_zone</a></code> | <code>aws_cdk.aws_route53.IHostedZone</code> | Optional Route53 hosted zone for custom domain. |
| <code><a href="#must-cdk.ApiGatewayToLambda.Initializer.parameter.lambdaApiProps">lambda_api_props</a></code> | <code>aws_cdk.aws_apigateway.LambdaRestApiProps</code> | *No description.* |
| <code><a href="#must-cdk.ApiGatewayToLambda.Initializer.parameter.logGroupProps">log_group_props</a></code> | <code>aws_cdk.aws_logs.LogGroupProps</code> | CloudWatch Logs configuration. |
| <code><a href="#must-cdk.ApiGatewayToLambda.Initializer.parameter.proxy">proxy</a></code> | <code>bool</code> | *No description.* |
| <code><a href="#must-cdk.ApiGatewayToLambda.Initializer.parameter.restApiProps">rest_api_props</a></code> | <code>aws_cdk.aws_apigateway.RestApiProps</code> | *No description.* |

---

##### `scope`<sup>Required</sup> <a name="scope" id="must-cdk.ApiGatewayToLambda.Initializer.parameter.scope"></a>

- *Type:* constructs.Construct

---

##### `id`<sup>Required</sup> <a name="id" id="must-cdk.ApiGatewayToLambda.Initializer.parameter.id"></a>

- *Type:* str

---

##### `api_name`<sup>Required</sup> <a name="api_name" id="must-cdk.ApiGatewayToLambda.Initializer.parameter.apiName"></a>

- *Type:* str

API configuration.

---

##### `lambda_function`<sup>Required</sup> <a name="lambda_function" id="must-cdk.ApiGatewayToLambda.Initializer.parameter.lambdaFunction"></a>

- *Type:* aws_cdk.aws_lambda.IFunction

Primary Lambda function for the API.

---

##### `create_usage_plan`<sup>Optional</sup> <a name="create_usage_plan" id="must-cdk.ApiGatewayToLambda.Initializer.parameter.createUsagePlan"></a>

- *Type:* bool

Whether to create a Usage Plan.

---

##### `custom_domain_name`<sup>Optional</sup> <a name="custom_domain_name" id="must-cdk.ApiGatewayToLambda.Initializer.parameter.customDomainName"></a>

- *Type:* str

Optional custom domain name for API Gateway.

---

##### `custom_routes`<sup>Optional</sup> <a name="custom_routes" id="must-cdk.ApiGatewayToLambda.Initializer.parameter.customRoutes"></a>

- *Type:* typing.List[<a href="#must-cdk.CustomRoute">CustomRoute</a>]

Custom routes for manual API setup (when proxy is false) If provided, will use RestApi instead of LambdaRestApi.

---

##### `enable_logging`<sup>Optional</sup> <a name="enable_logging" id="must-cdk.ApiGatewayToLambda.Initializer.parameter.enableLogging"></a>

- *Type:* bool

Enable CloudWatch logging for API Gateway.

---

##### `existing_certificate`<sup>Optional</sup> <a name="existing_certificate" id="must-cdk.ApiGatewayToLambda.Initializer.parameter.existingCertificate"></a>

- *Type:* aws_cdk.aws_certificatemanager.ICertificate

Optional ACM certificate to use instead of creating a new one.

---

##### `hosted_zone`<sup>Optional</sup> <a name="hosted_zone" id="must-cdk.ApiGatewayToLambda.Initializer.parameter.hostedZone"></a>

- *Type:* aws_cdk.aws_route53.IHostedZone

Optional Route53 hosted zone for custom domain.

---

##### `lambda_api_props`<sup>Optional</sup> <a name="lambda_api_props" id="must-cdk.ApiGatewayToLambda.Initializer.parameter.lambdaApiProps"></a>

- *Type:* aws_cdk.aws_apigateway.LambdaRestApiProps

---

##### `log_group_props`<sup>Optional</sup> <a name="log_group_props" id="must-cdk.ApiGatewayToLambda.Initializer.parameter.logGroupProps"></a>

- *Type:* aws_cdk.aws_logs.LogGroupProps

CloudWatch Logs configuration.

---

##### `proxy`<sup>Optional</sup> <a name="proxy" id="must-cdk.ApiGatewayToLambda.Initializer.parameter.proxy"></a>

- *Type:* bool

---

##### `rest_api_props`<sup>Optional</sup> <a name="rest_api_props" id="must-cdk.ApiGatewayToLambda.Initializer.parameter.restApiProps"></a>

- *Type:* aws_cdk.aws_apigateway.RestApiProps

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#must-cdk.ApiGatewayToLambda.toString">to_string</a></code> | Returns a string representation of this construct. |
| <code><a href="#must-cdk.ApiGatewayToLambda.addRoute">add_route</a></code> | Add a custom route after construction (for dynamic route addition). |

---

##### `to_string` <a name="to_string" id="must-cdk.ApiGatewayToLambda.toString"></a>

```python
def to_string() -> str
```

Returns a string representation of this construct.

##### `add_route` <a name="add_route" id="must-cdk.ApiGatewayToLambda.addRoute"></a>

```python
def add_route(
  handler: IFunction,
  method: str,
  path: str,
  method_options: MethodOptions = None
) -> Method
```

Add a custom route after construction (for dynamic route addition).

###### `handler`<sup>Required</sup> <a name="handler" id="must-cdk.ApiGatewayToLambda.addRoute.parameter.handler"></a>

- *Type:* aws_cdk.aws_lambda.IFunction

---

###### `method`<sup>Required</sup> <a name="method" id="must-cdk.ApiGatewayToLambda.addRoute.parameter.method"></a>

- *Type:* str

---

###### `path`<sup>Required</sup> <a name="path" id="must-cdk.ApiGatewayToLambda.addRoute.parameter.path"></a>

- *Type:* str

---

###### `method_options`<sup>Optional</sup> <a name="method_options" id="must-cdk.ApiGatewayToLambda.addRoute.parameter.methodOptions"></a>

- *Type:* aws_cdk.aws_apigateway.MethodOptions

---

#### Static Functions <a name="Static Functions" id="Static Functions"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#must-cdk.ApiGatewayToLambda.isConstruct">is_construct</a></code> | Checks if `x` is a construct. |

---

##### ~~`is_construct`~~ <a name="is_construct" id="must-cdk.ApiGatewayToLambda.isConstruct"></a>

```python
import must_cdk

must_cdk.ApiGatewayToLambda.is_construct(
  x: typing.Any
)
```

Checks if `x` is a construct.

###### `x`<sup>Required</sup> <a name="x" id="must-cdk.ApiGatewayToLambda.isConstruct.parameter.x"></a>

- *Type:* typing.Any

Any object.

---

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#must-cdk.ApiGatewayToLambda.property.node">node</a></code> | <code>constructs.Node</code> | The tree node. |
| <code><a href="#must-cdk.ApiGatewayToLambda.property.apiGateway">api_gateway</a></code> | <code>aws_cdk.aws_apigateway.RestApi</code> | *No description.* |
| <code><a href="#must-cdk.ApiGatewayToLambda.property.apiUrl">api_url</a></code> | <code>str</code> | *No description.* |
| <code><a href="#must-cdk.ApiGatewayToLambda.property.lambdaFunction">lambda_function</a></code> | <code>aws_cdk.aws_lambda.IFunction</code> | *No description.* |
| <code><a href="#must-cdk.ApiGatewayToLambda.property.apiGatewayLogGroup">api_gateway_log_group</a></code> | <code>aws_cdk.aws_logs.LogGroup</code> | *No description.* |
| <code><a href="#must-cdk.ApiGatewayToLambda.property.aRecord">a_record</a></code> | <code>aws_cdk.aws_route53.ARecord</code> | *No description.* |
| <code><a href="#must-cdk.ApiGatewayToLambda.property.certificate">certificate</a></code> | <code>aws_cdk.aws_certificatemanager.ICertificate</code> | *No description.* |
| <code><a href="#must-cdk.ApiGatewayToLambda.property.domain">domain</a></code> | <code>aws_cdk.aws_apigateway.DomainName</code> | *No description.* |
| <code><a href="#must-cdk.ApiGatewayToLambda.property.usagePlan">usage_plan</a></code> | <code>aws_cdk.aws_apigateway.UsagePlan</code> | *No description.* |

---

##### `node`<sup>Required</sup> <a name="node" id="must-cdk.ApiGatewayToLambda.property.node"></a>

```python
node: Node
```

- *Type:* constructs.Node

The tree node.

---

##### `api_gateway`<sup>Required</sup> <a name="api_gateway" id="must-cdk.ApiGatewayToLambda.property.apiGateway"></a>

```python
api_gateway: RestApi
```

- *Type:* aws_cdk.aws_apigateway.RestApi

---

##### `api_url`<sup>Required</sup> <a name="api_url" id="must-cdk.ApiGatewayToLambda.property.apiUrl"></a>

```python
api_url: str
```

- *Type:* str

---

##### `lambda_function`<sup>Required</sup> <a name="lambda_function" id="must-cdk.ApiGatewayToLambda.property.lambdaFunction"></a>

```python
lambda_function: IFunction
```

- *Type:* aws_cdk.aws_lambda.IFunction

---

##### `api_gateway_log_group`<sup>Optional</sup> <a name="api_gateway_log_group" id="must-cdk.ApiGatewayToLambda.property.apiGatewayLogGroup"></a>

```python
api_gateway_log_group: LogGroup
```

- *Type:* aws_cdk.aws_logs.LogGroup

---

##### `a_record`<sup>Optional</sup> <a name="a_record" id="must-cdk.ApiGatewayToLambda.property.aRecord"></a>

```python
a_record: ARecord
```

- *Type:* aws_cdk.aws_route53.ARecord

---

##### `certificate`<sup>Optional</sup> <a name="certificate" id="must-cdk.ApiGatewayToLambda.property.certificate"></a>

```python
certificate: ICertificate
```

- *Type:* aws_cdk.aws_certificatemanager.ICertificate

---

##### `domain`<sup>Optional</sup> <a name="domain" id="must-cdk.ApiGatewayToLambda.property.domain"></a>

```python
domain: DomainName
```

- *Type:* aws_cdk.aws_apigateway.DomainName

---

##### `usage_plan`<sup>Optional</sup> <a name="usage_plan" id="must-cdk.ApiGatewayToLambda.property.usagePlan"></a>

```python
usage_plan: UsagePlan
```

- *Type:* aws_cdk.aws_apigateway.UsagePlan

---


### CloudFrontToOrigins <a name="CloudFrontToOrigins" id="must-cdk.CloudFrontToOrigins"></a>

#### Initializers <a name="Initializers" id="must-cdk.CloudFrontToOrigins.Initializer"></a>

```python
import must_cdk

must_cdk.CloudFrontToOrigins(
  scope: Construct,
  id: str,
  additional_domain_names: typing.List[str] = None,
  cache_behaviors: typing.List[CacheBehaviorConfig] = None,
  certificate: ICertificate = None,
  comment: str = None,
  create_route53_records: bool = None,
  custom_domain_name: str = None,
  default_origin_id: str = None,
  default_root_object: str = None,
  disable_default_error_pages: bool = None,
  disable_intelligent_defaults: bool = None,
  enabled: bool = None,
  enable_ipv6: bool = None,
  enable_logging: bool = None,
  error_pages: typing.List[ErrorResponse] = None,
  geo_restriction: GeoRestriction = None,
  hosted_zone: IHostedZone = None,
  http_origins: typing.List[HttpOriginConfig] = None,
  http_version: HttpVersion = None,
  log_bucket: IBucket = None,
  log_include_cookies: bool = None,
  log_prefix: str = None,
  price_class: PriceClass = None,
  s3_origins: typing.List[S3OriginConfig] = None,
  web_acl_id: str = None
)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#must-cdk.CloudFrontToOrigins.Initializer.parameter.scope">scope</a></code> | <code>constructs.Construct</code> | *No description.* |
| <code><a href="#must-cdk.CloudFrontToOrigins.Initializer.parameter.id">id</a></code> | <code>str</code> | *No description.* |
| <code><a href="#must-cdk.CloudFrontToOrigins.Initializer.parameter.additionalDomainNames">additional_domain_names</a></code> | <code>typing.List[str]</code> | Additional domain names (aliases) for the distribution Note: All domains must be covered by the same certificate. |
| <code><a href="#must-cdk.CloudFrontToOrigins.Initializer.parameter.cacheBehaviors">cache_behaviors</a></code> | <code>typing.List[<a href="#must-cdk.CacheBehaviorConfig">CacheBehaviorConfig</a>]</code> | Cache behaviors for specific path patterns. |
| <code><a href="#must-cdk.CloudFrontToOrigins.Initializer.parameter.certificate">certificate</a></code> | <code>aws_cdk.aws_certificatemanager.ICertificate</code> | Existing ACM certificate to use for the CloudFront distribution Certificate must be in us-east-1 region for CloudFront. |
| <code><a href="#must-cdk.CloudFrontToOrigins.Initializer.parameter.comment">comment</a></code> | <code>str</code> | Comment for the distribution. |
| <code><a href="#must-cdk.CloudFrontToOrigins.Initializer.parameter.createRoute53Records">create_route53_records</a></code> | <code>bool</code> | Create Route53 records for all domain names. |
| <code><a href="#must-cdk.CloudFrontToOrigins.Initializer.parameter.customDomainName">custom_domain_name</a></code> | <code>str</code> | Primary custom domain name for the CloudFront distribution. |
| <code><a href="#must-cdk.CloudFrontToOrigins.Initializer.parameter.defaultOriginId">default_origin_id</a></code> | <code>str</code> | ID of the origin to use as default behavior If not specified, will use the first HTTP origin, then first S3 origin. |
| <code><a href="#must-cdk.CloudFrontToOrigins.Initializer.parameter.defaultRootObject">default_root_object</a></code> | <code>str</code> | Default root object for the distribution. |
| <code><a href="#must-cdk.CloudFrontToOrigins.Initializer.parameter.disableDefaultErrorPages">disable_default_error_pages</a></code> | <code>bool</code> | Disable intelligent defaults for error pages. |
| <code><a href="#must-cdk.CloudFrontToOrigins.Initializer.parameter.disableIntelligentDefaults">disable_intelligent_defaults</a></code> | <code>bool</code> | Disable intelligent defaults completely When true, only user-provided configuration will be applied. |
| <code><a href="#must-cdk.CloudFrontToOrigins.Initializer.parameter.enabled">enabled</a></code> | <code>bool</code> | Whether the distribution is enabled. |
| <code><a href="#must-cdk.CloudFrontToOrigins.Initializer.parameter.enableIpv6">enable_ipv6</a></code> | <code>bool</code> | Enable IPv6 for the distribution. |
| <code><a href="#must-cdk.CloudFrontToOrigins.Initializer.parameter.enableLogging">enable_logging</a></code> | <code>bool</code> | Enable CloudFront access logging. |
| <code><a href="#must-cdk.CloudFrontToOrigins.Initializer.parameter.errorPages">error_pages</a></code> | <code>typing.List[aws_cdk.aws_cloudfront.ErrorResponse]</code> | Custom error page configurations If not provided, intelligent defaults will be applied based on origin types. |
| <code><a href="#must-cdk.CloudFrontToOrigins.Initializer.parameter.geoRestriction">geo_restriction</a></code> | <code>aws_cdk.aws_cloudfront.GeoRestriction</code> | Geographic restriction configuration. |
| <code><a href="#must-cdk.CloudFrontToOrigins.Initializer.parameter.hostedZone">hosted_zone</a></code> | <code>aws_cdk.aws_route53.IHostedZone</code> | Route53 hosted zone for the custom domain Required for creating Route53 records. |
| <code><a href="#must-cdk.CloudFrontToOrigins.Initializer.parameter.httpOrigins">http_origins</a></code> | <code>typing.List[<a href="#must-cdk.HttpOriginConfig">HttpOriginConfig</a>]</code> | HTTP origins configuration. |
| <code><a href="#must-cdk.CloudFrontToOrigins.Initializer.parameter.httpVersion">http_version</a></code> | <code>aws_cdk.aws_cloudfront.HttpVersion</code> | HTTP version to support. |
| <code><a href="#must-cdk.CloudFrontToOrigins.Initializer.parameter.logBucket">log_bucket</a></code> | <code>aws_cdk.aws_s3.IBucket</code> | Existing S3 bucket for logs If not provided and logging is enabled, a new bucket will be created. |
| <code><a href="#must-cdk.CloudFrontToOrigins.Initializer.parameter.logIncludeCookies">log_include_cookies</a></code> | <code>bool</code> | Include cookies in access logs. |
| <code><a href="#must-cdk.CloudFrontToOrigins.Initializer.parameter.logPrefix">log_prefix</a></code> | <code>str</code> | Prefix for log files. |
| <code><a href="#must-cdk.CloudFrontToOrigins.Initializer.parameter.priceClass">price_class</a></code> | <code>aws_cdk.aws_cloudfront.PriceClass</code> | CloudFront distribution price class. |
| <code><a href="#must-cdk.CloudFrontToOrigins.Initializer.parameter.s3Origins">s3_origins</a></code> | <code>typing.List[<a href="#must-cdk.S3OriginConfig">S3OriginConfig</a>]</code> | S3 origins configuration. |
| <code><a href="#must-cdk.CloudFrontToOrigins.Initializer.parameter.webAclId">web_acl_id</a></code> | <code>str</code> | Web Application Firewall (WAF) web ACL ID. |

---

##### `scope`<sup>Required</sup> <a name="scope" id="must-cdk.CloudFrontToOrigins.Initializer.parameter.scope"></a>

- *Type:* constructs.Construct

---

##### `id`<sup>Required</sup> <a name="id" id="must-cdk.CloudFrontToOrigins.Initializer.parameter.id"></a>

- *Type:* str

---

##### `additional_domain_names`<sup>Optional</sup> <a name="additional_domain_names" id="must-cdk.CloudFrontToOrigins.Initializer.parameter.additionalDomainNames"></a>

- *Type:* typing.List[str]

Additional domain names (aliases) for the distribution Note: All domains must be covered by the same certificate.

---

##### `cache_behaviors`<sup>Optional</sup> <a name="cache_behaviors" id="must-cdk.CloudFrontToOrigins.Initializer.parameter.cacheBehaviors"></a>

- *Type:* typing.List[<a href="#must-cdk.CacheBehaviorConfig">CacheBehaviorConfig</a>]

Cache behaviors for specific path patterns.

---

##### `certificate`<sup>Optional</sup> <a name="certificate" id="must-cdk.CloudFrontToOrigins.Initializer.parameter.certificate"></a>

- *Type:* aws_cdk.aws_certificatemanager.ICertificate

Existing ACM certificate to use for the CloudFront distribution Certificate must be in us-east-1 region for CloudFront.

---

##### `comment`<sup>Optional</sup> <a name="comment" id="must-cdk.CloudFrontToOrigins.Initializer.parameter.comment"></a>

- *Type:* str

Comment for the distribution.

---

##### `create_route53_records`<sup>Optional</sup> <a name="create_route53_records" id="must-cdk.CloudFrontToOrigins.Initializer.parameter.createRoute53Records"></a>

- *Type:* bool
- *Default:* true if hostedZone is provided

Create Route53 records for all domain names.

---

##### `custom_domain_name`<sup>Optional</sup> <a name="custom_domain_name" id="must-cdk.CloudFrontToOrigins.Initializer.parameter.customDomainName"></a>

- *Type:* str

Primary custom domain name for the CloudFront distribution.

---

##### `default_origin_id`<sup>Optional</sup> <a name="default_origin_id" id="must-cdk.CloudFrontToOrigins.Initializer.parameter.defaultOriginId"></a>

- *Type:* str

ID of the origin to use as default behavior If not specified, will use the first HTTP origin, then first S3 origin.

---

##### `default_root_object`<sup>Optional</sup> <a name="default_root_object" id="must-cdk.CloudFrontToOrigins.Initializer.parameter.defaultRootObject"></a>

- *Type:* str
- *Default:* "index.html"

Default root object for the distribution.

---

##### `disable_default_error_pages`<sup>Optional</sup> <a name="disable_default_error_pages" id="must-cdk.CloudFrontToOrigins.Initializer.parameter.disableDefaultErrorPages"></a>

- *Type:* bool
- *Default:* false

Disable intelligent defaults for error pages.

---

##### `disable_intelligent_defaults`<sup>Optional</sup> <a name="disable_intelligent_defaults" id="must-cdk.CloudFrontToOrigins.Initializer.parameter.disableIntelligentDefaults"></a>

- *Type:* bool
- *Default:* false

Disable intelligent defaults completely When true, only user-provided configuration will be applied.

---

##### `enabled`<sup>Optional</sup> <a name="enabled" id="must-cdk.CloudFrontToOrigins.Initializer.parameter.enabled"></a>

- *Type:* bool
- *Default:* true

Whether the distribution is enabled.

---

##### `enable_ipv6`<sup>Optional</sup> <a name="enable_ipv6" id="must-cdk.CloudFrontToOrigins.Initializer.parameter.enableIpv6"></a>

- *Type:* bool
- *Default:* false

Enable IPv6 for the distribution.

---

##### `enable_logging`<sup>Optional</sup> <a name="enable_logging" id="must-cdk.CloudFrontToOrigins.Initializer.parameter.enableLogging"></a>

- *Type:* bool
- *Default:* true

Enable CloudFront access logging.

---

##### `error_pages`<sup>Optional</sup> <a name="error_pages" id="must-cdk.CloudFrontToOrigins.Initializer.parameter.errorPages"></a>

- *Type:* typing.List[aws_cdk.aws_cloudfront.ErrorResponse]

Custom error page configurations If not provided, intelligent defaults will be applied based on origin types.

---

##### `geo_restriction`<sup>Optional</sup> <a name="geo_restriction" id="must-cdk.CloudFrontToOrigins.Initializer.parameter.geoRestriction"></a>

- *Type:* aws_cdk.aws_cloudfront.GeoRestriction

Geographic restriction configuration.

---

##### `hosted_zone`<sup>Optional</sup> <a name="hosted_zone" id="must-cdk.CloudFrontToOrigins.Initializer.parameter.hostedZone"></a>

- *Type:* aws_cdk.aws_route53.IHostedZone

Route53 hosted zone for the custom domain Required for creating Route53 records.

---

##### `http_origins`<sup>Optional</sup> <a name="http_origins" id="must-cdk.CloudFrontToOrigins.Initializer.parameter.httpOrigins"></a>

- *Type:* typing.List[<a href="#must-cdk.HttpOriginConfig">HttpOriginConfig</a>]

HTTP origins configuration.

---

##### `http_version`<sup>Optional</sup> <a name="http_version" id="must-cdk.CloudFrontToOrigins.Initializer.parameter.httpVersion"></a>

- *Type:* aws_cdk.aws_cloudfront.HttpVersion
- *Default:* HttpVersion.HTTP2

HTTP version to support.

---

##### `log_bucket`<sup>Optional</sup> <a name="log_bucket" id="must-cdk.CloudFrontToOrigins.Initializer.parameter.logBucket"></a>

- *Type:* aws_cdk.aws_s3.IBucket

Existing S3 bucket for logs If not provided and logging is enabled, a new bucket will be created.

---

##### `log_include_cookies`<sup>Optional</sup> <a name="log_include_cookies" id="must-cdk.CloudFrontToOrigins.Initializer.parameter.logIncludeCookies"></a>

- *Type:* bool
- *Default:* false

Include cookies in access logs.

---

##### `log_prefix`<sup>Optional</sup> <a name="log_prefix" id="must-cdk.CloudFrontToOrigins.Initializer.parameter.logPrefix"></a>

- *Type:* str
- *Default:* "cloudfront-logs/"

Prefix for log files.

---

##### `price_class`<sup>Optional</sup> <a name="price_class" id="must-cdk.CloudFrontToOrigins.Initializer.parameter.priceClass"></a>

- *Type:* aws_cdk.aws_cloudfront.PriceClass
- *Default:* PRICE_CLASS_100

CloudFront distribution price class.

---

##### `s3_origins`<sup>Optional</sup> <a name="s3_origins" id="must-cdk.CloudFrontToOrigins.Initializer.parameter.s3Origins"></a>

- *Type:* typing.List[<a href="#must-cdk.S3OriginConfig">S3OriginConfig</a>]

S3 origins configuration.

---

##### `web_acl_id`<sup>Optional</sup> <a name="web_acl_id" id="must-cdk.CloudFrontToOrigins.Initializer.parameter.webAclId"></a>

- *Type:* str

Web Application Firewall (WAF) web ACL ID.

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#must-cdk.CloudFrontToOrigins.toString">to_string</a></code> | Returns a string representation of this construct. |
| <code><a href="#must-cdk.CloudFrontToOrigins.getHttpOrigin">get_http_origin</a></code> | Get HTTP origin by origin ID. |
| <code><a href="#must-cdk.CloudFrontToOrigins.getS3Bucket">get_s3_bucket</a></code> | Get S3 bucket by origin ID. |

---

##### `to_string` <a name="to_string" id="must-cdk.CloudFrontToOrigins.toString"></a>

```python
def to_string() -> str
```

Returns a string representation of this construct.

##### `get_http_origin` <a name="get_http_origin" id="must-cdk.CloudFrontToOrigins.getHttpOrigin"></a>

```python
def get_http_origin(
  origin_id: str
) -> HttpOrigin
```

Get HTTP origin by origin ID.

###### `origin_id`<sup>Required</sup> <a name="origin_id" id="must-cdk.CloudFrontToOrigins.getHttpOrigin.parameter.originId"></a>

- *Type:* str

---

##### `get_s3_bucket` <a name="get_s3_bucket" id="must-cdk.CloudFrontToOrigins.getS3Bucket"></a>

```python
def get_s3_bucket(
  origin_id: str
) -> IBucket
```

Get S3 bucket by origin ID.

###### `origin_id`<sup>Required</sup> <a name="origin_id" id="must-cdk.CloudFrontToOrigins.getS3Bucket.parameter.originId"></a>

- *Type:* str

---

#### Static Functions <a name="Static Functions" id="Static Functions"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#must-cdk.CloudFrontToOrigins.isConstruct">is_construct</a></code> | Checks if `x` is a construct. |

---

##### ~~`is_construct`~~ <a name="is_construct" id="must-cdk.CloudFrontToOrigins.isConstruct"></a>

```python
import must_cdk

must_cdk.CloudFrontToOrigins.is_construct(
  x: typing.Any
)
```

Checks if `x` is a construct.

###### `x`<sup>Required</sup> <a name="x" id="must-cdk.CloudFrontToOrigins.isConstruct.parameter.x"></a>

- *Type:* typing.Any

Any object.

---

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#must-cdk.CloudFrontToOrigins.property.node">node</a></code> | <code>constructs.Node</code> | The tree node. |
| <code><a href="#must-cdk.CloudFrontToOrigins.property.aRecords">a_records</a></code> | <code>typing.List[aws_cdk.aws_route53.ARecord]</code> | *No description.* |
| <code><a href="#must-cdk.CloudFrontToOrigins.property.distribution">distribution</a></code> | <code>aws_cdk.aws_cloudfront.Distribution</code> | *No description.* |
| <code><a href="#must-cdk.CloudFrontToOrigins.property.distributionDomainName">distribution_domain_name</a></code> | <code>str</code> | Get the CloudFront distribution domain name. |
| <code><a href="#must-cdk.CloudFrontToOrigins.property.distributionUrl">distribution_url</a></code> | <code>str</code> | Get the CloudFront distribution URL with protocol. |
| <code><a href="#must-cdk.CloudFrontToOrigins.property.httpOriginIds">http_origin_ids</a></code> | <code>typing.List[str]</code> | Get all HTTP origin IDs. |
| <code><a href="#must-cdk.CloudFrontToOrigins.property.httpOrigins">http_origins</a></code> | <code>typing.List[<a href="#must-cdk.HttpOriginInfo">HttpOriginInfo</a>]</code> | Get all HTTP origins as an array of objects with ID and origin. |
| <code><a href="#must-cdk.CloudFrontToOrigins.property.s3OriginIds">s3_origin_ids</a></code> | <code>typing.List[str]</code> | Get all S3 bucket origin IDs. |
| <code><a href="#must-cdk.CloudFrontToOrigins.property.s3Origins">s3_origins</a></code> | <code>typing.List[<a href="#must-cdk.S3OriginInfo">S3OriginInfo</a>]</code> | Get all S3 buckets as an array of objects with ID and bucket. |
| <code><a href="#must-cdk.CloudFrontToOrigins.property.certificate">certificate</a></code> | <code>aws_cdk.aws_certificatemanager.ICertificate</code> | *No description.* |
| <code><a href="#must-cdk.CloudFrontToOrigins.property.customDomainUrl">custom_domain_url</a></code> | <code>str</code> | Get the custom domain URL (if configured). |
| <code><a href="#must-cdk.CloudFrontToOrigins.property.domainNames">domain_names</a></code> | <code>typing.List[str]</code> | *No description.* |
| <code><a href="#must-cdk.CloudFrontToOrigins.property.logBucket">log_bucket</a></code> | <code>aws_cdk.aws_s3.IBucket</code> | *No description.* |

---

##### `node`<sup>Required</sup> <a name="node" id="must-cdk.CloudFrontToOrigins.property.node"></a>

```python
node: Node
```

- *Type:* constructs.Node

The tree node.

---

##### `a_records`<sup>Required</sup> <a name="a_records" id="must-cdk.CloudFrontToOrigins.property.aRecords"></a>

```python
a_records: typing.List[ARecord]
```

- *Type:* typing.List[aws_cdk.aws_route53.ARecord]

---

##### `distribution`<sup>Required</sup> <a name="distribution" id="must-cdk.CloudFrontToOrigins.property.distribution"></a>

```python
distribution: Distribution
```

- *Type:* aws_cdk.aws_cloudfront.Distribution

---

##### `distribution_domain_name`<sup>Required</sup> <a name="distribution_domain_name" id="must-cdk.CloudFrontToOrigins.property.distributionDomainName"></a>

```python
distribution_domain_name: str
```

- *Type:* str

Get the CloudFront distribution domain name.

---

##### `distribution_url`<sup>Required</sup> <a name="distribution_url" id="must-cdk.CloudFrontToOrigins.property.distributionUrl"></a>

```python
distribution_url: str
```

- *Type:* str

Get the CloudFront distribution URL with protocol.

---

##### `http_origin_ids`<sup>Required</sup> <a name="http_origin_ids" id="must-cdk.CloudFrontToOrigins.property.httpOriginIds"></a>

```python
http_origin_ids: typing.List[str]
```

- *Type:* typing.List[str]

Get all HTTP origin IDs.

---

##### `http_origins`<sup>Required</sup> <a name="http_origins" id="must-cdk.CloudFrontToOrigins.property.httpOrigins"></a>

```python
http_origins: typing.List[HttpOriginInfo]
```

- *Type:* typing.List[<a href="#must-cdk.HttpOriginInfo">HttpOriginInfo</a>]

Get all HTTP origins as an array of objects with ID and origin.

---

##### `s3_origin_ids`<sup>Required</sup> <a name="s3_origin_ids" id="must-cdk.CloudFrontToOrigins.property.s3OriginIds"></a>

```python
s3_origin_ids: typing.List[str]
```

- *Type:* typing.List[str]

Get all S3 bucket origin IDs.

---

##### `s3_origins`<sup>Required</sup> <a name="s3_origins" id="must-cdk.CloudFrontToOrigins.property.s3Origins"></a>

```python
s3_origins: typing.List[S3OriginInfo]
```

- *Type:* typing.List[<a href="#must-cdk.S3OriginInfo">S3OriginInfo</a>]

Get all S3 buckets as an array of objects with ID and bucket.

---

##### `certificate`<sup>Optional</sup> <a name="certificate" id="must-cdk.CloudFrontToOrigins.property.certificate"></a>

```python
certificate: ICertificate
```

- *Type:* aws_cdk.aws_certificatemanager.ICertificate

---

##### `custom_domain_url`<sup>Optional</sup> <a name="custom_domain_url" id="must-cdk.CloudFrontToOrigins.property.customDomainUrl"></a>

```python
custom_domain_url: str
```

- *Type:* str

Get the custom domain URL (if configured).

---

##### `domain_names`<sup>Optional</sup> <a name="domain_names" id="must-cdk.CloudFrontToOrigins.property.domainNames"></a>

```python
domain_names: typing.List[str]
```

- *Type:* typing.List[str]

---

##### `log_bucket`<sup>Optional</sup> <a name="log_bucket" id="must-cdk.CloudFrontToOrigins.property.logBucket"></a>

```python
log_bucket: IBucket
```

- *Type:* aws_cdk.aws_s3.IBucket

---


### EcsCodeDeploy <a name="EcsCodeDeploy" id="must-cdk.EcsCodeDeploy"></a>

#### Initializers <a name="Initializers" id="must-cdk.EcsCodeDeploy.Initializer"></a>

```python
import must_cdk

must_cdk.EcsCodeDeploy(
  scope: Construct,
  id: str,
  certificates: typing.List[ICertificate],
  cluster: ICluster,
  containers: typing.List[ContainerProps],
  security_groups: typing.List[ISecurityGroup],
  service_name: str,
  subnets: SubnetSelection,
  vpc: IVpc,
  alb_target_port: typing.Union[int, float] = None,
  auto_scaling: AutoScalingProps = None,
  enable_public_load_balancer: bool = None,
  memory_limit: typing.Union[int, float] = None,
  task_cp_u: typing.Union[int, float] = None,
  task_exec_role: IRole = None,
  task_role: IRole = None
)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#must-cdk.EcsCodeDeploy.Initializer.parameter.scope">scope</a></code> | <code>constructs.Construct</code> | *No description.* |
| <code><a href="#must-cdk.EcsCodeDeploy.Initializer.parameter.id">id</a></code> | <code>str</code> | *No description.* |
| <code><a href="#must-cdk.EcsCodeDeploy.Initializer.parameter.certificates">certificates</a></code> | <code>typing.List[aws_cdk.aws_certificatemanager.ICertificate]</code> | Optional ACM certificates for HTTPS termination. |
| <code><a href="#must-cdk.EcsCodeDeploy.Initializer.parameter.cluster">cluster</a></code> | <code>aws_cdk.aws_ecs.ICluster</code> | ECS Cluster where the service will run. |
| <code><a href="#must-cdk.EcsCodeDeploy.Initializer.parameter.containers">containers</a></code> | <code>typing.List[<a href="#must-cdk.ContainerProps">ContainerProps</a>]</code> | Configuration related to the task definition and container. |
| <code><a href="#must-cdk.EcsCodeDeploy.Initializer.parameter.securityGroups">security_groups</a></code> | <code>typing.List[aws_cdk.aws_ec2.ISecurityGroup]</code> | Security group config. |
| <code><a href="#must-cdk.EcsCodeDeploy.Initializer.parameter.serviceName">service_name</a></code> | <code>str</code> | Base name used for resources like log groups, roles, services, etc. |
| <code><a href="#must-cdk.EcsCodeDeploy.Initializer.parameter.subnets">subnets</a></code> | <code>aws_cdk.aws_ec2.SubnetSelection</code> | Select which subnets the Service and ALB will placed on. |
| <code><a href="#must-cdk.EcsCodeDeploy.Initializer.parameter.vpc">vpc</a></code> | <code>aws_cdk.aws_ec2.IVpc</code> | VPC in which to deploy ECS and ALB resources. |
| <code><a href="#must-cdk.EcsCodeDeploy.Initializer.parameter.albTargetPort">alb_target_port</a></code> | <code>typing.Union[int, float]</code> | The ALB target port. |
| <code><a href="#must-cdk.EcsCodeDeploy.Initializer.parameter.autoScaling">auto_scaling</a></code> | <code><a href="#must-cdk.AutoScalingProps">AutoScalingProps</a></code> | Optional auto-scaling configuration. |
| <code><a href="#must-cdk.EcsCodeDeploy.Initializer.parameter.enablePublicLoadBalancer">enable_public_load_balancer</a></code> | <code>bool</code> | Whether the load balancer should be internet-facing (default: false). |
| <code><a href="#must-cdk.EcsCodeDeploy.Initializer.parameter.memoryLimit">memory_limit</a></code> | <code>typing.Union[int, float]</code> | *No description.* |
| <code><a href="#must-cdk.EcsCodeDeploy.Initializer.parameter.taskCPU">task_cp_u</a></code> | <code>typing.Union[int, float]</code> | CPU units for the task (default: 1024). |
| <code><a href="#must-cdk.EcsCodeDeploy.Initializer.parameter.taskExecRole">task_exec_role</a></code> | <code>aws_cdk.aws_iam.IRole</code> | Task execution role for the ECS task. |
| <code><a href="#must-cdk.EcsCodeDeploy.Initializer.parameter.taskRole">task_role</a></code> | <code>aws_cdk.aws_iam.IRole</code> | Task role for the ECS task. |

---

##### `scope`<sup>Required</sup> <a name="scope" id="must-cdk.EcsCodeDeploy.Initializer.parameter.scope"></a>

- *Type:* constructs.Construct

---

##### `id`<sup>Required</sup> <a name="id" id="must-cdk.EcsCodeDeploy.Initializer.parameter.id"></a>

- *Type:* str

---

##### `certificates`<sup>Required</sup> <a name="certificates" id="must-cdk.EcsCodeDeploy.Initializer.parameter.certificates"></a>

- *Type:* typing.List[aws_cdk.aws_certificatemanager.ICertificate]

Optional ACM certificates for HTTPS termination.

---

##### `cluster`<sup>Required</sup> <a name="cluster" id="must-cdk.EcsCodeDeploy.Initializer.parameter.cluster"></a>

- *Type:* aws_cdk.aws_ecs.ICluster

ECS Cluster where the service will run.

---

##### `containers`<sup>Required</sup> <a name="containers" id="must-cdk.EcsCodeDeploy.Initializer.parameter.containers"></a>

- *Type:* typing.List[<a href="#must-cdk.ContainerProps">ContainerProps</a>]

Configuration related to the task definition and container.

---

##### `security_groups`<sup>Required</sup> <a name="security_groups" id="must-cdk.EcsCodeDeploy.Initializer.parameter.securityGroups"></a>

- *Type:* typing.List[aws_cdk.aws_ec2.ISecurityGroup]

Security group config.

---

##### `service_name`<sup>Required</sup> <a name="service_name" id="must-cdk.EcsCodeDeploy.Initializer.parameter.serviceName"></a>

- *Type:* str

Base name used for resources like log groups, roles, services, etc.

---

##### `subnets`<sup>Required</sup> <a name="subnets" id="must-cdk.EcsCodeDeploy.Initializer.parameter.subnets"></a>

- *Type:* aws_cdk.aws_ec2.SubnetSelection

Select which subnets the Service and ALB will placed on.

---

##### `vpc`<sup>Required</sup> <a name="vpc" id="must-cdk.EcsCodeDeploy.Initializer.parameter.vpc"></a>

- *Type:* aws_cdk.aws_ec2.IVpc

VPC in which to deploy ECS and ALB resources.

---

##### `alb_target_port`<sup>Optional</sup> <a name="alb_target_port" id="must-cdk.EcsCodeDeploy.Initializer.parameter.albTargetPort"></a>

- *Type:* typing.Union[int, float]

The ALB target port.

---

##### `auto_scaling`<sup>Optional</sup> <a name="auto_scaling" id="must-cdk.EcsCodeDeploy.Initializer.parameter.autoScaling"></a>

- *Type:* <a href="#must-cdk.AutoScalingProps">AutoScalingProps</a>

Optional auto-scaling configuration.

---

##### `enable_public_load_balancer`<sup>Optional</sup> <a name="enable_public_load_balancer" id="must-cdk.EcsCodeDeploy.Initializer.parameter.enablePublicLoadBalancer"></a>

- *Type:* bool

Whether the load balancer should be internet-facing (default: false).

---

##### `memory_limit`<sup>Optional</sup> <a name="memory_limit" id="must-cdk.EcsCodeDeploy.Initializer.parameter.memoryLimit"></a>

- *Type:* typing.Union[int, float]

---

##### `task_cp_u`<sup>Optional</sup> <a name="task_cp_u" id="must-cdk.EcsCodeDeploy.Initializer.parameter.taskCPU"></a>

- *Type:* typing.Union[int, float]

CPU units for the task (default: 1024).

---

##### `task_exec_role`<sup>Optional</sup> <a name="task_exec_role" id="must-cdk.EcsCodeDeploy.Initializer.parameter.taskExecRole"></a>

- *Type:* aws_cdk.aws_iam.IRole

Task execution role for the ECS task.

---

##### `task_role`<sup>Optional</sup> <a name="task_role" id="must-cdk.EcsCodeDeploy.Initializer.parameter.taskRole"></a>

- *Type:* aws_cdk.aws_iam.IRole

Task role for the ECS task.

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#must-cdk.EcsCodeDeploy.toString">to_string</a></code> | Returns a string representation of this construct. |
| <code><a href="#must-cdk.EcsCodeDeploy.allListeners">all_listeners</a></code> | *No description.* |
| <code><a href="#must-cdk.EcsCodeDeploy.blueListener">blue_listener</a></code> | *No description.* |
| <code><a href="#must-cdk.EcsCodeDeploy.greenListener">green_listener</a></code> | *No description.* |
| <code><a href="#must-cdk.EcsCodeDeploy.loadBalancerDnsName">load_balancer_dns_name</a></code> | *No description.* |
| <code><a href="#must-cdk.EcsCodeDeploy.serviceArn">service_arn</a></code> | *No description.* |

---

##### `to_string` <a name="to_string" id="must-cdk.EcsCodeDeploy.toString"></a>

```python
def to_string() -> str
```

Returns a string representation of this construct.

##### `all_listeners` <a name="all_listeners" id="must-cdk.EcsCodeDeploy.allListeners"></a>

```python
def all_listeners() -> typing.List[ApplicationListener]
```

##### `blue_listener` <a name="blue_listener" id="must-cdk.EcsCodeDeploy.blueListener"></a>

```python
def blue_listener() -> ApplicationListener
```

##### `green_listener` <a name="green_listener" id="must-cdk.EcsCodeDeploy.greenListener"></a>

```python
def green_listener() -> ApplicationListener
```

##### `load_balancer_dns_name` <a name="load_balancer_dns_name" id="must-cdk.EcsCodeDeploy.loadBalancerDnsName"></a>

```python
def load_balancer_dns_name() -> str
```

##### `service_arn` <a name="service_arn" id="must-cdk.EcsCodeDeploy.serviceArn"></a>

```python
def service_arn() -> str
```

#### Static Functions <a name="Static Functions" id="Static Functions"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#must-cdk.EcsCodeDeploy.isConstruct">is_construct</a></code> | Checks if `x` is a construct. |

---

##### ~~`is_construct`~~ <a name="is_construct" id="must-cdk.EcsCodeDeploy.isConstruct"></a>

```python
import must_cdk

must_cdk.EcsCodeDeploy.is_construct(
  x: typing.Any
)
```

Checks if `x` is a construct.

###### `x`<sup>Required</sup> <a name="x" id="must-cdk.EcsCodeDeploy.isConstruct.parameter.x"></a>

- *Type:* typing.Any

Any object.

---

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#must-cdk.EcsCodeDeploy.property.node">node</a></code> | <code>constructs.Node</code> | The tree node. |
| <code><a href="#must-cdk.EcsCodeDeploy.property.blueTargetGroup">blue_target_group</a></code> | <code>aws_cdk.aws_elasticloadbalancingv2.ApplicationTargetGroup</code> | *No description.* |
| <code><a href="#must-cdk.EcsCodeDeploy.property.codeDeployApp">code_deploy_app</a></code> | <code>aws_cdk.aws_codedeploy.EcsApplication</code> | *No description.* |
| <code><a href="#must-cdk.EcsCodeDeploy.property.greenTargetGroup">green_target_group</a></code> | <code>aws_cdk.aws_elasticloadbalancingv2.ApplicationTargetGroup</code> | *No description.* |
| <code><a href="#must-cdk.EcsCodeDeploy.property.loadBalancer">load_balancer</a></code> | <code>aws_cdk.aws_elasticloadbalancingv2.ApplicationLoadBalancer</code> | *No description.* |
| <code><a href="#must-cdk.EcsCodeDeploy.property.service">service</a></code> | <code>aws_cdk.aws_ecs.FargateService</code> | *No description.* |
| <code><a href="#must-cdk.EcsCodeDeploy.property.taskDef">task_def</a></code> | <code>aws_cdk.aws_ecs.TaskDefinition</code> | *No description.* |
| <code><a href="#must-cdk.EcsCodeDeploy.property.taskExecutionRole">task_execution_role</a></code> | <code>aws_cdk.aws_iam.IRole</code> | *No description.* |
| <code><a href="#must-cdk.EcsCodeDeploy.property.taskRole">task_role</a></code> | <code>aws_cdk.aws_iam.IRole</code> | *No description.* |

---

##### `node`<sup>Required</sup> <a name="node" id="must-cdk.EcsCodeDeploy.property.node"></a>

```python
node: Node
```

- *Type:* constructs.Node

The tree node.

---

##### `blue_target_group`<sup>Required</sup> <a name="blue_target_group" id="must-cdk.EcsCodeDeploy.property.blueTargetGroup"></a>

```python
blue_target_group: ApplicationTargetGroup
```

- *Type:* aws_cdk.aws_elasticloadbalancingv2.ApplicationTargetGroup

---

##### `code_deploy_app`<sup>Required</sup> <a name="code_deploy_app" id="must-cdk.EcsCodeDeploy.property.codeDeployApp"></a>

```python
code_deploy_app: EcsApplication
```

- *Type:* aws_cdk.aws_codedeploy.EcsApplication

---

##### `green_target_group`<sup>Required</sup> <a name="green_target_group" id="must-cdk.EcsCodeDeploy.property.greenTargetGroup"></a>

```python
green_target_group: ApplicationTargetGroup
```

- *Type:* aws_cdk.aws_elasticloadbalancingv2.ApplicationTargetGroup

---

##### `load_balancer`<sup>Required</sup> <a name="load_balancer" id="must-cdk.EcsCodeDeploy.property.loadBalancer"></a>

```python
load_balancer: ApplicationLoadBalancer
```

- *Type:* aws_cdk.aws_elasticloadbalancingv2.ApplicationLoadBalancer

---

##### `service`<sup>Required</sup> <a name="service" id="must-cdk.EcsCodeDeploy.property.service"></a>

```python
service: FargateService
```

- *Type:* aws_cdk.aws_ecs.FargateService

---

##### `task_def`<sup>Required</sup> <a name="task_def" id="must-cdk.EcsCodeDeploy.property.taskDef"></a>

```python
task_def: TaskDefinition
```

- *Type:* aws_cdk.aws_ecs.TaskDefinition

---

##### `task_execution_role`<sup>Required</sup> <a name="task_execution_role" id="must-cdk.EcsCodeDeploy.property.taskExecutionRole"></a>

```python
task_execution_role: IRole
```

- *Type:* aws_cdk.aws_iam.IRole

---

##### `task_role`<sup>Required</sup> <a name="task_role" id="must-cdk.EcsCodeDeploy.property.taskRole"></a>

```python
task_role: IRole
```

- *Type:* aws_cdk.aws_iam.IRole

---


### WebSocketApiGatewayToLambda <a name="WebSocketApiGatewayToLambda" id="must-cdk.WebSocketApiGatewayToLambda"></a>

#### Initializers <a name="Initializers" id="must-cdk.WebSocketApiGatewayToLambda.Initializer"></a>

```python
import must_cdk

must_cdk.WebSocketApiGatewayToLambda(
  scope: Construct,
  id: str,
  api_name: str,
  lambda_function: IFunction,
  api_props: WebSocketApiProps = None,
  custom_domain_name: str = None,
  custom_routes: typing.List[WebSocketRoute] = None,
  enable_logging: bool = None,
  existing_certificate: ICertificate = None,
  hosted_zone: IHostedZone = None,
  log_group_props: LogGroupProps = None,
  stage_name: str = None
)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#must-cdk.WebSocketApiGatewayToLambda.Initializer.parameter.scope">scope</a></code> | <code>constructs.Construct</code> | *No description.* |
| <code><a href="#must-cdk.WebSocketApiGatewayToLambda.Initializer.parameter.id">id</a></code> | <code>str</code> | *No description.* |
| <code><a href="#must-cdk.WebSocketApiGatewayToLambda.Initializer.parameter.apiName">api_name</a></code> | <code>str</code> | WebSocket API configuration. |
| <code><a href="#must-cdk.WebSocketApiGatewayToLambda.Initializer.parameter.lambdaFunction">lambda_function</a></code> | <code>aws_cdk.aws_lambda.IFunction</code> | Primary Lambda function for the API (usually handles $default route). |
| <code><a href="#must-cdk.WebSocketApiGatewayToLambda.Initializer.parameter.apiProps">api_props</a></code> | <code>aws_cdk.aws_apigatewayv2.WebSocketApiProps</code> | *No description.* |
| <code><a href="#must-cdk.WebSocketApiGatewayToLambda.Initializer.parameter.customDomainName">custom_domain_name</a></code> | <code>str</code> | Optional custom domain name for API Gateway. |
| <code><a href="#must-cdk.WebSocketApiGatewayToLambda.Initializer.parameter.customRoutes">custom_routes</a></code> | <code>typing.List[<a href="#must-cdk.WebSocketRoute">WebSocketRoute</a>]</code> | Custom routes for WebSocket API Common routes: $connect, $disconnect, $default, or custom route keys. |
| <code><a href="#must-cdk.WebSocketApiGatewayToLambda.Initializer.parameter.enableLogging">enable_logging</a></code> | <code>bool</code> | Enable CloudWatch logging for API Gateway. |
| <code><a href="#must-cdk.WebSocketApiGatewayToLambda.Initializer.parameter.existingCertificate">existing_certificate</a></code> | <code>aws_cdk.aws_certificatemanager.ICertificate</code> | Optional ACM certificate to use instead of creating a new one. |
| <code><a href="#must-cdk.WebSocketApiGatewayToLambda.Initializer.parameter.hostedZone">hosted_zone</a></code> | <code>aws_cdk.aws_route53.IHostedZone</code> | Optional Route53 hosted zone for custom domain. |
| <code><a href="#must-cdk.WebSocketApiGatewayToLambda.Initializer.parameter.logGroupProps">log_group_props</a></code> | <code>aws_cdk.aws_logs.LogGroupProps</code> | CloudWatch Logs configuration. |
| <code><a href="#must-cdk.WebSocketApiGatewayToLambda.Initializer.parameter.stageName">stage_name</a></code> | <code>str</code> | Stage name for the WebSocket API. |

---

##### `scope`<sup>Required</sup> <a name="scope" id="must-cdk.WebSocketApiGatewayToLambda.Initializer.parameter.scope"></a>

- *Type:* constructs.Construct

---

##### `id`<sup>Required</sup> <a name="id" id="must-cdk.WebSocketApiGatewayToLambda.Initializer.parameter.id"></a>

- *Type:* str

---

##### `api_name`<sup>Required</sup> <a name="api_name" id="must-cdk.WebSocketApiGatewayToLambda.Initializer.parameter.apiName"></a>

- *Type:* str

WebSocket API configuration.

---

##### `lambda_function`<sup>Required</sup> <a name="lambda_function" id="must-cdk.WebSocketApiGatewayToLambda.Initializer.parameter.lambdaFunction"></a>

- *Type:* aws_cdk.aws_lambda.IFunction

Primary Lambda function for the API (usually handles $default route).

---

##### `api_props`<sup>Optional</sup> <a name="api_props" id="must-cdk.WebSocketApiGatewayToLambda.Initializer.parameter.apiProps"></a>

- *Type:* aws_cdk.aws_apigatewayv2.WebSocketApiProps

---

##### `custom_domain_name`<sup>Optional</sup> <a name="custom_domain_name" id="must-cdk.WebSocketApiGatewayToLambda.Initializer.parameter.customDomainName"></a>

- *Type:* str

Optional custom domain name for API Gateway.

---

##### `custom_routes`<sup>Optional</sup> <a name="custom_routes" id="must-cdk.WebSocketApiGatewayToLambda.Initializer.parameter.customRoutes"></a>

- *Type:* typing.List[<a href="#must-cdk.WebSocketRoute">WebSocketRoute</a>]

Custom routes for WebSocket API Common routes: $connect, $disconnect, $default, or custom route keys.

---

##### `enable_logging`<sup>Optional</sup> <a name="enable_logging" id="must-cdk.WebSocketApiGatewayToLambda.Initializer.parameter.enableLogging"></a>

- *Type:* bool

Enable CloudWatch logging for API Gateway.

---

##### `existing_certificate`<sup>Optional</sup> <a name="existing_certificate" id="must-cdk.WebSocketApiGatewayToLambda.Initializer.parameter.existingCertificate"></a>

- *Type:* aws_cdk.aws_certificatemanager.ICertificate

Optional ACM certificate to use instead of creating a new one.

---

##### `hosted_zone`<sup>Optional</sup> <a name="hosted_zone" id="must-cdk.WebSocketApiGatewayToLambda.Initializer.parameter.hostedZone"></a>

- *Type:* aws_cdk.aws_route53.IHostedZone

Optional Route53 hosted zone for custom domain.

---

##### `log_group_props`<sup>Optional</sup> <a name="log_group_props" id="must-cdk.WebSocketApiGatewayToLambda.Initializer.parameter.logGroupProps"></a>

- *Type:* aws_cdk.aws_logs.LogGroupProps

CloudWatch Logs configuration.

---

##### `stage_name`<sup>Optional</sup> <a name="stage_name" id="must-cdk.WebSocketApiGatewayToLambda.Initializer.parameter.stageName"></a>

- *Type:* str
- *Default:* 'dev'

Stage name for the WebSocket API.

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#must-cdk.WebSocketApiGatewayToLambda.toString">to_string</a></code> | Returns a string representation of this construct. |
| <code><a href="#must-cdk.WebSocketApiGatewayToLambda.addRoute">add_route</a></code> | Add a custom route after construction (for dynamic route addition). |

---

##### `to_string` <a name="to_string" id="must-cdk.WebSocketApiGatewayToLambda.toString"></a>

```python
def to_string() -> str
```

Returns a string representation of this construct.

##### `add_route` <a name="add_route" id="must-cdk.WebSocketApiGatewayToLambda.addRoute"></a>

```python
def add_route(
  handler: IFunction,
  route_key: str,
  route_response_selection_expression: str = None
) -> WebSocketRoute
```

Add a custom route after construction (for dynamic route addition).

###### `handler`<sup>Required</sup> <a name="handler" id="must-cdk.WebSocketApiGatewayToLambda.addRoute.parameter.handler"></a>

- *Type:* aws_cdk.aws_lambda.IFunction

---

###### `route_key`<sup>Required</sup> <a name="route_key" id="must-cdk.WebSocketApiGatewayToLambda.addRoute.parameter.routeKey"></a>

- *Type:* str

---

###### `route_response_selection_expression`<sup>Optional</sup> <a name="route_response_selection_expression" id="must-cdk.WebSocketApiGatewayToLambda.addRoute.parameter.routeResponseSelectionExpression"></a>

- *Type:* str

---

#### Static Functions <a name="Static Functions" id="Static Functions"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#must-cdk.WebSocketApiGatewayToLambda.isConstruct">is_construct</a></code> | Checks if `x` is a construct. |

---

##### ~~`is_construct`~~ <a name="is_construct" id="must-cdk.WebSocketApiGatewayToLambda.isConstruct"></a>

```python
import must_cdk

must_cdk.WebSocketApiGatewayToLambda.is_construct(
  x: typing.Any
)
```

Checks if `x` is a construct.

###### `x`<sup>Required</sup> <a name="x" id="must-cdk.WebSocketApiGatewayToLambda.isConstruct.parameter.x"></a>

- *Type:* typing.Any

Any object.

---

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#must-cdk.WebSocketApiGatewayToLambda.property.node">node</a></code> | <code>constructs.Node</code> | The tree node. |
| <code><a href="#must-cdk.WebSocketApiGatewayToLambda.property.lambdaFunction">lambda_function</a></code> | <code>aws_cdk.aws_lambda.IFunction</code> | *No description.* |
| <code><a href="#must-cdk.WebSocketApiGatewayToLambda.property.webSocketApi">web_socket_api</a></code> | <code>aws_cdk.aws_apigatewayv2.WebSocketApi</code> | *No description.* |
| <code><a href="#must-cdk.WebSocketApiGatewayToLambda.property.webSocketStage">web_socket_stage</a></code> | <code>aws_cdk.aws_apigatewayv2.WebSocketStage</code> | *No description.* |
| <code><a href="#must-cdk.WebSocketApiGatewayToLambda.property.webSocketUrl">web_socket_url</a></code> | <code>str</code> | Get the WebSocket API URL (useful for outputs). |
| <code><a href="#must-cdk.WebSocketApiGatewayToLambda.property.apiGatewayLogGroup">api_gateway_log_group</a></code> | <code>aws_cdk.aws_logs.LogGroup</code> | *No description.* |
| <code><a href="#must-cdk.WebSocketApiGatewayToLambda.property.aRecord">a_record</a></code> | <code>aws_cdk.aws_route53.ARecord</code> | *No description.* |
| <code><a href="#must-cdk.WebSocketApiGatewayToLambda.property.certificate">certificate</a></code> | <code>aws_cdk.aws_certificatemanager.ICertificate</code> | *No description.* |
| <code><a href="#must-cdk.WebSocketApiGatewayToLambda.property.domain">domain</a></code> | <code>aws_cdk.aws_apigatewayv2.DomainName</code> | *No description.* |

---

##### `node`<sup>Required</sup> <a name="node" id="must-cdk.WebSocketApiGatewayToLambda.property.node"></a>

```python
node: Node
```

- *Type:* constructs.Node

The tree node.

---

##### `lambda_function`<sup>Required</sup> <a name="lambda_function" id="must-cdk.WebSocketApiGatewayToLambda.property.lambdaFunction"></a>

```python
lambda_function: IFunction
```

- *Type:* aws_cdk.aws_lambda.IFunction

---

##### `web_socket_api`<sup>Required</sup> <a name="web_socket_api" id="must-cdk.WebSocketApiGatewayToLambda.property.webSocketApi"></a>

```python
web_socket_api: WebSocketApi
```

- *Type:* aws_cdk.aws_apigatewayv2.WebSocketApi

---

##### `web_socket_stage`<sup>Required</sup> <a name="web_socket_stage" id="must-cdk.WebSocketApiGatewayToLambda.property.webSocketStage"></a>

```python
web_socket_stage: WebSocketStage
```

- *Type:* aws_cdk.aws_apigatewayv2.WebSocketStage

---

##### `web_socket_url`<sup>Required</sup> <a name="web_socket_url" id="must-cdk.WebSocketApiGatewayToLambda.property.webSocketUrl"></a>

```python
web_socket_url: str
```

- *Type:* str

Get the WebSocket API URL (useful for outputs).

---

##### `api_gateway_log_group`<sup>Optional</sup> <a name="api_gateway_log_group" id="must-cdk.WebSocketApiGatewayToLambda.property.apiGatewayLogGroup"></a>

```python
api_gateway_log_group: LogGroup
```

- *Type:* aws_cdk.aws_logs.LogGroup

---

##### `a_record`<sup>Optional</sup> <a name="a_record" id="must-cdk.WebSocketApiGatewayToLambda.property.aRecord"></a>

```python
a_record: ARecord
```

- *Type:* aws_cdk.aws_route53.ARecord

---

##### `certificate`<sup>Optional</sup> <a name="certificate" id="must-cdk.WebSocketApiGatewayToLambda.property.certificate"></a>

```python
certificate: ICertificate
```

- *Type:* aws_cdk.aws_certificatemanager.ICertificate

---

##### `domain`<sup>Optional</sup> <a name="domain" id="must-cdk.WebSocketApiGatewayToLambda.property.domain"></a>

```python
domain: DomainName
```

- *Type:* aws_cdk.aws_apigatewayv2.DomainName

---


## Structs <a name="Structs" id="Structs"></a>

### ApiGatewayToLambdaProps <a name="ApiGatewayToLambdaProps" id="must-cdk.ApiGatewayToLambdaProps"></a>

#### Initializer <a name="Initializer" id="must-cdk.ApiGatewayToLambdaProps.Initializer"></a>

```python
import must_cdk

must_cdk.ApiGatewayToLambdaProps(
  api_name: str,
  lambda_function: IFunction,
  create_usage_plan: bool = None,
  custom_domain_name: str = None,
  custom_routes: typing.List[CustomRoute] = None,
  enable_logging: bool = None,
  existing_certificate: ICertificate = None,
  hosted_zone: IHostedZone = None,
  lambda_api_props: LambdaRestApiProps = None,
  log_group_props: LogGroupProps = None,
  proxy: bool = None,
  rest_api_props: RestApiProps = None
)
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#must-cdk.ApiGatewayToLambdaProps.property.apiName">api_name</a></code> | <code>str</code> | API configuration. |
| <code><a href="#must-cdk.ApiGatewayToLambdaProps.property.lambdaFunction">lambda_function</a></code> | <code>aws_cdk.aws_lambda.IFunction</code> | Primary Lambda function for the API. |
| <code><a href="#must-cdk.ApiGatewayToLambdaProps.property.createUsagePlan">create_usage_plan</a></code> | <code>bool</code> | Whether to create a Usage Plan. |
| <code><a href="#must-cdk.ApiGatewayToLambdaProps.property.customDomainName">custom_domain_name</a></code> | <code>str</code> | Optional custom domain name for API Gateway. |
| <code><a href="#must-cdk.ApiGatewayToLambdaProps.property.customRoutes">custom_routes</a></code> | <code>typing.List[<a href="#must-cdk.CustomRoute">CustomRoute</a>]</code> | Custom routes for manual API setup (when proxy is false) If provided, will use RestApi instead of LambdaRestApi. |
| <code><a href="#must-cdk.ApiGatewayToLambdaProps.property.enableLogging">enable_logging</a></code> | <code>bool</code> | Enable CloudWatch logging for API Gateway. |
| <code><a href="#must-cdk.ApiGatewayToLambdaProps.property.existingCertificate">existing_certificate</a></code> | <code>aws_cdk.aws_certificatemanager.ICertificate</code> | Optional ACM certificate to use instead of creating a new one. |
| <code><a href="#must-cdk.ApiGatewayToLambdaProps.property.hostedZone">hosted_zone</a></code> | <code>aws_cdk.aws_route53.IHostedZone</code> | Optional Route53 hosted zone for custom domain. |
| <code><a href="#must-cdk.ApiGatewayToLambdaProps.property.lambdaApiProps">lambda_api_props</a></code> | <code>aws_cdk.aws_apigateway.LambdaRestApiProps</code> | *No description.* |
| <code><a href="#must-cdk.ApiGatewayToLambdaProps.property.logGroupProps">log_group_props</a></code> | <code>aws_cdk.aws_logs.LogGroupProps</code> | CloudWatch Logs configuration. |
| <code><a href="#must-cdk.ApiGatewayToLambdaProps.property.proxy">proxy</a></code> | <code>bool</code> | *No description.* |
| <code><a href="#must-cdk.ApiGatewayToLambdaProps.property.restApiProps">rest_api_props</a></code> | <code>aws_cdk.aws_apigateway.RestApiProps</code> | *No description.* |

---

##### `api_name`<sup>Required</sup> <a name="api_name" id="must-cdk.ApiGatewayToLambdaProps.property.apiName"></a>

```python
api_name: str
```

- *Type:* str

API configuration.

---

##### `lambda_function`<sup>Required</sup> <a name="lambda_function" id="must-cdk.ApiGatewayToLambdaProps.property.lambdaFunction"></a>

```python
lambda_function: IFunction
```

- *Type:* aws_cdk.aws_lambda.IFunction

Primary Lambda function for the API.

---

##### `create_usage_plan`<sup>Optional</sup> <a name="create_usage_plan" id="must-cdk.ApiGatewayToLambdaProps.property.createUsagePlan"></a>

```python
create_usage_plan: bool
```

- *Type:* bool

Whether to create a Usage Plan.

---

##### `custom_domain_name`<sup>Optional</sup> <a name="custom_domain_name" id="must-cdk.ApiGatewayToLambdaProps.property.customDomainName"></a>

```python
custom_domain_name: str
```

- *Type:* str

Optional custom domain name for API Gateway.

---

##### `custom_routes`<sup>Optional</sup> <a name="custom_routes" id="must-cdk.ApiGatewayToLambdaProps.property.customRoutes"></a>

```python
custom_routes: typing.List[CustomRoute]
```

- *Type:* typing.List[<a href="#must-cdk.CustomRoute">CustomRoute</a>]

Custom routes for manual API setup (when proxy is false) If provided, will use RestApi instead of LambdaRestApi.

---

##### `enable_logging`<sup>Optional</sup> <a name="enable_logging" id="must-cdk.ApiGatewayToLambdaProps.property.enableLogging"></a>

```python
enable_logging: bool
```

- *Type:* bool

Enable CloudWatch logging for API Gateway.

---

##### `existing_certificate`<sup>Optional</sup> <a name="existing_certificate" id="must-cdk.ApiGatewayToLambdaProps.property.existingCertificate"></a>

```python
existing_certificate: ICertificate
```

- *Type:* aws_cdk.aws_certificatemanager.ICertificate

Optional ACM certificate to use instead of creating a new one.

---

##### `hosted_zone`<sup>Optional</sup> <a name="hosted_zone" id="must-cdk.ApiGatewayToLambdaProps.property.hostedZone"></a>

```python
hosted_zone: IHostedZone
```

- *Type:* aws_cdk.aws_route53.IHostedZone

Optional Route53 hosted zone for custom domain.

---

##### `lambda_api_props`<sup>Optional</sup> <a name="lambda_api_props" id="must-cdk.ApiGatewayToLambdaProps.property.lambdaApiProps"></a>

```python
lambda_api_props: LambdaRestApiProps
```

- *Type:* aws_cdk.aws_apigateway.LambdaRestApiProps

---

##### `log_group_props`<sup>Optional</sup> <a name="log_group_props" id="must-cdk.ApiGatewayToLambdaProps.property.logGroupProps"></a>

```python
log_group_props: LogGroupProps
```

- *Type:* aws_cdk.aws_logs.LogGroupProps

CloudWatch Logs configuration.

---

##### `proxy`<sup>Optional</sup> <a name="proxy" id="must-cdk.ApiGatewayToLambdaProps.property.proxy"></a>

```python
proxy: bool
```

- *Type:* bool

---

##### `rest_api_props`<sup>Optional</sup> <a name="rest_api_props" id="must-cdk.ApiGatewayToLambdaProps.property.restApiProps"></a>

```python
rest_api_props: RestApiProps
```

- *Type:* aws_cdk.aws_apigateway.RestApiProps

---

### AutoScalingProps <a name="AutoScalingProps" id="must-cdk.AutoScalingProps"></a>

Configuration for ECS service auto-scaling.

#### Initializer <a name="Initializer" id="must-cdk.AutoScalingProps.Initializer"></a>

```python
import must_cdk

must_cdk.AutoScalingProps(
  max_capacity: typing.Union[int, float],
  min_capacity: typing.Union[int, float],
  cpu_scale: CpuUtilizationScalingProps = None,
  memory_scale: MemoryUtilizationScalingProps = None
)
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#must-cdk.AutoScalingProps.property.maxCapacity">max_capacity</a></code> | <code>typing.Union[int, float]</code> | Maximum number of tasks to run. |
| <code><a href="#must-cdk.AutoScalingProps.property.minCapacity">min_capacity</a></code> | <code>typing.Union[int, float]</code> | Minimum number of tasks to run. |
| <code><a href="#must-cdk.AutoScalingProps.property.cpuScale">cpu_scale</a></code> | <code>aws_cdk.aws_ecs.CpuUtilizationScalingProps</code> | Scale task based on CPU utilization. |
| <code><a href="#must-cdk.AutoScalingProps.property.memoryScale">memory_scale</a></code> | <code>aws_cdk.aws_ecs.MemoryUtilizationScalingProps</code> | Scale task based on memory utilization. |

---

##### `max_capacity`<sup>Required</sup> <a name="max_capacity" id="must-cdk.AutoScalingProps.property.maxCapacity"></a>

```python
max_capacity: typing.Union[int, float]
```

- *Type:* typing.Union[int, float]

Maximum number of tasks to run.

---

##### `min_capacity`<sup>Required</sup> <a name="min_capacity" id="must-cdk.AutoScalingProps.property.minCapacity"></a>

```python
min_capacity: typing.Union[int, float]
```

- *Type:* typing.Union[int, float]

Minimum number of tasks to run.

---

##### `cpu_scale`<sup>Optional</sup> <a name="cpu_scale" id="must-cdk.AutoScalingProps.property.cpuScale"></a>

```python
cpu_scale: CpuUtilizationScalingProps
```

- *Type:* aws_cdk.aws_ecs.CpuUtilizationScalingProps

Scale task based on CPU utilization.

---

##### `memory_scale`<sup>Optional</sup> <a name="memory_scale" id="must-cdk.AutoScalingProps.property.memoryScale"></a>

```python
memory_scale: MemoryUtilizationScalingProps
```

- *Type:* aws_cdk.aws_ecs.MemoryUtilizationScalingProps

Scale task based on memory utilization.

---

### CacheBehaviorConfig <a name="CacheBehaviorConfig" id="must-cdk.CacheBehaviorConfig"></a>

#### Initializer <a name="Initializer" id="must-cdk.CacheBehaviorConfig.Initializer"></a>

```python
import must_cdk

must_cdk.CacheBehaviorConfig(
  origin_id: str,
  path_pattern: str,
  allowed_methods: AllowedMethods = None,
  cached_methods: CachedMethods = None,
  cache_policy: ICachePolicy = None,
  cache_policy_id: str = None,
  compress: bool = None,
  origin_request_policy: IOriginRequestPolicy = None,
  origin_request_policy_id: str = None,
  response_headers_policy: IResponseHeadersPolicy = None,
  response_headers_policy_id: str = None,
  viewer_protocol_policy: ViewerProtocolPolicy = None
)
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#must-cdk.CacheBehaviorConfig.property.originId">origin_id</a></code> | <code>str</code> | Origin ID to route this pattern to. |
| <code><a href="#must-cdk.CacheBehaviorConfig.property.pathPattern">path_pattern</a></code> | <code>str</code> | Path pattern for this behavior (e.g., "/api/*", "*.jpg"). |
| <code><a href="#must-cdk.CacheBehaviorConfig.property.allowedMethods">allowed_methods</a></code> | <code>aws_cdk.aws_cloudfront.AllowedMethods</code> | Allowed HTTP methods. |
| <code><a href="#must-cdk.CacheBehaviorConfig.property.cachedMethods">cached_methods</a></code> | <code>aws_cdk.aws_cloudfront.CachedMethods</code> | Methods to cache. |
| <code><a href="#must-cdk.CacheBehaviorConfig.property.cachePolicy">cache_policy</a></code> | <code>aws_cdk.aws_cloudfront.ICachePolicy</code> | Cache policy (alternative to cachePolicyId). |
| <code><a href="#must-cdk.CacheBehaviorConfig.property.cachePolicyId">cache_policy_id</a></code> | <code>str</code> | Cache policy ID (use AWS managed policies). |
| <code><a href="#must-cdk.CacheBehaviorConfig.property.compress">compress</a></code> | <code>bool</code> | Enable compression. |
| <code><a href="#must-cdk.CacheBehaviorConfig.property.originRequestPolicy">origin_request_policy</a></code> | <code>aws_cdk.aws_cloudfront.IOriginRequestPolicy</code> | Origin request policy (alternative to originRequestPolicyId). |
| <code><a href="#must-cdk.CacheBehaviorConfig.property.originRequestPolicyId">origin_request_policy_id</a></code> | <code>str</code> | Origin request policy ID. |
| <code><a href="#must-cdk.CacheBehaviorConfig.property.responseHeadersPolicy">response_headers_policy</a></code> | <code>aws_cdk.aws_cloudfront.IResponseHeadersPolicy</code> | Response headers policy (alternative to responseHeadersPolicyId). |
| <code><a href="#must-cdk.CacheBehaviorConfig.property.responseHeadersPolicyId">response_headers_policy_id</a></code> | <code>str</code> | Response headers policy ID. |
| <code><a href="#must-cdk.CacheBehaviorConfig.property.viewerProtocolPolicy">viewer_protocol_policy</a></code> | <code>aws_cdk.aws_cloudfront.ViewerProtocolPolicy</code> | Viewer protocol policy. |

---

##### `origin_id`<sup>Required</sup> <a name="origin_id" id="must-cdk.CacheBehaviorConfig.property.originId"></a>

```python
origin_id: str
```

- *Type:* str

Origin ID to route this pattern to.

---

##### `path_pattern`<sup>Required</sup> <a name="path_pattern" id="must-cdk.CacheBehaviorConfig.property.pathPattern"></a>

```python
path_pattern: str
```

- *Type:* str

Path pattern for this behavior (e.g., "/api/*", "*.jpg").

---

##### `allowed_methods`<sup>Optional</sup> <a name="allowed_methods" id="must-cdk.CacheBehaviorConfig.property.allowedMethods"></a>

```python
allowed_methods: AllowedMethods
```

- *Type:* aws_cdk.aws_cloudfront.AllowedMethods
- *Default:* ALLOW_GET_HEAD for S3, ALLOW_ALL for HTTP

Allowed HTTP methods.

---

##### `cached_methods`<sup>Optional</sup> <a name="cached_methods" id="must-cdk.CacheBehaviorConfig.property.cachedMethods"></a>

```python
cached_methods: CachedMethods
```

- *Type:* aws_cdk.aws_cloudfront.CachedMethods
- *Default:* CACHE_GET_HEAD_OPTIONS

Methods to cache.

---

##### `cache_policy`<sup>Optional</sup> <a name="cache_policy" id="must-cdk.CacheBehaviorConfig.property.cachePolicy"></a>

```python
cache_policy: ICachePolicy
```

- *Type:* aws_cdk.aws_cloudfront.ICachePolicy

Cache policy (alternative to cachePolicyId).

---

##### `cache_policy_id`<sup>Optional</sup> <a name="cache_policy_id" id="must-cdk.CacheBehaviorConfig.property.cachePolicyId"></a>

```python
cache_policy_id: str
```

- *Type:* str

Cache policy ID (use AWS managed policies).

---

##### `compress`<sup>Optional</sup> <a name="compress" id="must-cdk.CacheBehaviorConfig.property.compress"></a>

```python
compress: bool
```

- *Type:* bool
- *Default:* true

Enable compression.

---

##### `origin_request_policy`<sup>Optional</sup> <a name="origin_request_policy" id="must-cdk.CacheBehaviorConfig.property.originRequestPolicy"></a>

```python
origin_request_policy: IOriginRequestPolicy
```

- *Type:* aws_cdk.aws_cloudfront.IOriginRequestPolicy

Origin request policy (alternative to originRequestPolicyId).

---

##### `origin_request_policy_id`<sup>Optional</sup> <a name="origin_request_policy_id" id="must-cdk.CacheBehaviorConfig.property.originRequestPolicyId"></a>

```python
origin_request_policy_id: str
```

- *Type:* str

Origin request policy ID.

---

##### `response_headers_policy`<sup>Optional</sup> <a name="response_headers_policy" id="must-cdk.CacheBehaviorConfig.property.responseHeadersPolicy"></a>

```python
response_headers_policy: IResponseHeadersPolicy
```

- *Type:* aws_cdk.aws_cloudfront.IResponseHeadersPolicy

Response headers policy (alternative to responseHeadersPolicyId).

---

##### `response_headers_policy_id`<sup>Optional</sup> <a name="response_headers_policy_id" id="must-cdk.CacheBehaviorConfig.property.responseHeadersPolicyId"></a>

```python
response_headers_policy_id: str
```

- *Type:* str

Response headers policy ID.

---

##### `viewer_protocol_policy`<sup>Optional</sup> <a name="viewer_protocol_policy" id="must-cdk.CacheBehaviorConfig.property.viewerProtocolPolicy"></a>

```python
viewer_protocol_policy: ViewerProtocolPolicy
```

- *Type:* aws_cdk.aws_cloudfront.ViewerProtocolPolicy
- *Default:* REDIRECT_TO_HTTPS

Viewer protocol policy.

---

### CloudFrontToOriginsProps <a name="CloudFrontToOriginsProps" id="must-cdk.CloudFrontToOriginsProps"></a>

#### Initializer <a name="Initializer" id="must-cdk.CloudFrontToOriginsProps.Initializer"></a>

```python
import must_cdk

must_cdk.CloudFrontToOriginsProps(
  additional_domain_names: typing.List[str] = None,
  cache_behaviors: typing.List[CacheBehaviorConfig] = None,
  certificate: ICertificate = None,
  comment: str = None,
  create_route53_records: bool = None,
  custom_domain_name: str = None,
  default_origin_id: str = None,
  default_root_object: str = None,
  disable_default_error_pages: bool = None,
  disable_intelligent_defaults: bool = None,
  enabled: bool = None,
  enable_ipv6: bool = None,
  enable_logging: bool = None,
  error_pages: typing.List[ErrorResponse] = None,
  geo_restriction: GeoRestriction = None,
  hosted_zone: IHostedZone = None,
  http_origins: typing.List[HttpOriginConfig] = None,
  http_version: HttpVersion = None,
  log_bucket: IBucket = None,
  log_include_cookies: bool = None,
  log_prefix: str = None,
  price_class: PriceClass = None,
  s3_origins: typing.List[S3OriginConfig] = None,
  web_acl_id: str = None
)
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#must-cdk.CloudFrontToOriginsProps.property.additionalDomainNames">additional_domain_names</a></code> | <code>typing.List[str]</code> | Additional domain names (aliases) for the distribution Note: All domains must be covered by the same certificate. |
| <code><a href="#must-cdk.CloudFrontToOriginsProps.property.cacheBehaviors">cache_behaviors</a></code> | <code>typing.List[<a href="#must-cdk.CacheBehaviorConfig">CacheBehaviorConfig</a>]</code> | Cache behaviors for specific path patterns. |
| <code><a href="#must-cdk.CloudFrontToOriginsProps.property.certificate">certificate</a></code> | <code>aws_cdk.aws_certificatemanager.ICertificate</code> | Existing ACM certificate to use for the CloudFront distribution Certificate must be in us-east-1 region for CloudFront. |
| <code><a href="#must-cdk.CloudFrontToOriginsProps.property.comment">comment</a></code> | <code>str</code> | Comment for the distribution. |
| <code><a href="#must-cdk.CloudFrontToOriginsProps.property.createRoute53Records">create_route53_records</a></code> | <code>bool</code> | Create Route53 records for all domain names. |
| <code><a href="#must-cdk.CloudFrontToOriginsProps.property.customDomainName">custom_domain_name</a></code> | <code>str</code> | Primary custom domain name for the CloudFront distribution. |
| <code><a href="#must-cdk.CloudFrontToOriginsProps.property.defaultOriginId">default_origin_id</a></code> | <code>str</code> | ID of the origin to use as default behavior If not specified, will use the first HTTP origin, then first S3 origin. |
| <code><a href="#must-cdk.CloudFrontToOriginsProps.property.defaultRootObject">default_root_object</a></code> | <code>str</code> | Default root object for the distribution. |
| <code><a href="#must-cdk.CloudFrontToOriginsProps.property.disableDefaultErrorPages">disable_default_error_pages</a></code> | <code>bool</code> | Disable intelligent defaults for error pages. |
| <code><a href="#must-cdk.CloudFrontToOriginsProps.property.disableIntelligentDefaults">disable_intelligent_defaults</a></code> | <code>bool</code> | Disable intelligent defaults completely When true, only user-provided configuration will be applied. |
| <code><a href="#must-cdk.CloudFrontToOriginsProps.property.enabled">enabled</a></code> | <code>bool</code> | Whether the distribution is enabled. |
| <code><a href="#must-cdk.CloudFrontToOriginsProps.property.enableIpv6">enable_ipv6</a></code> | <code>bool</code> | Enable IPv6 for the distribution. |
| <code><a href="#must-cdk.CloudFrontToOriginsProps.property.enableLogging">enable_logging</a></code> | <code>bool</code> | Enable CloudFront access logging. |
| <code><a href="#must-cdk.CloudFrontToOriginsProps.property.errorPages">error_pages</a></code> | <code>typing.List[aws_cdk.aws_cloudfront.ErrorResponse]</code> | Custom error page configurations If not provided, intelligent defaults will be applied based on origin types. |
| <code><a href="#must-cdk.CloudFrontToOriginsProps.property.geoRestriction">geo_restriction</a></code> | <code>aws_cdk.aws_cloudfront.GeoRestriction</code> | Geographic restriction configuration. |
| <code><a href="#must-cdk.CloudFrontToOriginsProps.property.hostedZone">hosted_zone</a></code> | <code>aws_cdk.aws_route53.IHostedZone</code> | Route53 hosted zone for the custom domain Required for creating Route53 records. |
| <code><a href="#must-cdk.CloudFrontToOriginsProps.property.httpOrigins">http_origins</a></code> | <code>typing.List[<a href="#must-cdk.HttpOriginConfig">HttpOriginConfig</a>]</code> | HTTP origins configuration. |
| <code><a href="#must-cdk.CloudFrontToOriginsProps.property.httpVersion">http_version</a></code> | <code>aws_cdk.aws_cloudfront.HttpVersion</code> | HTTP version to support. |
| <code><a href="#must-cdk.CloudFrontToOriginsProps.property.logBucket">log_bucket</a></code> | <code>aws_cdk.aws_s3.IBucket</code> | Existing S3 bucket for logs If not provided and logging is enabled, a new bucket will be created. |
| <code><a href="#must-cdk.CloudFrontToOriginsProps.property.logIncludeCookies">log_include_cookies</a></code> | <code>bool</code> | Include cookies in access logs. |
| <code><a href="#must-cdk.CloudFrontToOriginsProps.property.logPrefix">log_prefix</a></code> | <code>str</code> | Prefix for log files. |
| <code><a href="#must-cdk.CloudFrontToOriginsProps.property.priceClass">price_class</a></code> | <code>aws_cdk.aws_cloudfront.PriceClass</code> | CloudFront distribution price class. |
| <code><a href="#must-cdk.CloudFrontToOriginsProps.property.s3Origins">s3_origins</a></code> | <code>typing.List[<a href="#must-cdk.S3OriginConfig">S3OriginConfig</a>]</code> | S3 origins configuration. |
| <code><a href="#must-cdk.CloudFrontToOriginsProps.property.webAclId">web_acl_id</a></code> | <code>str</code> | Web Application Firewall (WAF) web ACL ID. |

---

##### `additional_domain_names`<sup>Optional</sup> <a name="additional_domain_names" id="must-cdk.CloudFrontToOriginsProps.property.additionalDomainNames"></a>

```python
additional_domain_names: typing.List[str]
```

- *Type:* typing.List[str]

Additional domain names (aliases) for the distribution Note: All domains must be covered by the same certificate.

---

##### `cache_behaviors`<sup>Optional</sup> <a name="cache_behaviors" id="must-cdk.CloudFrontToOriginsProps.property.cacheBehaviors"></a>

```python
cache_behaviors: typing.List[CacheBehaviorConfig]
```

- *Type:* typing.List[<a href="#must-cdk.CacheBehaviorConfig">CacheBehaviorConfig</a>]

Cache behaviors for specific path patterns.

---

##### `certificate`<sup>Optional</sup> <a name="certificate" id="must-cdk.CloudFrontToOriginsProps.property.certificate"></a>

```python
certificate: ICertificate
```

- *Type:* aws_cdk.aws_certificatemanager.ICertificate

Existing ACM certificate to use for the CloudFront distribution Certificate must be in us-east-1 region for CloudFront.

---

##### `comment`<sup>Optional</sup> <a name="comment" id="must-cdk.CloudFrontToOriginsProps.property.comment"></a>

```python
comment: str
```

- *Type:* str

Comment for the distribution.

---

##### `create_route53_records`<sup>Optional</sup> <a name="create_route53_records" id="must-cdk.CloudFrontToOriginsProps.property.createRoute53Records"></a>

```python
create_route53_records: bool
```

- *Type:* bool
- *Default:* true if hostedZone is provided

Create Route53 records for all domain names.

---

##### `custom_domain_name`<sup>Optional</sup> <a name="custom_domain_name" id="must-cdk.CloudFrontToOriginsProps.property.customDomainName"></a>

```python
custom_domain_name: str
```

- *Type:* str

Primary custom domain name for the CloudFront distribution.

---

##### `default_origin_id`<sup>Optional</sup> <a name="default_origin_id" id="must-cdk.CloudFrontToOriginsProps.property.defaultOriginId"></a>

```python
default_origin_id: str
```

- *Type:* str

ID of the origin to use as default behavior If not specified, will use the first HTTP origin, then first S3 origin.

---

##### `default_root_object`<sup>Optional</sup> <a name="default_root_object" id="must-cdk.CloudFrontToOriginsProps.property.defaultRootObject"></a>

```python
default_root_object: str
```

- *Type:* str
- *Default:* "index.html"

Default root object for the distribution.

---

##### `disable_default_error_pages`<sup>Optional</sup> <a name="disable_default_error_pages" id="must-cdk.CloudFrontToOriginsProps.property.disableDefaultErrorPages"></a>

```python
disable_default_error_pages: bool
```

- *Type:* bool
- *Default:* false

Disable intelligent defaults for error pages.

---

##### `disable_intelligent_defaults`<sup>Optional</sup> <a name="disable_intelligent_defaults" id="must-cdk.CloudFrontToOriginsProps.property.disableIntelligentDefaults"></a>

```python
disable_intelligent_defaults: bool
```

- *Type:* bool
- *Default:* false

Disable intelligent defaults completely When true, only user-provided configuration will be applied.

---

##### `enabled`<sup>Optional</sup> <a name="enabled" id="must-cdk.CloudFrontToOriginsProps.property.enabled"></a>

```python
enabled: bool
```

- *Type:* bool
- *Default:* true

Whether the distribution is enabled.

---

##### `enable_ipv6`<sup>Optional</sup> <a name="enable_ipv6" id="must-cdk.CloudFrontToOriginsProps.property.enableIpv6"></a>

```python
enable_ipv6: bool
```

- *Type:* bool
- *Default:* false

Enable IPv6 for the distribution.

---

##### `enable_logging`<sup>Optional</sup> <a name="enable_logging" id="must-cdk.CloudFrontToOriginsProps.property.enableLogging"></a>

```python
enable_logging: bool
```

- *Type:* bool
- *Default:* true

Enable CloudFront access logging.

---

##### `error_pages`<sup>Optional</sup> <a name="error_pages" id="must-cdk.CloudFrontToOriginsProps.property.errorPages"></a>

```python
error_pages: typing.List[ErrorResponse]
```

- *Type:* typing.List[aws_cdk.aws_cloudfront.ErrorResponse]

Custom error page configurations If not provided, intelligent defaults will be applied based on origin types.

---

##### `geo_restriction`<sup>Optional</sup> <a name="geo_restriction" id="must-cdk.CloudFrontToOriginsProps.property.geoRestriction"></a>

```python
geo_restriction: GeoRestriction
```

- *Type:* aws_cdk.aws_cloudfront.GeoRestriction

Geographic restriction configuration.

---

##### `hosted_zone`<sup>Optional</sup> <a name="hosted_zone" id="must-cdk.CloudFrontToOriginsProps.property.hostedZone"></a>

```python
hosted_zone: IHostedZone
```

- *Type:* aws_cdk.aws_route53.IHostedZone

Route53 hosted zone for the custom domain Required for creating Route53 records.

---

##### `http_origins`<sup>Optional</sup> <a name="http_origins" id="must-cdk.CloudFrontToOriginsProps.property.httpOrigins"></a>

```python
http_origins: typing.List[HttpOriginConfig]
```

- *Type:* typing.List[<a href="#must-cdk.HttpOriginConfig">HttpOriginConfig</a>]

HTTP origins configuration.

---

##### `http_version`<sup>Optional</sup> <a name="http_version" id="must-cdk.CloudFrontToOriginsProps.property.httpVersion"></a>

```python
http_version: HttpVersion
```

- *Type:* aws_cdk.aws_cloudfront.HttpVersion
- *Default:* HttpVersion.HTTP2

HTTP version to support.

---

##### `log_bucket`<sup>Optional</sup> <a name="log_bucket" id="must-cdk.CloudFrontToOriginsProps.property.logBucket"></a>

```python
log_bucket: IBucket
```

- *Type:* aws_cdk.aws_s3.IBucket

Existing S3 bucket for logs If not provided and logging is enabled, a new bucket will be created.

---

##### `log_include_cookies`<sup>Optional</sup> <a name="log_include_cookies" id="must-cdk.CloudFrontToOriginsProps.property.logIncludeCookies"></a>

```python
log_include_cookies: bool
```

- *Type:* bool
- *Default:* false

Include cookies in access logs.

---

##### `log_prefix`<sup>Optional</sup> <a name="log_prefix" id="must-cdk.CloudFrontToOriginsProps.property.logPrefix"></a>

```python
log_prefix: str
```

- *Type:* str
- *Default:* "cloudfront-logs/"

Prefix for log files.

---

##### `price_class`<sup>Optional</sup> <a name="price_class" id="must-cdk.CloudFrontToOriginsProps.property.priceClass"></a>

```python
price_class: PriceClass
```

- *Type:* aws_cdk.aws_cloudfront.PriceClass
- *Default:* PRICE_CLASS_100

CloudFront distribution price class.

---

##### `s3_origins`<sup>Optional</sup> <a name="s3_origins" id="must-cdk.CloudFrontToOriginsProps.property.s3Origins"></a>

```python
s3_origins: typing.List[S3OriginConfig]
```

- *Type:* typing.List[<a href="#must-cdk.S3OriginConfig">S3OriginConfig</a>]

S3 origins configuration.

---

##### `web_acl_id`<sup>Optional</sup> <a name="web_acl_id" id="must-cdk.CloudFrontToOriginsProps.property.webAclId"></a>

```python
web_acl_id: str
```

- *Type:* str

Web Application Firewall (WAF) web ACL ID.

---

### ContainerProps <a name="ContainerProps" id="must-cdk.ContainerProps"></a>

Configuration for the ECS Fargate task definition and container.

#### Initializer <a name="Initializer" id="must-cdk.ContainerProps.Initializer"></a>

```python
import must_cdk

must_cdk.ContainerProps(
  container_port: typing.Union[int, float],
  image: ContainerImage,
  health_check: HealthCheck = None,
  memory_limit: typing.Union[int, float] = None,
  memory_reservation: typing.Union[int, float] = None
)
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#must-cdk.ContainerProps.property.containerPort">container_port</a></code> | <code>typing.Union[int, float]</code> | The port number the container listens on. |
| <code><a href="#must-cdk.ContainerProps.property.image">image</a></code> | <code>aws_cdk.aws_ecs.ContainerImage</code> | Container image to deploy. |
| <code><a href="#must-cdk.ContainerProps.property.healthCheck">health_check</a></code> | <code>aws_cdk.aws_ecs.HealthCheck</code> | Optional container health check configuration. |
| <code><a href="#must-cdk.ContainerProps.property.memoryLimit">memory_limit</a></code> | <code>typing.Union[int, float]</code> | Hard memory limit in MiB for the task (default: 2048). |
| <code><a href="#must-cdk.ContainerProps.property.memoryReservation">memory_reservation</a></code> | <code>typing.Union[int, float]</code> | Soft memory reservation in MiB for the container (default: 1024). |

---

##### `container_port`<sup>Required</sup> <a name="container_port" id="must-cdk.ContainerProps.property.containerPort"></a>

```python
container_port: typing.Union[int, float]
```

- *Type:* typing.Union[int, float]

The port number the container listens on.

---

##### `image`<sup>Required</sup> <a name="image" id="must-cdk.ContainerProps.property.image"></a>

```python
image: ContainerImage
```

- *Type:* aws_cdk.aws_ecs.ContainerImage

Container image to deploy.

---

##### `health_check`<sup>Optional</sup> <a name="health_check" id="must-cdk.ContainerProps.property.healthCheck"></a>

```python
health_check: HealthCheck
```

- *Type:* aws_cdk.aws_ecs.HealthCheck

Optional container health check configuration.

---

##### `memory_limit`<sup>Optional</sup> <a name="memory_limit" id="must-cdk.ContainerProps.property.memoryLimit"></a>

```python
memory_limit: typing.Union[int, float]
```

- *Type:* typing.Union[int, float]

Hard memory limit in MiB for the task (default: 2048).

---

##### `memory_reservation`<sup>Optional</sup> <a name="memory_reservation" id="must-cdk.ContainerProps.property.memoryReservation"></a>

```python
memory_reservation: typing.Union[int, float]
```

- *Type:* typing.Union[int, float]

Soft memory reservation in MiB for the container (default: 1024).

---

### CustomRoute <a name="CustomRoute" id="must-cdk.CustomRoute"></a>

#### Initializer <a name="Initializer" id="must-cdk.CustomRoute.Initializer"></a>

```python
import must_cdk

must_cdk.CustomRoute(
  handler: IFunction,
  method: str,
  path: str,
  method_options: MethodOptions = None
)
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#must-cdk.CustomRoute.property.handler">handler</a></code> | <code>aws_cdk.aws_lambda.IFunction</code> | *No description.* |
| <code><a href="#must-cdk.CustomRoute.property.method">method</a></code> | <code>str</code> | *No description.* |
| <code><a href="#must-cdk.CustomRoute.property.path">path</a></code> | <code>str</code> | *No description.* |
| <code><a href="#must-cdk.CustomRoute.property.methodOptions">method_options</a></code> | <code>aws_cdk.aws_apigateway.MethodOptions</code> | *No description.* |

---

##### `handler`<sup>Required</sup> <a name="handler" id="must-cdk.CustomRoute.property.handler"></a>

```python
handler: IFunction
```

- *Type:* aws_cdk.aws_lambda.IFunction

---

##### `method`<sup>Required</sup> <a name="method" id="must-cdk.CustomRoute.property.method"></a>

```python
method: str
```

- *Type:* str

---

##### `path`<sup>Required</sup> <a name="path" id="must-cdk.CustomRoute.property.path"></a>

```python
path: str
```

- *Type:* str

---

##### `method_options`<sup>Optional</sup> <a name="method_options" id="must-cdk.CustomRoute.property.methodOptions"></a>

```python
method_options: MethodOptions
```

- *Type:* aws_cdk.aws_apigateway.MethodOptions

---

### EcsCodeDeployProps <a name="EcsCodeDeployProps" id="must-cdk.EcsCodeDeployProps"></a>

Properties for the EcsCodeDeploy construct.

#### Initializer <a name="Initializer" id="must-cdk.EcsCodeDeployProps.Initializer"></a>

```python
import must_cdk

must_cdk.EcsCodeDeployProps(
  certificates: typing.List[ICertificate],
  cluster: ICluster,
  containers: typing.List[ContainerProps],
  security_groups: typing.List[ISecurityGroup],
  service_name: str,
  subnets: SubnetSelection,
  vpc: IVpc,
  alb_target_port: typing.Union[int, float] = None,
  auto_scaling: AutoScalingProps = None,
  enable_public_load_balancer: bool = None,
  memory_limit: typing.Union[int, float] = None,
  task_cp_u: typing.Union[int, float] = None,
  task_exec_role: IRole = None,
  task_role: IRole = None
)
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#must-cdk.EcsCodeDeployProps.property.certificates">certificates</a></code> | <code>typing.List[aws_cdk.aws_certificatemanager.ICertificate]</code> | Optional ACM certificates for HTTPS termination. |
| <code><a href="#must-cdk.EcsCodeDeployProps.property.cluster">cluster</a></code> | <code>aws_cdk.aws_ecs.ICluster</code> | ECS Cluster where the service will run. |
| <code><a href="#must-cdk.EcsCodeDeployProps.property.containers">containers</a></code> | <code>typing.List[<a href="#must-cdk.ContainerProps">ContainerProps</a>]</code> | Configuration related to the task definition and container. |
| <code><a href="#must-cdk.EcsCodeDeployProps.property.securityGroups">security_groups</a></code> | <code>typing.List[aws_cdk.aws_ec2.ISecurityGroup]</code> | Security group config. |
| <code><a href="#must-cdk.EcsCodeDeployProps.property.serviceName">service_name</a></code> | <code>str</code> | Base name used for resources like log groups, roles, services, etc. |
| <code><a href="#must-cdk.EcsCodeDeployProps.property.subnets">subnets</a></code> | <code>aws_cdk.aws_ec2.SubnetSelection</code> | Select which subnets the Service and ALB will placed on. |
| <code><a href="#must-cdk.EcsCodeDeployProps.property.vpc">vpc</a></code> | <code>aws_cdk.aws_ec2.IVpc</code> | VPC in which to deploy ECS and ALB resources. |
| <code><a href="#must-cdk.EcsCodeDeployProps.property.albTargetPort">alb_target_port</a></code> | <code>typing.Union[int, float]</code> | The ALB target port. |
| <code><a href="#must-cdk.EcsCodeDeployProps.property.autoScaling">auto_scaling</a></code> | <code><a href="#must-cdk.AutoScalingProps">AutoScalingProps</a></code> | Optional auto-scaling configuration. |
| <code><a href="#must-cdk.EcsCodeDeployProps.property.enablePublicLoadBalancer">enable_public_load_balancer</a></code> | <code>bool</code> | Whether the load balancer should be internet-facing (default: false). |
| <code><a href="#must-cdk.EcsCodeDeployProps.property.memoryLimit">memory_limit</a></code> | <code>typing.Union[int, float]</code> | *No description.* |
| <code><a href="#must-cdk.EcsCodeDeployProps.property.taskCPU">task_cp_u</a></code> | <code>typing.Union[int, float]</code> | CPU units for the task (default: 1024). |
| <code><a href="#must-cdk.EcsCodeDeployProps.property.taskExecRole">task_exec_role</a></code> | <code>aws_cdk.aws_iam.IRole</code> | Task execution role for the ECS task. |
| <code><a href="#must-cdk.EcsCodeDeployProps.property.taskRole">task_role</a></code> | <code>aws_cdk.aws_iam.IRole</code> | Task role for the ECS task. |

---

##### `certificates`<sup>Required</sup> <a name="certificates" id="must-cdk.EcsCodeDeployProps.property.certificates"></a>

```python
certificates: typing.List[ICertificate]
```

- *Type:* typing.List[aws_cdk.aws_certificatemanager.ICertificate]

Optional ACM certificates for HTTPS termination.

---

##### `cluster`<sup>Required</sup> <a name="cluster" id="must-cdk.EcsCodeDeployProps.property.cluster"></a>

```python
cluster: ICluster
```

- *Type:* aws_cdk.aws_ecs.ICluster

ECS Cluster where the service will run.

---

##### `containers`<sup>Required</sup> <a name="containers" id="must-cdk.EcsCodeDeployProps.property.containers"></a>

```python
containers: typing.List[ContainerProps]
```

- *Type:* typing.List[<a href="#must-cdk.ContainerProps">ContainerProps</a>]

Configuration related to the task definition and container.

---

##### `security_groups`<sup>Required</sup> <a name="security_groups" id="must-cdk.EcsCodeDeployProps.property.securityGroups"></a>

```python
security_groups: typing.List[ISecurityGroup]
```

- *Type:* typing.List[aws_cdk.aws_ec2.ISecurityGroup]

Security group config.

---

##### `service_name`<sup>Required</sup> <a name="service_name" id="must-cdk.EcsCodeDeployProps.property.serviceName"></a>

```python
service_name: str
```

- *Type:* str

Base name used for resources like log groups, roles, services, etc.

---

##### `subnets`<sup>Required</sup> <a name="subnets" id="must-cdk.EcsCodeDeployProps.property.subnets"></a>

```python
subnets: SubnetSelection
```

- *Type:* aws_cdk.aws_ec2.SubnetSelection

Select which subnets the Service and ALB will placed on.

---

##### `vpc`<sup>Required</sup> <a name="vpc" id="must-cdk.EcsCodeDeployProps.property.vpc"></a>

```python
vpc: IVpc
```

- *Type:* aws_cdk.aws_ec2.IVpc

VPC in which to deploy ECS and ALB resources.

---

##### `alb_target_port`<sup>Optional</sup> <a name="alb_target_port" id="must-cdk.EcsCodeDeployProps.property.albTargetPort"></a>

```python
alb_target_port: typing.Union[int, float]
```

- *Type:* typing.Union[int, float]

The ALB target port.

---

##### `auto_scaling`<sup>Optional</sup> <a name="auto_scaling" id="must-cdk.EcsCodeDeployProps.property.autoScaling"></a>

```python
auto_scaling: AutoScalingProps
```

- *Type:* <a href="#must-cdk.AutoScalingProps">AutoScalingProps</a>

Optional auto-scaling configuration.

---

##### `enable_public_load_balancer`<sup>Optional</sup> <a name="enable_public_load_balancer" id="must-cdk.EcsCodeDeployProps.property.enablePublicLoadBalancer"></a>

```python
enable_public_load_balancer: bool
```

- *Type:* bool

Whether the load balancer should be internet-facing (default: false).

---

##### `memory_limit`<sup>Optional</sup> <a name="memory_limit" id="must-cdk.EcsCodeDeployProps.property.memoryLimit"></a>

```python
memory_limit: typing.Union[int, float]
```

- *Type:* typing.Union[int, float]

---

##### `task_cp_u`<sup>Optional</sup> <a name="task_cp_u" id="must-cdk.EcsCodeDeployProps.property.taskCPU"></a>

```python
task_cp_u: typing.Union[int, float]
```

- *Type:* typing.Union[int, float]

CPU units for the task (default: 1024).

---

##### `task_exec_role`<sup>Optional</sup> <a name="task_exec_role" id="must-cdk.EcsCodeDeployProps.property.taskExecRole"></a>

```python
task_exec_role: IRole
```

- *Type:* aws_cdk.aws_iam.IRole

Task execution role for the ECS task.

---

##### `task_role`<sup>Optional</sup> <a name="task_role" id="must-cdk.EcsCodeDeployProps.property.taskRole"></a>

```python
task_role: IRole
```

- *Type:* aws_cdk.aws_iam.IRole

Task role for the ECS task.

---

### HttpOriginConfig <a name="HttpOriginConfig" id="must-cdk.HttpOriginConfig"></a>

#### Initializer <a name="Initializer" id="must-cdk.HttpOriginConfig.Initializer"></a>

```python
import must_cdk

must_cdk.HttpOriginConfig(
  domain_name: str,
  id: str,
  http_origin_props: HttpOriginProps = None,
  http_port: typing.Union[int, float] = None,
  https_port: typing.Union[int, float] = None,
  origin_path: str = None,
  protocol_policy: OriginProtocolPolicy = None
)
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#must-cdk.HttpOriginConfig.property.domainName">domain_name</a></code> | <code>str</code> | Domain name of the HTTP origin (required). |
| <code><a href="#must-cdk.HttpOriginConfig.property.id">id</a></code> | <code>str</code> | Unique identifier for this HTTP origin. |
| <code><a href="#must-cdk.HttpOriginConfig.property.httpOriginProps">http_origin_props</a></code> | <code>aws_cdk.aws_cloudfront_origins.HttpOriginProps</code> | Additional HTTP origin properties. |
| <code><a href="#must-cdk.HttpOriginConfig.property.httpPort">http_port</a></code> | <code>typing.Union[int, float]</code> | HTTP port (for HTTP protocol). |
| <code><a href="#must-cdk.HttpOriginConfig.property.httpsPort">https_port</a></code> | <code>typing.Union[int, float]</code> | HTTPS port (for HTTPS protocol). |
| <code><a href="#must-cdk.HttpOriginConfig.property.originPath">origin_path</a></code> | <code>str</code> | Origin path for HTTP requests (e.g., "/api/v1"). |
| <code><a href="#must-cdk.HttpOriginConfig.property.protocolPolicy">protocol_policy</a></code> | <code>aws_cdk.aws_cloudfront.OriginProtocolPolicy</code> | Protocol policy for the origin. |

---

##### `domain_name`<sup>Required</sup> <a name="domain_name" id="must-cdk.HttpOriginConfig.property.domainName"></a>

```python
domain_name: str
```

- *Type:* str

Domain name of the HTTP origin (required).

---

##### `id`<sup>Required</sup> <a name="id" id="must-cdk.HttpOriginConfig.property.id"></a>

```python
id: str
```

- *Type:* str

Unique identifier for this HTTP origin.

---

##### `http_origin_props`<sup>Optional</sup> <a name="http_origin_props" id="must-cdk.HttpOriginConfig.property.httpOriginProps"></a>

```python
http_origin_props: HttpOriginProps
```

- *Type:* aws_cdk.aws_cloudfront_origins.HttpOriginProps

Additional HTTP origin properties.

---

##### `http_port`<sup>Optional</sup> <a name="http_port" id="must-cdk.HttpOriginConfig.property.httpPort"></a>

```python
http_port: typing.Union[int, float]
```

- *Type:* typing.Union[int, float]
- *Default:* 80

HTTP port (for HTTP protocol).

---

##### `https_port`<sup>Optional</sup> <a name="https_port" id="must-cdk.HttpOriginConfig.property.httpsPort"></a>

```python
https_port: typing.Union[int, float]
```

- *Type:* typing.Union[int, float]
- *Default:* 443

HTTPS port (for HTTPS protocol).

---

##### `origin_path`<sup>Optional</sup> <a name="origin_path" id="must-cdk.HttpOriginConfig.property.originPath"></a>

```python
origin_path: str
```

- *Type:* str

Origin path for HTTP requests (e.g., "/api/v1").

---

##### `protocol_policy`<sup>Optional</sup> <a name="protocol_policy" id="must-cdk.HttpOriginConfig.property.protocolPolicy"></a>

```python
protocol_policy: OriginProtocolPolicy
```

- *Type:* aws_cdk.aws_cloudfront.OriginProtocolPolicy
- *Default:* HTTPS_ONLY

Protocol policy for the origin.

---

### HttpOriginInfo <a name="HttpOriginInfo" id="must-cdk.HttpOriginInfo"></a>

HTTP origin information.

#### Initializer <a name="Initializer" id="must-cdk.HttpOriginInfo.Initializer"></a>

```python
import must_cdk

must_cdk.HttpOriginInfo(
  id: str,
  origin: HttpOrigin
)
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#must-cdk.HttpOriginInfo.property.id">id</a></code> | <code>str</code> | *No description.* |
| <code><a href="#must-cdk.HttpOriginInfo.property.origin">origin</a></code> | <code>aws_cdk.aws_cloudfront_origins.HttpOrigin</code> | *No description.* |

---

##### `id`<sup>Required</sup> <a name="id" id="must-cdk.HttpOriginInfo.property.id"></a>

```python
id: str
```

- *Type:* str

---

##### `origin`<sup>Required</sup> <a name="origin" id="must-cdk.HttpOriginInfo.property.origin"></a>

```python
origin: HttpOrigin
```

- *Type:* aws_cdk.aws_cloudfront_origins.HttpOrigin

---

### S3OriginConfig <a name="S3OriginConfig" id="must-cdk.S3OriginConfig"></a>

#### Initializer <a name="Initializer" id="must-cdk.S3OriginConfig.Initializer"></a>

```python
import must_cdk

must_cdk.S3OriginConfig(
  bucket: IBucket,
  id: str,
  origin_access_identity: OriginAccessIdentity = None,
  origin_path: str = None,
  s3_origin_props: S3OriginProps = None,
  use_legacy_oa_i: bool = None
)
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#must-cdk.S3OriginConfig.property.bucket">bucket</a></code> | <code>aws_cdk.aws_s3.IBucket</code> | Existing S3 bucket to use as origin (required). |
| <code><a href="#must-cdk.S3OriginConfig.property.id">id</a></code> | <code>str</code> | Unique identifier for this S3 origin. |
| <code><a href="#must-cdk.S3OriginConfig.property.originAccessIdentity">origin_access_identity</a></code> | <code>aws_cdk.aws_cloudfront.OriginAccessIdentity</code> | Existing Origin Access Identity (only used if useLegacyOAI is true). |
| <code><a href="#must-cdk.S3OriginConfig.property.originPath">origin_path</a></code> | <code>str</code> | Origin path for S3 requests (e.g., "/static"). |
| <code><a href="#must-cdk.S3OriginConfig.property.s3OriginProps">s3_origin_props</a></code> | <code>aws_cdk.aws_cloudfront_origins.S3OriginProps</code> | Additional S3 origin properties. |
| <code><a href="#must-cdk.S3OriginConfig.property.useLegacyOAI">use_legacy_oa_i</a></code> | <code>bool</code> | Use legacy Origin Access Identity instead of modern Origin Access Control. |

---

##### `bucket`<sup>Required</sup> <a name="bucket" id="must-cdk.S3OriginConfig.property.bucket"></a>

```python
bucket: IBucket
```

- *Type:* aws_cdk.aws_s3.IBucket

Existing S3 bucket to use as origin (required).

---

##### `id`<sup>Required</sup> <a name="id" id="must-cdk.S3OriginConfig.property.id"></a>

```python
id: str
```

- *Type:* str

Unique identifier for this S3 origin.

---

##### `origin_access_identity`<sup>Optional</sup> <a name="origin_access_identity" id="must-cdk.S3OriginConfig.property.originAccessIdentity"></a>

```python
origin_access_identity: OriginAccessIdentity
```

- *Type:* aws_cdk.aws_cloudfront.OriginAccessIdentity

Existing Origin Access Identity (only used if useLegacyOAI is true).

---

##### `origin_path`<sup>Optional</sup> <a name="origin_path" id="must-cdk.S3OriginConfig.property.originPath"></a>

```python
origin_path: str
```

- *Type:* str

Origin path for S3 requests (e.g., "/static").

---

##### `s3_origin_props`<sup>Optional</sup> <a name="s3_origin_props" id="must-cdk.S3OriginConfig.property.s3OriginProps"></a>

```python
s3_origin_props: S3OriginProps
```

- *Type:* aws_cdk.aws_cloudfront_origins.S3OriginProps

Additional S3 origin properties.

---

##### `use_legacy_oa_i`<sup>Optional</sup> <a name="use_legacy_oa_i" id="must-cdk.S3OriginConfig.property.useLegacyOAI"></a>

```python
use_legacy_oa_i: bool
```

- *Type:* bool
- *Default:* false - uses OAC for better security

Use legacy Origin Access Identity instead of modern Origin Access Control.

---

### S3OriginInfo <a name="S3OriginInfo" id="must-cdk.S3OriginInfo"></a>

S3 origin information.

#### Initializer <a name="Initializer" id="must-cdk.S3OriginInfo.Initializer"></a>

```python
import must_cdk

must_cdk.S3OriginInfo(
  bucket: IBucket,
  id: str
)
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#must-cdk.S3OriginInfo.property.bucket">bucket</a></code> | <code>aws_cdk.aws_s3.IBucket</code> | *No description.* |
| <code><a href="#must-cdk.S3OriginInfo.property.id">id</a></code> | <code>str</code> | *No description.* |

---

##### `bucket`<sup>Required</sup> <a name="bucket" id="must-cdk.S3OriginInfo.property.bucket"></a>

```python
bucket: IBucket
```

- *Type:* aws_cdk.aws_s3.IBucket

---

##### `id`<sup>Required</sup> <a name="id" id="must-cdk.S3OriginInfo.property.id"></a>

```python
id: str
```

- *Type:* str

---

### WebSocketApiGatewayToLambdaProps <a name="WebSocketApiGatewayToLambdaProps" id="must-cdk.WebSocketApiGatewayToLambdaProps"></a>

#### Initializer <a name="Initializer" id="must-cdk.WebSocketApiGatewayToLambdaProps.Initializer"></a>

```python
import must_cdk

must_cdk.WebSocketApiGatewayToLambdaProps(
  api_name: str,
  lambda_function: IFunction,
  api_props: WebSocketApiProps = None,
  custom_domain_name: str = None,
  custom_routes: typing.List[WebSocketRoute] = None,
  enable_logging: bool = None,
  existing_certificate: ICertificate = None,
  hosted_zone: IHostedZone = None,
  log_group_props: LogGroupProps = None,
  stage_name: str = None
)
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#must-cdk.WebSocketApiGatewayToLambdaProps.property.apiName">api_name</a></code> | <code>str</code> | WebSocket API configuration. |
| <code><a href="#must-cdk.WebSocketApiGatewayToLambdaProps.property.lambdaFunction">lambda_function</a></code> | <code>aws_cdk.aws_lambda.IFunction</code> | Primary Lambda function for the API (usually handles $default route). |
| <code><a href="#must-cdk.WebSocketApiGatewayToLambdaProps.property.apiProps">api_props</a></code> | <code>aws_cdk.aws_apigatewayv2.WebSocketApiProps</code> | *No description.* |
| <code><a href="#must-cdk.WebSocketApiGatewayToLambdaProps.property.customDomainName">custom_domain_name</a></code> | <code>str</code> | Optional custom domain name for API Gateway. |
| <code><a href="#must-cdk.WebSocketApiGatewayToLambdaProps.property.customRoutes">custom_routes</a></code> | <code>typing.List[<a href="#must-cdk.WebSocketRoute">WebSocketRoute</a>]</code> | Custom routes for WebSocket API Common routes: $connect, $disconnect, $default, or custom route keys. |
| <code><a href="#must-cdk.WebSocketApiGatewayToLambdaProps.property.enableLogging">enable_logging</a></code> | <code>bool</code> | Enable CloudWatch logging for API Gateway. |
| <code><a href="#must-cdk.WebSocketApiGatewayToLambdaProps.property.existingCertificate">existing_certificate</a></code> | <code>aws_cdk.aws_certificatemanager.ICertificate</code> | Optional ACM certificate to use instead of creating a new one. |
| <code><a href="#must-cdk.WebSocketApiGatewayToLambdaProps.property.hostedZone">hosted_zone</a></code> | <code>aws_cdk.aws_route53.IHostedZone</code> | Optional Route53 hosted zone for custom domain. |
| <code><a href="#must-cdk.WebSocketApiGatewayToLambdaProps.property.logGroupProps">log_group_props</a></code> | <code>aws_cdk.aws_logs.LogGroupProps</code> | CloudWatch Logs configuration. |
| <code><a href="#must-cdk.WebSocketApiGatewayToLambdaProps.property.stageName">stage_name</a></code> | <code>str</code> | Stage name for the WebSocket API. |

---

##### `api_name`<sup>Required</sup> <a name="api_name" id="must-cdk.WebSocketApiGatewayToLambdaProps.property.apiName"></a>

```python
api_name: str
```

- *Type:* str

WebSocket API configuration.

---

##### `lambda_function`<sup>Required</sup> <a name="lambda_function" id="must-cdk.WebSocketApiGatewayToLambdaProps.property.lambdaFunction"></a>

```python
lambda_function: IFunction
```

- *Type:* aws_cdk.aws_lambda.IFunction

Primary Lambda function for the API (usually handles $default route).

---

##### `api_props`<sup>Optional</sup> <a name="api_props" id="must-cdk.WebSocketApiGatewayToLambdaProps.property.apiProps"></a>

```python
api_props: WebSocketApiProps
```

- *Type:* aws_cdk.aws_apigatewayv2.WebSocketApiProps

---

##### `custom_domain_name`<sup>Optional</sup> <a name="custom_domain_name" id="must-cdk.WebSocketApiGatewayToLambdaProps.property.customDomainName"></a>

```python
custom_domain_name: str
```

- *Type:* str

Optional custom domain name for API Gateway.

---

##### `custom_routes`<sup>Optional</sup> <a name="custom_routes" id="must-cdk.WebSocketApiGatewayToLambdaProps.property.customRoutes"></a>

```python
custom_routes: typing.List[WebSocketRoute]
```

- *Type:* typing.List[<a href="#must-cdk.WebSocketRoute">WebSocketRoute</a>]

Custom routes for WebSocket API Common routes: $connect, $disconnect, $default, or custom route keys.

---

##### `enable_logging`<sup>Optional</sup> <a name="enable_logging" id="must-cdk.WebSocketApiGatewayToLambdaProps.property.enableLogging"></a>

```python
enable_logging: bool
```

- *Type:* bool

Enable CloudWatch logging for API Gateway.

---

##### `existing_certificate`<sup>Optional</sup> <a name="existing_certificate" id="must-cdk.WebSocketApiGatewayToLambdaProps.property.existingCertificate"></a>

```python
existing_certificate: ICertificate
```

- *Type:* aws_cdk.aws_certificatemanager.ICertificate

Optional ACM certificate to use instead of creating a new one.

---

##### `hosted_zone`<sup>Optional</sup> <a name="hosted_zone" id="must-cdk.WebSocketApiGatewayToLambdaProps.property.hostedZone"></a>

```python
hosted_zone: IHostedZone
```

- *Type:* aws_cdk.aws_route53.IHostedZone

Optional Route53 hosted zone for custom domain.

---

##### `log_group_props`<sup>Optional</sup> <a name="log_group_props" id="must-cdk.WebSocketApiGatewayToLambdaProps.property.logGroupProps"></a>

```python
log_group_props: LogGroupProps
```

- *Type:* aws_cdk.aws_logs.LogGroupProps

CloudWatch Logs configuration.

---

##### `stage_name`<sup>Optional</sup> <a name="stage_name" id="must-cdk.WebSocketApiGatewayToLambdaProps.property.stageName"></a>

```python
stage_name: str
```

- *Type:* str
- *Default:* 'dev'

Stage name for the WebSocket API.

---

### WebSocketRoute <a name="WebSocketRoute" id="must-cdk.WebSocketRoute"></a>

#### Initializer <a name="Initializer" id="must-cdk.WebSocketRoute.Initializer"></a>

```python
import must_cdk

must_cdk.WebSocketRoute(
  handler: IFunction,
  route_key: str,
  route_response_selection_expression: str = None
)
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#must-cdk.WebSocketRoute.property.handler">handler</a></code> | <code>aws_cdk.aws_lambda.IFunction</code> | *No description.* |
| <code><a href="#must-cdk.WebSocketRoute.property.routeKey">route_key</a></code> | <code>str</code> | *No description.* |
| <code><a href="#must-cdk.WebSocketRoute.property.routeResponseSelectionExpression">route_response_selection_expression</a></code> | <code>str</code> | *No description.* |

---

##### `handler`<sup>Required</sup> <a name="handler" id="must-cdk.WebSocketRoute.property.handler"></a>

```python
handler: IFunction
```

- *Type:* aws_cdk.aws_lambda.IFunction

---

##### `route_key`<sup>Required</sup> <a name="route_key" id="must-cdk.WebSocketRoute.property.routeKey"></a>

```python
route_key: str
```

- *Type:* str

---

##### `route_response_selection_expression`<sup>Optional</sup> <a name="route_response_selection_expression" id="must-cdk.WebSocketRoute.property.routeResponseSelectionExpression"></a>

```python
route_response_selection_expression: str
```

- *Type:* str

---



