# Must CDK Examples

This directory contains example implementations of Must CDK constructs for various AWS services and common scenarios. Each example is provided in both TypeScript and Python.

## Categories

### [Amplify](./amplify)
Examples for AWS Amplify deployments:
- Basic Next.js deployment
- Multi-branch environments
- Custom domain setup
- Full-featured enterprise setup

### [ECS CodeDeploy](./ecs-codedeploy)
Examples for ECS with CodeDeploy:
- Basic service deployment
- Blue/Green deployment
- Custom deployment configurations
- Load balanced service

### [CloudFront](./cloudfront)
Examples for CloudFront distributions:
- Static website hosting
- API Gateway integration
- Cross-region setup
- Custom domain and SSL

### [API Gateway Lambda](./apigw-lambda)
Examples for API Gateway with Lambda:
- REST API setup
- WebSocket API
- Custom domain configuration
- Lambda authorizers

## Prerequisites

- AWS CDK CLI installed
- Node.js and npm (for TypeScript examples)
- Python 3.7+ and pip (for Python examples)
- AWS credentials configured

## Common Commands

For TypeScript examples:
```bash
npm install
cdk deploy
```

For Python examples:
```bash
pip install -r requirements.txt
cdk deploy
```

## Notes

- Replace placeholder values with your actual values
- Ensure you have the necessary permissions in your AWS account
- Review the security implications of the configurations before deploying to production
- Consider cost implications of enabled features
