# Must CDK Amplify Examples

Examples demonstrating the usage of Must CDK's Amplify construct.

## Examples

### Basic Next.js (`basic-nextjs/`)
Simple setup for deploying a Next.js application with Amplify.
- Basic app configuration
- Next.js build settings
- Cache optimization

### Multi-Branch (`multi-branch/`)
Managing multiple environments with branch-specific configurations.
- Production/Staging/Development branches
- Environment-specific variables
- Auto branch creation

### Custom Domain (`custom-domain/`)
Domain and DNS configuration for Amplify apps.
- Custom domain setup
- Subdomain mappings
- WWW redirects

### Full Features (`full-features/`)
Enterprise-grade setup with all available features.
- Custom domains
- Multiple environments
- Basic auth
- Advanced routing
- Resource tagging

## Structure
Each example includes:
- TypeScript implementation
- Python implementation
- README with specific instructions
- Comments explaining key configurations

## Common Patterns
- Next.js optimizations
- Environment separation
- Cache configurations
- Security settings
